/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphExtract;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelExtract;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StatementBoundary;
import com.hp.hpl.jena.rdf.model.StatementBoundaryBase;
import com.hp.hpl.jena.rdf.model.StatementTripleBoundary;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestModelExtract
extends ModelTestBase {
    protected static final StatementBoundary sbTrue = new StatementBoundaryBase(){

        public boolean stopAt(Statement statement) {
            return true;
        }
    };
    protected static final StatementBoundary sbFalse = new StatementBoundaryBase(){

        public boolean stopAt(Statement statement) {
            return false;
        }
    };

    public TestModelExtract(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelExtract.class);
    }

    public void testAsTripleBoundary() {
        Model model = ModelFactory.createDefaultModel();
        TestModelExtract.assertTrue(sbTrue.asTripleBoundary(model).stopAt(TestModelExtract.triple("x R y")));
        TestModelExtract.assertFalse(sbFalse.asTripleBoundary(model).stopAt(TestModelExtract.triple("x R y")));
    }

    public void testStatementTripleBoundaryAnon() {
        TripleBoundary tripleBoundary = TripleBoundary.stopAtAnonObject;
        TestModelExtract.assertSame(tripleBoundary, new StatementTripleBoundary(tripleBoundary).asTripleBoundary(null));
        TestModelExtract.assertFalse(new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P o")));
        TestModelExtract.assertTrue(new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P _o")));
    }

    public void testStatementContinueWith() {
        StatementBoundaryBase statementBoundaryBase = new StatementBoundaryBase(){

            public boolean continueWith(Statement statement) {
                return false;
            }
        };
        TestModelExtract.assertTrue(statementBoundaryBase.stopAt(TestModelExtract.statement("x pings y")));
    }

    public void testStatementTripleBoundaryNowhere() {
        TripleBoundary tripleBoundary = TripleBoundary.stopNowhere;
        TestModelExtract.assertSame(tripleBoundary, new StatementTripleBoundary(tripleBoundary).asTripleBoundary(null));
        TestModelExtract.assertFalse(new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P _o")));
        TestModelExtract.assertFalse(new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P o")));
    }

    public void testRemembersBoundary() {
        TestModelExtract.assertSame(sbTrue, new MockModelExtract(sbTrue).getStatementBoundary());
        TestModelExtract.assertSame(sbFalse, new MockModelExtract(sbFalse).getStatementBoundary());
    }

    public void testInvokesExtract() {
        MockModelExtract mockModelExtract = new MockModelExtract(sbTrue);
        Model model = TestModelExtract.modelWithStatements("a R b");
        Model model2 = mockModelExtract.extract(TestModelExtract.resource("a"), model);
        TestModelExtract.assertEquals(TestModelExtract.node("a"), mockModelExtract.root);
        TestModelExtract.assertSame(mockModelExtract.result, model2.getGraph());
        TestModelExtract.assertSame(mockModelExtract.subject, model.getGraph());
    }

    public boolean stopAt(Statement statement) {
        return false;
    }

    public TripleBoundary asTripleBoundary(Model model) {
        return null;
    }

    static class MockModelExtract
    extends ModelExtract {
        Node root;
        Graph result;
        Graph subject;

        public MockModelExtract(StatementBoundary statementBoundary) {
            super(statementBoundary);
        }

        public StatementBoundary getStatementBoundary() {
            return this.boundary;
        }

        protected GraphExtract getGraphExtract(TripleBoundary tripleBoundary) {
            return new GraphExtract(this, tripleBoundary){
                private final /* synthetic */ MockModelExtract this$0;
                {
                    this.this$0 = mockModelExtract;
                    super(tripleBoundary);
                }

                public Graph extractInto(Graph graph, Node node, Graph graph2) {
                    this.this$0.root = node;
                    this.this$0.subject = graph2;
                    this.this$0.result = super.extractInto(graph, node, this.this$0.subject);
                    return this.this$0.result;
                }
            };
        }
    }
}

