/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.TestModelSpec;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestModelFactory
extends ModelTestBase {
    protected static final Resource DAMLLangResource = TestModelFactory.resource("http://www.daml.org/2001/03/daml+oil#");

    public TestModelFactory(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelFactory.class);
    }

    public void testCreateDefaultModel() {
        ModelFactory.createDefaultModel().close();
    }

    public void testGetDefaultPrefixMapping() {
        TestModelFactory.assertSame(ModelCom.getDefaultModelPrefixes(), ModelFactory.getDefaultModelPrefixes());
    }

    public void testSetDefaultPrefixMapping() {
        PrefixMapping prefixMapping = ModelCom.getDefaultModelPrefixes();
        PrefixMapping prefixMapping2 = PrefixMapping.Factory.create();
        ModelFactory.setDefaultModelPrefixes(prefixMapping2);
        TestModelFactory.assertSame(prefixMapping2, ModelCom.getDefaultModelPrefixes());
        TestModelFactory.assertSame(prefixMapping2, ModelFactory.getDefaultModelPrefixes());
        ModelCom.setDefaultModelPrefixes(prefixMapping);
    }

    public void testCreateSpecFails() {
        try {
            ModelFactory.createSpec(ModelFactory.createDefaultModel());
            TestModelFactory.fail("empty descriptions should throw the appropriate exception");
        }
        catch (BadDescriptionException badDescriptionException) {
            TestModelFactory.pass();
        }
    }

    public void testCreatePlainSpec() {
        Model model = TestModelSpec.createPlainModelDesc();
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        this.assertIsoModels(model, modelSpec.getDescription());
        TestModelFactory.assertTrue(modelSpec instanceof PlainModelSpec);
        TestModelFactory.assertTrue(modelSpec.createModel().getGraph() instanceof GraphMem);
    }

    public void testCreateOntSpec() {
        Resource resource = ResourceFactory.createResource();
        Resource resource2 = ResourceFactory.createResource();
        Resource resource3 = ResourceFactory.createResource();
        Resource resource4 = ResourceFactory.createResource();
        OntDocumentManager ontDocumentManager = new OntDocumentManager();
        Resource resource5 = ResourceFactory.createResource("http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory");
        Model model = ModelFactory.createDefaultModel().add(resource, JenaModelSpec.maker, resource3).add(resource, JenaModelSpec.importMaker, resource2).add(resource3, RDF.type, JenaModelSpec.FileMakerSpec).add(resource3, JenaModelSpec.fileBase, "/tmp/example").add(resource3, JenaModelSpec.reificationMode, JenaModelSpec.rsMinimal).add(resource2, RDF.type, JenaModelSpec.MemMakerSpec).add(resource2, JenaModelSpec.reificationMode, JenaModelSpec.rsMinimal).add(resource, JenaModelSpec.ontLanguage, DAMLLangResource).add(resource, JenaModelSpec.docManager, ModelSpecImpl.createValue(ontDocumentManager)).add(resource, JenaModelSpec.reasonsWith, resource4).add(resource4, JenaModelSpec.reasoner, resource5);
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        TestModelFactory.assertTrue(modelSpec instanceof OntModelSpec);
        this.assertIsoModels(model, modelSpec.getDescription());
        TestModelFactory.assertTrue(modelSpec.createModel() instanceof OntModel);
    }

    public void testCreateOntologyModelFromSpecOnly() {
        Resource resource = ResourceFactory.createResource();
        Model model = ModelFactory.createDefaultModel().add(resource, JenaModelSpec.ontLanguage, DAMLLangResource);
        OntModelSpec ontModelSpec = (OntModelSpec)ModelFactory.createSpec(model);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec);
    }

    public void testCreateInfSpec() {
        Model model = TestModelSpec.createInfModelDesc("http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory");
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        TestModelFactory.assertTrue(modelSpec instanceof InfModelSpec);
        this.assertIsoModels(model, modelSpec.getDescription());
        TestModelFactory.assertTrue(modelSpec.createModel() instanceof InfModel);
    }

    public void testMFCreate() {
        Model model = TestModelSpec.createPlainModelDesc();
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        Model model2 = ModelFactory.createModel(modelSpec);
    }

    public void testMFCreateNamed() {
        Model model = TestModelSpec.createPlainModelDesc();
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        Model model2 = ModelFactory.createModelOver(modelSpec, "aName");
    }

    public void testCreateNamed() {
        Resource resource = ResourceFactory.createResource();
        Model model = TestModelSpec.createPlainModelDesc(resource);
        ModelSpec modelSpec = ModelFactory.createSpec(resource, model);
    }

    public void testCreateUnion() {
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        Model model3 = ModelFactory.createUnion(model, model2);
        TestModelFactory.assertTrue(model3.getGraph() instanceof Union);
        TestModelFactory.assertSame(model.getGraph(), ((Union)model3.getGraph()).getL());
        TestModelFactory.assertSame(model2.getGraph(), ((Union)model3.getGraph()).getR());
    }
}

