/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class TestModelMakerImpl
extends ModelTestBase {
    private ModelMaker maker;
    private Graph graph;
    private GraphMaker graphMaker;

    public TestModelMakerImpl(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelMakerImpl.class);
    }

    public void setUp() {
        this.graph = GraphTestBase.graphWith("");
        this.graphMaker = new MockGraphMaker(this.graph);
        this.maker = new ModelMakerImpl(this.graphMaker);
    }

    public void testClose() {
        this.maker.close();
        this.checkHistory(this.one("close()"));
    }

    public void testRemove() {
        this.maker.removeModel("London");
        this.checkHistory(this.one("remove(London)"));
    }

    public void testCreate() {
        this.maker.createModel();
        this.checkHistory(this.one("create()"));
    }

    public void testGet() {
        this.maker.getModel();
        this.checkHistory(this.one("get()"));
    }

    public void testCreateNamed() {
        Model model = this.maker.createModel("petal");
        this.checkHistory(this.one("create(petal,false)"));
        TestModelMakerImpl.assertTrue(model.getGraph() == this.graph);
    }

    public void testCreateTrue() {
        Model model = this.maker.createModel("stem", true);
        this.checkHistory(this.one("create(stem,true)"));
        TestModelMakerImpl.assertTrue(model.getGraph() == this.graph);
    }

    public void testCreateFalse() {
        Model model = this.maker.createModel("leaf", false);
        this.checkHistory(this.one("create(leaf,false)"));
        TestModelMakerImpl.assertTrue(model.getGraph() == this.graph);
    }

    public void testOpen() {
        Model model = this.maker.openModel("trunk");
        this.checkHistory(this.one("open(trunk,false)"));
        TestModelMakerImpl.assertTrue(model.getGraph() == this.graph);
    }

    public void testOpenFalse() {
        Model model = this.maker.openModel("branch", false);
        this.checkHistory(this.one("open(branch,false)"));
        TestModelMakerImpl.assertTrue(model.getGraph() == this.graph);
    }

    public void testOpenTrue() {
        Model model = this.maker.openModel("bark", true);
        this.checkHistory(this.one("open(bark,true)"));
        TestModelMakerImpl.assertTrue(model.getGraph() == this.graph);
    }

    public void testListGraphs() {
        this.maker.listModels().close();
        this.checkHistory(this.one("listModels()"));
    }

    public void testGetGraphMaker() {
        TestModelMakerImpl.assertTrue(this.maker.getGraphMaker() == this.graphMaker);
    }

    public void testGetDescription() {
        this.maker.getDescription();
        this.checkHistory(this.one("getDescription()"));
    }

    private void checkHistory(List list) {
        TestModelMakerImpl.assertEquals(list, this.history());
    }

    private List history() {
        return ((MockGraphMaker)this.maker.getGraphMaker()).history;
    }

    private List one(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return arrayList;
    }

    static class MockGraphMaker
    implements GraphMaker {
        List history = new ArrayList();
        Graph graph;

        public MockGraphMaker(Graph graph) {
            this.graph = graph;
        }

        public ReificationStyle getReificationStyle() {
            this.history.add("getReificationStyle()");
            return null;
        }

        public Graph getGraph() {
            this.history.add("get()");
            return this.graph;
        }

        public Graph createGraph() {
            this.history.add("create()");
            return this.graph;
        }

        public Graph createGraph(String string, boolean bl) {
            this.history.add("create(" + string + "," + bl + ")");
            return this.graph;
        }

        public Graph createGraph(String string) {
            this.history.add("create(" + string + ")");
            return this.graph;
        }

        public Graph openGraph(String string, boolean bl) {
            this.history.add("open(" + string + "," + bl + ")");
            return this.graph;
        }

        public Graph openGraph(String string) {
            this.history.add("open(" + string + ")");
            return this.graph;
        }

        public void removeGraph(String string) {
            this.history.add("remove(" + string + ")");
        }

        public boolean hasGraph(String string) {
            this.history.add("has(" + string + ")");
            return false;
        }

        public Graph getDescription() {
            this.history.add("getDescription()");
            return GraphTestBase.graphWith("");
        }

        public Graph getDescription(Node node) {
            this.history.add("getDescription(Node)");
            return GraphTestBase.graphWith("");
        }

        public Graph addDescription(Graph graph, Node node) {
            this.history.add("addDescription()");
            return graph;
        }

        public void close() {
            this.history.add("close()");
        }

        public ExtendedIterator listGraphs() {
            this.history.add("listModels()");
            return NullIterator.instance;
        }
    }
}

