/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import junit.framework.TestSuite;

public class TestModelPrefixMapping
extends AbstractTestPrefixMapping {
    protected static final String alphaPrefix = "alpha";
    protected static final String betaPrefix = "beta";
    protected static final String alphaURI = "http://testing.jena.hpl.hp.com/alpha#";
    protected static final String betaURI = "http://testing.jena.hpl.hp.com/beta#";
    protected PrefixMapping baseMap = PrefixMapping.Factory.create().setNsPrefix("alpha", "http://testing.jena.hpl.hp.com/alpha#").setNsPrefix("beta", "http://testing.jena.hpl.hp.com/beta#");
    private PrefixMapping prevMap;

    public TestModelPrefixMapping(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelPrefixMapping.class);
    }

    protected PrefixMapping getMapping() {
        return ModelFactory.createDefaultModel();
    }

    public void setPrefixes() {
        this.prevMap = ModelCom.setDefaultModelPrefixes(this.baseMap);
    }

    public void restorePrefixes() {
        ModelCom.setDefaultModelPrefixes(this.prevMap);
    }

    public void testDefaultPrefixes() {
        this.setPrefixes();
        Model model = ModelFactory.createDefaultModel();
        TestModelPrefixMapping.assertEquals(this.baseMap.getNsPrefixMap(), model.getNsPrefixMap());
        this.restorePrefixes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnlyFreshPrefixes() {
        this.setPrefixes();
        try {
            this.doOnlyFreshPrefixes();
        }
        finally {
            this.restorePrefixes();
        }
    }

    private void doOnlyFreshPrefixes() {
        String string = "abc:def/";
        Graph graph = Factory.createDefaultGraph();
        PrefixMapping prefixMapping = graph.getPrefixMapping();
        prefixMapping.setNsPrefix(alphaPrefix, string);
        Model model = ModelFactory.createModelForGraph(graph);
        TestModelPrefixMapping.assertEquals(string, model.getNsPrefixURI(alphaPrefix));
        TestModelPrefixMapping.assertEquals(betaURI, model.getNsPrefixURI(betaPrefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDefault() {
        this.setPrefixes();
        try {
            TestModelPrefixMapping.assertSame(this.baseMap, ModelCom.getDefaultModelPrefixes());
        }
        finally {
            this.restorePrefixes();
        }
    }
}

