/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestModelRead
extends ModelTestBase {
    public TestModelRead(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelRead.class);
    }

    public void testReturnsSelf() {
        Model model = ModelFactory.createDefaultModel();
        TestModelRead.assertSame(model, model.read("file:testing/modelReading/empty.n3", "base", "N3"));
        TestModelRead.assertTrue(model.isEmpty());
    }

    public void testLoadsSimpleModel() {
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        model.read("file:testing/modelReading/simple.n3", "N3");
        TestModelRead.assertSame(model2, model2.read("file:testing/modelReading/simple.n3", "base", "N3"));
        this.assertIsoModels(model, model2);
    }

    public void testLoadsSimpleModelWithoutProtocol() {
    }

    public void testSimpleLoadImplictBase() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/modelReading/based.n3", "N3");
        this.assertIsoModels(TestModelRead.modelWithStatements("file:testing/modelReading/based.n3 jms:predicate jms:object"), model);
    }

    public void testSimpleLoadExplicitBase() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/modelReading/based.n3", "base:", "N3");
        this.assertIsoModels(TestModelRead.modelWithStatements("base: jms:predicate jms:object"), model);
    }

    public void testDefaultLangXML() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/modelReading/plain.rdf", null, null);
    }
}

