/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestSuite;

public class TestModelSpecMore
extends ModelTestBase {
    public TestModelSpecMore(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecMore.class);
    }

    public void testLoadWorks() throws Exception {
        String string = this.makeModel("a bb c");
        Model model = FileManager.get().loadModel(string);
        Model model2 = TestModelSpecMore.modelWithStatements("_root rdf:type jms:PlainModelSpec; _root jms:maker jms:MemMaker; _root jms:loadWith " + string);
        ModelSpec modelSpec = ModelFactory.createSpec(model2);
        Model model3 = ModelFactory.createModel(modelSpec);
        this.assertIsoModels(model, model3);
    }

    public void testLoadMultiWorks() throws Exception {
        String string = this.makeModel("dogs may bark");
        String string2 = this.makeModel("pigs might fly");
        Model model = FileManager.get().loadModel(string);
        FileManager.get().readModel(model, string2);
        Model model2 = TestModelSpecMore.modelWithStatements("_root rdf:type jms:PlainModelSpec; _root jms:maker jms:MemMaker");
        TestModelSpecMore.modelAdd(model2, "_root jms:loadWith " + string);
        TestModelSpecMore.modelAdd(model2, "_root jms:loadWith " + string2);
        ModelSpec modelSpec = ModelFactory.createSpec(model2);
        Model model3 = ModelFactory.createModel(modelSpec);
        this.assertIsoModels(model, model3);
    }

    protected String makeModel(String string) throws FileNotFoundException, IOException {
        String string2 = FileUtils.tempFileName("test-load-with-", ".rdf").getAbsolutePath();
        Model model = TestModelSpecMore.modelWithStatements(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        model.write(fileOutputStream, FileUtils.guessLang(string2));
        fileOutputStream.close();
        return "file:" + string2;
    }

    public void testOpenModel() {
        Model model = TestModelSpecMore.modelWithStatements("_root jms:maker jms:MemMaker");
        TestModelSpecMore.assertTrue(ModelFactory.createSpec(model).openModel("nosuch") instanceof Model);
    }
}

