/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.test.TestPrefixMapping;
import com.hp.hpl.jena.util.CollectionFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public class TestNamespace
extends ModelTestBase {
    public TestNamespace(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNamespace.class);
    }

    public void testReadPrefixes() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/wg/rdf-ns-prefix-confusion/test0014.rdf");
        Map map = model.getNsPrefixMap();
        TestNamespace.assertEquals("namespace eg", (Object)"http://example.org/", map.get("eg"));
        TestNamespace.assertEquals("namespace rdf", (Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", map.get("rdf"));
        TestNamespace.assertEquals("not present", null, map.get("spoo"));
    }

    public void testWritePrefixes() throws IOException {
        Model model = ModelFactory.createDefaultModel();
        ModelCom.addNamespaces(model, this.makePrefixes("fred=ftp://net.fred.org/;spoo=http://spoo.net/"));
        File file = File.createTempFile("hedgehog", ".rdf");
        model.add(TestNamespace.statement(model, "http://spoo.net/S http://spoo.net/P http://spoo.net/O"));
        model.add(TestNamespace.statement(model, "http://spoo.net/S ftp://net.fred.org/P http://spoo.net/O"));
        model.write(new FileWriter(file));
        Model model2 = ModelFactory.createDefaultModel();
        model2.read("file:" + file.getAbsolutePath());
        Map map = model2.getNsPrefixMap();
        TestNamespace.assertEquals("namespace spoo", (Object)"http://spoo.net/", map.get("spoo"));
        TestNamespace.assertEquals("namespace fred", (Object)"ftp://net.fred.org/", map.get("fred"));
        file.deleteOnExit();
    }

    private Map makePrefixes(String string) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            hashMap.put(string2.substring(0, n), this.set(string2.substring(n + 1)));
        }
        return hashMap;
    }

    private Set set(String string) {
        Set set = CollectionFactory.createHashedSet();
        set.add(string);
        return set;
    }

    public void testUseEasyPrefix() {
        TestPrefixMapping.testUseEasyPrefix("default model", ModelFactory.createDefaultModel());
    }
}

