/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestRDFNodes
extends ModelTestBase {
    public TestRDFNodes(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDFNodes.class);
    }

    public void testRDFVisitor() {
        final ArrayList arrayList = new ArrayList();
        Model model = ModelFactory.createDefaultModel();
        final Resource resource = model.createResource();
        final Property property = model.createProperty("eh:PP");
        final Literal literal = model.createLiteral("LL");
        RDFVisitor rDFVisitor = new RDFVisitor(){

            public Object visitBlank(Resource resource2, AnonId anonId) {
                arrayList.add("blank");
                Assert.assertTrue("must visit correct node", resource2 == resource);
                Assert.assertEquals("must have correct field", resource2.getId(), anonId);
                return "blank result";
            }

            public Object visitURI(Resource resource2, String string) {
                arrayList.add("uri");
                Assert.assertTrue("must visit correct node", resource2 == property);
                Assert.assertEquals("must have correct field", resource2.getURI(), string);
                return "uri result";
            }

            public Object visitLiteral(Literal literal2) {
                arrayList.add("literal");
                Assert.assertTrue("must visit correct node", literal2 == literal);
                return "literal result";
            }
        };
        TestRDFNodes.assertEquals((Object)"blank result", resource.visitWith(rDFVisitor));
        TestRDFNodes.assertEquals((Object)"uri result", property.visitWith(rDFVisitor));
        TestRDFNodes.assertEquals((Object)"literal result", literal.visitWith(rDFVisitor));
        TestRDFNodes.assertEquals(arrayList.get(0), (Object)"blank");
        TestRDFNodes.assertEquals(arrayList.get(1), (Object)"uri");
        TestRDFNodes.assertEquals(arrayList.get(2), (Object)"literal");
    }

    public void testRemoveAllRemoves() {
        String string = "x P a; x P b";
        String string2 = "x Q c; y P a; y Q b";
        Model model = TestRDFNodes.modelWithStatements(string + "; " + string2);
        Resource resource = TestRDFNodes.resource(model, "x");
        Resource resource2 = resource.removeAll(TestRDFNodes.property(model, "P"));
        TestRDFNodes.assertSame("removeAll should deliver its receiver", resource, resource2);
        this.assertIsoModels("x's P-values should go", TestRDFNodes.modelWithStatements(string2), model);
    }

    public void testRemoveAllBoring() {
        Model model = TestRDFNodes.modelWithStatements("x P a; y Q b");
        Model model2 = TestRDFNodes.modelWithStatements("x P a; y Q b");
        TestRDFNodes.resource(model2, "x").removeAll(TestRDFNodes.property(model2, "Z"));
        this.assertIsoModels("m2 should be unchanged", model, model2);
    }

    public void testInModel() {
        Model model = TestRDFNodes.modelWithStatements("");
        Model model2 = TestRDFNodes.modelWithStatements("");
        Resource resource = TestRDFNodes.resource(model, "r1");
        Resource resource2 = TestRDFNodes.resource(model, "_r2");
        TestRDFNodes.assertTrue(resource.getModel() == model);
        TestRDFNodes.assertTrue(resource2.getModel() == model);
        TestRDFNodes.assertFalse(resource.isAnon());
        TestRDFNodes.assertTrue(resource2.isAnon());
        TestRDFNodes.assertTrue(((Resource)resource.inModel(model2)).getModel() == model2);
        TestRDFNodes.assertTrue(((Resource)resource2.inModel(model2)).getModel() == model2);
        TestRDFNodes.assertEquals(resource, resource.inModel(model2));
        TestRDFNodes.assertEquals(resource2, resource2.inModel(model2));
    }
}

