/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.parser.Q_Query;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    static Log logger = LogFactory.getLog(Query.class);
    protected List resultVars = new ArrayList();
    protected List patternVars = new ArrayList();
    protected List triplePatterns = new ArrayList();
    protected List constraints = new ArrayList();
    protected Map prefixMap = new HashMap();
    protected static Map defaultPrefixMap = new HashMap();
    String sourceURL = null;
    Model source = null;
    public long parseTime = -1L;
    public long buildTime = -1L;
    public long loadTime = -1L;
    public long executeTime = -1L;

    public Query(String string) {
        this();
        Q_Query q_Query = null;
        try {
            this.parseTime = 0L;
            long l = 0L;
            StringReader stringReader = new StringReader(string);
            l = System.currentTimeMillis();
            RDQLParser rDQLParser = new RDQLParser(stringReader);
            rDQLParser.CompilationUnit();
            this.parseTime = System.currentTimeMillis() - l;
            logger.debug("Query parse time: " + this.parseTime);
            q_Query = (Q_Query)rDQLParser.top();
            q_Query.phase2(this);
            this.buildTime = System.currentTimeMillis() - this.parseTime - l;
            logger.debug("Query parse and build time: " + this.buildTime);
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Exception exception) {
            throw new QueryException("Parse error: " + exception);
        }
    }

    public Query() {
    }

    public static QueryResults exec(String string) {
        Query query = new Query(string);
        QueryEngine queryEngine = new QueryEngine(query);
        queryEngine.init();
        return queryEngine.exec();
    }

    public static QueryResults exec(String string, Model model) {
        Query query = new Query(string);
        if (model != null) {
            query.setSource(model);
        }
        QueryEngine queryEngine = new QueryEngine(query);
        queryEngine.init();
        return queryEngine.exec();
    }

    public static QueryResults exec(String string, String string2) {
        Query query = new Query(string);
        query.setSourceURL(string2);
        QueryEngine queryEngine = new QueryEngine(query);
        queryEngine.init();
        return queryEngine.exec();
    }

    public void setSource(Model model) {
        this.source = model;
    }

    public Model getSource() {
        return this.source;
    }

    public void setSourceURL(String string) {
        this.sourceURL = string;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public void addResultVar(String string) {
        if (!this.resultVars.contains(string)) {
            this.resultVars.add(string);
        }
    }

    public List getBoundVars() {
        return this.patternVars;
    }

    public void addBoundVar(String string) {
        if (!this.patternVars.contains(string)) {
            this.patternVars.add(string);
        }
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public List getConstraints() {
        return this.constraints;
    }

    public void addTriplePattern(Triple triple) {
        this.triplePatterns.add(triple);
    }

    public void addTriplePattern(Node node, Node node2, Node node3) {
        Triple triple = new Triple(node, node2, node3);
        this.triplePatterns.add(triple);
    }

    public List getTriplePatterns() {
        return this.triplePatterns;
    }

    public void setPrefix(String string, String string2) {
        this.prefixMap.put(string, string2);
    }

    public String getPrefix(String string) {
        String string2 = null;
        if (this.prefixMap != null) {
            string2 = (String)this.prefixMap.get(string);
        }
        if (string2 == null) {
            string2 = (String)defaultPrefixMap.get(string);
        }
        return string2;
    }

    public Map getPrefixMap() {
        return this.prefixMap;
    }

    public Map getDefaultPrefixMap() {
        return defaultPrefixMap;
    }

    public String toString() {
        Object object;
        Iterator iterator;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ");
        if (this.resultVars.size() == 0) {
            stringBuffer.append("*");
        } else {
            bl = true;
            iterator = this.resultVars.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("?");
                stringBuffer.append((String)object);
                bl = false;
            }
        }
        stringBuffer.append("\n");
        if (this.triplePatterns.size() > 0) {
            stringBuffer.append("WHERE   ");
            bl = true;
            iterator = this.triplePatterns.iterator();
            while (iterator.hasNext()) {
                object = (Triple)iterator.next();
                if (!bl) {
                    stringBuffer.append(", \n");
                    stringBuffer.append("        ");
                }
                stringBuffer.append(this.triplePatternToString((Triple)object));
                bl = false;
            }
            stringBuffer.append("\n");
        }
        if (this.constraints.size() > 0) {
            Iterator iterator2 = this.constraints.iterator();
            while (iterator2.hasNext()) {
                iterator = (Constraint)iterator2.next();
                stringBuffer.append("AND     ");
                stringBuffer.append(iterator.toString());
                stringBuffer.append("\n");
            }
        }
        if (this.prefixMap.size() > 0) {
            stringBuffer.append("USING\n");
            boolean bl2 = true;
            iterator = this.prefixMap.keySet().iterator();
            while (iterator.hasNext()) {
                if (!bl2) {
                    stringBuffer.append(" ,\n");
                }
                object = (String)iterator.next();
                String string = (String)this.prefixMap.get(object);
                stringBuffer.append("    " + (String)object + " FOR <" + string + ">");
                bl2 = false;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String triplePatternToString(Triple triple) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ");
        stringBuffer.append(this.slotToString(triple.getSubject()));
        stringBuffer.append(", ");
        stringBuffer.append(this.slotToString(triple.getPredicate()));
        stringBuffer.append(", ");
        stringBuffer.append(this.slotToString(triple.getObject()));
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    private String slotToString(Node node) {
        if (node instanceof Node_Variable) {
            return node.toString();
        }
        if (node instanceof Node_URI) {
            String string = this.applyPrefix(node.getURI());
            if (string == null) {
                return "<" + node.getURI() + ">";
            }
            return string;
        }
        if (node instanceof Node_Literal) {
            LiteralLabel literalLabel = ((Node_Literal)node).getLiteral();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            stringBuffer.append(literalLabel.getLexicalForm());
            stringBuffer.append('\"');
            if (literalLabel.language() != null && literalLabel.language().length() > 0) {
                stringBuffer.append("@");
                stringBuffer.append(literalLabel.language());
            }
            if (literalLabel.getDatatypeURI() != null) {
                stringBuffer.append("^^<");
                stringBuffer.append(literalLabel.getDatatypeURI());
                stringBuffer.append(">");
            }
            return stringBuffer.toString();
        }
        if (node instanceof Node_ANY) {
            return "any:" + node;
        }
        return "unknown:" + node;
    }

    private String applyPrefix(String string) {
        String string2 = this.applyPrefix(string, this.prefixMap, null);
        if (string2 == null) {
            string2 = this.applyPrefix(string, defaultPrefixMap, this.prefixMap);
        }
        return string2;
    }

    private String applyPrefix(String string, Map map, Map map2) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getValue();
            if (!string.startsWith(string2) || map2 != null && map2.containsKey(entry.getKey()) && !map2.get(entry.getKey()).equals(entry.getValue())) continue;
            return entry.getKey() + ":" + string.substring(string2.length());
        }
        return null;
    }

    static {
        defaultPrefixMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        defaultPrefixMap.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        defaultPrefixMap.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultPrefixMap.put("owl", "http://www.w3.org/2002/07/owl#");
    }
}

