/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class QueryPrintUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printName = true;
    static int bNodeCounter = 0;
    static Map bNodeStrings = new HashMap();

    public static void print(PrintWriter printWriter, Expr expr) {
        printWriter.println(expr.asPrefixString());
    }

    public static String asInfixString1(Expr expr, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(expr.asInfixString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String asInfixString2(Expr expr, Expr expr2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ");
        stringBuffer.append(expr.asInfixString());
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(expr2.asInfixString());
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public static String asPrefixString(Expr expr, Expr expr2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(printName ? string : string2);
        stringBuffer.append(" ");
        stringBuffer.append(expr.asPrefixString());
        if (expr2 != null) {
            stringBuffer.append(" ");
            stringBuffer.append(expr2.asPrefixString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static void print(PrintWriter printWriter, Expr expr, Expr expr2, String string, String string2, int n) {
        QueryPrintUtils.indent(printWriter, n);
        printWriter.println("(" + (printName ? string : string2));
        expr.print(printWriter, n + 1);
        if (expr2 != null) {
            expr2.print(printWriter, n + 1);
        }
        QueryPrintUtils.indent(printWriter, n);
        printWriter.println(")");
    }

    public static void indent(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print(indentPrefix);
        }
    }

    public static String stringForObject(Object object) {
        if (object == null) {
            return "<<null>>";
        }
        if (object instanceof RDFNode) {
            return QueryPrintUtils.stringForRDFNode((RDFNode)object);
        }
        if (object instanceof Node) {
            return QueryPrintUtils.stringForNode((Node)object);
        }
        return object.toString();
    }

    public static String stringForRDFNode(RDFNode rDFNode) {
        if (rDFNode == null) {
            return "<<null>>";
        }
        if (rDFNode instanceof Literal) {
            return QueryPrintUtils.stringForLiteral((Literal)rDFNode);
        }
        if (rDFNode instanceof Resource) {
            return QueryPrintUtils.stringForResource((Resource)rDFNode);
        }
        return ((Object)rDFNode).toString();
    }

    public static String stringForLiteral(Literal literal) {
        return QueryPrintUtils.stringForLiteralLabel(literal.asNode().getLiteral());
    }

    public static String stringForLiteralLabel(LiteralLabel literalLabel) {
        String string = literalLabel.getDatatypeURI();
        String string2 = literalLabel.language();
        String string3 = literalLabel.getLexicalForm();
        if (string != null) {
            if (string.equals(XSD.integer.getURI())) {
                try {
                    new BigInteger(string3);
                    return string3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.equals(XSD.xdouble.getURI()) && (string3.indexOf(46) >= 0 || string3.indexOf(101) >= 0 || string3.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(string3);
                    return string3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(string3);
        stringBuffer.append("\"");
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("@");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String stringForResource(Resource resource) {
        return QueryPrintUtils.stringForNode(resource.getNode(), resource.getModel());
    }

    public static String stringForNode(Node node) {
        return QueryPrintUtils.stringForNode(node, null);
    }

    public static String stringForNode(Node node, PrefixMapping prefixMapping) {
        if (node == null) {
            return "<<null>>";
        }
        if (node.isBlank()) {
            AnonId anonId = node.getBlankNodeId();
            if (!bNodeStrings.containsKey(anonId)) {
                bNodeStrings.put(anonId, "_:b" + bNodeCounter++);
            }
            return (String)bNodeStrings.get(anonId);
        }
        if (node.isLiteral()) {
            LiteralLabel literalLabel = node.getLiteral();
            return QueryPrintUtils.stringForLiteralLabel(literalLabel);
        }
        if (node.isURI()) {
            String string;
            String string2 = node.getURI();
            if (prefixMapping != null && (string = prefixMapping.shortForm(node.getURI())) != null && !string.equals(string2)) {
                return string;
            }
            return "<" + string2 + ">";
        }
        if (node.isVariable()) {
            return "?" + node.getName();
        }
        return node.toString();
    }
}

