/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.EvalFailureException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.Node;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class ExprNode
extends SimpleNode
implements Expression,
Valuator,
Constraint,
Expr {
    static Log log = LogFactory.getLog(ExprNode.class);
    Query query;
    VariableIndexes varIndexes;
    static final String exprBaseURI = "urn:x-jena:expr:";

    public ExprNode(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public ExprNode(int n) {
        super(n);
    }

    public boolean isSatisfied(Query query, IndexValues indexValues) {
        return this.evalBool(query, indexValues);
    }

    public void postParse(Query query) {
        super.postParse(query);
        this.query = query;
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        this.varIndexes = variableIndexes;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Node node = this.children[i];
                if (!(node instanceof Expression)) continue;
                ((Expression)((Object)node)).prepare(variableIndexes);
            }
        }
        return this;
    }

    public Object evalObject(IndexValues indexValues) {
        return this.evalNode(this.query, indexValues);
    }

    public boolean evalBool(IndexValues indexValues) {
        return this.evalBool(this.query, indexValues);
    }

    protected boolean evalBool(Query query, IndexValues indexValues) {
        NodeValue nodeValue = this.evalNode(query, indexValues);
        return nodeValue == null ? false : nodeValue.getBoolean();
    }

    public NodeValue evalNode(Query query, IndexValues indexValues) {
        try {
            return this.eval(query, indexValues);
        }
        catch (EvalFailureException evalFailureException) {
            return null;
        }
        catch (Exception exception) {
            log.warn("RDQL : general exception!", exception);
            return null;
        }
    }

    public boolean isVariable() {
        return false;
    }

    public String getName() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public boolean isApply() {
        return false;
    }

    public String getFun() {
        return null;
    }

    public int argCount() {
        return 0;
    }

    public Expression getArg(int n) {
        return null;
    }

    protected String constructURI(String string) {
        if (string.lastIndexOf(46) > -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        return exprBaseURI + string;
    }

    public String toString() {
        return this.asInfixString();
    }
}

