/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.test.QueryTestException;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.TestManifest;
import com.hp.hpl.jena.vocabulary.TestQuery;

class TestItem {
    Resource testResource = null;
    Resource actionResource;
    String name;
    String resultFile;
    String comment;
    String dataFile;
    String queryFile;
    Resource queryForm;
    Resource resultForm;

    public String getName() {
        return this.name;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public Resource getQueryForm() {
        return this.queryForm;
    }

    public Resource getResultForm() {
        return this.resultForm;
    }

    TestItem(Resource resource) {
        this.testResource = resource;
        if (!resource.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem with no action");
        }
        if (!resource.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name");
        }
        this.name = this._getName();
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.dataFile = this._getDataFile();
        this.queryFile = this._getQueryFile();
        this.queryForm = this._getQueryForm();
        this.resultForm = this._getResultForm();
    }

    TestItem(String string, String string2, String string3, String string4) {
        this.name = string;
        this.queryFile = string2;
        this.dataFile = string3;
        this.resultFile = string4;
        this.comment = "";
        this.queryForm = null;
        this.resultForm = null;
    }

    public Resource getResource() {
        return this.testResource;
    }

    String _getName() {
        Statement statement = this.testResource.getProperty(TestManifest.name);
        if (statement == null) {
            return "<<unset>>";
        }
        return statement.getString();
    }

    Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    String _getResultFile() {
        return this.getLiteralOrURI(this.testResource, TestManifest.result);
    }

    String _getComment() {
        Statement statement = this.testResource.getProperty(RDFS.comment);
        if (statement == null) {
            return null;
        }
        return statement.getString();
    }

    String _getDataFile() {
        if (this._getAction().isAnon()) {
            return this.getLiteralOrURI(this._getAction(), TestQuery.data);
        }
        return null;
    }

    String _getQueryFile() {
        Resource resource = this._getAction();
        if (resource.hasProperty(TestQuery.query)) {
            return this.getLiteralOrURI(this._getAction(), TestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    Resource _getQueryForm() {
        return null;
    }

    Resource _getResultForm() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        String string2 = this.getComment();
        String string3 = QueryPrintUtils.stringForRDFNode(this._getAction());
        stringBuffer.append("Name: " + string);
        if (this.getComment() != null) {
            stringBuffer.append("    Comment: " + this.getComment());
        }
        return stringBuffer.toString();
    }

    private String getLiteralOrURI(Resource resource, Property property) {
        Resource resource2;
        if (resource == null) {
            return null;
        }
        if (!resource.hasProperty(property)) {
            return null;
        }
        RDFNode rDFNode = resource.getProperty(property).getObject();
        if (rDFNode instanceof Literal) {
            return ((Literal)rDFNode).getString();
        }
        if (rDFNode instanceof Resource && !(resource2 = (Resource)rDFNode).isAnon()) {
            return resource2.getURI();
        }
        throw new QueryTestException("Manifest problem: " + QueryPrintUtils.stringForRDFNode(rDFNode) + " => " + QueryPrintUtils.stringForRDFNode(property));
    }
}

