/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryIsEquivalentTranslator
extends DIGQueryTranslator {
    protected String m_predicate;
    protected Node m_qSubject;
    protected Node m_qObject;

    public DIGQueryIsEquivalentTranslator(String string) {
        super(null, null, null);
        this.m_predicate = string;
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.translatePattern(triplePattern, dIGAdapter, null);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        Object object;
        Node node;
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        this.m_qSubject = triplePattern.getSubject();
        this.m_qObject = triplePattern.getObject();
        if (this.m_qSubject.isBlank() && this.m_qObject.isBlank()) {
            LogFactory.getLog(this.getClass()).warn("DIG 1.1 cannot handle isConcept query with two expressions");
            return null;
        }
        if (this.m_qObject.isBlank()) {
            node = this.m_qSubject;
            this.m_qSubject = this.m_qObject;
            this.m_qObject = node;
        }
        node = triplePattern.getPredicate();
        if (!this.m_qObject.isBlank() && (node.getURI().equals(dIGAdapter.getOntLanguage().UNION_OF().getURI()) || node.getURI().equals(dIGAdapter.getOntLanguage().INTERSECTION_OF().getURI()) || node.getURI().equals(dIGAdapter.getOntLanguage().COMPLEMENT_OF().getURI())) || node.getURI().equals(dIGAdapter.getOntLanguage().ONE_OF().getURI())) {
            if (model == null) {
                LogFactory.getLog(this.getClass()).warn("Cannot add comprehension axiom bNode for query because premises model is null");
            } else {
                object = model.createResource(dIGAdapter.getOntLanguage().CLASS());
                model.add((Resource)object, model.getProperty(node.getURI()), model.getRDFNode(this.m_qSubject));
                this.m_qSubject = object.getNode();
            }
        }
        object = dIGAdapter.createQueryElement(document, "equivalents");
        dIGAdapter.addClassDescription((Element)object, this.m_qSubject, model);
        return document;
    }

    public ExtendedIterator translateResponseHook(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.conceptSetNameCheck(document, dIGAdapter, this.m_qObject, triplePattern.asTriple());
    }

    public boolean checkTriple(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        Node node = triplePattern.getObject();
        Node node2 = triplePattern.getSubject();
        Node node3 = triplePattern.getPredicate();
        boolean bl = node2.isConcrete() && node.isConcrete() && node3.isConcrete();
        bl = bl && ((node.isBlank() || dIGAdapter.isConcept(node, model)) && node2.isBlank() || dIGAdapter.isConcept(node2, model) && (!node2.isBlank() || !node.isBlank()));
        bl = bl && (node3.getURI().equals(this.m_predicate) || node3.getURI().equals(dIGAdapter.getOntLanguage().UNION_OF().getURI()) || node3.getURI().equals(dIGAdapter.getOntLanguage().INTERSECTION_OF().getURI()) || node3.getURI().equals(dIGAdapter.getOntLanguage().COMPLEMENT_OF().getURI()) || node3.getURI().equals(dIGAdapter.getOntLanguage().ONE_OF().getURI()));
        return bl;
    }

    public boolean trigger(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return super.trigger(triplePattern, dIGAdapter, model);
    }
}

