/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGValueToNodeMapper;
import com.hp.hpl.jena.reasoner.dig.TripleObjectFiller;
import com.hp.hpl.jena.reasoner.dig.TripleSubjectFiller;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DIGQueryTranslator {
    public static final String ALL = "*";
    private Node m_subject;
    private Node m_object;
    private Node m_pred;

    public DIGQueryTranslator(String string, String string2, String string3) {
        this.m_subject = this.mapNode(string);
        this.m_pred = this.mapNode(string2);
        this.m_object = this.mapNode(string3);
    }

    public ExtendedIterator find(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        Document document;
        boolean bl;
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document2 = this.translatePattern(triplePattern, dIGAdapter);
        if (document2 == null) {
            LogFactory.getLog(this.getClass()).warn("Could not find pattern translator for nested DIG query " + triplePattern);
        }
        if (bl = dIGConnection.warningCheck(document = dIGAdapter.getConnection().sendDigVerb(document2, dIGAdapter.getProfile()))) {
            Iterator iterator = dIGConnection.getWarnings();
            while (iterator.hasNext()) {
                LogFactory.getLog(this.getClass()).warn(iterator.next());
            }
        }
        return this.translateResponse(document, triplePattern, dIGAdapter);
    }

    public ExtendedIterator find(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = this.translatePattern(triplePattern, dIGAdapter, model);
        if (document == null) {
            LogFactory.getLog(this.getClass()).warn("Could not find pattern translator for nested DIG query " + triplePattern);
            return NullIterator.instance;
        }
        Document document2 = dIGAdapter.getConnection().sendDigVerb(document, dIGAdapter.getProfile());
        boolean bl = dIGConnection.warningCheck(document2);
        if (bl) {
            Iterator iterator = dIGConnection.getWarnings();
            while (iterator.hasNext()) {
                LogFactory.getLog(this.getClass()).warn(iterator.next());
            }
        }
        return this.translateResponse(document2, triplePattern, dIGAdapter);
    }

    public boolean trigger(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return this.trigger(this.m_subject, triplePattern.getSubject(), model) && this.trigger(this.m_object, triplePattern.getObject(), model) && this.trigger(this.m_pred, triplePattern.getPredicate(), model) && this.checkTriple(triplePattern, dIGAdapter, model);
    }

    public boolean checkTriple(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return this.checkSubject(triplePattern.getSubject(), dIGAdapter, model) && this.checkObject(triplePattern.getObject(), dIGAdapter, model) && this.checkPredicate(triplePattern.getPredicate(), dIGAdapter, model);
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter, Model model) {
        return true;
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter, Model model) {
        return true;
    }

    public boolean checkPredicate(Node node, DIGAdapter dIGAdapter, Model model) {
        return true;
    }

    public abstract Document translatePattern(TriplePattern var1, DIGAdapter var2);

    public abstract Document translatePattern(TriplePattern var1, DIGAdapter var2, Model var3);

    public final ExtendedIterator translateResponse(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        ExtendedIterator extendedIterator = this.translateResponseHook(document, triplePattern, dIGAdapter);
        Filter filter = this.getResultsTripleFilter(triplePattern);
        return filter == null ? extendedIterator : extendedIterator.filterKeep(filter);
    }

    protected abstract ExtendedIterator translateResponseHook(Document var1, TriplePattern var2, DIGAdapter var3);

    protected Node mapNode(String string) {
        if (string == null) {
            return null;
        }
        return string.equals(ALL) ? Node_RuleVariable.WILD : Node.createURI(string);
    }

    protected boolean trigger(Node node, Node node2, Model model) {
        return node == null || node.equals(node2);
    }

    protected boolean isTrue(Document document) {
        return new SimpleXMLPath(true).appendElementPath("true").getAll(document).hasNext();
    }

    protected boolean isFalse(Document document) {
        return new SimpleXMLPath(true).appendElementPath("false").getAll(document).hasNext();
    }

    protected ExtendedIterator translateConceptSetResponse(Document document, TriplePattern triplePattern, boolean bl, DIGAdapter dIGAdapter) {
        return this.translateNameSetResponse(document, triplePattern, bl, new String[]{"conceptSet", "synonyms", "catom"}).andThen(this.translateSpecialConcepts(document, dIGAdapter, bl ? triplePattern.getSubject() : triplePattern.getObject(), triplePattern.getPredicate(), bl));
    }

    protected ExtendedIterator translateRoleSetResponse(Document document, TriplePattern triplePattern, boolean bl) {
        return this.translateNameSetResponse(document, triplePattern, bl, new String[]{"roleSet", "synonyms", "ratom"});
    }

    protected ExtendedIterator translateIndividualSetResponse(Document document, TriplePattern triplePattern, boolean bl) {
        return this.translateNameSetResponse(document, triplePattern, bl, new String[]{"individualSet", "individual"});
    }

    protected ExtendedIterator translateNameSetResponse(Document document, TriplePattern triplePattern, boolean bl, String[] stringArray) {
        SimpleXMLPath simpleXMLPath = new SimpleXMLPath(true);
        for (int i = 0; i < stringArray.length; ++i) {
            simpleXMLPath.appendElementPath(stringArray[i]);
        }
        simpleXMLPath.appendAttrPath("name");
        ExtendedIterator extendedIterator = simpleXMLPath.getAll(document).mapWith(new DIGValueToNodeMapper());
        if (bl) {
            return extendedIterator.mapWith(new TripleObjectFiller(triplePattern.getSubject(), triplePattern.getPredicate()));
        }
        return extendedIterator.mapWith(new TripleSubjectFiller(triplePattern.getPredicate(), triplePattern.getObject()));
    }

    protected ExtendedIterator conceptSetNameCheck(Document document, DIGAdapter dIGAdapter, Node node, Triple triple) {
        ExtendedIterator extendedIterator = new SimpleXMLPath(true).appendElementPath("conceptSet").appendElementPath("synonyms").appendElementPath(ALL).getAll(document);
        String string = dIGAdapter.getNodeID(node);
        boolean bl = string.equals(dIGAdapter.getOntLanguage().THING().getURI());
        boolean bl2 = string.equals(dIGAdapter.getOntLanguage().NOTHING().getURI());
        boolean bl3 = false;
        while (!bl3 && extendedIterator.hasNext()) {
            Element element = (Element)extendedIterator.next();
            bl3 = bl && element.getNodeName().equals("top") || bl2 && element.getNodeName().equals("bottom") || element.getAttribute("name").equals(string);
        }
        return bl3 ? new SingletonIterator(triple) : NullIterator.instance;
    }

    protected ExtendedIterator translateSpecialConcepts(Document document, DIGAdapter dIGAdapter, Node node, Node node2, boolean bl) {
        Node node3;
        SimpleXMLPath simpleXMLPath = new SimpleXMLPath(true).appendElementPath("conceptSet").appendElementPath("synonyms").appendElementPath("top");
        SimpleXMLPath simpleXMLPath2 = new SimpleXMLPath(true).appendElementPath("conceptSet").appendElementPath("synonyms").appendElementPath("bottom");
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        if (simpleXMLPath.getAll(document).hasNext()) {
            node3 = dIGAdapter.getOntLanguage().THING().asNode();
            arrayList.add(bl ? new Triple(node, node2, node3) : new Triple(node3, node2, node));
        }
        if (simpleXMLPath2.getAll(document).hasNext()) {
            node3 = dIGAdapter.getOntLanguage().NOTHING().asNode();
            arrayList.add(bl ? new Triple(node, node2, node3) : new Triple(node3, node2, node));
        }
        return WrappedIterator.create(arrayList.iterator());
    }

    protected Filter getResultsTripleFilter(TriplePattern triplePattern) {
        return null;
    }
}

