/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;

public class DIGReasoner
implements Reasoner {
    protected Capabilities capabilities;
    protected Graph m_tbox;
    protected ReasonerFactory m_factory;
    protected Resource m_configuration;
    protected String m_extReasonerURL = "http://localhost:8081";
    protected OntModelSpec m_ontLang = this.getModelSpec(ProfileRegistry.OWL_LANG);
    protected Model m_axioms = null;

    public DIGReasoner(Graph graph, ReasonerFactory reasonerFactory, Resource resource) {
        this.m_tbox = graph;
        this.m_factory = reasonerFactory;
        this.m_configuration = resource;
        this.configure(resource);
    }

    public Reasoner bindSchema(Graph graph) {
        return new DIGReasoner(graph, this.m_factory, this.m_configuration);
    }

    public Reasoner bindSchema(Model model) {
        return this.bindSchema(model.getGraph());
    }

    public InfGraph bind(Graph graph) {
        return new DIGInfGraph(graph, this);
    }

    public void setDerivationLogging(boolean bl) {
        throw new UnsupportedOperationException("DIG reasoner does not support derivation logging");
    }

    public Model getReasonerCapabilities() {
        return this.m_factory == null ? null : this.m_factory.getCapabilities();
    }

    public void addDescription(Model model, Resource resource) {
        if (this.m_configuration != null) {
            StmtIterator stmtIterator = this.m_configuration.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                model.add(resource, statement.getPredicate(), statement.getObject());
            }
        }
    }

    public boolean supportsProperty(Property property) {
        if (this.m_factory == null) {
            return false;
        }
        Model model = this.m_factory.getCapabilities();
        Resource resource = model.getResource(this.m_factory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public void setParameter(Property property, Object object) {
        if (!this.doSetParameter(property, object)) {
            throw new IllegalParameterException("DIGReasoner does not recognize configuration parameter " + property);
        }
        if (this.m_configuration == null) {
            Model model = ModelFactory.createDefaultModel();
            this.m_configuration = model.createResource();
        }
        Util.updateParameter(this.m_configuration, property, object);
    }

    public void configure(Resource resource) {
        if (resource != null) {
            StmtIterator stmtIterator = resource.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (this.doSetParameter(statement.getPredicate(), statement.getObject())) continue;
                throw new IllegalParameterException("DIGReasoner does not recognize configuration parameter " + statement.getPredicate());
            }
        }
    }

    public String getReasonerURL() {
        return this.m_extReasonerURL;
    }

    public OntModelSpec getOntLangModelSpec() {
        return this.m_ontLang;
    }

    public Graph getSchema() {
        return this.m_tbox;
    }

    public Model getAxioms() {
        return this.m_axioms;
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doSetParameter(Property property, Object object) {
        if (property.equals(ReasonerVocabulary.EXT_REASONER_URL)) {
            this.m_extReasonerURL = object instanceof Resource ? ((Resource)object).getURI() : object.toString();
            return true;
        }
        if (property.equals(ReasonerVocabulary.EXT_REASONER_ONT_LANG)) {
            String string = object instanceof Resource ? ((Resource)object).getURI() : object.toString();
            this.m_ontLang = this.getModelSpec(string);
            return true;
        }
        if (!property.equals(ReasonerVocabulary.EXT_REASONER_AXIOMS)) return false;
        String string = object instanceof Resource ? ((Resource)object).getURI() : object.toString();
        this.m_axioms = ModelFactory.createDefaultModel();
        if (string.startsWith("file:")) {
            String string2 = string.substring(5);
            InputStream inputStream = null;
            inputStream = FileUtils.openResourceFileAsStream(string2);
            this.m_axioms.read(inputStream, string);
            Object var8_7 = null;
            if (inputStream == null) return true;
            try {
                inputStream.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    LogFactory.getLog(this.getClass()).error("Could not open DIG axioms " + string);
                    Object var8_8 = null;
                    if (inputStream == null) return true;
                    try {
                        inputStream.close();
                        return true;
                    }
                    catch (IOException iOException) {}
                    return true;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.m_axioms.read(string);
        return true;
    }

    protected OntModelSpec getModelSpec(String string) {
        if (string.equals(ProfileRegistry.OWL_LANG) || string.equals(ProfileRegistry.OWL_DL_LANG) || string.equals(ProfileRegistry.OWL_LITE_LANG)) {
            return OntModelSpec.OWL_MEM;
        }
        if (string.equals("http://www.daml.org/2001/03/daml+oil#")) {
            return OntModelSpec.DAML_MEM;
        }
        if (string.equals(ProfileRegistry.RDFS_LANG)) {
            return OntModelSpec.RDFS_MEM;
        }
        throw new IllegalParameterException("DIG reasoner did not recognise ontology language " + string);
    }
}

