/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class DIGReasonerFactory
implements ReasonerFactory {
    public static final String URI = "http://jena.hpl.hp.com/2003/DIGReasoner";
    public static final String DEFAULT_OWL_AXIOMS = "file:etc/dig-owl-axioms.rdf";
    public static final String DEFAULT_DAML_AXIOMS = "file:etc/dig-daml-axioms.rdf";
    private static DIGReasonerFactory s_instance = new DIGReasonerFactory();
    private Model m_capabilities = null;

    private DIGReasonerFactory() {
    }

    public static DIGReasonerFactory theInstance() {
        return s_instance;
    }

    public Reasoner create(Resource resource) {
        return new DIGReasoner(null, this, resource);
    }

    public Reasoner createWithDAMLAxioms(Resource resource) {
        return this.create(OWL.NAMESPACE, DEFAULT_DAML_AXIOMS, resource);
    }

    public Reasoner createWithOWLAxioms(Resource resource) {
        return this.create(OWL.NAMESPACE, DEFAULT_OWL_AXIOMS, resource);
    }

    public DIGReasoner create(Resource resource, String string, Resource resource2) {
        Resource resource3;
        Model model = ModelFactory.createDefaultModel();
        if (resource2 != null) {
            model.add(ResourceUtils.reachableClosure(resource2));
            resource3 = (Resource)model.getRDFNode(resource2.getNode());
        } else {
            resource3 = model.createResource();
        }
        if (string != null && !resource3.hasProperty(ReasonerVocabulary.EXT_REASONER_AXIOMS)) {
            model.add(resource3, ReasonerVocabulary.EXT_REASONER_AXIOMS, model.getResource(string));
        }
        if (resource != null && !resource3.hasProperty(ReasonerVocabulary.EXT_REASONER_ONT_LANG)) {
            model.add(resource3, ReasonerVocabulary.EXT_REASONER_ONT_LANG, resource);
        }
        return (DIGReasoner)this.create(resource3);
    }

    public Model getCapabilities() {
        if (this.m_capabilities == null) {
            this.m_capabilities = ModelFactory.createDefaultModel();
            Resource resource = this.m_capabilities.createResource(this.getURI());
            resource.addProperty(ReasonerVocabulary.nameP, "DIG external Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Adapter for external (i.e. non-Jena) DIG reasoner.").addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubClassOf).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubPropertyOf).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.individualAsThingP).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.m_capabilities;
    }

    public String getURI() {
        return URI;
    }
}

