/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;

public class TestConsistency
extends TestCase {
    public void testConsistent0() {
        String string = "http://example.org/foo#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        OntClass ontClass = ontModel.createClass(string + "F0");
        OntClass ontClass2 = ontModel.createClass(string + "F1");
        ontClass.addDisjointWith(ontClass2);
        Individual individual = ontModel.createIndividual(string + "i0", OWL.Thing);
        individual.setRDFType(ontClass);
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel2 = ModelFactory.createOntologyModel(ontModelSpec, ontModel);
        TestConsistency.assertTrue("KB should be consistent", ontModel2.validate().isValid());
    }

    public void testConsistent1() {
        String string = "http://example.org/foo#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        OntClass ontClass = ontModel.createClass(string + "F0");
        OntClass ontClass2 = ontModel.createClass(string + "F1");
        ontClass.addDisjointWith(ontClass2);
        Individual individual = ontModel.createIndividual(string + "i0", OWL.Thing);
        individual.setRDFType(ontClass);
        individual.addRDFType(ontClass2);
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel2 = ModelFactory.createOntologyModel(ontModelSpec, ontModel);
        ValidityReport validityReport = ontModel2.validate();
        if (!validityReport.isValid()) {
            Iterator iterator = validityReport.getReports();
            while (iterator.hasNext()) {
                ValidityReport.Report report = (ValidityReport.Report)iterator.next();
                LogFactory.getLog(this.getClass()).debug("Problem report: " + report.type + " - " + report.description);
            }
        }
        TestConsistency.assertFalse("KB should not be consistent", ontModel2.validate().isValid());
    }

    public void testConsistent2() {
        String string = "http://example.org/foo#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        OntClass ontClass = ontModel.createClass(string + "F0");
        OntClass ontClass2 = ontModel.createClass(string + "F1");
        OntClass ontClass3 = ontModel.createClass(string + "F2");
        ontClass.addDisjointWith(ontClass2);
        ontClass3.addSuperClass(ontClass);
        ontClass3.addSuperClass(ontClass2);
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel2 = ModelFactory.createOntologyModel(ontModelSpec, ontModel);
        ValidityReport validityReport = ontModel2.validate();
        if (!validityReport.isValid()) {
            Iterator iterator = validityReport.getReports();
            while (iterator.hasNext()) {
                ValidityReport.Report report = (ValidityReport.Report)iterator.next();
                LogFactory.getLog(this.getClass()).debug("Problem report: " + report.type + " - " + report.description);
            }
        }
        TestConsistency.assertFalse("KB should not be consistent", ontModel2.validate().isValid());
    }
}

