/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestRacer
extends TestCase {
    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testRacerName() {
        DIGAdapter dIGAdapter = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        TestRacer.assertEquals("Name should be racer", "Racer", dIGAdapter.getDigIdentifier().getName());
    }

    public void testRacerVersion() {
        DIGAdapter dIGAdapter = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        TestRacer.assertNotNull("Version should be non-null", dIGAdapter.getDigIdentifier().getVersion());
    }

    public void testRacerMessage() {
        DIGAdapter dIGAdapter = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        TestRacer.assertNotNull("Message should be non-null", dIGAdapter.getDigIdentifier().getMessage());
    }

    public void testRacerSupportsLanguage() {
        DIGAdapter dIGAdapter = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        this.iteratorTest(dIGAdapter.getDigIdentifier().supportsLanguage(), new Object[]{"top", "bottom", "catom", "ratom", "and", "or", "not", "some", "all", "atmost", "atleast", "inverse", "feature", "attribute", "intmin", "intmax", "intrange", "intequals", "defined", "stringequals"});
    }

    public void testRacerSupportsTell() {
        DIGAdapter dIGAdapter = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        this.iteratorTest(dIGAdapter.getDigIdentifier().supportsTell(), new Object[]{"defconcept", "defrole", "deffeature", "defattribute", "defindividual", "impliesc", "equalc", "disjoint", "impliesr", "domain", "range", "rangeint", "transitive", "functional", "instanceof", "related", "value", "equalr", "rangestring"});
    }

    public void testRacerSupportsAsk() {
        DIGAdapter dIGAdapter = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        this.iteratorTest(dIGAdapter.getDigIdentifier().supportsAsk(), new Object[]{"allConceptNames", "allRoleNames", "allIndividuals", "satisfiable", "subsumes", "disjoint", "parents", "children", "descendants", "ancestors", "equivalents", "rparents", "rchildren", "rancestors", "rdescendants", "instances", "types", "instance", "roleFillers", "relatedIndividuals", "toldValues"});
    }

    protected void iteratorTest(Iterator iterator, Object[] objectArray) {
        TestRacer.assertNotNull("Iterator should not be null", iterator);
        Log log = LogFactory.getLog(this.getClass());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!arrayList.contains(e)) {
                log.debug(this.getName() + " - Unexpected iterator result: " + e);
            }
            TestRacer.assertTrue("Value " + e + " was not expected as a result from this iterator ", arrayList.contains(e));
            TestRacer.assertTrue("Value " + e + " was not removed from the list ", arrayList.remove(e));
        }
        if (arrayList.size() != 0) {
            log.debug(this.getName() + "Expected iterator results not found");
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                log.debug(this.getName() + " - missing: " + iterator2.next());
            }
        }
        TestRacer.assertEquals("There were expected elements from the iterator that were not found", 0, arrayList.size());
    }
}

