/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGErrorResponseException;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWLResults;
import com.hp.hpl.jena.vocabulary.OWLTest;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class WebOntTests {
    public static final String BASE_TESTDIR = "testing/wg/";
    public static String BASE_URI = "http://www.w3.org/2002/03owlt/";
    public static final String OTEST_NS = BASE_URI + "testOntology#";
    public static String BASE_RESULTS_URI = "http://jena.sourceforge.net/data/owl-results.rdf";
    public static final String[] TEST_DIRS = new String[]{"AllDifferent", "AnnotationProperty", "DatatypeProperty", "FunctionalProperty", "I3.2", "I3.4", "I4.1", "I4.5", "I4.6", "I5.1", "I5.2", "I5.21", "I5.24", "I5.26", "I5.3", "I5.5", "I5.8", "InverseFunctionalProperty", "Nothing", "Restriction", "SymmetricProperty", "Thing", "TransitiveProperty", "Class", "allValuesFrom", "amp-in-url", "cardinality", "complementOf", "datatypes", "differentFrom", "disjointWith", "distinctMembers", "equivalentClass", "equivalentProperty", "imports", "intersectionOf", "inverseOf", "localtests", "maxCardinality", "miscellaneous", "oneOf", "sameAs", "someValuesFrom", "statement-entailment", "unionOf", "xmlbase", "description-logic", "extra-credit"};
    public static final String[] BLOCKED_TESTS = new String[0];
    public static final String[] STATUS_FLAGS = new String[]{"APPROVED", "PROPOSED"};
    public static final List ACCEPTABLE_TEST_LEVELS = Arrays.asList(OWLTest.Lite, OWLTest.DL);
    protected static List UNSAFE_PREMISE_PREDICATES = new ArrayList();
    protected static boolean s_includeModified;
    protected static boolean s_approvedOnly;
    private DIGReasoner m_reasoner;
    private Model m_testDefinitions = this.loadAllTestDefinitions();
    private int m_testCount = 0;
    private long m_lastTestDuration = 0L;
    private int m_passCount = 0;
    private Model m_testResults;
    private Resource m_jena2;

    public WebOntTests() {
        DIGReasonerFactory dIGReasonerFactory = (DIGReasonerFactory)ReasonerRegistry.theRegistry().getFactory("http://jena.hpl.hp.com/2003/DIGReasoner");
        this.m_reasoner = (DIGReasoner)dIGReasonerFactory.createWithOWLAxioms(null);
        this.initResults();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "owl-results.rdf";
        String string2 = null;
        if (stringArray.length >= 1) {
            string2 = stringArray[0];
        }
        WebOntTests webOntTests = new WebOntTests();
        OntDocumentManager.getInstance().addAltEntry("http://www.w3.org/2002/03owlt/miscellaneous/consistent002", "file:testing/wg/miscellaneous/consistent002.rdf");
        OntDocumentManager.getInstance().addAltEntry("http://www.w3.org/2002/03owlt/miscellaneous/consistent001", "file:testing/wg/miscellaneous/consistent001.rdf");
        if (string2 == null) {
            webOntTests.runTests();
        } else {
            webOntTests.runTest(string2);
        }
        RDFWriter rDFWriter = webOntTests.m_testResults.getWriter("RDF/XML-ABBREV");
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        rDFWriter.setProperty("showXmlDeclaration", "true");
        webOntTests.m_testResults.setNsPrefix("", "http://www.w3.org/1999/xhtml");
        rDFWriter.write(webOntTests.m_testResults, fileOutputStream, BASE_RESULTS_URI);
    }

    public void runTests() {
        System.out.println("Testing " + (s_approvedOnly ? "only APPROVED" : "APPROVED and PROPOSED"));
        System.out.println("Positive entailment: ");
        this.runTests(this.findTestsOfType(OWLTest.PositiveEntailmentTest));
        System.out.println("\nNegative entailment: ");
        this.runTests(this.findTestsOfType(OWLTest.NegativeEntailmentTest));
        System.out.println("\nTrue tests: ");
        this.runTests(this.findTestsOfType(OWLTest.TrueTest));
        System.out.println("\nOWL for OWL tests: ");
        this.runTests(this.findTestsOfType(OWLTest.OWLforOWLTest));
        System.out.println("\nImport entailment tests: ");
        this.runTests(this.findTestsOfType(OWLTest.ImportEntailmentTest));
        System.out.println("\nInconsistency tests: ");
        this.runTests(this.findTestsOfType(OWLTest.InconsistencyTest));
        System.out.println("\nPassed " + this.m_passCount + " out of " + this.m_testCount);
    }

    public void runTests(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.runTest((Resource)iterator.next());
        }
    }

    public void runTest(String string) {
        this.runTest(this.m_testDefinitions.getResource(string));
    }

    public void runTest(Resource resource) {
        System.out.println("Running " + resource);
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.doRunTest(resource);
        }
        catch (Exception exception) {
            bl2 = true;
            System.err.print("\nException: " + exception);
            exception.printStackTrace();
        }
        ++this.m_testCount;
        if (bl) {
            System.out.print(this.m_testCount % 40 == 0 ? ".\n" : ".");
            System.out.flush();
            ++this.m_passCount;
        } else {
            System.out.println("\nFAIL: " + resource);
        }
        Resource resource2 = null;
        resource2 = bl2 ? OWLResults.FailingRun : (resource.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.ConsistencyTest) ? (bl ? OWLResults.PassingRun : OWLResults.FailingRun) : (bl ? OWLResults.PassingRun : OWLResults.IncompleteRun));
        Resource resource3 = this.m_testResults.createResource().addProperty(RDF.type, OWLResults.TestRun).addProperty(RDF.type, resource2).addProperty(OWLResults.test, resource).addProperty(OWLResults.system, this.m_jena2);
    }

    public boolean doRunTest(Resource resource) throws IOException {
        if (resource.hasProperty(RDF.type, OWLTest.PositiveEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.OWLforOWLTest) || resource.hasProperty(RDF.type, OWLTest.ImportEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.TrueTest)) {
            System.out.println("Starting: " + resource);
            boolean bl = resource.hasProperty(RDF.type, OWLTest.ImportEntailmentTest);
            Model model = this.getDoc(resource, RDFTest.premiseDocument, bl);
            Model model2 = this.getDoc(resource, RDFTest.conclusionDocument);
            long l = System.currentTimeMillis();
            boolean bl2 = this.testEntailment(model2, this.m_reasoner.bind(model.getGraph()));
            this.m_lastTestDuration = System.currentTimeMillis() - l;
            if (resource.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest)) {
                bl2 = !bl2;
            }
            return bl2;
        }
        if (resource.hasProperty(RDF.type, OWLTest.InconsistencyTest)) {
            System.out.println("Starting: " + resource);
            Model model = this.getDoc(resource, RDFTest.inputDocument);
            long l = System.currentTimeMillis();
            InfGraph infGraph = this.m_reasoner.bind(model.getGraph());
            boolean bl = !infGraph.validate().isValid();
            this.m_lastTestDuration = System.currentTimeMillis() - l;
            return bl;
        }
        if (resource.hasProperty(RDF.type, OWLTest.ConsistencyTest)) {
            System.out.println("Starting: " + resource);
            Model model = this.getDoc(resource, RDFTest.inputDocument);
            long l = System.currentTimeMillis();
            InfGraph infGraph = this.m_reasoner.bind(model.getGraph());
            boolean bl = infGraph.validate().isValid();
            long l2 = System.currentTimeMillis();
            this.m_lastTestDuration = l2 - l;
            return bl;
        }
        StmtIterator stmtIterator = resource.listProperties(RDF.type);
        while (stmtIterator.hasNext()) {
            System.out.println("Test type = " + stmtIterator.nextStatement().getObject());
        }
        throw new ReasonerException("Unknown test type");
    }

    public Model getDoc(Resource resource, Property property, boolean bl) throws IOException {
        if (bl) {
            OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
            StmtIterator stmtIterator = resource.listProperties(property);
            while (stmtIterator.hasNext()) {
                String string = ((Object)stmtIterator.nextStatement().getObject()).toString() + ".rdf";
                WebOntTests.loadFile(string, ontModel);
            }
            return ontModel;
        }
        return this.getDoc(resource, property);
    }

    public Model getDoc(Resource resource, Property property) throws IOException {
        Model model = ModelFactory.createDefaultModel();
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            String string = ((Object)stmtIterator.nextStatement().getObject()).toString() + ".rdf";
            WebOntTests.loadFile(string, model);
        }
        return model;
    }

    public static Model loadFile(String string, Model model) throws IOException {
        String string2 = "RDF/XML";
        if (string.endsWith(".nt")) {
            string2 = "N-TRIPLE";
        } else if (string.endsWith("n3")) {
            string2 = "N3";
        }
        String string3 = string;
        if (string3.startsWith(BASE_URI)) {
            string3 = string3.substring(BASE_URI.length());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(BASE_TESTDIR + string3));
        model.read(bufferedReader, BASE_URI + string3, string2);
        return model;
    }

    public boolean testEntailment(Model model, InfGraph infGraph) {
        ExtendedIterator extendedIterator;
        Object object;
        List list = this.listQueryRoots(model);
        Model model2 = ModelFactory.createDefaultModel();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (Resource)object2.next();
            extendedIterator = object.listProperties();
            while (extendedIterator.hasNext()) {
                Statement statement = extendedIterator.nextStatement();
                Resource resource = statement.getSubject();
                RDFNode rDFNode = statement.getObject();
                OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
                ontModel.setStrictMode(false);
                if (resource.isAnon()) {
                    this.addSubGraph(resource, ontModel);
                }
                if (rDFNode instanceof Resource && ((Resource)rDFNode).isAnon()) {
                    this.addSubGraph((Resource)rDFNode, ontModel);
                }
                try {
                    ExtendedIterator extendedIterator2 = infGraph.find(statement.getSubject().asNode(), statement.getPredicate().asNode(), statement.getObject().asNode(), ontModel.getGraph());
                    while (extendedIterator2.hasNext()) {
                        Object e = extendedIterator2.next();
                        Triple triple = (Triple)e;
                        LogFactory.getLog(this.getClass()).debug("testEntailment got triple " + triple);
                        model2.getGraph().add(triple);
                    }
                    model2.add(ontModel);
                }
                catch (DIGErrorResponseException dIGErrorResponseException) {
                    LogFactory.getLog(this.getClass()).error("DIG reasoner returned error: " + dIGErrorResponseException.getMessage());
                    return false;
                }
            }
        }
        model2.write(System.out, "RDF/XML-ABBREV");
        object2 = model2.queryHandler();
        object = WGReasonerTester.graphToQuery(model.getGraph());
        extendedIterator = object2.prepareBindings((Query)object, new Node[0]).executeBindings();
        return extendedIterator.hasNext();
    }

    protected Model loadAllTestDefinitions() {
        System.out.print("Loading manifests ");
        System.out.flush();
        Model model = ModelFactory.createDefaultModel();
        int n = 0;
        for (int i = 0; i < TEST_DIRS.length; ++i) {
            File file = new File(BASE_TESTDIR + TEST_DIRS[i]);
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.startsWith("Manifest") && string.endsWith(".rdf") && (s_includeModified || !string.endsWith("-mod.rdf"));
                }
            });
            if (stringArray == null) {
                System.err.println("No manifests for testing/wg/" + TEST_DIRS[i]);
                continue;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                File file2 = new File(file, string);
                try {
                    model.read(new FileInputStream(file2), "file:" + file2);
                    if (++n % 8 != 0) continue;
                    System.out.print(".");
                    System.out.flush();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("File not readable - " + fileNotFoundException);
                }
            }
        }
        System.out.println("loaded");
        return model;
    }

    protected void initResults() {
        this.m_testResults = ModelFactory.createDefaultModel();
        this.m_jena2 = this.m_testResults.createResource(BASE_RESULTS_URI + "#jena2");
        this.m_jena2.addProperty(RDFS.comment, this.m_testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> includes a rule-based inference engine for RDF processing, supporting both forward and backward chaining rules. Its OWL rule set is designed to provide sound but not complete instance resasoning for that fragment of OWL/Full limited to the OWL/lite vocabulary. Inparticular it does not support unionOf/complementOf.", true));
        this.m_jena2.addProperty(RDFS.label, "Jena2");
        this.m_testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    public List findTestsOfType(Resource resource) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        StmtIterator stmtIterator = this.m_testDefinitions.listStatements(null, RDF.type, resource);
        while (stmtIterator.hasNext()) {
            int n;
            Resource resource2 = stmtIterator.nextStatement().getSubject();
            boolean bl = true;
            Literal literal = (Literal)resource2.getProperty(RDFTest.status).getObject();
            if (s_approvedOnly) {
                bl = literal.getString().equals(STATUS_FLAGS[0]);
            } else {
                bl = false;
                for (n = 0; n < STATUS_FLAGS.length; ++n) {
                    if (!literal.getString().equals(STATUS_FLAGS[n])) continue;
                    bl = true;
                    break;
                }
            }
            for (n = 0; n < BLOCKED_TESTS.length; ++n) {
                if (!BLOCKED_TESTS[n].equals(((Object)resource2).toString())) continue;
                bl = false;
            }
            if (bl) {
                n = 1;
                StmtIterator stmtIterator2 = resource2.listProperties(OWLTest.level);
                while (stmtIterator2.hasNext()) {
                    if (!ACCEPTABLE_TEST_LEVELS.contains(stmtIterator2.nextStatement().getResource())) continue;
                    n = 0;
                }
                if (n != 0) {
                    LogFactory.getLog(this.getClass()).debug("Ignoring test " + resource2 + " because it either has no test level defined, or an unacceptable test level");
                    bl = false;
                }
            }
            if (!bl) continue;
            arrayList.add(resource2);
        }
        return arrayList;
    }

    protected List listQueryRoots(Model model) {
        HashSet hashSet = new HashSet();
        ArrayList arrayList = new ArrayList();
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
        Iterator iterator = model.listSubjects();
        while (iterator.hasNext()) {
            Resource resource = iterator.nextResource();
            if (resource.isAnon()) continue;
            arrayList2.add(resource);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            LogFactory.getLog(this.getClass()).debug("Found query root: " + iterator.next());
        }
        return arrayList2;
    }

    protected void addSubGraph(Resource resource, Model model) {
        ArrayList<RDFNode> arrayList = new ArrayList<RDFNode>();
        HashSet<Resource> hashSet = new HashSet<Resource>();
        arrayList.add(resource);
        while (!arrayList.isEmpty()) {
            Resource resource2 = (Resource)arrayList.remove(0);
            if (hashSet.contains(resource2)) continue;
            StmtIterator stmtIterator = resource2.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (!this.safePremise(statement.getPredicate())) continue;
                model.add(statement);
                if (!(statement.getObject() instanceof Resource)) continue;
                arrayList.add(statement.getObject());
            }
            hashSet.add(resource2);
        }
    }

    protected boolean safePremise(Property property) {
        return !UNSAFE_PREMISE_PREDICATES.contains(property);
    }

    static {
        UNSAFE_PREMISE_PREDICATES.add(OWL.equivalentClass);
        UNSAFE_PREMISE_PREDICATES.add(OWL.equivalentProperty);
        UNSAFE_PREMISE_PREDICATES.add(OWL.sameAs);
        UNSAFE_PREMISE_PREDICATES.add(RDFS.subClassOf);
        UNSAFE_PREMISE_PREDICATES.add(RDFS.subPropertyOf);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.sameClassAs);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.sameIndividualAs);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.samePropertyAs);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.subClassOf);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.subPropertyOf);
        s_includeModified = false;
        s_approvedOnly = true;
    }
}

