/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.AssertFRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BackchainFRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BaseFRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.PatternRouter;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.PropertyBRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasoner;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.ResourceBRWRule;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFSInfGraph
extends BaseInfGraph {
    protected TransitiveGraphCache subClassCache;
    protected boolean haveSplitSubClassCache = false;
    protected TransitiveGraphCache subPropertyCache;
    protected PatternRouter router;
    protected FGraph axioms = new FGraph(new GraphMem());
    protected Finder tbox;
    protected Finder tripleCache;
    protected HashMap dtRange = null;
    protected boolean scanProperties = true;
    protected static Log logger = LogFactory.getLog(RDFSInfGraph.class);
    protected static BaseFRule[] rules = new BaseFRule[]{new AssertFRule("?x rdf:type rdfs:Class -> ?x rdfs:subClassOf rdfs:Resource"), new AssertFRule("?x rdf:type rdfs:Class -> ?x rdfs:subClassOf ?x"), new AssertFRule("?x rdf:type rdf:Property -> ?x rdfs:subPropertyOf ?x"), new BackchainFRule("?p rdfs:subPropertyOf ?q -> ?s ?q ?o <- ?s ?p ?o"), new BackchainFRule("?c rdfs:subClassOf ?d -> ?s rdf:type ?d <- ?s rdf:type ?c"), new BackchainFRule("?p rdfs:domain ?z -> ?s rdf:type ?z <- ?s ?p _"), new BackchainFRule("?p rdfs:range ?z -> ?o rdf:type ?z <- _ ?p ?s")};
    protected static BRWRule[] brules = new BRWRule[]{new ResourceBRWRule(), new PropertyBRWRule()};
    protected static Triple[] baseAxioms = new Triple[]{BaseFRule.parseTriple("rdf:type rdfs:range rdfs:Class"), BaseFRule.parseTriple("rdfs:Resource rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:Literal rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:Statement rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:nil rdf:type rdf:List"), BaseFRule.parseTriple("rdf:XMLLiteral rdf:type rdfs:Datatype"), BaseFRule.parseTriple("rdf:Alt rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:Seq rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:Bag rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:XMLLiteral rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:Container rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:ContainerMembershipProperty rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:isDefinedBy rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:seeAlso rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:comment rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:label rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:subject rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:predicate rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:object rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:first rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:rest rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:type rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:range rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:domain rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:subPropertyOf rdfs:domain rdf:Property"), BaseFRule.parseTriple("rdfs:subPropertyOf rdfs:range rdf:Property"), BaseFRule.parseTriple("rdfs:subClassOf rdfs:domain rdfs:Class"), BaseFRule.parseTriple("rdfs:subClassOf rdfs:range rdfs:Class"), BaseFRule.parseTriple("rdfs:subPropertyOf rdfs:subPropertyOf rdfs:subPropertyOf"), BaseFRule.parseTriple("rdfs:subClassOf rdfs:subPropertyOf rdfs:subClassOf"), BaseFRule.parseTriple("rdf:subject rdfs:subPropertyOf rdf:subject"), BaseFRule.parseTriple("rdf:predicate rdfs:subPropertyOf rdf:predicate"), BaseFRule.parseTriple("rdf:object rdfs:subPropertyOf rdf:object"), BaseFRule.parseTriple("rdf:first rdfs:subPropertyOf rdf:first"), BaseFRule.parseTriple("rdf:rest rdfs:subPropertyOf rdf:rest"), BaseFRule.parseTriple("rdf:type rdfs:subPropertyOf rdf:type"), BaseFRule.parseTriple("rdfs:range rdfs:subPropertyOf rdfs:range"), BaseFRule.parseTriple("rdfs:domain rdfs:subPropertyOf rdfs:domain")};

    public RDFSInfGraph(RDFSReasoner rDFSReasoner, Graph graph) {
        super(graph, rDFSReasoner);
        this.scanProperties = rDFSReasoner.scanProperties;
    }

    public boolean getScanProperties() {
        return this.scanProperties;
    }

    public void setScanProperties(boolean bl) {
        this.scanProperties = bl;
    }

    public Graph getSchemaGraph() {
        if (this.tbox == null) {
            return null;
        }
        if (this.tbox instanceof FGraph) {
            return ((FGraph)this.tbox).getGraph();
        }
        throw new ReasonerException("RDFS1 reasoner got into an illegal state");
    }

    public void prepare() {
        this.subClassCache = ((TransitiveReasoner)this.reasoner).getSubClassCache();
        this.subPropertyCache = ((TransitiveReasoner)this.reasoner).getSubPropertyCache().deepCopy();
        this.tbox = ((TransitiveReasoner)this.reasoner).getTbox();
        this.haveSplitSubClassCache = false;
        this.tripleCache = this.tbox == null ? this.axioms : FinderUtil.cascade(this.axioms, this.tbox);
        Graph graph = this.fdata.getGraph();
        if (TransitiveEngine.checkOccuranceUtility(RDFSReasoner.subPropertyOf, graph, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(RDFSReasoner.subClassOf, graph, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(RDFSReasoner.domainP, graph, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(RDFSReasoner.rangeP, graph, this.subPropertyCache)) {
            FGraph fGraph = this.tbox == null ? this.fdata : FinderUtil.cascade(this.tbox, this.fdata);
            this.splitSubClassCache();
            TransitiveEngine.cacheSubPropUtility(fGraph, this.subPropertyCache);
            TransitiveEngine.cacheSubClassUtility(fGraph, this.subPropertyCache, this.subClassCache);
            this.subPropertyCache.setCaching(true);
        }
        for (int i = 0; i < baseAxioms.length; ++i) {
            this.axioms.getGraph().add(baseAxioms[i]);
        }
        TransitiveEngine.cacheSubPropUtility(this.axioms, this.subPropertyCache);
        if (this.scanProperties) {
            ExtendedIterator extendedIterator = this.tripleCache.findWithContinuation(new TriplePattern(null, null, null), this.fdata);
            HashSet<Node> hashSet = new HashSet<Node>();
            String string = RDF.getURI() + "_";
            Node node = RDF.Property.getNode();
            while (extendedIterator.hasNext()) {
                Triple triple = (Triple)extendedIterator.next();
                Node node2 = triple.getPredicate();
                if (node2.equals(RDF.type.getNode()) && node2.equals(RDF.Property.getNode())) {
                    node2 = triple.getSubject();
                }
                if (!hashSet.add(node2)) continue;
                this.subPropertyCache.addRelation(new Triple(node2, node, node2));
                if (!node2.getURI().startsWith(string)) continue;
                this.axioms.getGraph().add(new Triple(node2, RDF.type.getNode(), RDFS.ContainerMembershipProperty.getNode()));
                this.subPropertyCache.addRelation(new Triple(node2, node, RDFS.member.getNode()));
            }
        }
        this.router = new PatternRouter();
        this.router.register(this.subPropertyCache);
        this.router.register(this.subClassCache);
        this.checkAllForwardRules();
        for (int i = 0; i < brules.length; ++i) {
            this.addBRule(brules[i]);
        }
        this.isPrepared = true;
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        return new UniqueExtendedIterator(this.router.find(triplePattern, this.tripleCache, finder, this));
    }

    public ExtendedIterator findNested(TriplePattern triplePattern, Finder finder, HashSet hashSet) {
        return this.router.find(triplePattern, this.tripleCache, finder, this, hashSet);
    }

    public ExtendedIterator findRawWithContinuation(TriplePattern triplePattern, Finder finder) {
        return this.tripleCache.findWithContinuation(triplePattern, finder);
    }

    public ExtendedIterator findProperties() {
        return this.subPropertyCache.listAllSubjects();
    }

    public boolean isProperty(Node node) {
        return this.subPropertyCache.isSubject(node);
    }

    public ValidityReport validate() {
        StandardValidityReport standardValidityReport = new StandardValidityReport();
        HashMap hashMap = this.getDTRange();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ExtendedIterator extendedIterator = this.find(null, node, null);
            while (extendedIterator.hasNext()) {
                Triple triple = (Triple)extendedIterator.next();
                standardValidityReport.add(this.checkLiteral(node, triple.getObject()));
            }
        }
        return standardValidityReport;
    }

    private HashMap getDTRange() {
        if (this.dtRange == null) {
            this.dtRange = new HashMap();
            ExtendedIterator extendedIterator = this.find(null, RDFS.range.asNode(), null);
            while (extendedIterator.hasNext()) {
                RDFDatatype rDFDatatype;
                Triple triple = (Triple)extendedIterator.next();
                Node node = triple.getSubject();
                Node node2 = triple.getObject();
                if (!node2.isURI() || (rDFDatatype = TypeMapper.getInstance().getTypeByName(node2.getURI())) == null) continue;
                ArrayList<RDFDatatype> arrayList = (ArrayList<RDFDatatype>)this.dtRange.get(node);
                if (arrayList == null) {
                    arrayList = new ArrayList<RDFDatatype>();
                    this.dtRange.put(node, arrayList);
                }
                arrayList.add(rDFDatatype);
            }
        }
        return this.dtRange;
    }

    private ValidityReport.Report checkLiteral(Node node, Node node2) {
        List list = (List)this.getDTRange().get(node);
        if (list != null) {
            if (!node2.isLiteral()) {
                return new ValidityReport.Report(true, "dtRange", "Property " + node + " has a typed range but was given a non literal value " + node2);
            }
            LiteralLabel literalLabel = node2.getLiteral();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RDFDatatype rDFDatatype = (RDFDatatype)iterator.next();
                if (rDFDatatype.isValidLiteral(literalLabel)) continue;
                return new ValidityReport.Report(true, "dtRange", "Property " + node + " has a typed range " + rDFDatatype + "that is not compatible with " + node2);
            }
        }
        return null;
    }

    private void checkAllForwardRules() {
        Finder finder = FinderUtil.cascade(this.subPropertyCache, this.subClassCache, this.tripleCache);
        for (int i = 0; i < rules.length; ++i) {
            BaseFRule baseFRule = rules[i];
            TriplePattern triplePattern = baseFRule.getHead();
            Node node = triplePattern.getPredicate();
            if (node.isVariable()) {
                this.checkRule(triplePattern, baseFRule, finder);
                continue;
            }
            TriplePattern triplePattern2 = new TriplePattern(null, TransitiveReasoner.subPropertyOf, node);
            ExtendedIterator extendedIterator = this.subPropertyCache.find(triplePattern2);
            while (extendedIterator.hasNext()) {
                TriplePattern triplePattern3 = new TriplePattern(triplePattern.getSubject(), ((Triple)extendedIterator.next()).getSubject(), triplePattern.getObject());
                this.checkRule(triplePattern3, baseFRule, finder);
            }
        }
    }

    private void checkRule(TriplePattern triplePattern, BaseFRule baseFRule, Finder finder) {
        ExtendedIterator extendedIterator = finder.findWithContinuation(triplePattern, this.fdata);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            baseFRule.bindAndFire(triple, this);
        }
    }

    public void assertTriple(Triple triple) {
        this.axioms.getGraph().add(triple);
    }

    public void addBRule(BRWRule bRWRule) {
        this.router.register(bRWRule);
    }

    private void splitSubClassCache() {
        if (!this.haveSplitSubClassCache) {
            this.subClassCache = this.subClassCache.deepCopy();
            this.haveSplitSubClassCache = true;
        }
    }

    public String toString() {
        ExtendedIterator extendedIterator;
        StringBuffer stringBuffer = new StringBuffer();
        TriplePattern triplePattern = new TriplePattern(null, null, null);
        if (this.tripleCache != null) {
            stringBuffer.append("axioms + tbox\n");
            extendedIterator = this.tripleCache.find(triplePattern);
            while (extendedIterator.hasNext()) {
                stringBuffer.append(TriplePattern.simplePrintString((Triple)extendedIterator.next()));
                stringBuffer.append("\n");
            }
        }
        if (this.fdata != null) {
            stringBuffer.append("Bound raw data\n");
            extendedIterator = this.fdata.find(triplePattern);
            while (extendedIterator.hasNext()) {
                stringBuffer.append(TriplePattern.simplePrintString((Triple)extendedIterator.next()));
                stringBuffer.append("\n");
            }
        }
        if (this.router != null) {
            stringBuffer.append("Rule set\n");
            stringBuffer.append(this.router.toString());
        }
        return stringBuffer.toString();
    }
}

