/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OWLFBRuleReasoner
extends FBRuleReasoner {
    protected static final String RULE_FILE = "etc/owl-fb.rules";
    protected static List ruleSet;
    protected static FBRuleInfGraph staticPreload;
    protected static Log logger;

    public OWLFBRuleReasoner(ReasonerFactory reasonerFactory) {
        super(OWLFBRuleReasoner.loadRules(), reasonerFactory);
    }

    private OWLFBRuleReasoner(OWLFBRuleReasoner oWLFBRuleReasoner, InfGraph infGraph) {
        super(oWLFBRuleReasoner.rules, infGraph, oWLFBRuleReasoner.factory);
    }

    public static List loadRules() {
        if (ruleSet == null) {
            ruleSet = OWLFBRuleReasoner.loadRules(RULE_FILE);
        }
        return ruleSet;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        this.checkArgGraph(graph);
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this, this.rules, this.getPreload(), graph);
        fBRuleInfGraph.addPreprocessingHook(new OWLRuleTranslationHook());
        fBRuleInfGraph.prepare();
        return new OWLFBRuleReasoner(this, fBRuleInfGraph);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        this.checkArgGraph(graph);
        FBRuleInfGraph fBRuleInfGraph = null;
        InfGraph infGraph = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        List list = ((FBRuleInfGraph)infGraph).getRules();
        fBRuleInfGraph = new FBRuleInfGraph(this, list, infGraph);
        fBRuleInfGraph.addPreprocessingHook(new OWLRuleTranslationHook());
        fBRuleInfGraph.setDerivationLogging(this.recordDerivations);
        fBRuleInfGraph.setTraceOn(this.traceOn);
        fBRuleInfGraph.rebind(graph);
        return fBRuleInfGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfGraph getPreload() {
        Class clazz = OWLFBRuleReasoner.class;
        synchronized (clazz) {
            if (staticPreload == null) {
                boolean bl = JenaParameters.enableFilteringOfHiddenInfNodes;
                try {
                    JenaParameters.enableFilteringOfHiddenInfNodes = true;
                    staticPreload = new FBRuleInfGraph(this, this.rules, null);
                    staticPreload.prepare();
                }
                finally {
                    JenaParameters.enableFilteringOfHiddenInfNodes = bl;
                }
            }
            return staticPreload;
        }
    }

    private void checkArgGraph(Graph graph) {
        if (JenaParameters.enableOWLRuleOverOWLRuleWarnings && graph instanceof InfGraph && ((InfGraph)graph).getReasoner() instanceof OWLFBRuleReasoner) {
            logger.warn("Creating OWL rule reasoner working over another OWL rule reasoner");
        }
    }

    static {
        logger = LogFactory.getLog(OWLFBRuleReasoner.class);
    }
}

