/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.ChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.EnvironmentFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.EnvironmentFrameWithDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.FrameObject;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterState;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.reasoner.rulesys.impl.TopLevelTripleMatchFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.TripleMatchFrame;
import com.hp.hpl.jena.util.PrintUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LPInterpreter {
    protected LPBRuleEngine engine;
    protected LPInterpreterContext iContext;
    protected boolean isComplete = false;
    protected Node[] tVars = new Node[8];
    protected Node[] argVars = new Node[8];
    protected Node[] pVars = null;
    protected EnvironmentFrame envFrame;
    protected FrameObject cpFrame;
    protected ArrayList trail = new ArrayList();
    protected RuleContext context;
    protected TopLevelTripleMatchFrame topTMFrame;
    protected TriplePattern goal;
    static Log logger = LogFactory.getLog(LPInterpreter.class);

    public LPInterpreter(LPBRuleEngine lPBRuleEngine, TriplePattern triplePattern) {
        this(lPBRuleEngine, triplePattern, lPBRuleEngine.getRuleStore().codeFor(triplePattern), true);
    }

    public LPInterpreter(LPBRuleEngine lPBRuleEngine, TriplePattern triplePattern, boolean bl) {
        this(lPBRuleEngine, triplePattern, lPBRuleEngine.getRuleStore().codeFor(triplePattern), bl);
    }

    public LPInterpreter(LPBRuleEngine lPBRuleEngine, TriplePattern triplePattern, List list, boolean bl) {
        this.engine = lPBRuleEngine;
        this.goal = triplePattern;
        this.envFrame = lPBRuleEngine.getDerivationLogging() ? new EnvironmentFrameWithDerivation(RuleClauseCode.returnCodeBlock) : new EnvironmentFrame(RuleClauseCode.returnCodeBlock);
        this.envFrame.allocate(15);
        HashMap hashMap = new HashMap();
        this.envFrame.pVars[0] = this.argVars[0] = this.standardize(triplePattern.getSubject(), hashMap);
        this.envFrame.pVars[1] = this.argVars[1] = this.standardize(triplePattern.getPredicate(), hashMap);
        this.envFrame.pVars[2] = this.argVars[2] = this.standardize(triplePattern.getObject(), hashMap);
        if (lPBRuleEngine.getDerivationLogging()) {
            ((EnvironmentFrameWithDerivation)this.envFrame).initDerivationRecord(this.argVars);
        }
        if (list != null && list.size() > 0) {
            if (bl && lPBRuleEngine.getRuleStore().isTabled(triplePattern)) {
                this.setupTabledCall(0, 0);
            } else {
                this.setupClauseCall(0, 0, list);
            }
        }
        this.topTMFrame = new TopLevelTripleMatchFrame(this, triplePattern);
        this.topTMFrame.linkTo(this.cpFrame);
        this.topTMFrame.setContinuation(0, 0);
        this.cpFrame = this.topTMFrame;
    }

    public void setTopInterpreter(LPInterpreterContext lPInterpreterContext) {
        this.iContext = lPInterpreterContext;
        FrameObject frameObject = this.topTMFrame.getLink();
        if (frameObject instanceof ConsumerChoicePointFrame) {
            ((ConsumerChoicePointFrame)frameObject).context = lPInterpreterContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LPBRuleEngine lPBRuleEngine = this.engine;
        synchronized (lPBRuleEngine) {
            this.isComplete = true;
            this.engine.detach(this);
            if (this.cpFrame != null) {
                this.cpFrame.close();
            }
        }
    }

    public void setState(LPInterpreterState lPInterpreterState) {
        if (lPInterpreterState instanceof ConsumerChoicePointFrame) {
            this.restoreState((ConsumerChoicePointFrame)lPInterpreterState);
        } else {
            this.iContext = (LPInterpreterContext)lPInterpreterState;
        }
    }

    public Object next() {
        boolean bl = this.engine.isTraceOn();
        StateFlag stateFlag = this.run();
        if (stateFlag == StateFlag.FAIL || stateFlag == StateFlag.SUSPEND) {
            return stateFlag;
        }
        if (stateFlag == StateFlag.SATISFIED) {
            if (bl) {
                logger.info("RETURN: " + this.topTMFrame.lastMatch);
            }
            return this.topTMFrame.lastMatch;
        }
        Triple triple = new Triple(LPInterpreter.deref(this.pVars[0]), LPInterpreter.deref(this.pVars[1]), LPInterpreter.derefPossFunctor(this.pVars[2]));
        if (bl) {
            logger.info("RETURN: " + triple);
        }
        return triple;
    }

    public LPBRuleEngine getEngine() {
        return this.engine;
    }

    public FrameObject getChoiceFrame() {
        return this.cpFrame;
    }

    public LPInterpreterContext getContext() {
        return this.iContext;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected StateFlag run() {
        var1_1 = 0;
        var2_2 = 0;
        var3_3 = null;
        var4_4 = null;
        var7_5 = this.engine.isTraceOn();
        var8_6 = this.engine.getDerivationLogging();
        block25: while (this.cpFrame != null) {
            if (this.cpFrame instanceof ChoicePointFrame) {
                var4_4 = (ChoicePointFrame)this.cpFrame;
                if (!var4_4.hasNext()) {
                    this.cpFrame = var4_4.getLink();
                    if (!var7_5) continue;
                    LPInterpreter.logger.info("FAIL in clause " + var4_4.envFrame.clause + " choices exhausted");
                    continue;
                }
                var3_3 = var4_4.nextClause();
                this.envFrame = var8_6 != false ? new EnvironmentFrameWithDerivation(var3_3) : new EnvironmentFrame(var3_3);
                this.envFrame.linkTo(var4_4.envFrame);
                this.envFrame.cpc = var4_4.cpc;
                this.envFrame.cac = var4_4.cac;
                System.arraycopy(var4_4.argVars, 0, this.argVars, 0, 8);
                var9_9 = var4_4.trailIndex;
                if (var9_9 < this.trail.size()) {
                    this.unwindTrail(var9_9);
                }
                var2_2 = 0;
                var1_1 = 0;
                if (var8_6) {
                    ((EnvironmentFrameWithDerivation)this.envFrame).initDerivationRecord(this.argVars);
                }
                if (var7_5) {
                    LPInterpreter.logger.info("ENTER " + var3_3 + " : " + this.getArgTrace());
                }
            } else if (this.cpFrame instanceof TripleMatchFrame) {
                var9_10 = (TripleMatchFrame)this.cpFrame;
                this.envFrame = var9_10.envFrame;
                var3_3 = this.envFrame.clause;
                var10_13 = var9_10.trailIndex;
                if (var10_13 < this.trail.size()) {
                    this.unwindTrail(var10_13);
                }
                if (!var9_10.nextMatch(this)) {
                    this.cpFrame = this.cpFrame.getLink();
                    if (!var7_5) continue;
                    LPInterpreter.logger.info("TRIPLE match (" + var9_10.goal + ") -> FAIL");
                    continue;
                }
                if (var7_5) {
                    LPInterpreter.logger.info("TRIPLE match (" + var9_10.goal + ") -> " + this.getArgTrace());
                    LPInterpreter.logger.info("RENTER " + var3_3);
                }
                var1_1 = var9_10.cpc;
                var2_2 = var9_10.cac;
                if (var8_6 && this.envFrame instanceof EnvironmentFrameWithDerivation) {
                    ((EnvironmentFrameWithDerivation)this.envFrame).noteMatch(var9_10.goal, var1_1);
                }
            } else {
                if (this.cpFrame instanceof TopLevelTripleMatchFrame) {
                    var9_11 = (TopLevelTripleMatchFrame)this.cpFrame;
                    if (!var9_11.nextMatch(this)) {
                        this.cpFrame = this.cpFrame.getLink();
                        if (!var7_5) continue;
                        LPInterpreter.logger.info("TRIPLE match (" + var9_11.goal + ") -> FAIL");
                        continue;
                    }
                    if (var7_5) {
                        LPInterpreter.logger.info("TRIPLE match (" + var9_11.goal + ") ->");
                    }
                    return StateFlag.SATISFIED;
                }
                if (this.cpFrame instanceof ConsumerChoicePointFrame) {
                    var9_12 = (ConsumerChoicePointFrame)this.cpFrame;
                    this.envFrame = var9_12.envFrame;
                    var3_3 = this.envFrame.clause;
                    if (var7_5) {
                        LPInterpreter.logger.info("RESTORE " + var3_3 + ", due to tabled goal " + var9_12.generator.goal);
                    }
                    if ((var10_13 = var9_12.trailIndex) < this.trail.size()) {
                        this.unwindTrail(var10_13);
                    }
                    if ((var11_14 = var9_12.nextMatch(this)) == StateFlag.FAIL) {
                        this.cpFrame = this.cpFrame.getLink();
                        if (!var7_5) continue;
                        LPInterpreter.logger.info("FAIL " + var3_3);
                        continue;
                    }
                    if (var11_14 == StateFlag.SUSPEND) {
                        this.preserveState(var9_12);
                        this.iContext.notifyBlockedOn(var9_12);
                        this.cpFrame = this.cpFrame.getLink();
                        if (!var7_5) continue;
                        LPInterpreter.logger.info("SUSPEND " + var3_3);
                        continue;
                    }
                    var1_1 = var9_12.cpc;
                    var2_2 = var9_12.cac;
                    if (var8_6 && this.envFrame instanceof EnvironmentFrameWithDerivation) {
                        ((EnvironmentFrameWithDerivation)this.envFrame).noteMatch(var9_12.goal, var1_1);
                    }
                } else {
                    throw new ReasonerException("Internal error in backward rule system, unrecognized choice point");
                }
            }
            this.engine.incrementProfile(var3_3);
            block26: while (this.envFrame != null) {
                this.pVars = this.envFrame.pVars;
                var5_7 = var3_3.getCode();
                var6_8 = var3_3.getArgs();
                block27: while (true) {
                    switch (var5_7[var1_1++]) {
                        case 32: {
                            if (!LPInterpreter.deref(this.argVars[var10_13 = var5_7[var1_1++]]).isVariable()) continue block27;
                            if (!var7_5) continue block25;
                            LPInterpreter.logger.info("FAIL " + var3_3);
                            continue block25;
                        }
                        case 33: {
                            if (LPInterpreter.deref(this.argVars[var10_13 = var5_7[var1_1++]]).isVariable()) continue block27;
                            if (!var7_5) continue block25;
                            LPInterpreter.logger.info("FAIL " + var3_3);
                            continue block25;
                        }
                        case 22: {
                            var16_20 = var5_7[var1_1++];
                            this.envFrame.allocate(var16_20);
                            this.pVars = this.envFrame.pVars;
                            continue block27;
                        }
                        case 2: {
                            var9_9 = var5_7[var1_1++];
                            var10_13 = var5_7[var1_1++];
                            this.pVars[var9_9] = this.argVars[var10_13];
                            continue block27;
                        }
                        case 4: {
                            var11_15 = var5_7[var1_1++];
                            var10_13 = var5_7[var1_1++];
                            this.tVars[var11_15] = this.argVars[var10_13];
                            continue block27;
                        }
                        case 1: {
                            var10_13 = var5_7[var1_1++];
                            var12_18 = this.argVars[var10_13];
                            if (var12_18 instanceof Node_RuleVariable) {
                                var12_18 = ((Node_RuleVariable)var12_18).deref();
                            }
                            var13_19 = (Node)var6_8[var2_2++];
                            if (var12_18 instanceof Node_RuleVariable) {
                                this.bind(var12_18, var13_19);
                                continue block27;
                            }
                            if (var12_18.sameValueAs(var13_19)) continue block27;
                            if (!var7_5) continue block25;
                            LPInterpreter.logger.info("FAIL " + var3_3);
                            continue block25;
                        }
                        case 10: {
                            var17_21 = (Functor)var6_8[var2_2++];
                            var18_22 = false;
                            var19_23 = this.argVars[2];
                            if (var19_23 instanceof Node_RuleVariable) {
                                var19_23 = ((Node_RuleVariable)var19_23).deref();
                            }
                            if (Functor.isFunctor(var19_23)) {
                                var20_24 /* !! */  = (Functor)var19_23.getLiteral().getValue();
                                if (var20_24 /* !! */ .getName().equals(var17_21.getName()) && var20_24 /* !! */ .getArgLength() == var17_21.getArgLength()) {
                                    var21_25 = var20_24 /* !! */ .getArgs();
                                    for (var22_26 = 0; var22_26 < var21_25.length; ++var22_26) {
                                        this.argVars[var22_26 + 3] = var21_25[var22_26];
                                    }
                                    var18_22 = true;
                                }
                            } else if (var19_23.isVariable()) {
                                var20_24 /* !! */  = new Node[var17_21.getArgLength()];
                                var21_25 = var17_21.getArgs();
                                for (var22_26 = 0; var22_26 < var20_24 /* !! */ .length; ++var22_26) {
                                    var23_31 = var21_25[var22_26];
                                    if (var23_31.isVariable()) {
                                        var23_31 = new Node_RuleVariable(null, var22_26 + 3);
                                    }
                                    var20_24 /* !! */ [var22_26] = var23_31;
                                    this.argVars[var22_26 + 3] = var23_31;
                                }
                                var22_27 = Functor.makeFunctorNode(var17_21.getName(), var20_24 /* !! */ );
                                this.bind(((Node_RuleVariable)var19_23).deref(), var22_27);
                                var18_22 = true;
                            }
                            if (var18_22) continue block27;
                            if (!var7_5) continue block25;
                            LPInterpreter.logger.info("FAIL " + var3_3);
                            continue block25;
                        }
                        case 3: {
                            if (this.unify(this.argVars[var10_13 = var5_7[var1_1++]], this.pVars[var9_9 = var5_7[var1_1++]])) continue block27;
                            if (!var7_5) continue block25;
                            LPInterpreter.logger.info("FAIL " + var3_3);
                            continue block25;
                        }
                        case 18: {
                            if (this.unify(this.argVars[var10_13 = var5_7[var1_1++]], this.tVars[var11_16 = var5_7[var1_1++]])) continue block27;
                            if (!var7_5) continue block25;
                            LPInterpreter.logger.info("FAIL " + var3_3);
                            continue block25;
                        }
                        case 6: {
                            var9_9 = var5_7[var1_1++];
                            var10_13 = var5_7[var1_1++];
                            this.argVars[var10_13] = this.pVars[var9_9] = new Node_RuleVariable(null, var9_9);
                            continue block27;
                        }
                        case 7: {
                            var9_9 = var5_7[var1_1++];
                            var10_13 = var5_7[var1_1++];
                            this.argVars[var10_13] = this.pVars[var9_9];
                            continue block27;
                        }
                        case 20: {
                            var9_9 = var5_7[var1_1++];
                            var10_13 = var5_7[var1_1++];
                            this.argVars[var10_13] = LPInterpreter.deref(this.pVars[var9_9]);
                            continue block27;
                        }
                        case 8: {
                            var11_17 = var5_7[var1_1++];
                            var10_13 = var5_7[var1_1++];
                            this.argVars[var10_13] = this.tVars[var11_17];
                            continue block27;
                        }
                        case 5: {
                            var10_13 = var5_7[var1_1++];
                            this.argVars[var10_13] = (Node)var6_8[var2_2++];
                            continue block27;
                        }
                        case 16: {
                            var10_13 = var5_7[var1_1++];
                            this.argVars[var10_13] = new Node_RuleVariable(null, var10_13);
                            continue block27;
                        }
                        case 12: {
                            var20_24 /* !! */  = (Node[])var6_8[var2_2++];
                            var21_25 = new Node[var20_24 /* !! */ .getArgLength()];
                            System.arraycopy(this.argVars, 3, var21_25, 0, var21_25.length);
                            this.argVars[2] = Functor.makeFunctorNode(var20_24 /* !! */ .getName(), var21_25);
                            continue block27;
                        }
                        case 9: 
                        case 19: {
                            var22_28 = (List)var6_8[var2_2++];
                            this.setupClauseCall(var1_1, var2_2, var22_28);
                            this.setupTripleMatchCall(var1_1, var2_2);
                            continue block25;
                        }
                        case 23: {
                            var22_29 = (List)var6_8[var2_2++];
                            if (!this.argVars[2].isVariable()) {
                                var22_29 = this.engine.getRuleStore().codeFor(new TriplePattern(this.argVars[0], this.argVars[1], this.argVars[2]));
                            }
                            this.setupClauseCall(var1_1, var2_2, var22_29);
                            this.setupTripleMatchCall(var1_1, var2_2);
                            continue block25;
                        }
                        case 17: {
                            this.setupTripleMatchCall(var1_1, var2_2);
                            continue block25;
                        }
                        case 24: {
                            this.setupTabledCall(var1_1, var2_2);
                            continue block25;
                        }
                        case 25: {
                            var23_31 = LPInterpreter.deref(this.argVars[1]);
                            if (this.engine.getRuleStore().isTabled(var23_31)) {
                                this.setupTabledCall(var1_1, var2_2);
                                continue block25;
                            }
                            var22_30 = this.engine.getRuleStore().codeFor(new TriplePattern(this.argVars[0], var23_31, this.argVars[2]));
                            if (var22_30 != null) {
                                this.setupClauseCall(var1_1, var2_2, var22_30);
                            }
                            this.setupTripleMatchCall(var1_1, var2_2);
                            continue block25;
                        }
                        case 11: {
                            var1_1 = this.envFrame.cpc;
                            var2_2 = this.envFrame.cac;
                            if (var7_5) {
                                LPInterpreter.logger.info("EXIT " + var3_3);
                            }
                            if (var8_6 && this.envFrame.getRule() != null && this.envFrame instanceof EnvironmentFrameWithDerivation) {
                                var24_32 = (EnvironmentFrameWithDerivation)this.envFrame;
                                var25_33 = var24_32.getResult();
                                var26_34 = var24_32.getMatchList();
                                var27_35 = this.engine.getInfGraph();
                                var28_36 = new RuleDerivation(this.envFrame.getRule(), (Triple)var25_33, var26_34, var27_35);
                                var27_35.logDerivation((Triple)var25_33, var28_36);
                            }
                            this.envFrame = (EnvironmentFrame)this.envFrame.link;
                            if (this.envFrame == null) continue block26;
                            var3_3 = this.envFrame.clause;
                            continue block26;
                        }
                        case 13: {
                            var24_32 = (Builtin)var6_8[var2_2++];
                            if (this.context == null) {
                                var25_33 = new BBRuleContext(this.engine.getInfGraph());
                                var25_33.setEnv(new LPBindingEnvironment(this));
                                this.context = var25_33;
                            }
                            this.context.setRule(var3_3.getRule());
                            if (!var24_32.bodyCall(this.argVars, var5_7[var1_1++], this.context)) ** break;
                            continue block27;
                            if (!var7_5) continue block25;
                            LPInterpreter.logger.info("FAIL " + var3_3 + ", due to " + var24_32.getName());
                            continue block25;
                        }
                    }
                    break;
                }
                throw new ReasonerException("Internal error in backward rule system\nIllegal op code");
            }
            return StateFlag.ACTIVE;
        }
        return StateFlag.FAIL;
    }

    private String getArgTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PrintUtil.print(LPInterpreter.deref(this.argVars[0])));
        stringBuffer.append(" ");
        stringBuffer.append(PrintUtil.print(LPInterpreter.deref(this.argVars[1])));
        stringBuffer.append(" ");
        stringBuffer.append(PrintUtil.print(LPInterpreter.deref(this.argVars[2])));
        return stringBuffer.toString();
    }

    private void setupTripleMatchCall(int n, int n2) {
        TripleMatchFrame tripleMatchFrame = new TripleMatchFrame(this);
        tripleMatchFrame.setContinuation(n, n2);
        tripleMatchFrame.linkTo(this.cpFrame);
        this.cpFrame = tripleMatchFrame;
    }

    private void setupClauseCall(int n, int n2, List list) {
        ChoicePointFrame choicePointFrame = new ChoicePointFrame(this, list);
        choicePointFrame.linkTo(this.cpFrame);
        choicePointFrame.setContinuation(n, n2);
        this.cpFrame = choicePointFrame;
    }

    private void setupTabledCall(int n, int n2) {
        ConsumerChoicePointFrame consumerChoicePointFrame = new ConsumerChoicePointFrame(this);
        consumerChoicePointFrame.linkTo(this.cpFrame);
        consumerChoicePointFrame.setContinuation(n, n2);
        this.cpFrame = consumerChoicePointFrame;
    }

    public void preserveState(ConsumerChoicePointFrame consumerChoicePointFrame) {
        consumerChoicePointFrame.preserveState(this.trail);
    }

    public void restoreState(ConsumerChoicePointFrame consumerChoicePointFrame) {
        this.cpFrame = consumerChoicePointFrame;
        consumerChoicePointFrame.restoreState(this);
        this.iContext = consumerChoicePointFrame.context;
    }

    public boolean unify(Node node, Node node2) {
        Node node3;
        Node node4 = node;
        if (node4 instanceof Node_RuleVariable) {
            node4 = ((Node_RuleVariable)node).deref();
        }
        if ((node3 = node2) instanceof Node_RuleVariable) {
            node3 = ((Node_RuleVariable)node2).deref();
        }
        if (node4 instanceof Node_RuleVariable) {
            this.bind(node4, node3);
            return true;
        }
        if (node3 instanceof Node_RuleVariable) {
            this.bind(node3, node4);
            return true;
        }
        return node4.sameValueAs(node3);
    }

    public void bind(Node node, Node node2) {
        ((Node_RuleVariable)node).simpleBind(node2);
        this.trail.add(node);
    }

    public void unwindTrail(int n) {
        for (int i = this.trail.size() - 1; i >= n; --i) {
            Node_RuleVariable node_RuleVariable = (Node_RuleVariable)this.trail.get(i);
            node_RuleVariable.unbind();
            this.trail.remove(i);
        }
    }

    public static Node deref(Node node) {
        if (node instanceof Node_RuleVariable) {
            return ((Node_RuleVariable)node).deref();
        }
        return node;
    }

    public static Node derefPossFunctor(Node node) {
        if (node instanceof Node_RuleVariable) {
            Node node2 = ((Node_RuleVariable)node).deref();
            if (node2.isVariable()) {
                throw new ReasonerException("Internal error in LP reasoner: variable in triple result");
            }
            if (Functor.isFunctor(node2)) {
                Functor functor = (Functor)node2.getLiteral().getValue();
                Node[] nodeArray = functor.getArgs();
                boolean bl = false;
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (!nodeArray[i].isVariable()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Node[] nodeArray2 = new Node[nodeArray.length];
                    for (int i = 0; i < nodeArray.length; ++i) {
                        nodeArray2[i] = LPInterpreter.deref(nodeArray[i]);
                    }
                    node2 = Functor.makeFunctorNode(functor.getName(), nodeArray2);
                }
                return node2;
            }
            return node2;
        }
        return node;
    }

    private Node standardize(Node node, Map map) {
        Node node2 = LPInterpreter.deref(node);
        if (node == Node.ANY || node == Node_RuleVariable.WILD) {
            return new Node_RuleVariable(null, 0);
        }
        if (node2.isVariable()) {
            Node node3 = (Node)map.get(node2);
            if (node3 == null) {
                node3 = new Node_RuleVariable(null, 0);
                map.put(node2, node3);
            }
            return node3;
        }
        return node2;
    }
}

