/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.Trail;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTrail
extends TestCase {
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");

    public TestTrail(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTrail.class);
    }

    public void testUnify() {
        Node_RuleVariable node_RuleVariable = new Node_RuleVariable("x", 0);
        Node_RuleVariable node_RuleVariable2 = new Node_RuleVariable("y", 1);
        Node_RuleVariable node_RuleVariable3 = new Node_RuleVariable("z", 2);
        Trail trail = new Trail();
        TestTrail.assertTrue(trail.unify(new TriplePattern(node_RuleVariable, this.p, node_RuleVariable2), new TriplePattern(this.a, this.p, this.b)));
        TestTrail.assertEquals(node_RuleVariable.deref(), this.a);
        TestTrail.assertEquals(node_RuleVariable2.deref(), this.b);
        TestTrail.assertTrue(node_RuleVariable3.isUnbound());
        trail.unwindAndClear();
        TestTrail.assertTrue(node_RuleVariable.isUnbound());
        TestTrail.assertTrue(node_RuleVariable2.isUnbound());
        TestTrail.assertTrue(trail.unify(new TriplePattern(node_RuleVariable, this.p, node_RuleVariable), new TriplePattern(node_RuleVariable3, this.p, this.a)));
        TestTrail.assertEquals(node_RuleVariable.deref(), this.a);
        TestTrail.assertEquals(node_RuleVariable3.deref(), this.a);
        trail.unwindAndClear();
        TriplePattern triplePattern = new TriplePattern(node_RuleVariable, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable, this.b}));
        TriplePattern triplePattern2 = new TriplePattern(node_RuleVariable2, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable3, this.b}));
        TriplePattern triplePattern3 = new TriplePattern(node_RuleVariable2, this.p, Functor.makeFunctorNode("f", new Node[]{this.a, node_RuleVariable2}));
        TriplePattern triplePattern4 = new TriplePattern(node_RuleVariable2, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, node_RuleVariable2}));
        TestTrail.assertTrue(trail.unify(triplePattern, triplePattern2));
        TestTrail.assertEquals(node_RuleVariable.deref(), node_RuleVariable2.deref());
        TestTrail.assertEquals(node_RuleVariable.deref(), node_RuleVariable3.deref());
        trail.unwindAndClear();
        TestTrail.assertTrue(!trail.unify(triplePattern, triplePattern3));
        TestTrail.assertTrue(node_RuleVariable.isUnbound());
        TestTrail.assertTrue(node_RuleVariable2.isUnbound());
        TestTrail.assertTrue(node_RuleVariable3.isUnbound());
        trail.unwindAndClear();
        TestTrail.assertTrue(trail.unify(triplePattern, triplePattern4));
        TestTrail.assertEquals(node_RuleVariable.deref(), this.b);
        TestTrail.assertEquals(node_RuleVariable2.deref(), this.b);
        trail.unwindAndClear();
    }

    public void testMatching() {
        Node_RuleVariable node_RuleVariable = new Node_RuleVariable("x", 0);
        Node_RuleVariable node_RuleVariable2 = new Node_RuleVariable("y", 1);
        Node_RuleVariable node_RuleVariable3 = new Node_RuleVariable("z", 2);
        Node_RuleVariable node_RuleVariable4 = new Node_RuleVariable("x1", 0);
        Node_RuleVariable node_RuleVariable5 = new Node_RuleVariable("y1", 1);
        Node_RuleVariable node_RuleVariable6 = new Node_RuleVariable("z1", 2);
        TestTrail.assertTrue(node_RuleVariable.sameValueAs(node_RuleVariable2));
        TriplePattern triplePattern = new TriplePattern(node_RuleVariable, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable, this.b}));
        TriplePattern triplePattern2 = new TriplePattern(node_RuleVariable2, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable3, this.b}));
        TriplePattern triplePattern3 = new TriplePattern(node_RuleVariable5, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable5, this.b}));
        TriplePattern triplePattern4 = new TriplePattern(node_RuleVariable4, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable6, this.b}));
        TestTrail.assertEquals(triplePattern, triplePattern2);
        TestTrail.assertEquals(triplePattern.hashCode(), triplePattern2.hashCode());
        TestTrail.assertTrue(triplePattern.variantOf(triplePattern3));
        TestTrail.assertTrue(triplePattern2.variantOf(triplePattern4));
        TestTrail.assertTrue(!triplePattern.variantOf(triplePattern2));
        TestTrail.assertTrue(!triplePattern3.variantOf(triplePattern4));
    }
}

