/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OWLWGTester {
    public static String BASE_URI = "http://www.w3.org/2002/03owlt/";
    public static String baseDir = "testing/wg/";
    public static final String NS_OTEST = "http://www.w3.org/2002/03owlt/testOntology#";
    public static final String NS_RTEST = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#";
    public static final Resource PositiveEntailmentTest;
    public static final Resource NegativeEntailmentTest;
    public static final Property descriptionP;
    public static final Property premiseDocumentP;
    public static final Property conclusionDocumentP;
    public static final Property statusP;
    protected ReasonerFactory reasonerF;
    protected Resource configuration;
    protected TestCase testcase;
    protected static long timeCost;
    protected static int numTests;
    protected static Log logger;

    public OWLWGTester(ReasonerFactory reasonerFactory, TestCase testCase, Resource resource) {
        this.reasonerF = reasonerFactory;
        this.testcase = testCase;
        this.configuration = resource;
    }

    public boolean runTests(String string, boolean bl, boolean bl2) throws IOException {
        Resource resource;
        Model model = FileManager.get().loadModel(baseDir + string);
        ResIterator resIterator = model.listSubjectsWithProperty(RDF.type, PositiveEntailmentTest);
        while (resIterator.hasNext()) {
            resource = resIterator.nextResource();
            if (this.runTest(resource, bl, bl2)) continue;
            return false;
        }
        resIterator = model.listSubjectsWithProperty(RDF.type, NegativeEntailmentTest);
        while (resIterator.hasNext()) {
            resource = resIterator.nextResource();
            if (this.runTest(resource, bl, bl2)) continue;
            return false;
        }
        return true;
    }

    public boolean runTest(Resource resource, boolean bl, boolean bl2) throws IOException {
        Object object;
        RDFNode rDFNode = resource.getRequiredProperty(RDF.type).getObject();
        if (!rDFNode.equals(NegativeEntailmentTest) && !rDFNode.equals(PositiveEntailmentTest)) {
            throw new JenaException("Can't find test: " + resource);
        }
        String string = ((Object)resource.getRequiredProperty(descriptionP).getObject()).toString();
        String string2 = ((Object)resource.getRequiredProperty(statusP).getObject()).toString();
        logger.debug("WG test " + resource.getURI() + " - " + string2);
        Model model = ModelFactory.createNonreifyingModel();
        Object object2 = resource.listProperties(premiseDocumentP);
        while (object2.hasNext()) {
            model.add(OWLWGTester.loadFile(((Object)object2.nextStatement().getObject()).toString() + ".rdf"));
        }
        object2 = (Resource)resource.getRequiredProperty(conclusionDocumentP).getObject();
        Model model2 = OWLWGTester.loadFile(object2.toString() + ".rdf");
        if (bl) {
            if (this.configuration == null) {
                object = ModelFactory.createDefaultModel();
                this.configuration = object.createResource();
            }
            this.configuration.addProperty(ReasonerVocabulary.PROPtraceOn, "true").addProperty(ReasonerVocabulary.PROPderivationLogging, "true");
        }
        object = this.reasonerF.create(this.configuration);
        long l = System.currentTimeMillis();
        InfGraph infGraph = object.bind(model.getGraph());
        Model model3 = ModelFactory.createModelForGraph(infGraph);
        if (!bl2 || infGraph instanceof FBRuleInfGraph) {
            // empty if block
        }
        boolean bl3 = true;
        bl3 = rDFNode.equals(PositiveEntailmentTest) ? this.testConclusions(model2.getGraph(), model3.getGraph()) : !this.testConclusions(model2.getGraph(), model3.getGraph());
        long l2 = System.currentTimeMillis();
        timeCost += l2 - l;
        ++numTests;
        if (bl2) {
            logger.info("Time=" + (l2 - l) + "ms for " + resource.getURI());
            this.printStats();
            if (infGraph instanceof FBRuleInfGraph) {
                ((FBRuleInfGraph)infGraph).printLPProfile();
            }
        }
        if (!bl3) {
            // empty if block
        }
        if (this.testcase != null) {
            TestCase.assertTrue("Test: " + resource + "\n" + this.reasonerF.getURI() + "\n" + string, bl3);
        }
        return bl3;
    }

    public static Model loadFile(String string) throws IOException {
        String string2 = "RDF/XML";
        if (string.endsWith(".nt")) {
            string2 = "N-TRIPLE";
        } else if (string.endsWith("n3")) {
            string2 = "N3";
        }
        Model model = ModelFactory.createNonreifyingModel();
        String string3 = string;
        if (string3.startsWith(BASE_URI)) {
            string3 = string3.substring(BASE_URI.length());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(baseDir + string3));
        model.read(bufferedReader, BASE_URI + string3, string2);
        return model;
    }

    private boolean testConclusions(Graph graph, Graph graph2) {
        QueryHandler queryHandler = graph2.queryHandler();
        Query query = WGReasonerTester.graphToQuery(graph);
        ExtendedIterator extendedIterator = queryHandler.prepareBindings(query, new Node[0]).executeBindings();
        return extendedIterator.hasNext();
    }

    public void printStats() {
        logger.info("Ran " + numTests + " in " + timeCost + "ms = " + timeCost / (long)numTests + "ms/test");
    }

    static {
        timeCost = 0L;
        numTests = 0;
        logger = LogFactory.getLog(OWLWGTester.class);
        PositiveEntailmentTest = ResourceFactory.createProperty(NS_OTEST, "PositiveEntailmentTest");
        NegativeEntailmentTest = ResourceFactory.createProperty(NS_OTEST, "NegativeEntailmentTest");
        descriptionP = ResourceFactory.createProperty(NS_RTEST, "description");
        premiseDocumentP = ResourceFactory.createProperty(NS_RTEST, "premiseDocument");
        conclusionDocumentP = ResourceFactory.createProperty(NS_RTEST, "conclusionDocument");
        statusP = ResourceFactory.createProperty(NS_RTEST, "status");
    }
}

