/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.LPBackwardRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBackchainer
extends TestCase {
    protected Node p = Node.createURI("p");
    protected Node q = Node.createURI("q");
    protected Node r = Node.createURI("r");
    protected Node s = Node.createURI("s");
    protected Node t = Node.createURI("t");
    protected Node a = Node.createURI("a");
    protected Node b = Node.createURI("b");
    protected Node c = Node.createURI("c");
    protected Node d = Node.createURI("d");
    protected Node C1 = Node.createURI("C1");
    protected Node C2 = Node.createURI("C2");
    protected Node C3 = Node.createURI("C3");
    protected Node sP = RDFS.subPropertyOf.getNode();
    protected Node sC = RDFS.subClassOf.getNode();
    protected Node ty = RDF.type.getNode();
    String testRules1 = "(?x ?q ?y) <- (?p rdfs:subPropertyOf ?q)(?x ?p ?y). (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b)(?b rdfs:subPropertyOf ?c). ";
    String testRuleAxioms = "[ -> (p rdfs:subPropertyOf q)][ -> (q rdfs:subPropertyOf r) ][ -> (a p b) ]";
    Triple[] dataElts = new Triple[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b)};

    public TestBackchainer(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBackchainer.class);
    }

    public Reasoner createReasoner(List list) {
        LPBackwardRuleReasoner lPBackwardRuleReasoner = new LPBackwardRuleReasoner(list);
        lPBackwardRuleReasoner.tablePredicate(this.sP);
        lPBackwardRuleReasoner.tablePredicate(this.sC);
        lPBackwardRuleReasoner.tablePredicate(this.ty);
        lPBackwardRuleReasoner.tablePredicate(this.p);
        lPBackwardRuleReasoner.tablePredicate(this.a);
        lPBackwardRuleReasoner.tablePredicate(this.b);
        return lPBackwardRuleReasoner;
    }

    public void testParse() {
        List list = Rule.parseRules(this.testRules1);
        TestBackchainer.assertEquals("BRule parsing", "[ (?x ?q ?y) <- (?p rdfs:subPropertyOf ?q) (?x ?p ?y) ]", list.get(0).toString());
        TestBackchainer.assertEquals("BRule parsing", "[ (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b) (?b rdfs:subPropertyOf ?c) ]", list.get(1).toString());
    }

    public void testUnify() {
        Node_RuleVariable node_RuleVariable = new Node_RuleVariable("?x", 0);
        Node_RuleVariable node_RuleVariable2 = new Node_RuleVariable("?y", 1);
        Node_RuleVariable node_RuleVariable3 = new Node_RuleVariable("?z", 2);
        Node_RuleVariable node_RuleVariable4 = new Node_RuleVariable("?x", 0);
        Node_RuleVariable node_RuleVariable5 = new Node_RuleVariable("?y", 1);
        Node_RuleVariable node_RuleVariable6 = new Node_RuleVariable("?z", 2);
        TriplePattern triplePattern = new TriplePattern(node_RuleVariable, this.p, node_RuleVariable2);
        TriplePattern triplePattern2 = new TriplePattern(node_RuleVariable, this.p, node_RuleVariable);
        TriplePattern triplePattern3 = new TriplePattern(this.a, this.p, node_RuleVariable);
        TriplePattern triplePattern4 = new TriplePattern(this.a, this.p, this.b);
        TriplePattern triplePattern5 = new TriplePattern(node_RuleVariable4, this.p, node_RuleVariable5);
        TriplePattern triplePattern6 = new TriplePattern(node_RuleVariable4, this.p, node_RuleVariable4);
        TriplePattern triplePattern7 = new TriplePattern(this.a, this.p, node_RuleVariable4);
        TriplePattern triplePattern8 = new TriplePattern(this.a, this.p, this.b);
        TriplePattern triplePattern9 = new TriplePattern(node_RuleVariable4, this.p, this.a);
        this.doTestUnify(triplePattern, triplePattern5, true, new Node[]{null, null});
        this.doTestUnify(triplePattern, triplePattern6, true, new Node[]{null, null});
        this.doTestUnify(triplePattern, triplePattern7, true, new Node[]{null, null});
        this.doTestUnify(triplePattern, triplePattern8, true, new Node[]{null, null});
        this.doTestUnify(triplePattern, triplePattern9, true, new Node[]{null, null});
        this.doTestUnify(triplePattern2, triplePattern5, true, new Node[]{null, node_RuleVariable4});
        this.doTestUnify(triplePattern2, triplePattern6, true, new Node[]{null, null});
        this.doTestUnify(triplePattern2, triplePattern7, true, new Node[]{this.a, null});
        this.doTestUnify(triplePattern2, triplePattern8, false, null);
        this.doTestUnify(triplePattern2, triplePattern9, true, new Node[]{this.a, null});
        this.doTestUnify(triplePattern3, triplePattern5, true, new Node[]{this.a, null});
        this.doTestUnify(triplePattern3, triplePattern6, true, new Node[]{this.a, null});
        this.doTestUnify(triplePattern3, triplePattern7, true, new Node[]{null, null});
        this.doTestUnify(triplePattern3, triplePattern8, true, new Node[]{null, null});
        this.doTestUnify(triplePattern3, triplePattern9, true, new Node[]{this.a, null});
        this.doTestUnify(triplePattern4, triplePattern5, true, new Node[]{this.a, this.b});
        this.doTestUnify(triplePattern4, triplePattern6, false, null);
        this.doTestUnify(triplePattern4, triplePattern7, true, new Node[]{this.b});
        this.doTestUnify(triplePattern4, triplePattern8, true, null);
        this.doTestUnify(triplePattern4, triplePattern9, false, null);
        this.doTestUnify(triplePattern5, triplePattern5, true, new Node[]{null, null});
        this.doTestUnify(new TriplePattern(null, null, null), triplePattern6, true, new Node[]{null, null});
        TriplePattern triplePattern10 = new TriplePattern(node_RuleVariable, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable, this.b}));
        TriplePattern triplePattern11 = new TriplePattern(node_RuleVariable5, this.p, Functor.makeFunctorNode("f", new Node[]{node_RuleVariable6, this.b}));
        TriplePattern triplePattern12 = new TriplePattern(node_RuleVariable5, this.p, Functor.makeFunctorNode("f", new Node[]{this.a, node_RuleVariable5}));
        TriplePattern triplePattern13 = new TriplePattern(node_RuleVariable5, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, node_RuleVariable5}));
        this.doTestUnify(triplePattern10, triplePattern11, true, new Node[]{null, null, node_RuleVariable5});
        this.doTestUnify(triplePattern10, triplePattern12, false, null);
        this.doTestUnify(triplePattern10, triplePattern13, true, new Node[]{null, this.b});
        BindingVector bindingVector = BindingVector.unify(triplePattern2, triplePattern5);
        bindingVector.bind(node_RuleVariable4, this.c);
        TestBackchainer.assertEquals(bindingVector.getBinding(node_RuleVariable5), this.c);
        bindingVector = BindingVector.unify(triplePattern2, triplePattern5);
        bindingVector.bind(node_RuleVariable5, this.c);
        TestBackchainer.assertEquals(bindingVector.getBinding(node_RuleVariable4), this.c);
    }

    private void doTestUnify(TriplePattern triplePattern, TriplePattern triplePattern2, boolean bl, Node[] nodeArray) {
        BindingVector bindingVector = BindingVector.unify(triplePattern, triplePattern2);
        if (bl) {
            TestBackchainer.assertNotNull(bindingVector);
            if (nodeArray != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node = bindingVector.getEnvironment()[i];
                    if (nodeArray[i] != null) {
                        TestBackchainer.assertEquals(nodeArray[i], node);
                        continue;
                    }
                    TestBackchainer.assertNull(node);
                }
            }
        } else {
            TestBackchainer.assertNull(bindingVector);
        }
    }

    public void testListData() {
        GraphMem graphMem = new GraphMem();
        for (int i = 0; i < this.dataElts.length; ++i) {
            graphMem.add(this.dataElts[i]);
        }
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(this.c, this.p, this.c));
        Reasoner reasoner = this.createReasoner(new ArrayList());
        InfGraph infGraph = reasoner.bindSchema(graphMem2).bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b), new Triple(this.c, this.p, this.c)});
        List list = Rule.parseRules("-> (d p d).");
        reasoner = this.createReasoner(list);
        infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b), new Triple(this.d, this.p, this.d)});
        infGraph = reasoner.bindSchema(graphMem2).bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b), new Triple(this.c, this.p, this.c), new Triple(this.d, this.p, this.d)});
    }

    public void testBaseRules1() {
        List list = Rule.parseRules("[r1: (?a r ?c) <- (?a p ?b),(?b p ?c)]");
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.p, this.c));
        graphMem.add(new Triple(this.b, this.p, this.d));
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.c), new Triple(this.a, this.r, this.d)});
    }

    public void testBaseRules2() {
        List list = Rule.parseRules("[r1: (?a r ?b) <- (?a p ?b)][r2: (?a r ?b) <- (?a q ?b)][r3: (?a r ?b) <- (?a s ?c), (?c s ?b)]");
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.q, this.c));
        graphMem.add(new Triple(this.a, this.s, this.b));
        graphMem.add(new Triple(this.b, this.s, this.d));
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.b), new Triple(this.b, this.r, this.c), new Triple(this.a, this.r, this.d)});
    }

    public void testBaseRules2b() {
        List list = Rule.parseRules("[r1: (?a r ?b) <- (?a p ?b)][r2: (?a r ?b) <- (?a q ?b)][r3: (?a r ?b) <- (?a t ?c), (?c t ?b)][r4: (?a t ?b) <- (?a s ?b)]");
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.q, this.c));
        graphMem.add(new Triple(this.a, this.s, this.b));
        graphMem.add(new Triple(this.b, this.s, this.d));
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.b), new Triple(this.b, this.r, this.c), new Triple(this.a, this.r, this.d)});
    }

    public void testBaseRules3() {
        List list = Rule.parseRules("[rule: (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b),(?b rdfs:subPropertyOf ?c)]");
        Reasoner reasoner = this.createReasoner(list);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.p, this.sP, this.q));
        graphMem.add(new Triple(this.q, this.sP, this.r));
        graphMem.add(new Triple(this.p, this.sP, this.s));
        graphMem.add(new Triple(this.s, this.sP, this.t));
        graphMem.add(new Triple(this.a, this.p, this.b));
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.p, this.sP, this.s), new Triple(this.s, this.sP, this.t), new Triple(this.p, this.sP, this.t), new Triple(this.p, this.sP, this.r)});
    }

    public void testBaseRules3b() {
        List list = Rule.parseRules("[rule: (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b),(?b rdfs:subPropertyOf ?c)]");
        Reasoner reasoner = this.createReasoner(list);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.p, this.sP, this.q));
        graphMem.add(new Triple(this.q, this.sP, this.r));
        graphMem.add(new Triple(this.r, this.sP, this.t));
        graphMem.add(new Triple(this.q, this.sP, this.s));
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.r, this.sP, this.t), new Triple(this.q, this.sP, this.s), new Triple(this.p, this.sP, this.s), new Triple(this.p, this.sP, this.r), new Triple(this.p, this.sP, this.t), new Triple(this.q, this.sP, this.t), new Triple(this.p, this.sP, this.r)});
    }

    public void testBaseRules4() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        graphMem.add(new Triple(this.b, this.r, this.c));
        graphMem.add(new Triple(this.b, this.r, this.b));
        graphMem.add(new Triple(this.b, this.r, this.d));
        List list = Rule.parseRules("[r1: (?x p ?y) <- (?x r ?y)][r2: (?x p ?z) <- (?x p ?y), (?y r ?z)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.p, null), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.d), new Triple(this.a, this.p, this.c)});
    }

    public void testBaseRulesXSB1() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.p, this.c, this.q));
        graphMem.add(new Triple(this.q, this.c, this.r));
        graphMem.add(new Triple(this.p, this.d, this.q));
        graphMem.add(new Triple(this.q, this.d, this.r));
        List list = Rule.parseRules("[r1: (?x a ?y) <- (?x c ?y)][r2: (?x a ?y) <- (?x b ?z), (?z c ?y)][r3: (?x b ?y) <- (?x d ?y)][r4: (?x b ?y) <- (?x a ?z), (?z d ?y)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.p, this.a, null), new Object[]{new Triple(this.p, this.a, this.q), new Triple(this.p, this.a, this.r)});
    }

    public void testFunctors1() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.a, this.q, this.c));
        List list = Rule.parseRules("[r1: (?x r f(?y,?z)) <- (?x p ?y), (?x q ?z)][r2: (?x s ?y) <- (?x r f(?y, ?z))]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.s, null), new Object[]{new Triple(this.a, this.s, this.b)});
    }

    public void testFunctors2() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.a, this.q, this.c));
        graphMem.add(new Triple(this.a, this.t, this.d));
        List list = Rule.parseRules("[r1: (?x r f(?y,?z)) <- (?x p ?y), (?x q ?z)][r2: (?x s ?y) <- (?x r f(?y, ?z))][r3: (?x r g(?y,?z)) <- (?x p ?y), (?x t ?z)][r4: (?x s ?z) <- (?x r g(?y, ?z))]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.s, null), new Object[]{new Triple(this.a, this.s, this.b), new Triple(this.a, this.s, this.d)});
    }

    public void testFunctors3() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.s, this.b));
        graphMem.add(new Triple(this.a, this.t, this.c));
        List list = Rule.parseRules("[r1: (a q f(?x,?y)) <- (a s ?x), (a t ?y)][r2: (a p ?x) <- (a q ?x)][r3: (a r ?y) <- (a p f(?x, ?y))]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.r, null), new Object[]{new Triple(this.a, this.r, this.c)});
    }

    public void testBuiltin1() {
        GraphMem graphMem = new GraphMem();
        List list = Rule.parseRules("[a1: -> (a p 2) ][a2: -> (a q 3) ][r1: (?x r ?s) <- (?x p ?y), (?x q ?z), sum(?y, ?z, ?s)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.r, null), new Object[]{new Triple(this.a, this.r, Util.makeIntNode(5))});
    }

    public void testBuiltin2() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.a, this.q, this.c));
        List list = Rule.parseRules("[r1: (?x r ?y ) <- bound(?x), (?x p ?y) ][r2: (?x r ?y) <- unbound(?x), (?x q ?y)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.r, null), new Object[]{new Triple(this.a, this.r, this.b)});
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.c)});
    }

    public void testBuiltin3() {
        GraphMem graphMem = new GraphMem();
        List list = Rule.parseRules("[r1: (a p b ) <- unbound(?x) ]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, null, null), new Object[]{new Triple(this.a, this.p, this.b)});
    }

    public void testGroundHead() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        List list = Rule.parseRules("[r1: (a p b ) <- (a r b) ]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, null, null), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.r, this.b)});
    }

    public void testRebind() {
        List list = Rule.parseRules("[r1: (?a r ?c) <- (?a p ?b),(?b p ?c)]");
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.p, this.c));
        graphMem.add(new Triple(this.b, this.p, this.d));
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.c), new Triple(this.a, this.r, this.d)});
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(this.a, this.p, this.d));
        graphMem2.add(new Triple(this.d, this.p, this.b));
        infGraph.rebind(graphMem2);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.b)});
    }

    public void testRDFSProblemsb() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.C1, this.sC, this.C2));
        graphMem.add(new Triple(this.C2, this.sC, this.C3));
        graphMem.add(new Triple(this.C1, this.ty, RDFS.Class.asNode()));
        graphMem.add(new Triple(this.C2, this.ty, RDFS.Class.asNode()));
        graphMem.add(new Triple(this.C3, this.ty, RDFS.Class.asNode()));
        List list = Rule.parseRules("[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.sC, null), new Object[]{new Triple(this.C1, this.sC, this.C2), new Triple(this.C1, this.sC, this.C3), new Triple(this.C1, this.sC, this.C1), new Triple(this.C2, this.sC, this.C3), new Triple(this.C2, this.sC, this.C2), new Triple(this.C3, this.sC, this.C3)});
    }

    public void testRDFSProblems() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.p, this.sP, this.q));
        graphMem.add(new Triple(this.q, this.sP, this.r));
        graphMem.add(new Triple(this.C1, this.sC, this.C2));
        graphMem.add(new Triple(this.C2, this.sC, this.C3));
        graphMem.add(new Triple(this.a, this.ty, this.C1));
        List list = Rule.parseRules("[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs9:  (?x rdfs:subClassOf ?y), (?a rdf:type ?x) -> (?a rdf:type ?y)][rdfs3:  (?x ?p ?y), (?p rdfs:range ?c) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, infGraph.find(this.C1, this.sC, this.a), new Object[0]);
    }

    public void testHeadUnify() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.c, this.q, this.d));
        List list = Rule.parseRules("[r1: (c r ?x) <- (?x p f(?x b))][r2: (?y p f(a ?y)) <- (c q ?y)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[0]);
        graphMem.add(new Triple(this.c, this.q, this.a));
        list = Rule.parseRules("[r1: (c r ?x) <- (?x p f(?x a))][r2: (?y p f(a ?y)) <- (c q ?y)]");
        reasoner = this.createReasoner(list);
        infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
        graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.q, this.a));
        graphMem.add(new Triple(this.a, this.q, this.b));
        graphMem.add(new Triple(this.a, this.q, this.c));
        graphMem.add(new Triple(this.b, this.q, this.d));
        graphMem.add(new Triple(this.b, this.q, this.b));
        list = Rule.parseRules("[r1: (c r ?x) <- (?x p ?x)][r2: (?x p ?y) <- (a q ?x), (b q ?y)]");
        reasoner = this.createReasoner(list);
        infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.b)});
        list = Rule.parseRules("[r1: (c r ?x) <- (?x p ?x)][r2: (a p ?x) <- (a q ?x)]");
        reasoner = this.createReasoner(list);
        infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
    }

    public void testRestriction1() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.ty, this.r));
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.r, this.sC, this.C1));
        graphMem.add(new Triple(this.C1, this.ty, OWL.Restriction.asNode()));
        graphMem.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        graphMem.add(new Triple(this.C1, OWL.allValuesFrom.asNode(), this.c));
        List list = Rule.parseRules("[rdfs9:  (?x rdfs:subClassOf ?y) (?a rdf:type ?x) -> (?a rdf:type ?y)][restriction2: (?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:allValuesFrom ?D) -> (?C owl:equivalentClass all(?P, ?D))][rs2: (?D owl:equivalentClass all(?P,?C)), (?X rdf:type ?D) -> (?X rdf:type all(?P,?C))][rp4: (?X rdf:type all(?P, ?C)), (?X ?P ?Y) -> (?Y rdf:type ?C)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.b, this.ty, this.c), new Object[]{new Triple(this.b, this.ty, this.c)});
    }

    public void testRestriction2() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.ty, OWL.Thing.asNode()));
        graphMem.add(new Triple(this.p, this.ty, OWL.FunctionalProperty.asNode()));
        graphMem.add(new Triple(this.c, OWL.equivalentClass.asNode(), this.C1));
        graphMem.add(new Triple(this.C1, this.ty, OWL.Restriction.asNode()));
        graphMem.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        graphMem.add(new Triple(this.C1, OWL.maxCardinality.asNode(), Util.makeIntNode(1)));
        List list = Rule.parseRules("[rdfs9:  bound(?y)   (?x rdfs:subClassOf ?y) (?a rdf:type ?x) -> (?a rdf:type ?y)][restriction4: (?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:maxCardinality ?X) -> (?C owl:equivalentClass max(?P, ?X))][restrictionProc11: (?P rdf:type owl:FunctionalProperty), (?X rdf:type owl:Thing) -> (?X rdf:type max(?P, 1))][equivalentClass1: (?P owl:equivalentClass ?Q) -> (?P rdfs:subClassOf ?Q) ][equivalentClass1: (?P owl:equivalentClass ?Q) -> (?Q rdfs:subClassOf ?P) ][restrictionSubclass1: bound(?D) (?D owl:equivalentClass ?R), isFunctor(?R) (?X rdf:type ?R)-> (?X rdf:type ?D)][rdfs8:  unbound(?c) (?a rdfs:subClassOf ?b) (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs8:  bound(?c)   (?b rdfs:subClassOf ?c) (?a rdfs:subClassOf ?b) -> (?a rdfs:subClassOf ?c)][rdfs9:  unbound(?y) (?a rdf:type ?x) (?x rdfs:subClassOf ?y) -> (?a rdf:type ?y)][-> (rdf:type      rdfs:range rdfs:Class)][rdfs3:  bound(?c)   (?p rdfs:range ?c) (?x ?p ?y) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)][restrictionProc13: (owl:Thing rdfs:subClassOf all(?P, ?C)) -> (?P rdfs:range ?C)][restrictionSubclass1: unbound(?D) (?X rdf:type ?R), isFunctor(?R) (?D owl:equivalentClass ?R) -> (?X rdf:type ?D)][restrictionSubclass2: bound(?R), isFunctor(?R), (?D owl:equivalentClass ?R),(?X rdf:type ?D) -> (?X rdf:type ?R)][restrictionSubclass2: unbound(?R), (?X rdf:type ?D), (?D owl:equivalentClass ?R) isFunctor(?R) -> (?X rdf:type ?R)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, this.C1), new Object[]{new Triple(this.a, this.ty, this.C1)});
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, this.c), new Object[]{new Triple(this.a, this.ty, this.c)});
    }

    public void testRestriction3() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.ty, this.r));
        graphMem.add(new Triple(this.r, this.sC, this.C1));
        graphMem.add(new Triple(this.C1, this.ty, OWL.Restriction.asNode()));
        graphMem.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        graphMem.add(new Triple(this.C1, OWL.allValuesFrom.asNode(), this.c));
        List list = Rule.parseRules("[-> (rdfs:subClassOf rdfs:range rdfs:Class)][rdfs3:  bound(?c)   (?p rdfs:range ?c) (?x ?p ?y) -> (?y rdf:type ?c)][rdfs3:  unbound(?c) (?x ?p ?y), (?p rdfs:range ?c) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)][rdfs8:  (?a rdfs:subClassOf ?b) (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][restrictionProc4b: bound(?Y) (?X ?P ?Y), notEqual(?P, rdf:type), (?X rdf:type all(?P, ?C)),-> (?Y rdf:type ?C)][restrictionProc4b: unbound(?Y), (?X rdf:type all(?P, ?C)), (?X ?P ?Y), notEqual(?P, rdf:type),-> (?Y rdf:type ?C)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.ty, this.c), new Object[0]);
    }

    public void testClose() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.p, this.sP, this.q));
        graphMem.add(new Triple(this.q, this.sP, this.r));
        graphMem.add(new Triple(this.C1, this.sC, this.C2));
        graphMem.add(new Triple(this.C2, this.sC, this.C3));
        graphMem.add(new Triple(this.a, this.ty, this.C1));
        graphMem.add(new Triple(this.ty, RDFS.range.asNode(), RDFS.Class.asNode()));
        List list = Rule.parseRules("[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs9:  (?x rdfs:subClassOf ?y), (?a rdf:type ?x) -> (?a rdf:type ?y)][rdfs3:  (?x ?p ?y), (?p rdfs:range ?c) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)]");
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        ExtendedIterator extendedIterator = infGraph.find(this.a, this.ty, null);
        Triple triple = (Triple)extendedIterator.next();
        TestBackchainer.assertEquals(triple.getSubject(), this.a);
        TestBackchainer.assertEquals(triple.getPredicate(), this.ty);
        extendedIterator.close();
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
    }

    public void testBug1() throws IOException {
        GraphMem graphMem = new GraphMem();
        Node node = Node.createURI("http://www.hpl.hp.com/semweb/2003/eg#p");
        Node node2 = Node.createURI("http://www.hpl.hp.com/semweb/2003/eg#r");
        Node node3 = Node.createURI("http://www.hpl.hp.com/semweb/2003/eg#C1");
        graphMem.add(new Triple(this.a, node, this.b));
        List list = Rule.parseRules(Util.loadRuleParserFromResourceFile("testing/reasoners/bugs/rdfs-error1.brules"));
        Reasoner reasoner = this.createReasoner(list);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.b, this.ty, node3), new Object[]{new Triple(this.b, this.ty, node3)});
    }
}

