/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBasicLP
extends TestCase {
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node t = Node.createURI("t");
    Node u = Node.createURI("u");
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node d = Node.createURI("d");
    Node e = Node.createURI("e");
    Node C1 = Node.createURI("C1");
    Node C2 = Node.createURI("C2");
    Node C3 = Node.createURI("C3");
    Node C4 = Node.createURI("C4");
    Node D1 = Node.createURI("D1");
    Node D2 = Node.createURI("D2");
    Node D3 = Node.createURI("D3");
    Node sP = RDFS.subPropertyOf.getNode();
    Node sC = RDFS.subClassOf.getNode();
    Node ty = RDF.type.getNode();

    public TestBasicLP(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBasicLP.class);
    }

    public InfGraph makeInfGraph(List list, Graph graph) {
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        FBRuleInfGraph fBRuleInfGraph = (FBRuleInfGraph)fBRuleReasoner.bind(graph);
        return fBRuleInfGraph;
    }

    public InfGraph makeInfGraph(List list, Graph graph, Node[] nodeArray) {
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(list);
        FBRuleInfGraph fBRuleInfGraph = (FBRuleInfGraph)fBRuleReasoner.bind(graph);
        for (int i = 0; i < nodeArray.length; ++i) {
            fBRuleInfGraph.setTabled(nodeArray[i]);
        }
        return fBRuleInfGraph;
    }

    public void testBaseRules1() {
        this.doBasicTest("[r1: (?x r c) <- (?x p b)]", new Triple(Node.ANY, this.p, this.b), new Object[]{new Triple(this.a, this.p, this.b)});
    }

    public void testBaseRules2() {
        this.doBasicTest("[r1: (?x r c) <- (?x p b)]", new Triple(Node.ANY, this.r, this.c), new Object[]{new Triple(this.a, this.r, this.c)});
    }

    public void testBaseRules3() {
        this.doBasicTest("[r1: (?x r ?x) <- (?x p b)]", new Triple(Node.ANY, this.r, this.a), new Object[]{new Triple(this.a, this.r, this.a)});
    }

    public void testBaseRules4() {
        this.doBasicTest("[r1: (?x r ?x) <- (?y p b), (?x p b)]", new Triple(Node.ANY, this.r, this.a), new Object[]{new Triple(this.a, this.r, this.a)});
    }

    public void testBaseRules5() {
        this.doBasicTest("[r1: (?x q ?y) <- (?x r ?y)(?y s ?x)][r2: (?x r ?y) <- (?x p ?y)][r3: (?x s ?y) <- (?y p ?x)]", new Triple(Node.ANY, this.q, Node.ANY), new Object[]{new Triple(this.a, this.q, this.b)});
    }

    public void testBaseRules6() {
        this.doBasicTest("[r1: (?x r ?x) <- (?x p b)]", new Triple(this.a, this.r, this.b), new Object[0]);
    }

    public void testBaseRules7() {
        this.doBasicTest("[r1: (?x r ?y) <- (?x p c)]", new Triple(this.a, this.r, this.b), new Object[0]);
    }

    public void testBaseRules8() {
        this.doBasicTest("[r1: (?x q ?y) <- (?x r ?y)][r2: (?x r ?y) <- (?x p ?y)]", new Triple(Node.ANY, this.q, Node.ANY), new Object[]{new Triple(this.a, this.q, this.b)});
    }

    public void testBaseRules9() {
        this.doBasicTest("[r1: (?x q ?y) <- (?x r ?y)][r2: (?x r ?y) <- (?y p ?x)]", new Triple(Node.ANY, this.q, Node.ANY), new Object[]{new Triple(this.b, this.q, this.a)});
    }

    public void testBacktrack1() {
        this.doTest("[r1: (?x r ?y) <- (?x p ?y)]", new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.c), new Triple(this.a, this.p, this.d)}, new Triple(this.a, this.p, Node.ANY), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.c), new Triple(this.a, this.p, this.d)});
    }

    public void testBacktrack2() {
        this.doTest("[r1: (?x r ?y) <- (?x p ?y)]", new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.c), new Triple(this.a, this.p, this.d)}, new Triple(this.a, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, this.b), new Triple(this.a, this.r, this.c), new Triple(this.a, this.r, this.d)});
    }

    public void testBacktrack3() {
        this.doTest("[r1: (?x r C1) <- (?x p b)][r2: (?x r C2) <- (?x p b)][r3: (?x r C3) <- (?x p b)]", new Triple[]{new Triple(this.a, this.p, this.b)}, new Triple(this.a, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, this.C1), new Triple(this.a, this.r, this.C2), new Triple(this.a, this.r, this.C3)});
    }

    public void testBacktrack4() {
        this.doTest("[r1: (?x r C1) <- (?x p b)][r2: (?x r C2) <- (?x p b)][r3: (?x r C3) <- (?x p b)][r4: (?x s ?z) <- (?x p ?w), (?x r ?y) (?y p ?z)]", new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.C1, this.p, this.D1), new Triple(this.C2, this.p, this.D2), new Triple(this.C3, this.p, this.D3)}, new Triple(this.a, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.D1), new Triple(this.a, this.s, this.D2), new Triple(this.a, this.s, this.D3)});
    }

    public void testBacktrack5() {
        this.doTest("[r1: (?x r C3) <- (C1 p ?x)][r2: (?x r C2) <- (C2 p ?x)][r4: (?x s ?y) <- (?x r ?y)]", new Triple[]{new Triple(this.C1, this.p, this.D1), new Triple(this.C1, this.p, this.a), new Triple(this.C2, this.p, this.D2), new Triple(this.C2, this.p, this.b)}, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.D1, this.s, this.C3), new Triple(this.a, this.s, this.C3), new Triple(this.D2, this.s, this.C2), new Triple(this.b, this.s, this.C2)});
    }

    public void testBacktrack6() {
        this.doTest("[r1: (?x r C1) <- (?x p a)][r2: (?x r C2) <- (?x p b)][r3: (?x q C1) <- (?x p b)][r4: (?x q C2) <- (?x p a)][r5: (?x s ?y) <- (?x r ?y) (?x q ?y)]", new Triple[]{new Triple(this.D1, this.p, this.a), new Triple(this.D2, this.p, this.a), new Triple(this.D2, this.p, this.b), new Triple(this.D3, this.p, this.b)}, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.D2, this.s, this.C1), new Triple(this.D2, this.s, this.C2)});
    }

    public void testBacktrack7() {
        this.doTest("[r1: (?x r C1) <- (?x p b)][r2: (?x r C2) <- (?x p b)][r3: (?x r C3) <- (?x p b)][r3: (?x r D1) <- (?x p b)][r4: (?x q C2) <- (?x p b)][r5: (?x q C3) <- (?x p b)][r5: (?x q D1) <- (?x p b)][r6: (?x t C1) <- (?x p b)][r7: (?x t C2) <- (?x p b)][r8: (?x t C3) <- (?x p b)][r9: (?x s ?y) <- (?x r ?y) (?x q ?y) (?x t ?y)]", new Triple[]{new Triple(this.a, this.p, this.b)}, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.C2), new Triple(this.a, this.s, this.C3)});
    }

    public void testBacktrack8() {
        this.doTest("[r1: (?x r C1) <- (?x p b)][r2: (?x r C2) <- (?x p b)][r3: (?x r C3) <- (?x p b)][r3: (?x r D1) <- (?x p b)][r4: (?x q C2) <- (?x p b)][r5: (?x q C3) <- (?x p b)][r5: (?x q D1) <- (?x p b)][r6: (?x t C1) <- (?x p b)][r7: (?x t C2) <- (?x p b)][r8: (?x t C3) <- (?x p b)][r9: (?x s ?y) <- (?w r C1) (?x q ?y) (?w t C1)]", new Triple[]{new Triple(this.a, this.p, this.b)}, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.D1), new Triple(this.a, this.s, this.C2), new Triple(this.a, this.s, this.C3)});
    }

    public void testBacktrack9() {
        this.doTest("[r1: (?x s ?y) <- (?x r ?y) (?x q ?y)]", new Triple[]{new Triple(this.a, this.r, this.D1), new Triple(this.a, this.r, this.D2), new Triple(this.a, this.r, this.D3), new Triple(this.b, this.r, this.D2), new Triple(this.a, this.q, this.D2), new Triple(this.b, this.q, this.D2), new Triple(this.b, this.q, this.D3)}, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.D2), new Triple(this.b, this.s, this.D2)});
    }

    public void testBacktrack10() {
        this.doTest("[r1: (?x s ?y) <- (?x r ?y) (?x q ?z), equal(?y, ?z)(?x, p, ?y)][(a p D1) <- ][(a p D2) <- ][(b p D1) <- ]", new Triple[]{new Triple(this.a, this.r, this.D1), new Triple(this.a, this.r, this.D2), new Triple(this.a, this.r, this.D3), new Triple(this.b, this.r, this.D2), new Triple(this.a, this.q, this.D2), new Triple(this.b, this.q, this.D2), new Triple(this.b, this.q, this.D3)}, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.D2)});
    }

    public void testClauseOrder() {
        List list = Rule.parseRules("[r1: (?x r C1) <- (?x p b)][r1: (?x r C2) <- (?x p b)][r2: (?x r C3) <- (?x r C3) (?x p b)]");
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        InfGraph infGraph = this.makeInfGraph(list, graphMem);
        ExtendedIterator extendedIterator = infGraph.find(Node.ANY, this.r, Node.ANY);
        TestBasicLP.assertTrue(extendedIterator.hasNext());
        TestBasicLP.assertEquals(extendedIterator.next(), new Triple(this.a, this.r, this.C1));
        extendedIterator.close();
    }

    public void testAxioms() {
        this.doTest("[a1: -> (a r C1) ][a2: -> (a r C2) ][a3: (b r C1) <- ][r1: (?x s ?y) <- (?x r ?y)]", new Triple[0], new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.C1), new Triple(this.a, this.s, this.C2), new Triple(this.b, this.s, this.C1)});
    }

    public void testNestedPvars() {
        this.doTest("[r1: (?x r ?y) <- (?x p ?z) (?z q ?y)][r1: (?y t ?x) <- (?x p ?z) (?z q ?y)][r3: (?x s ?y) <- (?x r ?y) (?y t ?x)]", new Triple[]{new Triple(this.a, this.p, this.C1), new Triple(this.a, this.p, this.C2), new Triple(this.a, this.p, this.C3), new Triple(this.C2, this.q, this.b), new Triple(this.C3, this.q, this.c), new Triple(this.D1, this.q, this.D2)}, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.b), new Triple(this.a, this.s, this.c)});
    }

    public void testBuiltin1() {
        this.doTest("[r1: (?x r ?y) <- (?x p ?v), sum(?v 2 ?y)]", new Triple[]{new Triple(this.a, this.p, Util.makeIntNode(3)), new Triple(this.b, this.p, Util.makeIntNode(4))}, new Triple(Node.ANY, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, Util.makeIntNode(5)), new Triple(this.b, this.r, Util.makeIntNode(6))});
    }

    public void testBuiltin2() {
        this.doTest("[r1: (?x r C1) <- (?x p ?v), lessThan(?v 3)]", new Triple[]{new Triple(this.a, this.p, Util.makeIntNode(1)), new Triple(this.b, this.p, Util.makeIntNode(2)), new Triple(this.c, this.p, Util.makeIntNode(3))}, new Triple(Node.ANY, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, this.C1), new Triple(this.b, this.r, this.C1)});
    }

    public void testWildPredicate1() {
        this.doTest("[r1: (b r ?y) <- (a ?y ?v)]", new Triple[]{new Triple(this.a, this.p, this.C1), new Triple(this.a, this.q, this.C2), new Triple(this.a, this.q, this.C3)}, new Triple(this.b, this.r, Node.ANY), new Object[]{new Triple(this.b, this.r, this.p), new Triple(this.b, this.r, this.q)});
    }

    public void testWildPredicate2() {
        this.doTest("[r1: (a r ?y) <- (b ?y ?v)][r2: (?x q ?y) <- (?x p ?y)][r3: (?x s C1) <- (?x p C1)][r4: (?x t C2) <- (?x p C2)]", new Triple[]{new Triple(this.b, this.p, this.C1), new Triple(this.b, this.q, this.C2), new Triple(this.b, this.q, this.C3), new Triple(this.a, this.p, this.C1), new Triple(this.a, this.p, this.C2), new Triple(this.c, this.p, this.C1)}, new Triple(this.a, Node.ANY, Node.ANY), new Object[]{new Triple(this.a, this.r, this.p), new Triple(this.a, this.r, this.q), new Triple(this.a, this.q, this.C1), new Triple(this.a, this.q, this.C2), new Triple(this.a, this.s, this.C1), new Triple(this.a, this.t, this.C2), new Triple(this.a, this.p, this.C1), new Triple(this.a, this.p, this.C2), new Triple(this.a, this.r, this.s)});
    }

    public void testWildPredicate3() {
        String string = "[r1: (a r ?y) <- (b ?y ?v)][r2: (?x q ?y) <- (?x p ?y)][r3: (?x s C1) <- (?x p C1)][r4: (?x t ?y) <- (?x ?y C1)]";
        Triple[] tripleArray = new Triple[]{new Triple(this.b, this.p, this.C1), new Triple(this.b, this.q, this.C2), new Triple(this.b, this.q, this.C3), new Triple(this.a, this.p, this.C1), new Triple(this.a, this.p, this.C2), new Triple(this.c, this.p, this.C1)};
        this.doTest(string, tripleArray, new Triple(this.a, Node.ANY, this.C1), new Object[]{new Triple(this.a, this.q, this.C1), new Triple(this.a, this.s, this.C1), new Triple(this.a, this.p, this.C1)});
        this.doTest(string, tripleArray, new Triple(this.a, this.t, Node.ANY), new Object[]{new Triple(this.a, this.t, this.q), new Triple(this.a, this.t, this.s), new Triple(this.a, this.t, this.p)});
        this.doTest(string, tripleArray, new Triple(Node.ANY, this.t, this.q), new Object[]{new Triple(this.a, this.t, this.q), new Triple(this.b, this.t, this.q), new Triple(this.c, this.t, this.q)});
    }

    public void testWildPredicate4() {
        this.doTest("[r1: (a ?p ?x) <- (b ?p ?x)]", new Triple[]{new Triple(this.b, this.p, this.C1), new Triple(this.b, this.q, this.C2), new Triple(this.b, this.q, this.C3), new Triple(this.c, this.q, this.d)}, new Triple(this.a, Node.ANY, Node.ANY), new Object[]{new Triple(this.a, this.p, this.C1), new Triple(this.a, this.q, this.C2), new Triple(this.a, this.q, this.C3)});
    }

    public void testFunctors1() {
        String string = "[r1: (?x s ?y) <- (?x p foo(?z, ?y))] ";
        Triple[] tripleArray = new Triple[]{new Triple(this.a, this.p, Functor.makeFunctorNode("foo", new Node[]{this.C1, this.C2})), new Triple(this.a, this.p, Functor.makeFunctorNode("bar", new Node[]{this.C1, this.D1})), new Triple(this.b, this.p, Functor.makeFunctorNode("foo", new Node[]{this.C1, this.C2})), new Triple(this.a, this.p, Functor.makeFunctorNode("foo", new Node[]{this.C1, this.C3})), new Triple(this.a, this.p, this.D1)};
        this.doTest(string, tripleArray, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.C2), new Triple(this.b, this.s, this.C2), new Triple(this.a, this.s, this.C3)});
    }

    public void testFunctors2() {
        String string = "[r1: (?x r foo(?y,?z)) <- (?x p ?y), (?x q ?z)][r2: (?x s ?y) <- (?x r foo(?z, ?y))] ";
        Triple[] tripleArray = new Triple[]{new Triple(this.a, this.p, this.C1), new Triple(this.a, this.p, this.C3), new Triple(this.a, this.q, this.C2), new Triple(this.b, this.p, this.D1), new Triple(this.b, this.q, this.D2), new Triple(this.b, this.q, this.D3)};
        this.doTest(string, tripleArray, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.C2), new Triple(this.b, this.s, this.D2), new Triple(this.b, this.s, this.D3)});
    }

    public void testFunctors3() {
        String string = "[r1: (?x r foo(p,?y)) <- (?x p ?y)][r2: (?x r foo(q,?y)) <- (?x q ?y)][r3: (?x r ?y) <- (?x t ?y)] [r4: (?x s ?y) <- (?x r ?y), notFunctor(?y)] [r5: (?x s ?y) <- (?x r foo(?y, ?z))] ";
        Triple[] tripleArray = new Triple[]{new Triple(this.a, this.p, this.C1), new Triple(this.b, this.q, this.D1), new Triple(this.b, this.p, this.D2), new Triple(this.c, this.t, this.d)};
        this.doTest(string, tripleArray, new Triple(Node.ANY, this.s, Node.ANY), new Object[]{new Triple(this.a, this.s, this.p), new Triple(this.b, this.s, this.p), new Triple(this.b, this.s, this.q), new Triple(this.c, this.s, this.d)});
    }

    public void testTabled1() {
        this.doTest("[r1: (?a q ?b) <- (?a p ?b)][r2: (?x r ?y) <- (?x q ?y)]", new Node[]{this.q}, new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c)}, new Triple(Node.ANY, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, this.b), new Triple(this.b, this.r, this.c)});
    }

    public void testTabled2() {
        this.doTest("[r1: (?a p ?c) <- (?a p ?b)(?b p ?c)]", new Node[]{this.p}, new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.b, this.p, this.d)}, new Triple(Node.ANY, this.p, Node.ANY), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.a, this.p, this.c), new Triple(this.b, this.p, this.d), new Triple(this.a, this.p, this.d)});
    }

    public void testTabled3() {
        this.doTest("[r1: (?x p ?z) <- (?x p ?y), (?y p ?z)][r2: (?x p ?z) <- (?x e ?z), (?z q ?z)]", new Node[]{this.p}, new Triple[]{new Triple(this.a, this.e, this.b), new Triple(this.a, this.e, this.d), new Triple(this.b, this.e, this.c), new Triple(this.a, this.q, this.a), new Triple(this.b, this.q, this.b), new Triple(this.c, this.q, this.c)}, new Triple(this.a, this.p, Node.ANY), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.c)});
    }

    public void testTabled4() {
        this.doTest("[r1: (?x a ?y) <- (?x c ?y)][r2: (?x a ?y) <- (?x b ?z), (?z c ?y)][r3: (?x b ?y) <- (?x d ?y)][r4: (?x b ?y) <- (?x a ?z) (?z c ?y)]", new Node[]{this.a, this.b}, new Triple[]{new Triple(this.p, this.c, this.q), new Triple(this.q, this.c, this.r), new Triple(this.p, this.d, this.q), new Triple(this.q, this.d, this.r)}, new Triple(this.p, this.a, Node.ANY), new Object[]{new Triple(this.p, this.a, this.q), new Triple(this.p, this.a, this.r)});
    }

    public void testTabled5() {
        this.doTest("[r1: (?a p ?c) <- (?a p ?b)(?b p ?c)][r2: (?a r ?b) <- (?a q ?b)]", new Node[]{this.p}, new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.a, this.q, this.d), new Triple(this.c, this.q, this.d)}, new Triple(this.a, Node.ANY, Node.ANY), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.c), new Triple(this.a, this.q, this.d), new Triple(this.a, this.r, this.d)});
    }

    public void testTabled6() {
        this.doTest("[-> table(p)] [r1: (?a p ?c) <- (?a p ?b)(?b p ?c)]", new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.b, this.p, this.d)}, new Triple(Node.ANY, this.p, Node.ANY), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.a, this.p, this.c), new Triple(this.b, this.p, this.d), new Triple(this.a, this.p, this.d)});
    }

    public void testTabled7() {
        this.doTest("[r1: (?a q ?b) <- (?a p ?b)][r2: (?a q ?a) <- (?a s ?a)][r2: (?a r ?z) <- (?a q ?a)]", new Node[0], new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.c, this.p, this.c), new Triple(this.a, this.p, this.a), new Triple(this.b, this.s, this.e), new Triple(this.d, this.s, this.d)}, new Triple(Node.ANY, this.r, this.C1), new Object[]{new Triple(this.a, this.r, this.C1), new Triple(this.c, this.r, this.C1), new Triple(this.d, this.r, this.C1)});
    }

    public void testRDFS1() {
        this.doTest("[ (?a rdf:type C1) <- (?a rdf:type C2) ][ (?a rdf:type C2) <- (?a rdf:type C3) ][ (?a rdf:type C3) <- (?a rdf:type C4) ]", new Node[]{this.ty}, new Triple[]{new Triple(this.a, this.ty, this.C1), new Triple(this.b, this.ty, this.C2), new Triple(this.c, this.ty, this.C3), new Triple(this.d, this.ty, this.C4)}, new Triple(Node.ANY, this.ty, this.C1), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.b, this.ty, this.C1), new Triple(this.c, this.ty, this.C1), new Triple(this.d, this.ty, this.C1)});
    }

    public void testRDFS2() {
        this.doTest("[ (?a rdf:type C1) <- (?a rdf:type C2) ][ (?a rdf:type C1) <- (?a rdf:type C3) ][ (?a rdf:type C1) <- (?a rdf:type C4) ]", new Node[]{this.ty}, new Triple[]{new Triple(this.a, this.ty, this.C1), new Triple(this.b, this.ty, this.C2), new Triple(this.c, this.ty, this.C3), new Triple(this.d, this.ty, this.C4)}, new Triple(Node.ANY, this.ty, this.C1), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.b, this.ty, this.C1), new Triple(this.c, this.ty, this.C1), new Triple(this.d, this.ty, this.C1)});
    }

    public void testProblem1() {
        this.doTest("[r1: (a q f(?x,?y)) <- (a s ?x), (a t ?y)][r2: (a p ?x) <- (a q ?x)][r3: (a r ?y) <- (a p f(?x, ?y))]", new Node[]{this.p}, new Triple[]{new Triple(this.a, this.s, this.b), new Triple(this.a, this.t, this.c)}, new Triple(this.a, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, this.c)});
    }

    public void testProblem2() {
        String string = "[rdfs8:  (?a rdfs:subClassOf ?c) <- (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c)][rdfs7:  (?a rdfs:subClassOf ?a) <- (?a rdf:type rdfs:Class)]";
        this.doTest(string, new Node[]{this.ty, this.sC}, new Triple[]{new Triple(this.C1, this.sC, this.C2), new Triple(this.C2, this.sC, this.C3), new Triple(this.C1, this.ty, RDFS.Class.asNode()), new Triple(this.C2, this.ty, RDFS.Class.asNode()), new Triple(this.C3, this.ty, RDFS.Class.asNode())}, new Triple(Node.ANY, this.sC, Node.ANY), new Object[]{new Triple(this.C1, this.sC, this.C2), new Triple(this.C1, this.sC, this.C3), new Triple(this.C1, this.sC, this.C1), new Triple(this.C2, this.sC, this.C3), new Triple(this.C2, this.sC, this.C2), new Triple(this.C3, this.sC, this.C3)});
    }

    public void testProblem3() {
        String string = "[r1: (?x r ?y ) <- bound(?x), (?x p ?y) ][r2: (?x r ?y) <- unbound(?x), (?x q ?y)]";
        this.doTest(string, new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.q, this.c)}, new Triple(this.a, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, this.b)});
        this.doTest(string, new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.q, this.c)}, new Triple(Node.ANY, this.r, Node.ANY), new Object[]{new Triple(this.a, this.r, this.c)});
    }

    public void testProblem4() {
        String string = "[r1: (c r ?x) <- (?x p ?x)][r2: (?x p ?y) <- (a q ?x), (b q ?y)]";
        this.doTest(string, new Node[]{this.r, this.p}, new Triple[]{new Triple(this.a, this.q, this.a), new Triple(this.a, this.q, this.b), new Triple(this.a, this.q, this.c), new Triple(this.b, this.q, this.b), new Triple(this.b, this.q, this.d)}, new Triple(this.c, this.r, Node.ANY), new Object[]{new Triple(this.c, this.r, this.b)});
    }

    public void testProblem5() {
        String string = "[rdfs8:  (?a rdfs:subClassOf ?c) <- (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c)][rdfs9:   (?a rdf:type ?y) <- (?x rdfs:subClassOf ?y), (?a rdf:type ?x)][(rdf:type rdfs:range rdfs:Class) <-][rdfs3:  (?y rdf:type ?c) <- (?x ?p ?y), (?p rdfs:range ?c)][rdfs7:  (?a rdfs:subClassOf ?a) <- (?a rdf:type rdfs:Class)]";
        this.doTest(string, new Node[]{this.ty, this.sC}, new Triple[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.C1, this.sC, this.C2), new Triple(this.C2, this.sC, this.C3), new Triple(this.a, this.ty, this.C1)}, new Triple(this.a, this.ty, Node.ANY), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
    }

    public void testProblem6() {
        String string = "[rdfs9:   (?a rdf:type ?y) <- (?x rdfs:subClassOf ?y), (?a rdf:type ?x)][restriction2: (?C owl:equivalentClass all(?P, ?D)) <- (?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:allValuesFrom ?D)][rs2: (?X rdf:type all(?P,?C)) <- (?D owl:equivalentClass all(?P,?C)), (?X rdf:type ?D)][rp4: (?Y rdf:type ?C) <- (?X rdf:type all(?P, ?C)), (?X ?P ?Y)]";
        this.doTest(string, new Node[]{this.ty, this.sC, OWL.equivalentClass.asNode()}, new Triple[]{new Triple(this.a, this.ty, this.r), new Triple(this.a, this.p, this.b), new Triple(this.r, this.sC, this.C1), new Triple(this.C1, this.ty, OWL.Restriction.asNode()), new Triple(this.C1, OWL.onProperty.asNode(), this.p), new Triple(this.C1, OWL.allValuesFrom.asNode(), this.c)}, new Triple(this.b, this.ty, this.c), new Object[]{new Triple(this.b, this.ty, this.c)});
    }

    public void testProblem7() {
        String string = "[rdfs8:  (?a rdfs:subClassOf ?c) <- (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c)][rdfs9:   (?a rdf:type ?y) <- (?x rdfs:subClassOf ?y), (?a rdf:type ?x)][rdfs3:  (?y rdf:type rdfs:Class) <- (?x rdf:type ?y)][rdfs7:  (?a rdfs:subClassOf ?a) <- (?a rdf:type rdfs:Class)]";
        List list = Rule.parseRules(string);
        Node[] nodeArray = new Node[]{this.ty, this.sC};
        Triple[] tripleArray = new Triple[]{new Triple(this.C1, this.sC, this.C2), new Triple(this.C2, this.sC, this.C3), new Triple(this.a, this.ty, this.C1)};
        GraphMem graphMem = new GraphMem();
        for (int i = 0; i < tripleArray.length; ++i) {
            graphMem.add(tripleArray[i]);
        }
        InfGraph infGraph = this.makeInfGraph(list, graphMem, nodeArray);
        ExtendedIterator extendedIterator = infGraph.find(this.a, this.ty, null);
        Triple triple = (Triple)extendedIterator.next();
        TestBasicLP.assertEquals(triple.getSubject(), this.a);
        TestBasicLP.assertEquals(triple.getPredicate(), this.ty);
        extendedIterator.close();
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
    }

    public void testProblem8() {
        String string = "[rdfs9:   (?a rdf:type ?y) <- bound(?y) (?x rdfs:subClassOf ?y) (?a rdf:type ?x)][restriction4:  (?C owl:equivalentClass max(?P, ?X)) <- (?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:maxCardinality ?X)][restrictionProc11: (?X rdf:type max(?P, 1)) <- (?P rdf:type owl:FunctionalProperty), (?X rdf:type owl:Thing)][equivalentClass1: (?Q rdfs:subClassOf ?P) <- (?P owl:equivalentClass ?Q) ][equivalentClass1: (?P rdfs:subClassOf ?Q) <- (?P owl:equivalentClass ?Q) ][restrictionSubclass1: (?X rdf:type ?D) <- bound(?D) (?D owl:equivalentClass ?R), isFunctor(?R) (?X rdf:type ?R)]";
        this.doTest(string, new Node[]{this.ty, this.sC, OWL.equivalentClass.asNode()}, new Triple[]{new Triple(this.a, this.ty, OWL.Thing.asNode()), new Triple(this.p, this.ty, OWL.FunctionalProperty.asNode()), new Triple(this.c, OWL.equivalentClass.asNode(), this.C1), new Triple(this.C1, this.ty, OWL.Restriction.asNode()), new Triple(this.C1, OWL.onProperty.asNode(), this.p), new Triple(this.C1, OWL.maxCardinality.asNode(), Util.makeIntNode(1))}, new Triple(this.a, this.ty, this.c), new Object[]{new Triple(this.a, this.ty, this.c)});
    }

    public void testRuleDerivations() {
        Object object;
        String string = "[testRule1: (C2, p, ?a) <- (C1 p ?a)][testRule2: (C2, q, ?a) <- (C1 q ?a)][testRule3: (a p ?a)  <- (C2 p ?a), (C2 q ?a)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.C1, this.p, this.C3));
        graphMem.add(new Triple(this.C1, this.q, this.C4));
        graphMem.add(new Triple(this.C1, this.q, this.C3));
        InfGraph infGraph = this.makeInfGraph(list, graphMem, new Node[]{this.p, this.q});
        infGraph.setDerivationLogging(true);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, null, null), new Triple[]{new Triple(this.a, this.p, this.C3)});
        Iterator iterator = infGraph.getDerivation(new Triple(this.a, this.p, this.C3));
        StringWriter stringWriter = new StringWriter(250);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        while (iterator.hasNext()) {
            object = (Derivation)iterator.next();
            object.printTrace(printWriter, true);
        }
        printWriter.flush();
        object = TestUtil.normalizeWhiteSpace("Rule testRule3 concluded (a p C3) <-\n    Rule testRule1 concluded (C2 p C3) <-\n        Fact (C1 p C3)\r\n    Rule testRule2 concluded (C2 q C3) <-\n        Fact (C1 q C3)\r\n");
        TestBasicLP.assertEquals((String)object, TestUtil.normalizeWhiteSpace(stringWriter.getBuffer().toString()));
    }

    public void testProblem9() {
        String string = "[test:   (?x owl:sameAs ?x) <- (?x rdf:type owl:Thing) ][sameIndividualAs6: (?X rdf:type owl:Thing) <- (?X owl:sameAs ?Y) ][ans:    (?x p C1) <- (?y owl:sameAs ?x)]";
        Node node = OWL.sameAs.asNode();
        this.doTest(string, new Node[]{this.ty, node}, new Triple[]{new Triple(this.a, this.ty, OWL.Thing.asNode()), new Triple(this.b, node, this.c)}, new Triple(Node.ANY, this.p, Node.ANY), new Object[]{new Triple(this.a, this.p, this.C1), new Triple(this.b, this.p, this.C1), new Triple(this.c, this.p, this.C1)});
    }

    public void testArithBuiltins() {
        this.doBuiltinTest("[(a,r,0) <- (a,p,?x), (a,q,?y), lessThan(?x,?y)][(a,r,1) <- (a,p,?x), (a,q,?y), ge(?x, ?y)]", Util.makeIntNode(2), Util.makeIntNode(3), Util.makeIntNode(0));
        this.doBuiltinTest("[(a,r,0) <- (a,p,?x), (a,q,?y), lessThan(?x,?y)][(a,r,1) <- (a,p,?x), (a,q,?y), ge(?x, ?y)]", Util.makeIntNode(3), Util.makeIntNode(3), Util.makeIntNode(1));
        this.doBuiltinTest("[(a,r,0) <- (a,p,?x), (a,q,?y), le(?x,?y)][(a,r,1) <- (a,p,?x), (a,q,?y), greaterThan(?x, ?y)]", Util.makeIntNode(3), Util.makeIntNode(3), Util.makeIntNode(0));
        this.doBuiltinTest("[(a,r,?z) <- (a,p,?x), (a,q,?y), min(?x,?y,?z)]", Util.makeIntNode(2), Util.makeIntNode(3), Util.makeIntNode(2));
        this.doBuiltinTest("[(a,r,?z) <- (a,p,?x), (a,q,?y), min(?x,?y,?z)]", Util.makeIntNode(4), Util.makeIntNode(3), Util.makeIntNode(3));
        this.doBuiltinTest("[(a,r,?z) <- (a,p,?x), (a,q,?y), max(?x,?y,?z)]", Util.makeIntNode(2), Util.makeIntNode(3), Util.makeIntNode(3));
        this.doBuiltinTest("[(a,r,?z) <- (a,p,?x), (a,q,?y), max(?x,?y,?z)]", Util.makeIntNode(4), Util.makeIntNode(3), Util.makeIntNode(4));
    }

    public void testListBuiltins() {
        String string = "[(a r ?n) <- (a p ?l), listLength(?l, ?n)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, Util.makeList(new Node[]{this.C1, this.C2, this.C3}, graphMem)));
        InfGraph infGraph = this.makeInfGraph(list, graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(new Triple(this.a, this.r, Node.ANY)), new Triple[]{new Triple(this.a, this.r, Util.makeIntNode(3))});
        list = Rule.parseRules("[(a s b) <- (a p ?l), (a, q, ?j) listEqual(?l, ?j)][(a s c) <- (a p ?l), (a, q, ?j) listNotEqual(?l, ?j)][(a s d) <- (a p ?l), (a, r, ?j) listEqual(?l, ?j)][(a s e) <- (a p ?l), (a, r, ?j) listNotEqual(?l, ?j)]");
        graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, Util.makeList(new Node[]{this.C1, Util.makeIntNode(3), this.C3}, graphMem)));
        graphMem.add(new Triple(this.a, this.q, Util.makeList(new Node[]{this.C3, this.C1, Util.makeLongNode(3L)}, graphMem)));
        graphMem.add(new Triple(this.a, this.r, Util.makeList(new Node[]{this.C3, this.C1, Util.makeLongNode(2L)}, graphMem)));
        infGraph = this.makeInfGraph(list, graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(new Triple(this.a, this.s, Node.ANY)), new Triple[]{new Triple(this.a, this.s, this.b), new Triple(this.a, this.s, this.e)});
        list = Rule.parseRules("[(b r ?j) <- (a p ?l), (a, q, ?j) listContains(?l, ?j)][(b s ?j) <- (a p ?l), (a, q, ?j) listNotContains(?l, ?j)]");
        graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, Util.makeList(new Node[]{this.C1, Util.makeIntNode(3), this.C3}, graphMem)));
        graphMem.add(new Triple(this.a, this.q, this.C1));
        graphMem.add(new Triple(this.a, this.q, Util.makeLongNode(3L)));
        graphMem.add(new Triple(this.a, this.q, this.C2));
        infGraph = this.makeInfGraph(list, graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(new Triple(this.b, Node.ANY, Node.ANY)), new Triple[]{new Triple(this.b, this.r, this.C1), new Triple(this.b, this.r, Util.makeIntNode(3)), new Triple(this.b, this.s, this.C2)});
    }

    private void doTest(String string, Triple[] tripleArray, TripleMatch tripleMatch, Object[] objectArray) {
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        for (int i = 0; i < tripleArray.length; ++i) {
            graphMem.add(tripleArray[i]);
        }
        InfGraph infGraph = this.makeInfGraph(list, graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(tripleMatch), objectArray);
    }

    private void doTest(String string, Node[] nodeArray, Triple[] tripleArray, TripleMatch tripleMatch, Object[] objectArray) {
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        for (int i = 0; i < tripleArray.length; ++i) {
            graphMem.add(tripleArray[i]);
        }
        InfGraph infGraph = this.makeInfGraph(list, graphMem, nodeArray);
        TestUtil.assertIteratorValues(this, infGraph.find(tripleMatch), objectArray);
    }

    private void doBasicTest(String string, TripleMatch tripleMatch, Object[] objectArray) {
        this.doTest(string, new Triple[]{new Triple(this.a, this.p, this.b)}, tripleMatch, objectArray);
    }

    private void doBuiltinTest(String string, Node node, Node node2, Node node3) {
        this.doTest(string, new Triple[]{new Triple(this.a, this.p, node), new Triple(this.a, this.q, node2)}, new Triple(this.a, this.r, Node.ANY), new Triple[]{new Triple(this.a, this.r, node3)});
    }
}

