/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.BFRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingStack;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBasics
extends TestCase {
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node n1 = Node.createURI("n1");
    Node n2 = Node.createURI("n2");
    Node n3 = Node.createURI("n3");
    Node n4 = Node.createURI("n4");
    Node n5 = Node.createURI("n5");
    Node res = Node.createURI("res");

    public TestBasics(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBasics.class);
    }

    public void testRuleParser() {
        String[] stringArray = new String[]{"(?a rdf:type ?_) -> (?a rdf:type ?b).", "(?a rdf:type ?_), (?a rdf:type ?_) -> (?a rdf:type ?b).", "(?a rdf:type max(?a,1)) -> (?a rdf:type 'foo').", "(?a rdf:type ?_) -> addOne(?a).", "(?a rdf:type ?_) -> [(?a rdf:type ?_) -> addOne(?a)].", "(?a rdf:type ?_) -> (?a rdf:type '42').", "(?a rdf:type ?_) -> (?a rdf:type 4.2).", "(?a rdf:type ?_) -> (?a rdf:type ' fool that,I(am)').", "[rule1: (?a rdf:type ?_) -> (?a rdf:type a)]"};
        String[] stringArray2 = new String[]{"[ (?a rdf:type ?_) -> (?a rdf:type ?b) ]", "[ (?a rdf:type ?_) (?a rdf:type ?_) -> (?a rdf:type ?b) ]", "[ (?a rdf:type max(?a 1^^http://www.w3.org/2001/XMLSchema#int)^^urn:x-hp-jena:Functor) -> (?a rdf:type 'foo') ]", "[ (?a rdf:type ?_) -> addOne(?a) ]", "[ (?a rdf:type ?_) -> [ (?a rdf:type ?_) -> addOne(?a) ] ]", "[ (?a rdf:type ?_) -> (?a rdf:type '42') ]", "[ (?a rdf:type ?_) -> (?a rdf:type 4.2^^http://www.w3.org/2001/XMLSchema#float) ]", "[ (?a rdf:type ?_) -> (?a rdf:type ' fool that,I(am)') ]", "[ rule1: (?a rdf:type ?_) -> (?a rdf:type a) ]"};
        for (int i = 0; i < stringArray.length; ++i) {
            Rule rule = Rule.parseRule(stringArray[i]);
            TestBasics.assertEquals(stringArray2[i], rule.toString());
        }
    }

    public void testRuleEquality() {
        Rule rule = Rule.parseRule("(?a p ?b) -> (?a q ?b).");
        Rule rule2 = Rule.parseRule("(?a p ?b) -> (?b q ?a).");
        Rule rule3 = Rule.parseRule("(?x p ?y) -> (?x q ?y).");
        Rule rule4 = Rule.parseRule("(?a p ?b), addOne(?a) -> (?a q ?b).");
        Rule rule5 = Rule.parseRule("(?c p ?d), addOne(?c) -> (?c q ?d).");
        Rule rule6 = Rule.parseRule("(?a p ?b), makeTemp(?a) -> (?a q ?b).");
        Rule rule7 = Rule.parseRule("(?a p ?b), addOne(?b) -> (?a q ?b).");
        Rule rule8 = Rule.parseRule("(?a p ?b), addOne(p) -> (?a q ?b).");
        TestBasics.assertTrue(!rule.equals(rule2));
        TestBasics.assertTrue(rule.equals(rule3));
        TestBasics.assertTrue(!rule.equals(rule4));
        TestBasics.assertTrue(rule4.equals(rule5));
        TestBasics.assertTrue(!rule4.equals(rule6));
        TestBasics.assertTrue(!rule4.equals(rule7));
        TestBasics.assertTrue(!rule4.equals(rule8));
    }

    public void testBindingEnvironment() {
        BindingStack bindingStack = new BindingStack();
        bindingStack.bind(3, this.n1);
        TestBasics.assertEquals(this.n1, bindingStack.getEnvironment()[3]);
        bindingStack.push();
        bindingStack.bind(2, this.n2);
        TestBasics.assertEquals(this.n2, bindingStack.getEnvironment()[2]);
        bindingStack.unwind();
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        TestBasics.assertEquals(this.n1, bindingStack.getEnvironment()[3]);
        bindingStack.push();
        bindingStack.bind(1, this.n3);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        TestBasics.assertEquals(this.n1, bindingStack.getEnvironment()[3]);
        TestBasics.assertEquals(this.n3, bindingStack.getEnvironment()[1]);
        bindingStack.unwind();
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        TestBasics.assertEquals(this.n1, bindingStack.getEnvironment()[3]);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[1]);
        bindingStack.push();
        bindingStack.bind(1, this.n3);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        TestBasics.assertEquals(this.n1, bindingStack.getEnvironment()[3]);
        TestBasics.assertEquals(this.n3, bindingStack.getEnvironment()[1]);
        bindingStack.commit();
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        TestBasics.assertEquals(this.n1, bindingStack.getEnvironment()[3]);
        TestBasics.assertEquals(this.n3, bindingStack.getEnvironment()[1]);
        try {
            bindingStack.unwind();
            TestBasics.assertTrue("Failed to catch end of stack", false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testClauseMaching() {
        BindingStack bindingStack = new BindingStack();
        ArrayList arrayList = new ArrayList();
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = new BasicForwardRuleInfGraph(new BasicForwardRuleReasoner(arrayList), arrayList, null);
        TriplePattern triplePattern = new TriplePattern(new Node_RuleVariable("?a", 0), this.n1, new Node_RuleVariable("?b", 1));
        TriplePattern triplePattern2 = new TriplePattern(new Node_RuleVariable("?b", 1), new Node_RuleVariable("?c", 2), this.n2);
        boolean bl = FRuleEngine.match(triplePattern, new Triple(this.n1, this.n2, this.n3), bindingStack);
        TestBasics.assertTrue(!bl);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[0]);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[1]);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        bl = FRuleEngine.match(triplePattern, new Triple(this.n2, this.n1, this.n3), bindingStack);
        TestBasics.assertTrue(bl);
        TestBasics.assertEquals(this.n2, bindingStack.getEnvironment()[0]);
        TestBasics.assertEquals(this.n3, bindingStack.getEnvironment()[1]);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        bl = FRuleEngine.match(triplePattern2, new Triple(this.n1, this.n2, this.n2), bindingStack);
        TestBasics.assertTrue(!bl);
        TestBasics.assertEquals(this.n2, bindingStack.getEnvironment()[0]);
        TestBasics.assertEquals(this.n3, bindingStack.getEnvironment()[1]);
        TestBasics.assertEquals(null, bindingStack.getEnvironment()[2]);
        bl = FRuleEngine.match(triplePattern2, new Triple(this.n3, this.n1, this.n2), bindingStack);
        TestBasics.assertTrue(bl);
        TestBasics.assertEquals(this.n2, bindingStack.getEnvironment()[0]);
        TestBasics.assertEquals(this.n3, bindingStack.getEnvironment()[1]);
        TestBasics.assertEquals(this.n1, bindingStack.getEnvironment()[2]);
    }

    public void testRuleMatcher() {
        String string = "[r1: (?a p ?b), (?b q ?c) -> (?a, q, ?c)][r2: (?a p ?b), (?b p ?c) -> (?a, p, ?c)][r3: (?a p ?a), (n1 p ?c), (n1, p, ?a) -> (?a, p, ?c)][r4: (n4 ?p ?a) -> (n4, ?a, ?p)]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(new GraphMem());
        infGraph.add(new Triple(this.n1, this.p, this.n2));
        infGraph.add(new Triple(this.n2, this.p, this.n3));
        infGraph.add(new Triple(this.n2, this.q, this.n3));
        infGraph.add(new Triple(this.n4, this.p, this.n4));
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4), new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3), new Triple(this.n4, this.n4, this.p)});
    }

    public void testRuleDerivations() {
        Object object;
        String string = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(new GraphMem());
        infGraph.setDerivationLogging(true);
        infGraph.add(new Triple(this.n1, this.p, this.n3));
        infGraph.add(new Triple(this.n1, this.q, this.n4));
        infGraph.add(new Triple(this.n1, this.q, this.n3));
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
        Iterator iterator = infGraph.getDerivation(new Triple(this.res, this.p, this.n3));
        StringWriter stringWriter = new StringWriter(250);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        while (iterator.hasNext()) {
            object = (Derivation)iterator.next();
            object.printTrace(printWriter, true);
        }
        printWriter.flush();
        object = TestUtil.normalizeWhiteSpace("Rule testRule3 concluded (res p n3) <-\n    Rule testRule1 concluded (n2 p n3) <-\n        Fact (n1 p n3)\r\n    Rule testRule2 concluded (n2 q n3) <-\n        Fact (n1 q n3)\r\n");
        TestBasics.assertEquals((String)object, TestUtil.normalizeWhiteSpace(stringWriter.getBuffer().toString()));
    }

    public void testAxiomHandling() {
        String string = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][axiom1: -> (n1 p n3)]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(new GraphMem());
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3)});
        infGraph.add(new Triple(this.n1, this.q, this.n4));
        infGraph.add(new Triple(this.n1, this.q, this.n3));
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
    }

    public void testSchemaBinding() {
        String string = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.n1, this.p, this.n3));
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(this.n1, this.q, this.n4));
        graphMem2.add(new Triple(this.n1, this.q, this.n3));
        BasicForwardRuleReasoner basicForwardRuleReasoner = new BasicForwardRuleReasoner(list);
        Reasoner reasoner = basicForwardRuleReasoner.bindSchema(graphMem);
        InfGraph infGraph = reasoner.bind(graphMem2);
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
    }

    public void testEmbeddedFunctors() {
        String string = "(?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:allValuesFrom ?D) -> (?C rb:restriction all(?P, ?D)).(?C rb:restriction all(eg:p, eg:D)) -> (?C rb:restriction 'allOK').[ -> (eg:foo eg:prop functor(eg:bar, 1)) ][ (?x eg:prop functor(eg:bar, ?v)) -> (?x eg:propbar ?v) ][ (?x eg:prop functor(?v, ?*)) -> (?x eg:propfunc ?v) ]";
        List list = Rule.parseRules(string);
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("urn:x-hp:eg/R1");
        Resource resource2 = model.createResource("urn:x-hp:eg/D");
        Property property = model.createProperty("urn:x-hp:eg/", "p");
        Property property2 = model.createProperty("urn:x-hp:eg/", "prop");
        Property property3 = model.createProperty("urn:x-hp:eg/", "propbar");
        Property property4 = model.createProperty("urn:x-hp:eg/", "propfunc");
        Property property5 = model.createProperty("urn:x-hp-jena:rubrik/", "restriction");
        resource.addProperty(RDF.type, OWL.Restriction).addProperty(OWL.onProperty, property).addProperty(OWL.allValuesFrom, resource2);
        BasicForwardRuleReasoner basicForwardRuleReasoner = new BasicForwardRuleReasoner(list);
        InfGraph infGraph = basicForwardRuleReasoner.bind(model.getGraph());
        Model model2 = ModelFactory.createModelForGraph(infGraph);
        Resource resource3 = model2.createResource("urn:x-hp:eg/foo");
        Resource resource4 = model2.createResource("urn:x-hp:eg/bar");
        RDFNode rDFNode = model2.getResource(resource.getURI()).getRequiredProperty(property5).getObject();
        TestBasics.assertNotNull(rDFNode);
        TestBasics.assertEquals(((Object)rDFNode).toString(), "allOK");
        Literal literal = (Literal)resource3.getRequiredProperty(property3).getObject();
        TestBasics.assertEquals(new Integer(1), literal.getValue());
    }

    public void testBuiltins() {
        String string = "[r1: (n1 p ?x), addOne(?x, ?y) -> (n1 q ?y)][r2: (n1 p ?x), lessThan(?x, 3) -> (n2 q ?x)][axiom1: -> (n1 p 1)][axiom2: -> (n1 p 4)]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(new GraphMem());
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, this.q, null), new Triple[]{new Triple(this.n1, this.q, Util.makeIntNode(2)), new Triple(this.n1, this.q, Util.makeIntNode(5))});
        TestUtil.assertIteratorValues(this, infGraph.find(this.n2, this.q, null), new Triple[]{new Triple(this.n2, this.q, Util.makeIntNode(1))});
    }

    public void testRemoveBuiltin() {
        String string = "[rule1: (?x p ?y), (?x q ?y) -> remove(0)]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(new GraphMem());
        infGraph.add(new Triple(this.n1, this.p, Util.makeIntNode(1)));
        infGraph.add(new Triple(this.n1, this.p, Util.makeIntNode(2)));
        infGraph.add(new Triple(this.n1, this.q, Util.makeIntNode(2)));
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode(1)), new Triple(this.n1, this.q, Util.makeIntNode(2))});
    }

    public void testRebind() {
        String string = "[rule1: (?x p ?y) -> (?x q ?y)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.n1, this.p, this.n2));
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n1, this.q, this.n2)});
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(this.n1, this.p, this.n3));
        infGraph.rebind(graphMem2);
        TestUtil.assertIteratorValues(this, infGraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3)});
    }

    public void testSize() {
        String string = "[rule1: (?x p ?y) -> (?x q ?y)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.n1, this.p, this.n2));
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(graphMem);
        TestBasics.assertEquals(infGraph.size(), 2);
    }

    public void testValidityReport() {
        StandardValidityReport standardValidityReport = new StandardValidityReport();
        standardValidityReport.add(false, "dummy", "dummy1");
        standardValidityReport.add(false, "dummy", "dummy3");
        TestBasics.assertTrue(standardValidityReport.isValid());
        standardValidityReport.add(true, "dummy", "dummy2");
        TestBasics.assertTrue(!standardValidityReport.isValid());
        standardValidityReport = new StandardValidityReport();
        standardValidityReport.add(false, "dummy", "dummy1");
        standardValidityReport.add(true, "dummy", "dummy2");
        standardValidityReport.add(false, "dummy", "dummy3");
        TestBasics.assertTrue(!standardValidityReport.isValid());
        standardValidityReport = new StandardValidityReport();
        standardValidityReport.add(new ValidityReport.Report(false, "dummy", "dummy1"));
        standardValidityReport.add(new ValidityReport.Report(true, "dummy", "dummy2"));
        standardValidityReport.add(new ValidityReport.Report(false, "dummy", "dummy3"));
        TestBasics.assertTrue(!standardValidityReport.isValid());
    }

    public void testConvertList() {
        GraphMem graphMem = new GraphMem();
        Node node = RDF.Nodes.first;
        Node node2 = RDF.Nodes.rest;
        Node node3 = RDF.Nodes.nil;
        graphMem.add(new Triple(this.n1, node, this.p));
        graphMem.add(new Triple(this.n1, node2, this.n2));
        graphMem.add(new Triple(this.n2, node, this.q));
        graphMem.add(new Triple(this.n2, node2, node3));
        graphMem.add(new Triple(this.n3, node, this.p));
        graphMem.add(new Triple(this.n3, node2, this.n4));
        graphMem.add(new Triple(this.n4, node2, this.n5));
        graphMem.add(new Triple(this.n5, node, this.q));
        graphMem.add(new Triple(this.n5, node2, node3));
        String string = "[rule1: (?x p ?y) -> (?x q ?y)]";
        List list = Rule.parseRules(string);
        InfGraph infGraph = new BasicForwardRuleReasoner(list).bind(graphMem);
        BFRuleContext bFRuleContext = new BFRuleContext((ForwardRuleInfGraphI)infGraph);
        List list2 = Util.convertList(this.n1, bFRuleContext);
        TestBasics.assertEquals(list2.size(), 2);
        TestBasics.assertEquals(list2.get(0), this.p);
        TestBasics.assertEquals(list2.get(1), this.q);
        List list3 = Util.convertList(this.n3, bFRuleContext);
        TestBasics.assertEquals(list3.size(), 1);
        TestBasics.assertEquals(list3.get(0), this.p);
    }
}

