/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.test.TestFBRules;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestGenericRules
extends TestCase {
    protected static Log logger = LogFactory.getLog(TestFBRules.class);
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node t = Node.createURI("t");
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node d = Node.createURI("d");
    Node C1 = Node.createURI("C1");
    Node C2 = Node.createURI("C2");
    Node C3 = Node.createURI("C3");
    Node ty = RDF.type.getNode();
    Node sC = RDFS.subClassOf.getNode();
    List ruleList = Rule.parseRules("[r1: (?a p ?b), (?b p ?c) -> (?a p ?c)][r2: (?a q ?b) -> (?a p ?c)]-> table(p). -> table(q).");
    Triple[] ans = new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.a, this.p, this.c)};

    public TestGenericRules(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGenericRules.class);
    }

    public void testForward() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.p, this.c));
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(this.ruleList);
        genericRuleReasoner.setMode(GenericRuleReasoner.FORWARD);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
        infGraph = genericRuleReasoner.bindSchema(graphMem).bind(new GraphMem());
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
    }

    public void testBackward() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.p, this.c));
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(this.ruleList);
        genericRuleReasoner.setMode(GenericRuleReasoner.BACKWARD);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
        infGraph = genericRuleReasoner.bindSchema(graphMem).bind(new GraphMem());
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
    }

    public void testHybrid() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        graphMem.add(new Triple(this.p, this.ty, this.s));
        List list = Rule.parseRules("[a1: -> (a rdf:type t)][r0: (?x r ?y) -> (?x p ?y)][r1: (?p rdf:type s) -> [r1b: (?x ?p ?y) <- (?y ?p ?x)]][r2: (?p rdf:type s) -> [r2b: (?x ?p ?x) <- (?x rdf:type t)]]-> tableAll().");
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.HYBRID);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        infGraph.setDerivationLogging(true);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        Iterator iterator = infGraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestGenericRules.assertTrue(iterator.hasNext());
        RuleDerivation ruleDerivation = (RuleDerivation)iterator.next();
        TestGenericRules.assertTrue(ruleDerivation.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, ruleDerivation.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestGenericRules.assertTrue(!iterator.hasNext());
    }

    public void testParameters() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        graphMem.add(new Triple(this.p, this.ty, this.s));
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        resource.addProperty(ReasonerVocabulary.PROPderivationLogging, "true");
        resource.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        resource.addProperty(ReasonerVocabulary.PROPruleSet, "testing/reasoners/genericRuleTest.rules");
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(resource);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        Iterator iterator = infGraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestGenericRules.assertTrue(iterator.hasNext());
        RuleDerivation ruleDerivation = (RuleDerivation)iterator.next();
        TestGenericRules.assertTrue(ruleDerivation.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, ruleDerivation.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestGenericRules.assertTrue(!iterator.hasNext());
        Model model2 = ModelFactory.createDefaultModel();
        Resource resource2 = model2.createResource();
        genericRuleReasoner.addDescription(model2, resource2);
        TestUtil.assertIteratorValues(this, resource2.listProperties(), new Statement[]{model2.createStatement(resource2, ReasonerVocabulary.PROPderivationLogging, "true"), model2.createStatement(resource2, ReasonerVocabulary.PROPruleMode, "hybrid"), model2.createStatement(resource2, ReasonerVocabulary.PROPruleSet, "testing/reasoners/genericRuleTest.rules")});
        genericRuleReasoner.setParameter(ReasonerVocabulary.PROPderivationLogging, "false");
        resource2 = model2.createResource();
        genericRuleReasoner.addDescription(model2, resource2);
        TestUtil.assertIteratorValues(this, resource2.listProperties(), new Statement[]{model2.createStatement(resource2, ReasonerVocabulary.PROPderivationLogging, "false"), model2.createStatement(resource2, ReasonerVocabulary.PROPruleMode, "hybrid"), model2.createStatement(resource2, ReasonerVocabulary.PROPruleSet, "testing/reasoners/genericRuleTest.rules")});
        model = ModelFactory.createDefaultModel();
        resource = model.createResource("http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        resource.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        resource.addProperty(ReasonerVocabulary.PROPruleSet, "testing/reasoners/ruleset1.rules");
        resource.addProperty(ReasonerVocabulary.PROPruleSet, "testing/reasoners/ruleset2.rules");
        genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(resource);
        infGraph = genericRuleReasoner.bind(new GraphMem());
        Node node = Node.createURI("urn:x-hp:eg/a");
        Node node2 = Node.createURI("urn:x-hp:eg/C");
        Node node3 = Node.createURI("urn:x-hp:eg/D");
        TestUtil.assertIteratorValues(this, infGraph.find(null, null, null), new Object[]{new Triple(node, RDF.Nodes.type, node2), new Triple(node, RDF.Nodes.type, node3)});
    }

    public void testHybridFunctorFilter() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        graphMem.add(new Triple(this.a, this.p, this.s));
        List list = Rule.parseRules("[r0: (?x r ?y) (?x p ?z) -> (?x q func(?y, ?z)) ]");
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.HYBRID);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.q, null), new Object[0]);
        genericRuleReasoner.setFunctorFiltering(false);
        infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.q, null), new Object[]{new Triple(this.a, this.q, Functor.makeFunctorNode("func", new Node[]{this.b, this.s}))});
    }

    public void testExtendedRuleParser() {
        List list = Rule.rulesFromURL("file:testing/reasoners/ruleParserTest1.rules");
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list);
        genericRuleReasoner.setTransitiveClosureCaching(true);
        Model model = ModelFactory.createDefaultModel();
        InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, model);
        String string = "http://jena.hpl.hp.com/newprefix#";
        String string2 = "http://jena.hpl.hp.com/newprefix2#";
        String string3 = "http://jena.hpl.hp.com/newprefix3#";
        Resource resource = infModel.getResource(string + "A");
        Resource resource2 = infModel.getResource(string + "C");
        Property property = infModel.getProperty(string2 + "p");
        Property property2 = infModel.getProperty(string3 + "a");
        Resource resource3 = infModel.getResource(string + "foo");
        TestGenericRules.assertTrue("@prefix test", infModel.contains(resource, property, resource3));
        TestGenericRules.assertTrue("@include RDFS test", infModel.contains(resource, RDFS.subClassOf, resource2));
        TestGenericRules.assertTrue("@include test", infModel.contains((Resource)property2, property2, property2));
    }

    public void testAddRemove() {
        this.doTestAddRemove(false);
        this.doTestAddRemove(true);
    }

    public void doTestAddRemove(boolean bl) {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.C1));
        graphMem.add(new Triple(this.C1, this.sC, this.C2));
        graphMem.add(new Triple(this.C2, this.sC, this.C3));
        List list = Rule.parseRules("-> table(rdf:type).[r1: (?x p ?c) -> (?x rdf:type ?c)] [rdfs9:  (?x rdfs:subClassOf ?y) -> [ (?a rdf:type ?y) <- (?a rdf:type ?x)] ]");
        if (!bl) {
            list.add(Rule.parseRule("[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)] "));
        }
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.HYBRID);
        genericRuleReasoner.setTransitiveClosureCaching(bl);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
        logger.debug("Checkpoint 1");
        infGraph.delete(new Triple(this.C1, this.sC, this.C2));
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1)});
        logger.debug("Checkpoint 2");
        infGraph.add(new Triple(this.C1, this.sC, this.C3));
        infGraph.add(new Triple(this.b, this.p, this.C2));
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, infGraph.find(this.b, this.ty, null), new Object[]{new Triple(this.b, this.ty, this.C2), new Triple(this.b, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, graphMem.find(null, null, null), new Object[]{new Triple(this.a, this.p, this.C1), new Triple(this.b, this.p, this.C2), new Triple(this.C2, this.sC, this.C3), new Triple(this.C1, this.sC, this.C3)});
    }

    public void testAddRemove2() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, Util.makeIntNode(0)));
        List list = Rule.parseRules("(?x p ?v) noValue(a r 1) -> (?x p inc(1, a)) (?x r 1).\n(?x p ?v) noValue(a r 2) -> (?x p inc(1, b)) (?x r 2).\n(?x p ?v) (?x p inc(?i, ?t)) sum(?v, ?i, ?s) -> remove(0,1), (?x p ?s).\n");
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.p, null), new Object[]{new Triple(this.a, this.p, Util.makeIntNode(2))});
    }
}

