/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.FileManager;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestOWLConsistency
extends TestCase {
    public static final String testTbox = "file:testing/reasoners/owl/tbox.owl";
    public static Reasoner reasonerCache;

    public TestOWLConsistency(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestOWLConsistency.class);
    }

    public Reasoner makeReasoner() {
        if (reasonerCache == null) {
            Model model = FileManager.get().loadModel(testTbox);
            reasonerCache = ReasonerRegistry.getOWLReasoner().bindSchema(model.getGraph());
        }
        return reasonerCache;
    }

    public void testConsistent() {
        TestOWLConsistency.assertTrue(this.doTestOn("file:testing/reasoners/owl/consistentData.rdf"));
    }

    public void testInconsistent1() {
        TestOWLConsistency.assertTrue(!this.doTestOn("file:testing/reasoners/owl/inconsistent1.rdf"));
    }

    public void testInconsistent2() {
        TestOWLConsistency.assertTrue(!this.doTestOn("file:testing/reasoners/owl/inconsistent2.rdf"));
    }

    public void testInconsistent3() {
        TestOWLConsistency.assertTrue(!this.doTestOn("file:testing/reasoners/owl/inconsistent3.rdf"));
    }

    public void testInconsistent4() {
        TestOWLConsistency.assertTrue(!this.doTestOn("file:testing/reasoners/owl/inconsistent4.rdf"));
    }

    public void testInconsistent5() {
        TestOWLConsistency.assertTrue(!this.doTestOn("file:testing/reasoners/owl/inconsistent5.rdf"));
    }

    private boolean doTestOn(String string) {
        Model model = FileManager.get().loadModel(string);
        InfModel infModel = ModelFactory.createInfModel(this.makeReasoner(), model);
        ValidityReport validityReport = infModel.validate();
        return validityReport.isValid();
    }
}

