/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.WrappedReasonerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestSetRules
extends ModelTestBase {
    static final List rules = Rule.parseRules("[name: (?s owl:foo ?p) -> (?s ?p ?a)]");

    public TestSetRules(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestSetRules.class);
    }

    public void testRuleReasonerWrapper() {
        MockFactory mockFactory = new MockFactory();
        ReasonerFactory reasonerFactory = TestSetRules.wrap(mockFactory);
        TestSetRules.assertEquals(MockFactory.capabilities, reasonerFactory.getCapabilities());
        TestSetRules.assertEquals("eg:mockURI", reasonerFactory.getURI());
        TestSetRules.assertEquals(MockFactory.reasoner, reasonerFactory.create(null));
        TestSetRules.assertEquals(Arrays.asList("capabilities", "uri", "create"), mockFactory.done);
    }

    private static ReasonerFactory wrap(ReasonerFactory reasonerFactory) {
        return new WrappedReasonerFactory(reasonerFactory, ModelSpecImpl.emptyResource);
    }

    private static class MockFactory
    implements ReasonerFactory {
        List done = new ArrayList();
        static final Model capabilities = ModelTestBase.modelWithStatements("this isA Capability");
        static final String uri = "eg:mockURI";
        static final Reasoner reasoner = new GenericRuleReasoner(rules);

        private MockFactory() {
        }

        public void addRules(List list) {
            Assert.assertEquals(rules, list);
            this.done.add("addRules");
        }

        public Reasoner create(Resource resource) {
            this.done.add("create");
            return reasoner;
        }

        public Model getCapabilities() {
            this.done.add("capabilities");
            return capabilities;
        }

        public String getURI() {
            this.done.add("uri");
            return uri;
        }
    }
}

