/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.PrintWriter;
import java.util.Iterator;

public class ManualExample {
    public void test1() {
        String string = "urn:x-hp-jena:eg/";
        Model model = ModelFactory.createDefaultModel();
        Property property = model.createProperty(string, "p");
        Property property2 = model.createProperty(string, "q");
        model.add((Resource)property, RDFS.subPropertyOf, property2);
        model.createResource(string + "a").addProperty(property, "foo");
        Resource resource = ModelFactory.createDefaultModel().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
        Reasoner reasoner = RDFSRuleReasonerFactory.theInstance().create(resource);
        InfModel infModel = ModelFactory.createInfModel(reasoner, model);
        Resource resource2 = infModel.getResource(string + "a");
        Statement statement = resource2.getProperty(property2);
        System.out.println("Statement: " + statement);
    }

    public void test2(String string) {
        System.out.println("Testing " + string);
        Model model = FileManager.get().loadModel(string);
        InfModel infModel = ModelFactory.createRDFSModel(model);
        ValidityReport validityReport = infModel.validate();
        if (validityReport.isValid()) {
            System.out.println("OK");
        } else {
            System.out.println("Conflicts");
            Iterator iterator = validityReport.getReports();
            while (iterator.hasNext()) {
                ValidityReport.Report report = (ValidityReport.Report)iterator.next();
                System.out.println(" - " + report);
            }
        }
    }

    public void test3() {
        String string = "urn:x-hp:eg/";
        Model model = ModelFactory.createDefaultModel();
        Property property = model.createProperty(string, "p");
        Resource resource = model.createResource(string + "A");
        Resource resource2 = model.createResource(string + "B");
        Resource resource3 = model.createResource(string + "C");
        Resource resource4 = model.createResource(string + "D");
        resource.addProperty(property, resource2);
        resource2.addProperty(property, resource3);
        resource3.addProperty(property, resource4);
        String string2 = "[rule1: (?a eg:p ?b) (?b eg:p ?c) -> (?a eg:p ?c)]";
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(Rule.parseRules(string2));
        genericRuleReasoner.setDerivationLogging(true);
        InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, model);
        PrintWriter printWriter = new PrintWriter(System.out);
        StmtIterator stmtIterator = infModel.listStatements(resource, property, resource4);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            System.out.println("Statement is " + statement);
            Iterator iterator = infModel.getDerivation(statement);
            while (iterator.hasNext()) {
                Derivation derivation = (Derivation)iterator.next();
                derivation.printTrace(printWriter, true);
            }
        }
        printWriter.flush();
    }

    public void test4() {
        String string = "urn:x-hp:eg/";
        Model model = ModelFactory.createDefaultModel();
        Property property = model.createProperty(string, "concatFirst");
        Property property2 = model.createProperty(string, "concatSecond");
        Property property3 = model.createProperty(string, "p");
        Property property4 = model.createProperty(string, "q");
        Property property5 = model.createProperty(string, "r");
        Resource resource = model.createResource(string + "A");
        Resource resource2 = model.createResource(string + "B");
        Resource resource3 = model.createResource(string + "C");
        resource.addProperty(property3, resource2);
        resource2.addProperty(property4, resource3);
        property5.addProperty(property, property3);
        property5.addProperty(property2, property4);
        String string2 = "[r1: (?c eg:concatFirst ?p), (?c eg:concatSecond ?q) ->      [r1b: (?x ?c ?y) <- (?x ?p ?z) (?z ?q ?y)] ]";
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(Rule.parseRules(string2));
        InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, model);
        StmtIterator stmtIterator = infModel.listStatements(resource, null, (RDFNode)null);
        System.out.println("A * * =>");
        while (stmtIterator.hasNext()) {
            System.out.println(" - " + stmtIterator.next());
        }
    }

    public static void main(String[] stringArray) {
        try {
            new ManualExample().test4();
        }
        catch (Exception exception) {
            System.out.println("Problem: " + exception);
            exception.printStackTrace();
        }
    }
}

