/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTestBase;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestCurrentRDFWG
extends ReasonerTestBase {
    public static final String TEST_DIR = "testing/wg20031010/";
    public static String BASE_RESULTS_URI = "http://jena.sourceforge.net/data/rdf-results.rdf";
    Model testResults;
    Resource jena2;
    protected static Log logger = LogFactory.getLog(TestCurrentRDFWG.class);

    public TestCurrentRDFWG(String string) {
        super(string);
    }

    public void initResults() {
        this.testResults = ModelFactory.createDefaultModel();
        this.jena2 = this.testResults.createResource(BASE_RESULTS_URI + "#jena2");
        this.jena2.addProperty(RDFS.comment, this.testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> includes a rule-based inference engine for RDF processing, supporting both forward and backward chaining rules. Its OWL rule set is designed to provide sound but not complete instance resasoning for that fragment of OWL/Full limited to the OWL/lite vocabulary. Inparticular it does not support unionOf/complementOf.", true));
        this.jena2.addProperty(RDFS.label, "Jena2");
        this.testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        try {
            Resource resource = TestCurrentRDFWG.newResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "full");
            TestCurrentRDFWG.constructRDFWGtests(testSuite, RDFSRuleReasonerFactory.theInstance(), resource);
        }
        catch (IOException iOException) {
            logger.error("Failed to construct RDF WG test harness", iOException);
        }
        return testSuite;
    }

    private static void constructRDFWGtests(TestSuite testSuite, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        JenaParameters.enableWhitespaceCheckingOfTypedLiterals = true;
        WGReasonerTester wGReasonerTester = new WGReasonerTester("Manifest.rdf", TEST_DIR);
        Iterator iterator = wGReasonerTester.listTests().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            testSuite.addTest(new TestReasonerWG(wGReasonerTester, string, reasonerFactory, resource));
        }
    }

    static class TestReasonerWG
    extends TestCase {
        WGReasonerTester tester;
        String test;
        ReasonerFactory reasonerFactory;
        Resource config;

        TestReasonerWG(WGReasonerTester wGReasonerTester, String string, ReasonerFactory reasonerFactory, Resource resource) {
            super(string);
            this.tester = wGReasonerTester;
            this.test = string;
            this.reasonerFactory = reasonerFactory;
            this.config = resource;
        }

        public void runTest() throws IOException {
            boolean bl = this.tester.runTest(this.test, this.reasonerFactory, this, this.config);
        }
    }
}

