/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.arp.test.ARPTests;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WGReasonerTester {
    public static final String NS = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#";
    public static final String BASE_URI = "http://www.w3.org/2000/10/rdf-tests/rdfcore/";
    public static final String DEFAULT_BASE_DIR = "testing/wg/";
    protected String baseDir = "testing/wg/";
    public static final Resource PositiveEntailmentTest;
    public static final Resource NegativeEntailmentTest;
    public static final Resource FalseDocument;
    public static final Property descriptionP;
    public static final Property statusP;
    public static final Property entailmentRulesP;
    public static final Property premiseDocumentP;
    public static final Property conclusionDocumentP;
    Resource testType;
    public static final String[] blockedTests;
    protected Model testManifest;
    protected static Log logger;
    public static final int FAIL = -1;
    public static final int NOT_APPLICABLE = 0;
    public static final int INCOMPLETE = 1;
    public static final int PASS = 2;

    public WGReasonerTester(String string, String string2) throws IOException {
        this.baseDir = string2;
        this.testManifest = this.loadFile(string);
    }

    public WGReasonerTester(String string) throws IOException {
        this.testManifest = this.loadFile(string);
    }

    public Model loadFile(String string) throws IOException {
        String string2 = "RDF/XML";
        if (string.endsWith(".nt")) {
            string2 = "N-TRIPLE";
        } else if (string.endsWith("n3")) {
            string2 = "N3";
        }
        Model model = ModelFactory.createNonreifyingModel();
        String string3 = string;
        if (string3.startsWith(BASE_URI)) {
            string3 = string3.substring(BASE_URI.length());
        }
        InputStream inputStream = this.baseDir.startsWith("http:") ? new URL(this.baseDir + string3).openStream() : new FileInputStream(this.baseDir + string3);
        inputStream = new BufferedInputStream(inputStream);
        model.read(inputStream, BASE_URI + string3, string2);
        return model;
    }

    private Graph loadTestFile(Resource resource, Property property) throws IOException {
        if (resource.hasProperty(property)) {
            String string = ((Object)resource.getRequiredProperty(property).getObject()).toString();
            return this.loadFile(string).getGraph();
        }
        return new GraphMem();
    }

    public boolean runTests(ReasonerFactory reasonerFactory, TestCase testCase, Resource resource) throws IOException {
        Iterator iterator = this.listTests().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.runTest(string, reasonerFactory, testCase, resource)) continue;
            return false;
        }
        return true;
    }

    public List listTests() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResIterator resIterator = this.testManifest.listSubjectsWithProperty(RDF.type, PositiveEntailmentTest);
        while (resIterator.hasNext()) {
            arrayList.add(resIterator.next().toString());
        }
        resIterator = this.testManifest.listSubjectsWithProperty(RDF.type, NegativeEntailmentTest);
        while (resIterator.hasNext()) {
            arrayList.add(resIterator.next().toString());
        }
        return arrayList;
    }

    public Resource getTypeOfLastTest() {
        return this.testType;
    }

    public boolean runTest(String string, ReasonerFactory reasonerFactory, TestCase testCase, Resource resource) throws IOException {
        return this.runTestDetailedResponse(string, reasonerFactory, testCase, resource) != -1;
    }

    public int runTestDetailedResponse(String string, ReasonerFactory reasonerFactory, TestCase testCase, Resource resource) throws IOException {
        boolean bl;
        Resource resource2 = this.testManifest.getResource(string);
        this.testType = (Resource)resource2.getRequiredProperty(RDF.type).getObject();
        if (!((Object)this.testType).equals(NegativeEntailmentTest) && !((Object)this.testType).equals(PositiveEntailmentTest)) {
            throw new JenaException("Can't find test: " + string);
        }
        Statement statement = resource2.getProperty(descriptionP);
        String string2 = statement == null ? "no description" : ((Object)statement.getObject()).toString();
        String string3 = ((Object)resource2.getRequiredProperty(statusP).getObject()).toString();
        logger.debug("WG test " + resource2.getURI() + " - " + string3);
        if (!string3.equals("APPROVED")) {
            return 0;
        }
        for (int i = 0; i < blockedTests.length; ++i) {
            if (!resource2.getURI().equals(blockedTests[i])) continue;
            return 0;
        }
        Model model = ModelFactory.createNonreifyingModel();
        Object object = resource2.listProperties(premiseDocumentP);
        while (object.hasNext()) {
            model.add(this.loadFile(((Object)object.nextStatement().getObject()).toString()));
        }
        object = null;
        Resource resource3 = (Resource)resource2.getRequiredProperty(conclusionDocumentP).getObject();
        Resource resource4 = (Resource)resource3.getRequiredProperty(RDF.type).getObject();
        if (!((Object)resource4).equals(FalseDocument)) {
            object = this.loadFile(((Object)resource3).toString());
        }
        Reasoner reasoner = reasonerFactory.create(resource);
        InfGraph infGraph = reasoner.bind(model.getGraph());
        Model model2 = ModelFactory.createModelForGraph(infGraph);
        boolean bl2 = true;
        int n = 2;
        boolean bl3 = bl = !this.baseDir.equals(DEFAULT_BASE_DIR) && !ARPTests.internet;
        if (((Object)this.testType).equals(PositiveEntailmentTest)) {
            if (object == null) {
                boolean bl4 = bl2 = !infGraph.validate().isValid();
                if (bl) {
                    System.out.println("PositiveEntailmentTest of FalseDoc " + resource2.getURI() + (bl2 ? " - OK" : " - FAIL"));
                }
            } else {
                bl2 = this.testConclusions(object.getGraph(), model2.getGraph());
                if (!infGraph.validate().isValid()) {
                    bl2 = false;
                }
                if (bl) {
                    System.out.println("PositiveEntailmentTest " + resource2.getURI() + (bl2 ? " - OK" : " - FAIL"));
                }
            }
        } else {
            n = 1;
            if (object == null) {
                bl2 = infGraph.validate().isValid();
                if (bl) {
                    System.out.println("NegativentailmentTest of FalseDoc " + resource2.getURI() + (bl2 ? " - OK" : " - FAIL"));
                }
            } else {
                boolean bl5 = bl2 = !this.testConclusions(object.getGraph(), model2.getGraph());
                if (bl) {
                    System.out.println("NegativeEntailmentTest " + resource2.getURI() + (bl2 ? " - OK" : " - FAIL"));
                }
            }
        }
        if (!bl2) {
            logger.debug("Premises: ");
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                logger.debug("  - " + stmtIterator.nextStatement());
            }
            logger.debug("Conclusions: ");
            if (object != null) {
                stmtIterator = object.listStatements();
                while (stmtIterator.hasNext()) {
                    logger.debug("  - " + stmtIterator.nextStatement());
                }
            }
        }
        if (testCase != null) {
            TestCase.assertTrue("Test: " + resource2 + "\n" + string2, bl2);
        }
        return bl2 ? n : -1;
    }

    private boolean testConclusions(Graph graph, Graph graph2) {
        QueryHandler queryHandler = graph2.queryHandler();
        Query query = WGReasonerTester.graphToQuery(graph);
        ExtendedIterator extendedIterator = queryHandler.prepareBindings(query, new Node[0]).executeBindings();
        return extendedIterator.hasNext();
    }

    public static Query graphToQuery(Graph graph) {
        HashMap hashMap = new HashMap();
        Query query = new Query();
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            query.addMatch(WGReasonerTester.translate(triple.getSubject(), hashMap), WGReasonerTester.translate(triple.getPredicate(), hashMap), WGReasonerTester.translate(triple.getObject(), hashMap));
        }
        return query;
    }

    private static Node translate(Node node, HashMap hashMap) {
        String string = "abcdefghijklmnopqrstuvwxyz";
        if (node.isBlank()) {
            Node node2 = (Node)hashMap.get(node);
            if (node2 == null) {
                int n = hashMap.size();
                if (n > string.length()) {
                    throw new ReasonerException("Too many bnodes in query");
                }
                node2 = Node.createVariable(string.substring(n, n + 1));
                hashMap.put(node, node2);
            }
            return node2;
        }
        return node;
    }

    static {
        blockedTests = new String[]{"http://www.w3.org/2000/10/rdf-tests/rdfcore/datatypes/Manifest.rdf#language-important-for-non-dt-entailment-1", "http://www.w3.org/2000/10/rdf-tests/rdfcore/datatypes/Manifest.rdf#language-important-for-non-dt-entailment-2", "http://www.w3.org/2000/10/rdf-tests/rdfcore/pfps-10/Manifest.rdf#non-well-formed-literal-1", "http://www.w3.org/2000/10/rdf-tests/rdfcore/xmlsch-02/Manifest.rdf#whitespace-facet-3"};
        PositiveEntailmentTest = new ResourceImpl(NS, "PositiveEntailmentTest");
        NegativeEntailmentTest = new ResourceImpl(NS, "NegativeEntailmentTest");
        FalseDocument = new ResourceImpl(NS, "False-Document");
        descriptionP = new PropertyImpl(NS, "description");
        statusP = new PropertyImpl(NS, "status");
        entailmentRulesP = new PropertyImpl(NS, "entailmentRules");
        premiseDocumentP = new PropertyImpl(NS, "premiseDocument");
        conclusionDocumentP = new PropertyImpl(NS, "conclusionDocument");
        logger = LogFactory.getLog(WGReasonerTester.class);
    }
}

