/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.regression.ResourceReader;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Regression {
    protected boolean errors = false;
    protected static Log logger = LogFactory.getLog(Regression.class);

    public static void doTest(Model model, Model model2, Model model3, Model model4) {
        new Regression().test(model, model2, model3, model4);
    }

    public void test(Model model, Model model2, Model model3, Model model4) {
        try {
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                stmtIterator.remove();
            }
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                stmtIterator.remove();
            }
            stmtIterator = model3.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                stmtIterator.remove();
            }
            stmtIterator = model4.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                stmtIterator.remove();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.errors = true;
        }
        this.test1(model);
        this.test2(model);
        this.test3(model);
        this.test4(model);
        this.test5(model);
        this.test6(model);
        this.test7(model, model2);
        this.test8(model);
        this.test9(model2);
        this.test10(model3);
        this.test11(model, model2);
        this.test12(model);
        this.test13(model);
        this.test14(model);
        this.test15(model);
        this.test16(model);
        this.test17(model);
        this.test18(model4);
        this.test19(model2, model3);
        this.test97(model4);
    }

    public void test1(Model model) {
        String string = "Test1";
        int n = 0;
        try {
            n = 100;
            ++n;
            if (!model.createLiteral(true).getBoolean()) {
                this.error(string, n);
            }
            ++n;
            if (model.createLiteral(false).getBoolean()) {
                this.error(string, n);
            }
            n = 200;
            byte by = 0;
            Literal literal = model.createLiteral(by);
            ++n;
            if (literal.getByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != by) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by) {
                this.error(string, n);
            }
            byte l = -1;
            literal = model.createLiteral(l);
            ++n;
            if (literal.getByte() != l) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != l) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != l) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)l) {
                this.error(string, n);
            }
            byte f2 = -128;
            literal = model.createLiteral(f2);
            ++n;
            if (literal.getByte() != f2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != f2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != f2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)f2) {
                this.error(string, n);
            }
            byte d2 = 127;
            literal = model.createLiteral(d2);
            ++n;
            if (literal.getByte() != d2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != d2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != d2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)d2) {
                this.error(string, n);
            }
            n = 300;
            byte c = 0;
            literal = model.createLiteral(c);
            ++n;
            if (literal.getByte() != c) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != c) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != c) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)c) {
                this.error(string, n);
            }
            byte object = -1;
            literal = model.createLiteral(object);
            ++n;
            if (literal.getByte() != object) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != object) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != object) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)object) {
                this.error(string, n);
            }
            byte exception = Short.MIN_VALUE;
            literal = model.createLiteral(exception);
            try {
                ++n;
                if (literal.getByte() != exception) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getShort() != exception) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != exception) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)exception) {
                this.error(string, n);
            }
            byte by2 = Short.MAX_VALUE;
            literal = model.createLiteral(by2);
            try {
                ++n;
                if (literal.getByte() != by2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getShort() != by2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by2) {
                this.error(string, n);
            }
            n = 400;
            byte by3 = 0;
            literal = model.createLiteral(by3);
            ++n;
            if (literal.getByte() != by3) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != by3) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by3) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by3) {
                this.error(string, n);
            }
            byte by4 = -1;
            literal = model.createLiteral(by4);
            ++n;
            if (literal.getByte() != by4) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != by4) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by4) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by4) {
                this.error(string, n);
            }
            byte by5 = Integer.MIN_VALUE;
            literal = model.createLiteral(by5);
            try {
                ++n;
                if (literal.getByte() != by5) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if (literal.getShort() != by5) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getInt() != by5) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by5) {
                this.error(string, n);
            }
            byte by6 = Integer.MAX_VALUE;
            literal = model.createLiteral(by6);
            try {
                ++n;
                if (literal.getByte() != by6) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if (literal.getShort() != by6) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getInt() != by6) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by6) {
                this.error(string, n);
            }
            n = 500;
            long l2 = 0L;
            literal = model.createLiteral(l2);
            ++n;
            if ((long)literal.getByte() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getShort() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getInt() != l2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            l2 = -1L;
            literal = model.createLiteral(l2);
            ++n;
            if ((long)literal.getByte() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getShort() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getInt() != l2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            l2 = Long.MIN_VALUE;
            literal = model.createLiteral(l2);
            try {
                ++n;
                if ((long)literal.getByte() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getShort() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getInt() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            l2 = Long.MAX_VALUE;
            literal = model.createLiteral(l2);
            try {
                ++n;
                if ((long)literal.getByte() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getShort() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getInt() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            float f = 5.0E-5f;
            n = 600;
            float f3 = 0.0f;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = -1.0f;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = 12345.679f;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = Float.MAX_VALUE;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = Float.MIN_VALUE;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            double d = 5.0E-9;
            n = 700;
            double d3 = 0.0;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = -1.0;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = 12345.6789;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = Double.MAX_VALUE;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = Double.MIN_VALUE;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            n = 800;
            char c2 = 'A';
            ++n;
            if (model.createLiteral(c2).getChar() != c2) {
                this.error(string, n);
            }
            char c3 = 'a';
            ++n;
            if (model.createLiteral(c3).getChar() != c3) {
                this.error(string, n);
            }
            char c4 = '#';
            ++n;
            if (model.createLiteral(c4).getChar() != c4) {
                this.error(string, n);
            }
            char c5 = '@';
            ++n;
            if (model.createLiteral(c5).getChar() != c5) {
                this.error(string, n);
            }
            String string2 = "en";
            n = 900;
            Object object2 = "";
            ++n;
            if (!model.createLiteral((String)object2).getString().equals(object2)) {
                this.error(string, n);
            }
            object2 = "A test string";
            ++n;
            if (!model.createLiteral((String)object2).getString().equals(object2)) {
                this.error(string, n);
            }
            object2 = "Another test string";
            ++n;
            literal = model.createLiteral((String)object2);
            ++n;
            if (!literal.getString().equals(object2)) {
                this.error(string, n);
            }
            ++n;
            if (!literal.getLanguage().equals("")) {
                this.error(string, n);
            }
            ++n;
            literal = model.createLiteral((String)object2, string2);
            ++n;
            if (!literal.getString().equals(object2)) {
                this.error(string, n);
            }
            ++n;
            if (!literal.getLanguage().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)literal).equals(model.createLiteral((String)object2, string2))) {
                this.error(string, n);
            }
            ++n;
            if (((Object)literal).equals(model.createLiteral((String)object2))) {
                this.error(string, n);
            }
            object2 = new LitTestObjF();
            n = 1000;
            LitTestObj litTestObj = new LitTestObj(0L);
            ++n;
            if (!model.createLiteral(litTestObj).getObject((ObjectF)object2).equals(litTestObj)) {
                this.error(string, n);
            }
            LitTestObj litTestObj2 = new LitTestObj(12345L);
            ++n;
            if (!model.createLiteral(litTestObj2).getObject((ObjectF)object2).equals(litTestObj2)) {
                this.error(string, n);
            }
            LitTestObj litTestObj3 = new LitTestObj(-67890L);
            ++n;
            if (!model.createLiteral(litTestObj3).getObject((ObjectF)object2).equals(litTestObj3)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test2(Model model) {
        String string = "Test2";
        int n = 0;
        try {
            String string2;
            Object object;
            Statement statement;
            byte by;
            String string3;
            Object object2;
            n = 100;
            try {
                n = 110;
                ++n;
                object2 = model.createResource();
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (object2.getURI() != null) {
                    this.error(string, n);
                }
                ++n;
                if (object2.getNameSpace() != null) {
                    this.error(string, n);
                }
                ++n;
                if (object2.getLocalName() != null) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                n = 120;
                ++n;
                object2 = model.createResource((String)null);
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (object2.getURI() != null) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                n = 140;
                string3 = "http://aldabaran.hpl.hp.com/foo";
                ++n;
                object2 = model.createResource(string3);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                n = 150;
                ++n;
                object2 = model.createResource(RDF.Property);
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                n = 160;
                string3 = "http://aldabaran.hpl.hp.com/foo";
                ++n;
                object2 = model.createResource(string3, RDF.Property);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                n = 170;
                ++n;
                object2 = model.createResource(new ResTestObjF());
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                n = 180;
                string3 = "http://aldabaran.hpl.hp.com/foo";
                ++n;
                object2 = model.createResource(string3, new ResTestObjF());
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            n = 200;
            try {
                object2 = model.createProperty(null);
                this.error(string, ++n);
            }
            catch (InvalidPropertyURIException invalidPropertyURIException) {
                // empty catch block
            }
            try {
                ++n;
                object2 = model.createProperty("abc/def");
                ++n;
                if (!object2.getNameSpace().equals("abc/")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("def")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals("abc/def")) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                ++n;
                object2 = model.createProperty("abc/", "def");
                ++n;
                if (!object2.getNameSpace().equals("abc/")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("def")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals("abc/def")) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                ++n;
                object2 = model.createProperty(RDF.getURI() + "_345");
                ++n;
                if (!object2.getNameSpace().equals(RDF.getURI())) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("_345")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals(RDF.getURI() + "_345")) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            try {
                ++n;
                object2 = model.createProperty(RDF.getURI(), "_345");
                ++n;
                if (!object2.getNameSpace().equals(RDF.getURI())) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("_345")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals(RDF.getURI() + "_345")) {
                    this.error(string, n);
                }
            }
            catch (JenaException jenaException) {
                this.error(string, n, jenaException);
            }
            object2 = "http://aldabaran.hpl.hp.com/foo";
            String string4 = "http://aldabaran.hpl.hp.com/bar";
            Resource resource = model.createResource((String)object2);
            Property property = model.createProperty(string4);
            n = 300;
            try {
                by = 1;
                n = 310;
                ++n;
                statement = model.createStatement(resource, property, by != 0);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getBoolean()) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                by = 127;
                n = 320;
                ++n;
                statement = model.createStatement(resource, property, by);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getByte() != by) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                short s = Short.MAX_VALUE;
                n = 330;
                ++n;
                statement = model.createStatement(resource, property, s);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getShort() != s) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                int n2 = Integer.MAX_VALUE;
                n = 340;
                ++n;
                statement = model.createStatement(resource, property, n2);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getInt() != n2) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                long l = Long.MAX_VALUE;
                n = 350;
                ++n;
                statement = model.createStatement(resource, property, l);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getLong() != l) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                char c = '$';
                n = 360;
                ++n;
                statement = model.createStatement(resource, property, c);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getChar() != c) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                float f = 123.456f;
                n = 370;
                ++n;
                statement = model.createStatement(resource, property, f);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!((double)(statement.getFloat() - f) < 5.0E-4)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                double d = 12345.6789;
                n = 380;
                ++n;
                statement = model.createStatement(resource, property, d);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!(statement.getDouble() - d < 5.0E-7)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = "this is a test string";
                string2 = "en";
                n = 390;
                ++n;
                statement = model.createStatement(resource, property, (String)object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getString().equals(object)) {
                    this.error(string, n);
                }
                ++n;
                statement = model.createStatement(resource, property, (String)object, string2);
                ++n;
                if (!statement.getLanguage().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = new LitTestObj(Long.MIN_VALUE);
                string2 = "fr";
                n = 400;
                ++n;
                statement = model.createStatement(resource, property, object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getObject(new LitTestObjF()).equals(object)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = model.createResource();
                n = 410;
                ++n;
                statement = model.createStatement(resource, property, (RDFNode)object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!((Object)statement.getResource()).equals(object)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = model.createLiteral(true);
                n = 420;
                ++n;
                statement = model.createStatement(resource, property, (RDFNode)object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getBoolean()) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 500;
                ++n;
                object2 = model.createBag();
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Bag)) {
                    this.error(string, n);
                }
                string3 = "http://aldabaran/foo";
                ++n;
                object2 = model.createBag(string3);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Bag)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 510;
                ++n;
                object2 = model.createAlt();
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Alt)) {
                    this.error(string, n);
                }
                string3 = "http://aldabaran/foo";
                ++n;
                object2 = model.createAlt(string3);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Alt)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 520;
                ++n;
                object2 = model.createSeq();
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Seq)) {
                    this.error(string, n);
                }
                string3 = "http://aldabaran/foo";
                ++n;
                object2 = model.createSeq(string3);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Seq)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test3(Model model) {
        String string = "Test3";
        int n = 0;
        try {
            boolean bl = true;
            int n2 = 1;
            int n4 = 2;
            int n5 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test string";
            String string3 = "en";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource();
            try {
                n = 100;
                ++n;
                model.add(resource2, RDF.value, resource);
                ++n;
                if (!model.contains(resource2, RDF.value, resource)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 110;
                ++n;
                model.add(resource2, RDF.value, literal);
                ++n;
                if (!model.contains(resource2, RDF.value, literal)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 120;
                ++n;
                model.add(resource2, RDF.value, n2);
                ++n;
                if (!model.contains(resource2, RDF.value, n2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 130;
                ++n;
                model.add(resource2, RDF.value, n4);
                ++n;
                if (!model.contains(resource2, RDF.value, n4)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 140;
                ++n;
                model.add(resource2, RDF.value, n5);
                ++n;
                if (!model.contains(resource2, RDF.value, n5)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 150;
                ++n;
                model.add(resource2, RDF.value, l);
                ++n;
                if (!model.contains(resource2, RDF.value, l)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 160;
                ++n;
                model.add(resource2, RDF.value, c);
                ++n;
                if (!model.contains(resource2, RDF.value, c)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 170;
                ++n;
                model.add(resource2, RDF.value, f);
                ++n;
                if (!model.contains(resource2, RDF.value, f)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 180;
                ++n;
                model.add(resource2, RDF.value, d);
                ++n;
                if (!model.contains(resource2, RDF.value, d)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 190;
                ++n;
                model.add(resource2, RDF.value, litTestObj);
                ++n;
                if (!model.contains(resource2, RDF.value, litTestObj)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 200;
                ++n;
                model.add(resource2, RDF.value, string2);
                ++n;
                if (!model.contains(resource2, RDF.value, string2)) {
                    this.error(string, n);
                }
                ++n;
                if (model.contains(resource2, RDF.value, string2, string3)) {
                    this.error(string, n);
                }
                ++n;
                model.add(resource2, RDF.value, string2, string3);
                ++n;
                if (!model.contains(resource2, RDF.value, string2, string3)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 210;
                literal = model.createLiteral(++n);
                ++n;
                Statement statement = model.createStatement(resource2, RDF.value, literal);
                ++n;
                model.add(statement);
                ++n;
                if (!model.contains(statement)) {
                    this.error(string, n);
                }
                ++n;
                long l2 = model.size();
                ++n;
                model.add(statement);
                ++n;
                if (model.size() != l2) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource2, RDF.value)) {
                    this.error(string, n);
                }
                ++n;
                if (model.contains(resource2, RDF.subject)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test4(Model model) {
        String string = "Test4";
        int n = 0;
        try {
            Resource resource;
            String string2;
            try {
                n = 110;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                resource = model.getResource(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 120;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                resource = model.getResource(string2, new ResTestObjF());
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 130;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                resource = model.getProperty(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 140;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n) + "/";
                String string3 = "foo";
                ++n;
                resource = model.getProperty(string2, string3);
                ++n;
                if (!resource.getURI().equals(string2 + string3)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 150;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                model.createBag(string2);
                ++n;
                resource = model.getBag(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource, RDF.type, RDF.Bag)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 160;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                model.createAlt(string2);
                ++n;
                resource = model.getAlt(string2);
                resource = model.getAlt(model.getResource(string2));
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource, RDF.type, RDF.Alt)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 170;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                model.createSeq(string2);
                ++n;
                resource = model.getSeq(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource, RDF.type, RDF.Seq)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test5(Model model) {
        String string = "Test5";
        int n = 0;
        try {
            try {
                n = 100;
                ++n;
                StmtIterator stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.nextStatement();
                    ++n;
                    stmtIterator.remove();
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (model.size() != 0L) {
                    this.error(string, 999);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
        }
    }

    public void test6(Model model) {
        String string = "Test6";
        int n = 0;
        int n2 = 5;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Statement[] statementArray = new Statement[n2 * n2];
        String string2 = "http://aldabaran/test6/s";
        String string3 = "http://aldabaran/test6/";
        try {
            int n4;
            int n5;
            int n6;
            Object object;
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                resourceArray[n7] = model.createResource(string2 + Integer.toString(n7));
                propertyArray[n7] = model.createProperty(string3 + Integer.toString(n7), "p");
            }
            n = 50;
            if (model.size() != 0L) {
                this.error(string, n);
            }
            for (n7 = 0; n7 < n2; ++n7) {
                for (int i = 0; i < n2; ++i) {
                    object = model.createStatement(resourceArray[n7], propertyArray[i], model.createLiteral(n7 * n2 + i));
                    model.add((Statement)object);
                    model.add((Statement)object);
                    statementArray[n7 * n2 + i] = object;
                }
            }
            n7 = n2 * n2;
            boolean[] blArray = new boolean[n7];
            object = new boolean[n2];
            boolean[] blArray2 = new boolean[n2];
            n = 100;
            ++n;
            if (model.size() != (long)n7) {
                this.error(string, n);
            }
            for (n6 = 0; n6 < n7; ++n6) {
                blArray[n6] = false;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                object[n6] = false;
                blArray2[n6] = false;
            }
            n6 = 0;
            ResIterator resIterator = model.listSubjects();
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!((Object)resource).equals(resourceArray[i])) continue;
                    n6 = 1;
                    if (object[i]) {
                        this.error(string, 110);
                    }
                    object[i] = true;
                }
                if (n6 != 0) continue;
                this.error(string, 120);
            }
            for (int i = 0; i < n2; ++i) {
                if (object[i]) continue;
                this.error(string, 120 + i);
            }
            NsIterator nsIterator = model.listNameSpaces();
            while (nsIterator.hasNext()) {
                String string4 = nsIterator.nextNs();
                n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!string4.equals(propertyArray[i].getNameSpace())) continue;
                    n6 = 1;
                    if (blArray2[i]) {
                        this.error(string, 130);
                    }
                    blArray2[i] = true;
                }
                if (n6 != 0) continue;
                this.error(string, 140);
            }
            for (int i = 0; i < n2; ++i) {
                if (blArray2[i]) continue;
                this.error(string, 140 + i);
            }
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                n6 = 0;
                for (int i = 0; i < n7; ++i) {
                    if (!((Object)statement).equals(statementArray[i])) continue;
                    n6 = 1;
                    if (blArray[i]) {
                        this.error(string, 150);
                    }
                    blArray[i] = true;
                }
                if (n6 != 0) continue;
                this.error(string, 160);
            }
            for (int i = 0; i < n7; ++i) {
                if (blArray[i]) continue;
                this.error(string, 160 + i);
            }
            Object object2 = new boolean[n2 * n2];
            n = 300;
            for (n5 = 0; n5 < n2 * n2; ++n5) {
                object2[n5] = false;
            }
            NodeIterator nodeIterator = model.listObjectsOfProperty(propertyArray[0]);
            while (nodeIterator.hasNext()) {
                Literal literal = (Literal)nodeIterator.nextNode();
                n4 = literal.getInt();
                object2[n4] = true;
            }
            for (n5 = 0; n5 < n2 * n2; ++n5) {
                if (n5 % n2 == 0) {
                    if (object2[n5]) continue;
                    this.error(string, 300 + n5);
                    continue;
                }
                if (!object2[n5]) continue;
                this.error(string, 350 + n5);
            }
            object2 = new boolean[n2];
            n = 400;
            Resource resource = model.createResource();
            for (n4 = 0; n4 < n2; ++n4) {
                model.add(resource, RDF.value, n4);
                object2[n4] = false;
            }
            nodeIterator = model.listObjectsOfProperty(resource, RDF.value);
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                object2[n4] = true;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (object2[n4]) continue;
                this.error(string, n + n4);
            }
            int n8 = 0;
            n = 500;
            object2 = model.listObjects();
            while (object2.hasNext()) {
                object2.nextNode();
                ++n8;
            }
            if (n8 != 25) {
                this.error(string, n + n8);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test7(Model model, Model model2) {
        String string = "Test7";
        int n = 0;
        try {
            StmtIterator stmtIterator;
            try {
                n = 100;
                ++n;
                stmtIterator = model.listStatements();
                ++n;
                model2.add(stmtIterator);
                stmtIterator.close();
                ++n;
                if (model.size() != model2.size()) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model.listStatements();
                n = 110;
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model2.contains(stmtIterator.nextStatement())) continue;
                    this.error(string, n);
                }
                n = 200;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model.contains(stmtIterator.nextStatement())) continue;
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 300;
                model.add(model.createResource(), RDF.value, model.createResource());
                model.add(model.createResource(), RDF.value, model.createResource());
                model.add(model.createResource(), RDF.value, model.createResource());
                ++n;
                stmtIterator = model.listStatements();
                ++n;
                model2.remove(stmtIterator.nextStatement());
                ++n;
                model2.remove(stmtIterator);
                stmtIterator.close();
                ++n;
                if (model2.size() != 0L) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 400;
                ++n;
                model2.add(model);
                ++n;
                if (model.size() != model2.size()) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model.listStatements();
                n = 410;
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model2.contains(stmtIterator.nextStatement())) continue;
                    this.error(string, n);
                }
                n = 500;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model.contains(stmtIterator.nextStatement())) continue;
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 600;
                ++n;
                model2.remove(model);
                ++n;
                if (model2.size() != 0L) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test8(Model model) {
        String string = "Test8";
        int n = 0;
        int n2 = 5;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Vector vector = new Vector();
        String string2 = "http://aldabaran/test8/s";
        String string3 = "http://aldabaran/test8/";
        boolean[] blArray = new boolean[]{false, true};
        long[] lArray = new long[]{123L, 321L};
        char[] cArray = new char[]{'@', ';'};
        float[] fArray = new float[]{456.789f, 789.456f};
        double[] dArray = new double[]{123.456, 456.123};
        String[] stringArray = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] stringArray2 = new String[]{"en", "fr"};
        boolean[] blArray2 = new boolean[n2];
        boolean[] blArray3 = new boolean[n2];
        int n4 = 9;
        boolean[] blArray4 = new boolean[n4];
        RDFNode[] rDFNodeArray = new RDFNode[n4];
        try {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            int n29;
            int n30;
            int n31;
            int n32;
            Statement statement;
            int n33;
            Literal[] literalArray = new Literal[]{model.createLiteral(new LitTestObjF()), model.createLiteral(new LitTestObjF())};
            Resource[] resourceArray2 = new Resource[]{model.createResource(new ResTestObjF()), model.createResource(new ResTestObjF())};
            for (n33 = 0; n33 < n2; ++n33) {
                resourceArray[n33] = model.createResource(string2 + Integer.toString(n33));
                propertyArray[n33] = model.createProperty(string3 + Integer.toString(n33), "p");
            }
            for (n33 = 0; n33 < n2; ++n33) {
                model.add(resourceArray[n33], propertyArray[4], false);
            }
            for (n33 = 0; n33 < 2; ++n33) {
                for (int i = 0; i < 2; ++i) {
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], blArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], lArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], cArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], fArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], dArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], stringArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], stringArray[i], stringArray2[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], literalArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n33], propertyArray[i], resourceArray2[i]);
                    model.add(statement);
                }
            }
            rDFNodeArray[0] = model.createLiteral(blArray[1]);
            rDFNodeArray[1] = model.createLiteral(lArray[1]);
            rDFNodeArray[2] = model.createLiteral(cArray[1]);
            rDFNodeArray[3] = model.createLiteral(fArray[1]);
            rDFNodeArray[4] = model.createLiteral(dArray[1]);
            rDFNodeArray[5] = model.createLiteral(stringArray[1]);
            rDFNodeArray[6] = model.createLiteral(stringArray[1], stringArray2[1]);
            rDFNodeArray[7] = literalArray[1];
            rDFNodeArray[8] = resourceArray2[1];
            n = 100;
            ++n;
            statement = model.getRequiredProperty(resourceArray[1], propertyArray[1]);
            ++n;
            try {
                statement = model.getRequiredProperty(resourceArray[1], RDF.value);
                this.error(string, n);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            for (n32 = 0; n32 < n2; ++n32) {
                blArray2[n32] = false;
            }
            n32 = 0;
            ResIterator resIterator = model.listSubjectsWithProperty(propertyArray[4]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, 110);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, 120);
            }
            for (n30 = 0; n30 < n2; ++n30) {
                if (blArray2[n30]) continue;
                this.error(string, 130 + n30);
            }
            for (n30 = 0; n30 < n2; ++n30) {
                blArray2[n30] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, 150);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, 160);
            }
            for (n29 = 0; n29 < n2; ++n29) {
                if (blArray2[n29]) {
                    if (n29 <= 1) continue;
                    this.error(string, 170 + n29);
                    continue;
                }
                if (n29 >= 2) continue;
                this.error(string, 190 + n29);
            }
            n = 200;
            for (n29 = 0; n29 < n2; ++n29) {
                blArray2[n29] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], blArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n28 = 0; n28 < n2; ++n28) {
                if (blArray2[n28]) {
                    if (n28 <= 1) continue;
                    this.error(string, n + 30 + n28);
                    continue;
                }
                if (n28 >= 2) continue;
                this.error(string, n + 40 + n28);
            }
            for (n28 = 0; n28 < n2; ++n28) {
                blArray2[n28] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], blArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n27 = 0; n27 < n2; ++n27) {
                if (!blArray2[n27]) continue;
                this.error(string, n + 70 + n27);
            }
            n = 300;
            for (n27 = 0; n27 < n2; ++n27) {
                blArray2[n27] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (byte)lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n26 = 0; n26 < n2; ++n26) {
                if (blArray2[n26]) {
                    if (n26 <= 1) continue;
                    this.error(string, n + 30 + n26);
                    continue;
                }
                if (n26 >= 2) continue;
                this.error(string, n + 40 + n26);
            }
            for (n26 = 0; n26 < n2; ++n26) {
                blArray2[n26] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (byte)lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n25 = 0; n25 < n2; ++n25) {
                if (!blArray2[n25]) continue;
                this.error(string, n + 70 + n25);
            }
            n = 400;
            for (n25 = 0; n25 < n2; ++n25) {
                blArray2[n25] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (short)lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n24 = 0; n24 < n2; ++n24) {
                if (blArray2[n24]) {
                    if (n24 <= 1) continue;
                    this.error(string, n + 30 + n24);
                    continue;
                }
                if (n24 >= 2) continue;
                this.error(string, n + 40 + n24);
            }
            for (n24 = 0; n24 < n2; ++n24) {
                blArray2[n24] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (short)lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n23 = 0; n23 < n2; ++n23) {
                if (!blArray2[n23]) continue;
                this.error(string, n + 70 + n23);
            }
            n = 500;
            for (n23 = 0; n23 < n2; ++n23) {
                blArray2[n23] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (int)lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n22 = 0; n22 < n2; ++n22) {
                if (blArray2[n22]) {
                    if (n22 <= 1) continue;
                    this.error(string, n + 30 + n22);
                    continue;
                }
                if (n22 >= 2) continue;
                this.error(string, n + 40 + n22);
            }
            for (n22 = 0; n22 < n2; ++n22) {
                blArray2[n22] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (int)lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n21 = 0; n21 < n2; ++n21) {
                if (!blArray2[n21]) continue;
                this.error(string, n + 70 + n21);
            }
            n = 600;
            for (n21 = 0; n21 < n2; ++n21) {
                blArray2[n21] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n20 = 0; n20 < n2; ++n20) {
                if (blArray2[n20]) {
                    if (n20 <= 1) continue;
                    this.error(string, n + 30 + n20);
                    continue;
                }
                if (n20 >= 2) continue;
                this.error(string, n + 40 + n20);
            }
            for (n20 = 0; n20 < n2; ++n20) {
                blArray2[n20] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n19 = 0; n19 < n2; ++n19) {
                if (!blArray2[n19]) continue;
                this.error(string, n + 70 + n19);
            }
            n = 700;
            for (n19 = 0; n19 < n2; ++n19) {
                blArray2[n19] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], cArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n18 = 0; n18 < n2; ++n18) {
                if (blArray2[n18]) {
                    if (n18 <= 1) continue;
                    this.error(string, n + 30 + n18);
                    continue;
                }
                if (n18 >= 2) continue;
                this.error(string, n + 40 + n18);
            }
            for (n18 = 0; n18 < n2; ++n18) {
                blArray2[n18] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], cArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n17 = 0; n17 < n2; ++n17) {
                if (!blArray2[n17]) continue;
                this.error(string, n + 70 + n17);
            }
            n = 800;
            for (n17 = 0; n17 < n2; ++n17) {
                blArray2[n17] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n16 = 0; n16 < n2; ++n16) {
                if (blArray2[n16]) {
                    if (n16 <= 1) continue;
                    this.error(string, n + 30 + n16);
                    continue;
                }
                if (n16 >= 2) continue;
                this.error(string, n + 40 + n16);
            }
            for (n16 = 0; n16 < n2; ++n16) {
                blArray2[n16] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n15 = 0; n15 < n2; ++n15) {
                if (!blArray2[n15]) continue;
                this.error(string, n + 70 + n15);
            }
            n = 900;
            for (n15 = 0; n15 < n2; ++n15) {
                blArray2[n15] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n14 = 0; n14 < n2; ++n14) {
                if (blArray2[n14]) {
                    if (n14 <= 1) continue;
                    this.error(string, n + 30 + n14);
                    continue;
                }
                if (n14 >= 2) continue;
                this.error(string, n + 40 + n14);
            }
            for (n14 = 0; n14 < n2; ++n14) {
                blArray2[n14] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n13 = 0; n13 < n2; ++n13) {
                if (!blArray2[n13]) continue;
                this.error(string, n + 70 + n13);
            }
            n = 1000;
            for (n13 = 0; n13 < n2; ++n13) {
                blArray2[n13] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n12 = 0; n12 < n2; ++n12) {
                if (blArray2[n12]) {
                    if (n12 <= 1) continue;
                    this.error(string, n + 30 + n12);
                    continue;
                }
                if (n12 >= 2) continue;
                this.error(string, n + 40 + n12);
            }
            for (n12 = 0; n12 < n2; ++n12) {
                blArray2[n12] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n11 = 0; n11 < n2; ++n11) {
                if (!blArray2[n11]) continue;
                this.error(string, n + 70 + n11);
            }
            n = 1100;
            for (n11 = 0; n11 < n2; ++n11) {
                blArray2[n11] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[0], stringArray2[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n10 = 0; n10 < n2; ++n10) {
                if (blArray2[n10]) {
                    if (n10 <= 1) continue;
                    this.error(string, n + 30 + n10);
                    continue;
                }
                if (n10 >= 2) continue;
                this.error(string, n + 40 + n10);
            }
            for (n10 = 0; n10 < n2; ++n10) {
                blArray2[n10] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n9 = 0; n9 < n2; ++n9) {
                if (!blArray2[n9]) continue;
                this.error(string, n + 70 + n9);
            }
            n = 1200;
            for (n9 = 0; n9 < n2; ++n9) {
                blArray2[n9] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], literalArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n8 = 0; n8 < n2; ++n8) {
                if (blArray2[n8]) {
                    if (n8 <= 1) continue;
                    this.error(string, n + 30 + n8);
                    continue;
                }
                if (n8 >= 2) continue;
                this.error(string, n + 40 + n8);
            }
            for (n8 = 0; n8 < n2; ++n8) {
                blArray2[n8] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], literalArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n7 = 0; n7 < n2; ++n7) {
                if (!blArray2[n7]) continue;
                this.error(string, n + 70 + n7);
            }
            n = 1300;
            for (n7 = 0; n7 < n2; ++n7) {
                blArray2[n7] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], resourceArray2[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 10);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 20);
            }
            for (n6 = 0; n6 < n2; ++n6) {
                if (blArray2[n6]) {
                    if (n6 <= 1) continue;
                    this.error(string, n + 30 + n6);
                    continue;
                }
                if (n6 >= 2) continue;
                this.error(string, n + 40 + n6);
            }
            for (n6 = 0; n6 < n2; ++n6) {
                blArray2[n6] = false;
            }
            n32 = 0;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], resourceArray2[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.nextResource();
                n32 = 0;
                for (n31 = 0; n31 < n2; ++n31) {
                    if (!((Object)resource).equals(resourceArray[n31])) continue;
                    n32 = 1;
                    if (blArray2[n31]) {
                        this.error(string, n + 50);
                    }
                    blArray2[n31] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (n5 = 0; n5 < n2; ++n5) {
                if (!blArray2[n5]) continue;
                this.error(string, n + 70 + n5);
            }
            n = 1400;
            for (n5 = 0; n5 < n2; ++n5) {
                blArray2[n5] = false;
            }
            NodeIterator nodeIterator = model.listObjectsOfProperty(propertyArray[1]);
            while (nodeIterator.hasNext()) {
                RDFNode rDFNode = nodeIterator.nextNode();
                n32 = 0;
                for (int i = 0; i < n4; ++i) {
                    if (!rDFNode.equals(rDFNodeArray[i])) continue;
                    n32 = 1;
                    if (blArray4[i]) {
                        this.error(string, n + 50);
                    }
                    blArray4[i] = true;
                }
                if (n32 != 0) continue;
                this.error(string, n + 60);
            }
            for (int i = 0; i < n4; ++i) {
                if (blArray4[i]) continue;
                this.error(string, n + 70 + i);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test9(Model model) {
        String string = "Test9";
        int n = 0;
        int n2 = 2;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Vector vector = new Vector();
        String string2 = "http://aldabaran/test9/s";
        String string3 = "http://aldabaran/test9/";
        boolean[] blArray = new boolean[]{false, true};
        long[] lArray = new long[]{123L, 321L};
        char[] cArray = new char[]{'@', ';'};
        double[] dArray = new double[]{123.456, 456.123};
        String[] stringArray = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] stringArray2 = new String[]{"en", "fr"};
        try {
            Statement statement;
            int n4;
            int n5;
            Literal[] literalArray = new Literal[]{model.createLiteral(new LitTestObjF()), model.createLiteral(new LitTestObjF())};
            Resource[] resourceArray2 = new Resource[]{model.createResource(new ResTestObjF()), model.createResource(new ResTestObjF())};
            for (n5 = 0; n5 < n2; ++n5) {
                resourceArray[n5] = model.createResource(string2 + Integer.toString(n5));
                propertyArray[n5] = model.createProperty(string3 + Integer.toString(n5), "p");
            }
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = 0; n4 < n2; ++n4) {
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], blArray[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], lArray[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], cArray[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], dArray[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], stringArray[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], stringArray[n4], stringArray2[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], literalArray[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n4], resourceArray2[n4]);
                    model.add(statement);
                }
            }
            n = 100;
            n4 = 0;
            ++n;
            StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, null, (RDFNode)null));
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                ++n4;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n4 != n2 * n2 * 8) {
                this.error(string, n);
                System.err.println(n4);
            }
            n = 110;
            n4 = 0;
            ++n;
            stmtIterator = model.listStatements(new SimpleSelector(resourceArray[0], null, (RDFNode)null));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resourceArray[0])) {
                    this.error(string, n);
                }
                ++n4;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n4 != n2 * 8) {
                this.error(string, n);
            }
            n = 120;
            n4 = 0;
            ++n;
            stmtIterator = model.listStatements(new SimpleSelector(null, propertyArray[1], (RDFNode)null));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!statement.getPredicate().equals(propertyArray[1])) {
                    this.error(string, n);
                }
                ++n4;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n4 != n2 * 8) {
                this.error(string, n);
            }
            n = 130;
            n4 = 0;
            ++n;
            stmtIterator = model.listStatements(new SimpleSelector(null, null, resourceArray2[1]));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!statement.getObject().equals(resourceArray2[1])) {
                    this.error(string, n);
                }
                ++n4;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n4 != 2) {
                this.error(string, n);
            }
            n = 140;
            n4 = 0;
            ++n;
            stmtIterator = model.listStatements(new SimpleSelector(null, null, false));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (statement.getBoolean()) {
                    this.error(string, n);
                }
                ++n4;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n4 != 2) {
                this.error(string, n);
            }
            n = 150;
            n4 = 0;
            ++n;
            stmtIterator = model.listStatements(new SimpleSelector(null, null, stringArray[1], stringArray2[1]));
            ++n;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!statement.getLanguage().equals(stringArray2[1])) {
                    this.error(string, n);
                }
                ++n4;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n4 != 2) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test10(Model model) {
        String string = "Test10";
        int n = 0;
        int n2 = 2;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Vector vector = new Vector();
        String string2 = "http://aldabaran/test10/s";
        String string3 = "http://aldabaran/test10/";
        boolean[] blArray = new boolean[]{false, true};
        long[] lArray = new long[]{123L, 321L};
        char[] cArray = new char[]{'@', ';'};
        double[] dArray = new double[]{123.456, 456.123};
        String[] stringArray = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] stringArray2 = new String[]{"en", "fr"};
        try {
            Statement statement;
            int n4;
            Literal[] literalArray = new Literal[]{model.createLiteral(new LitTestObj(1L)), model.createLiteral(new LitTestObj(2L))};
            Resource[] resourceArray2 = new Resource[]{model.createResource(new ResTestObjF()), model.createResource(new ResTestObjF())};
            for (n4 = 0; n4 < n2; ++n4) {
                resourceArray[n4] = model.createResource(string2 + Integer.toString(n4));
                propertyArray[n4] = model.createProperty(string3 + Integer.toString(n4), "p");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                for (int i = 0; i < n2; ++i) {
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], blArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], lArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], cArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], dArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], stringArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], stringArray[i], stringArray2[n4]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], literalArray[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], resourceArray2[i]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n4], propertyArray[i], resourceArray2[i]);
                    model.add(statement);
                }
            }
            n = 100;
            int n5 = 0;
            ++n;
            Model model2 = model.query(new SimpleSelector(null, null, (RDFNode)null));
            ++n;
            StmtIterator stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                ++n5;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n5 != n2 * n2 * 8) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n5) {
                this.error(string, n);
            }
            n = 110;
            n5 = 0;
            ++n;
            model2 = model.query(new SimpleSelector(resourceArray[0], null, (RDFNode)null));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resourceArray[0])) {
                    this.error(string, n);
                }
                ++n5;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n5 != n2 * 8) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n5) {
                this.error(string, n);
            }
            n = 120;
            n5 = 0;
            ++n;
            model2 = model.query(new SimpleSelector(null, propertyArray[1], (RDFNode)null));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!statement.getPredicate().equals(propertyArray[1])) {
                    this.error(string, n);
                }
                ++n5;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n5 != n2 * 8) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n5) {
                this.error(string, n);
            }
            n = 130;
            n5 = 0;
            ++n;
            model2 = model.query(new SimpleSelector(null, null, resourceArray2[1]));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!statement.getObject().equals(resourceArray2[1])) {
                    this.error(string, n);
                }
                ++n5;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n5 != 2) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n5) {
                this.error(string, n);
            }
            n = 140;
            n5 = 0;
            ++n;
            model2 = model.query(new SimpleSelector(null, null, false));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (statement.getBoolean()) {
                    this.error(string, n);
                }
                ++n5;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n5 != 2) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n5) {
                this.error(string, n);
            }
            n = 150;
            ++n;
            model2 = model.query(new SimpleSelector(null, null, stringArray[1], stringArray2[0]));
            ++n;
            if (model2.size() != 1L) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = model2.listStatements();
            ++n;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (statement.getLanguage().equals(stringArray2[0])) continue;
                this.error(string, n);
            }
            stmtIterator.close();
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test11(Model model, Model model2) {
        String string = "Test11";
        int n = 0;
        Model model3 = null;
        Model model4 = null;
        Model model5 = null;
        if (!model.supportsSetOperations() || !model2.supportsSetOperations()) {
            return;
        }
        try {
            Statement statement;
            StmtIterator stmtIterator;
            try {
                n = 100;
                model2.add(model2.createResource(new ResTestObjF()), RDF.value, 1L);
                if (model.containsAll(model2)) {
                    this.error(string, n);
                }
                ++n;
                model3 = model.union(model2);
                ++n;
                stmtIterator = model3.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (model.contains(statement) || model2.contains(statement)) continue;
                    System.out.println(statement.toString());
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (model3.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (model3.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (!model3.containsAll(model)) {
                    this.error(string, n);
                }
                ++n;
                if (!model3.containsAll(model2)) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model.listStatements();
                ++n;
                if (!model3.containsAll(stmtIterator)) {
                    this.error(string, n);
                }
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 200;
                model4 = model3.intersection(model);
                ++n;
                stmtIterator = model4.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (model3.contains(statement) && model.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model3.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (!model.contains(statement) || model4.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (!model.contains(statement) || model4.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 300;
                model5 = model3.difference(model2);
                ++n;
                stmtIterator = model5.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (model3.contains(statement) && !model2.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model3.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (model2.contains(statement)) {
                        if (!model5.contains(statement)) continue;
                        this.error(string, n);
                        continue;
                    }
                    if (model5.contains(statement)) continue;
                    this.error(string, 1000 + n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.nextStatement();
                    if (!model5.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (model5.containsAny(model2)) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model2.listStatements();
                ++n;
                if (model5.containsAny(stmtIterator)) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test12(Model model) {
        String string = "Test12";
        int n = 0;
        try {
            Statement statement;
            Resource resource = model.createResource();
            boolean bl = true;
            int n2 = 1;
            int n4 = 2;
            int n5 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource2 = model.createResource();
            String string3 = "en";
            n = 100;
            ++n;
            if (!resource.addProperty(RDF.value, n2).hasProperty(RDF.value, n2)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, n4).hasProperty(RDF.value, n4)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, n5).hasProperty(RDF.value, n5)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, l).hasProperty(RDF.value, l)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, c).hasProperty(RDF.value, c)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, f).hasProperty(RDF.value, f)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, d).hasProperty(RDF.value, d)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, string2).hasProperty(RDF.value, string2)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, string2, string3).hasProperty(RDF.value, string2, string3)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, litTestObj).hasProperty(RDF.value, litTestObj)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, literal).hasProperty(RDF.value, literal)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, resource2).hasProperty(RDF.value, resource2)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)resource.getRequiredProperty(RDF.value).getSubject()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            try {
                resource.getRequiredProperty(RDF.type);
                this.error(string, n);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            ++n;
            StmtIterator stmtIterator = resource.listProperties(RDF.value);
            int n6 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resource)) {
                    this.error(string, n);
                }
                ++n6;
            }
            ++n;
            if (n6 != 12) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties(RDF.type);
            n6 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resource)) {
                    this.error(string, n);
                }
                ++n6;
            }
            ++n;
            if (n6 != 0) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties();
            n6 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resource)) {
                    this.error(string, n);
                }
                ++n6;
            }
            ++n;
            if (n6 != 12) {
                this.error(string, n);
            }
            ++n;
            resource.removeProperties();
            ++n;
            Model model2 = model.query(new SimpleSelector(resource, null, (RDFNode)null));
            if (model2.size() != 0L) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test13(Model model) {
        String string = "Test13";
        int n = 0;
        try {
            Resource resource = model.createResource();
            boolean bl = true;
            byte by = 1;
            short s = 2;
            int n2 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource2 = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            Resource resource3 = model.createResource();
            String string3 = "fr";
            n = 100;
            ++n;
            if (!((Object)model.createStatement(resource, RDF.value, resource).getResource()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            try {
                model.createStatement(resource, RDF.value, false).getResource();
                this.error(string, n);
            }
            catch (ResourceRequiredException resourceRequiredException) {
                // empty catch block
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, true).getLiteral().getBoolean()) {
                this.error(string, n);
            }
            ++n;
            try {
                model.createStatement(resource, RDF.value, resource).getLiteral();
                this.error(string, n);
            }
            catch (LiteralRequiredException literalRequiredException) {
                // empty catch block
            }
            n = 200;
            ++n;
            if (!model.createStatement(resource, RDF.value, true).getBoolean()) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource, RDF.value, by).getByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource, RDF.value, s).getShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource, RDF.value, n2).getInt() != n2) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource, RDF.value, l).getLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource, RDF.value, c).getChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource, RDF.value, f).getFloat() != f) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource, RDF.value, d).getDouble() != d) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, string2).getString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, string2, string3).getString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, string2, string3).getLanguage().equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)model.createStatement(resource, RDF.value, resource2).getResource(new ResTestObjF())).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, litTestObj2).getObject(new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, bag).getBag().equals(bag)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, alt).getAlt().equals(alt)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource, RDF.value, seq).getSeq().equals(seq)) {
                this.error(string, n);
            }
            n = 300;
            ++n;
            Statement statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(!bl);
            ++n;
            if (statement.getBoolean() != !bl) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, !bl)) {
                this.error(string, n);
            }
            n = 310;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(by);
            ++n;
            if (statement.getByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, by)) {
                this.error(string, n);
            }
            n = 320;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(s);
            ++n;
            if (statement.getShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, s)) {
                this.error(string, n);
            }
            n = 330;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(n2);
            ++n;
            if (statement.getInt() != n2) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, n2)) {
                this.error(string, n);
            }
            n = 340;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(l);
            ++n;
            if (statement.getLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, l)) {
                this.error(string, n);
            }
            n = 350;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(c);
            ++n;
            if (statement.getChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, c)) {
                this.error(string, n);
            }
            n = 360;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(f);
            ++n;
            if (!((double)(statement.getFloat() - f) < 5.0E-5)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, f)) {
                this.error(string, n);
            }
            n = 370;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(d);
            ++n;
            if (!(statement.getDouble() - d < 5.0E-4)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, d)) {
                this.error(string, n);
            }
            n = 380;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(string2);
            ++n;
            if (!statement.getString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, string2)) {
                this.error(string, n);
            }
            ++n;
            statement = statement.changeObject(string2, string3);
            ++n;
            if (!statement.getString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, string2)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, string2, string3)) {
                this.error(string, n);
            }
            n = 390;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(resource2);
            ++n;
            if (!((Object)statement.getResource()).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, resource2)) {
                this.error(string, n);
            }
            n = 400;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement = statement.changeObject(litTestObj2);
            ++n;
            if (!statement.getObject(new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, litTestObj2)) {
                this.error(string, n);
            }
            n = 500;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            model.remove(statement);
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test14(Model model) {
        String string = "Test14";
        int n = 0;
        try {
            int n2;
            int n4;
            boolean bl = true;
            int n5 = 1;
            int n6 = 2;
            int n7 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            int n8 = 10;
            n = 100;
            ++n;
            Bag bag2 = model.createBag();
            ++n;
            if (!model.contains((Resource)bag2, RDF.type, RDF.Bag)) {
                this.error(string, n);
            }
            ++n;
            if (bag2.size() != 0) {
                this.error(string, n);
            }
            n = 200;
            ++n;
            bag2.add(bl);
            ++n;
            if (!bag2.contains(bl)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(n5);
            ++n;
            if (!bag2.contains(n5)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(n6);
            ++n;
            if (!bag2.contains(n6)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(n7);
            ++n;
            if (!bag2.contains(n7)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(l);
            ++n;
            if (!bag2.contains(l)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(c);
            ++n;
            if (!bag2.contains(c)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(f);
            ++n;
            if (!bag2.contains(f)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(d);
            ++n;
            if (!bag2.contains(d)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(string2);
            ++n;
            if (!bag2.contains(string2)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(literal);
            ++n;
            if (!bag2.contains(literal)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(resource);
            ++n;
            if (!bag2.contains(resource)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(litTestObj2);
            ++n;
            if (!bag2.contains(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (bag2.size() != 12) {
                this.error(string, n);
            }
            n = 300;
            ++n;
            bag2 = model.createBag();
            for (n4 = 0; n4 < n8; ++n4) {
                bag2.add(n4);
            }
            ++n;
            if (bag2.size() != n8) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = bag2.iterator();
            for (n4 = 0; n4 < n8; ++n4) {
                if (((Literal)nodeIterator.nextNode()).getInt() == n4) continue;
                this.error(string, 320 + n4);
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n8];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nodeIterator = bag2.iterator();
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = 450;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 480;
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n8];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            bag2 = model.createBag();
            for (n2 = 0; n2 < n8; ++n2) {
                bag2.add(n2);
            }
            ++n;
            nodeIterator = bag2.iterator();
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = 550;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 580;
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n8];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            bag2 = model.createBag();
            for (n2 = 0; n2 < n8; ++n2) {
                bag2.add(n2);
            }
            ++n;
            nodeIterator = bag2.iterator();
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = 650;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 680;
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test15(Model model) {
        String string = "Test15";
        int n = 0;
        try {
            int n2;
            int n4;
            boolean bl = true;
            byte by = 1;
            short s = 2;
            int n5 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            int n6 = 10;
            n = 100;
            ++n;
            Alt alt2 = model.createAlt();
            ++n;
            if (!model.contains((Resource)alt2, RDF.type, RDF.Alt)) {
                this.error(string, n);
            }
            ++n;
            if (alt2.size() != 0) {
                this.error(string, n);
            }
            n = 200;
            ++n;
            alt2.add(bl);
            ++n;
            if (!alt2.contains(bl)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(by);
            ++n;
            if (!alt2.contains(by)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(s);
            ++n;
            if (!alt2.contains(s)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(n5);
            ++n;
            if (!alt2.contains(n5)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(l);
            ++n;
            if (!alt2.contains(l)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(c);
            ++n;
            if (!alt2.contains(c)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(f);
            ++n;
            if (!alt2.contains(f)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(d);
            ++n;
            if (!alt2.contains(d)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(string2);
            ++n;
            if (!alt2.contains(string2)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(literal);
            ++n;
            if (!alt2.contains(literal)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(resource2);
            ++n;
            if (!alt2.contains(resource2)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(litTestObj2);
            ++n;
            if (!alt2.contains(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (alt2.size() != 12) {
                this.error(string, n);
            }
            n = 300;
            ++n;
            alt2 = model.createAlt();
            for (n4 = 0; n4 < n6; ++n4) {
                alt2.add(n4);
            }
            ++n;
            if (alt2.size() != n6) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = alt2.iterator();
            for (n4 = 0; n4 < n6; ++n4) {
                if (((Literal)nodeIterator.nextNode()).getInt() == n4) continue;
                this.error(string, 320 + n4);
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n6];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nodeIterator = alt2.iterator();
            for (n2 = 0; n2 < n6; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = 450;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 480;
            for (n2 = 0; n2 < n6; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n6];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            alt2 = model.createAlt();
            for (n2 = 0; n2 < n6; ++n2) {
                alt2.add(n2);
            }
            ++n;
            nodeIterator = alt2.iterator();
            for (n2 = 0; n2 < n6; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = 550;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 580;
            for (n2 = 0; n2 < n6; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n6];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            alt2 = model.createAlt();
            for (n2 = 0; n2 < n6; ++n2) {
                alt2.add(n2);
            }
            ++n;
            nodeIterator = alt2.iterator();
            for (n2 = 0; n2 < n6; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = 650;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 680;
            for (n2 = 0; n2 < n6; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            n = 700;
            ++n;
            alt2 = model.createAlt();
            ++n;
            if (!alt2.setDefault(literal).getDefault().equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)alt2.setDefault(literal).getDefaultLiteral()).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)alt2.setDefault(resource).getDefaultResource()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(by).getDefaultByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(s).getDefaultShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(n5).getDefaultInt() != n5) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(l).getDefaultLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(c).getDefaultChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(f).getDefaultFloat() != f) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(d).getDefaultDouble() != d) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(string2).getDefaultString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)alt2.setDefault(resource2).getDefaultResource(new ResTestObjF())).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(litTestObj2).getDefaultObject(new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(alt).getDefaultAlt().equals(alt)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(bag).getDefaultBag().equals(bag)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(seq).getDefaultSeq().equals(seq)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test16(Model model) {
        String string = "Test16";
        int n = 0;
        try {
            int n2;
            int n4;
            int n5;
            boolean bl = true;
            byte by = 1;
            short s = 2;
            int n6 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            int n7 = 10;
            n = 100;
            ++n;
            Seq seq2 = model.createSeq();
            ++n;
            if (!model.contains((Resource)seq2, RDF.type, RDF.Seq)) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != 0) {
                this.error(string, n);
            }
            n = 200;
            ++n;
            seq2.add(bl);
            ++n;
            if (!seq2.contains(bl)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(by);
            ++n;
            if (!seq2.contains(by)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(s);
            ++n;
            if (!seq2.contains(s)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(n6);
            ++n;
            if (!seq2.contains(n6)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(l);
            ++n;
            if (!seq2.contains(l)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(c);
            ++n;
            if (!seq2.contains(c)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(f);
            ++n;
            if (!seq2.contains(f)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(d);
            ++n;
            if (!seq2.contains(d)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(string2);
            ++n;
            if (!seq2.contains(string2)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(literal);
            ++n;
            if (!seq2.contains(literal)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(resource2);
            ++n;
            if (!seq2.contains(resource2)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(litTestObj2);
            ++n;
            if (!seq2.contains(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != 12) {
                this.error(string, n);
            }
            n = 300;
            ++n;
            seq2 = model.createSeq();
            for (n5 = 0; n5 < n7; ++n5) {
                seq2.add(n5);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = seq2.iterator();
            for (n5 = 0; n5 < n7; ++n5) {
                if (((Literal)nodeIterator.nextNode()).getInt() == n5) continue;
                this.error(string, 320 + n5);
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n7];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nodeIterator = seq2.iterator();
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = 450;
            ++n;
            nodeIterator = seq2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = 480;
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n7];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            seq2 = model.createSeq();
            for (n4 = 0; n4 < n7; ++n4) {
                seq2.add(n4);
            }
            ++n;
            nodeIterator = seq2.iterator();
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = 550;
            ++n;
            nodeIterator = seq2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = 580;
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n7];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            seq2 = model.createSeq();
            for (n4 = 0; n4 < n7; ++n4) {
                seq2.add(n4);
            }
            ++n;
            nodeIterator = seq2.iterator();
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = 650;
            ++n;
            nodeIterator = seq2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = 680;
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            n = 700;
            seq2 = model.createSeq();
            ++n;
            seq2.add(bl);
            ++n;
            if (seq2.getBoolean(1) != bl) {
                this.error(string, n);
            }
            ++n;
            seq2.add(by);
            ++n;
            if (seq2.getByte(2) != by) {
                this.error(string, n);
            }
            ++n;
            seq2.add(s);
            ++n;
            if (seq2.getShort(3) != s) {
                this.error(string, n);
            }
            ++n;
            seq2.add(n6);
            ++n;
            if (seq2.getInt(4) != n6) {
                this.error(string, n);
            }
            ++n;
            seq2.add(l);
            ++n;
            if (seq2.getLong(5) != l) {
                this.error(string, n);
            }
            ++n;
            seq2.add(c);
            ++n;
            if (seq2.getChar(6) != c) {
                this.error(string, n);
            }
            ++n;
            seq2.add(f);
            ++n;
            if (seq2.getFloat(7) != f) {
                this.error(string, n);
            }
            ++n;
            seq2.add(d);
            ++n;
            if (seq2.getDouble(8) != d) {
                this.error(string, n);
            }
            ++n;
            seq2.add(string2);
            ++n;
            if (!seq2.getString(9).equals(string2)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(litTestObj2);
            ++n;
            if (!seq2.getObject(10, new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(resource);
            ++n;
            if (!((Object)seq2.getResource(11)).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(literal);
            ++n;
            if (!((Object)seq2.getLiteral(12)).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(resource2);
            ++n;
            if (!((Object)seq2.getResource(13, new ResTestObjF())).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(bag);
            ++n;
            if (!seq2.getBag(14).equals(bag)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(alt);
            ++n;
            if (!seq2.getAlt(15).equals(alt)) {
                this.error(string, n);
            }
            ++n;
            seq2.add(seq);
            ++n;
            if (!seq2.getSeq(16).equals(seq)) {
                this.error(string, n);
            }
            ++n;
            try {
                seq2.getInt(17);
                this.error(string, n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            ++n;
            try {
                seq2.getInt(0);
                this.error(string, n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            n = 800;
            seq2 = model.createSeq();
            for (int i = 0; i < n7; ++i) {
                seq2.add(i);
            }
            try {
                seq2.add(0, false);
                this.error(string, ++n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            seq2.add(n7 + 1, false);
            if (seq2.size() != n7 + 1) {
                this.error(string, n);
            }
            seq2.remove(n7 + 1);
            try {
                seq2.add(n7 + 2, false);
                this.error(string, ++n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            n = 820;
            int n8 = seq2.size();
            for (n2 = 1; n2 <= n7 - 1; ++n2) {
                ++n;
                seq2.add(n2, 1000 + n2);
                ++n;
                if (seq2.getInt(n2) != 1000 + n2) {
                    this.error(string, n);
                }
                ++n;
                if (seq2.getInt(n2 + 1) != 0) {
                    this.error(string, n);
                }
                ++n;
                if (seq2.size() != n8 + n2) {
                    this.error(string, n);
                }
                ++n;
                if (seq2.getInt(n8) == n7 - n2 - 1) continue;
                this.error(string, n);
            }
            n = 900;
            seq2 = model.createSeq();
            seq2.add(model.createResource());
            seq2.add(1, bl);
            ++n;
            if (seq2.getBoolean(1) != bl) {
                this.error(string, n);
            }
            seq2.add(1, by);
            ++n;
            if (seq2.getByte(1) != by) {
                this.error(string, n);
            }
            seq2.add(1, s);
            ++n;
            if (seq2.getShort(1) != s) {
                this.error(string, n);
            }
            seq2.add(1, n6);
            ++n;
            if (seq2.getInt(1) != n6) {
                this.error(string, n);
            }
            seq2.add(1, l);
            ++n;
            if (seq2.getLong(1) != l) {
                this.error(string, n);
            }
            seq2.add(1, c);
            ++n;
            if (seq2.getChar(1) != c) {
                this.error(string, n);
            }
            seq2.add(1, f);
            ++n;
            if (seq2.getFloat(1) != f) {
                this.error(string, n);
            }
            seq2.add(1, d);
            ++n;
            if (seq2.getDouble(1) != d) {
                this.error(string, n);
            }
            seq2.add(1, string2);
            ++n;
            if (!seq2.getString(1).equals(string2)) {
                this.error(string, n);
            }
            seq2.add(1, resource);
            ++n;
            if (!((Object)seq2.getResource(1)).equals(resource)) {
                this.error(string, n);
            }
            seq2.add(1, literal);
            ++n;
            if (!((Object)seq2.getLiteral(1)).equals(literal)) {
                this.error(string, n);
            }
            seq2.add(1, litTestObj2);
            ++n;
            if (!seq2.getObject(1, new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            n = 1000;
            ++n;
            if (seq2.indexOf(litTestObj2) != 1) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(literal) != 2) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(resource) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(string2) != 4) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(d) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(f) != 6) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(c) != 7) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(l) != 8) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(n6) != 9) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(s) != 10) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(by) != 11) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(bl) != 12) {
                this.error(string, n);
            }
            ++n;
            if (seq2.indexOf(1234543L) != 0) {
                this.error(string, n);
            }
            n = 1100;
            seq2 = model.createSeq();
            for (n2 = 0; n2 < n7; ++n2) {
                seq2.add(n2);
            }
            n = 1110;
            seq2.set(5, bl);
            ++n;
            if (seq2.getBoolean(5) != bl) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1120;
            seq2.set(5, by);
            ++n;
            if (seq2.getByte(5) != by) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1130;
            seq2.set(5, s);
            ++n;
            if (seq2.getShort(5) != s) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1140;
            seq2.set(5, n6);
            ++n;
            if (seq2.getInt(5) != n6) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1150;
            seq2.set(5, l);
            ++n;
            if (seq2.getLong(5) != l) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1160;
            seq2.set(5, c);
            ++n;
            if (seq2.getChar(5) != c) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1170;
            seq2.set(5, f);
            ++n;
            if (seq2.getFloat(5) != f) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1180;
            seq2.set(5, d);
            ++n;
            if (seq2.getDouble(5) != d) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1190;
            seq2.set(5, literal);
            ++n;
            if (!((Object)seq2.getLiteral(5)).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1200;
            seq2.set(5, resource);
            ++n;
            if (!((Object)seq2.getResource(5)).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1210;
            seq2.set(5, litTestObj2);
            ++n;
            if (!seq2.getObject(5, new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
            n = 1220;
            seq2.set(5, resource2);
            ++n;
            if (!((Object)seq2.getResource(5, new ResTestObjF())).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq2.size() != n7) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test17(Model model) {
        String string = "Test17";
        int n = 0;
        try {
            ResourceImpl resourceImpl = new ResourceImpl((ModelCom)model);
            n = 1000;
            this.testResource(model, resourceImpl, string, n, 0);
            n = 2000;
            this.testResource(model, model.createBag(), string, n, 1);
            n = 3000;
            this.testContainer(model, model.createBag(), model.createBag(), string, n);
            n = 4000;
            this.testBag(model, model.createBag(), model.createBag(), model.createBag(), string, n);
            n = 5000;
            this.testResource(model, model.createAlt(), string, n, 1);
            n = 6000;
            this.testContainer(model, model.createAlt(), model.createAlt(), string, n);
            n = 7000;
            this.testAlt(model, model.createAlt(), model.createAlt(), model.createAlt(), model.createAlt(), string, n);
            n = 8000;
            this.testResource(model, model.createSeq(), string, n, 1);
            n = 9000;
            this.testContainer(model, model.createSeq(), model.createSeq(), string, n);
            n = 10000;
            this.testSeq(model, model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), string, n);
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test18(Model model) {
        block17: {
            String string = "Test18";
            if (string.equals(string)) {
                return;
            }
            String string2 = "http://aldabaran.hpl.hp.com/rdftest/test18/";
            String string3 = string2 + "1";
            String string4 = "<foo bar=\"bar\"><bar>abc<foobar/>def&lt;&gt;&apos;&quot;&amp;</bar></foo>";
            String string5 = "http://lists.w3.org/Archives/Public/www-archive/2001Sep/att-0064/00-rdfschema.rdf";
            int n = 0;
            try {
                System.out.println("Beginning " + string);
                model.read(ResourceReader.getInputStream("modules/rdf/rdfschema.html"), string5);
                ++n;
                if (model.size() != 124L) {
                    this.error(string, n);
                }
                StmtIterator stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.nextStatement();
                    stmtIterator.remove();
                }
                model.read(ResourceReader.getInputStream("modules/rdf/embeddedxml.xml"), "");
                ++n;
                String string6 = model.getResource(string3).getRequiredProperty(RDF.value).getString();
                ++n;
                if (string6.indexOf("&lt;") == -1) {
                    this.error(string, n);
                }
                ++n;
                if (string6.indexOf("&gt;") == -1) {
                    this.error(string, n);
                }
                ++n;
                if (string6.indexOf("&amp;") == -1) {
                    this.error(string, n);
                }
                ++n;
                if (string6.indexOf("'bar'") == -1 && string6.indexOf("\"bar\"") == -1) {
                    this.error(string, n);
                }
                model.createResource().addProperty(RDF.value, "can't loose");
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.nextStatement();
                    stmtIterator.remove();
                }
                ++n;
                model.read(ResourceReader.getInputStream("modules/rdf/testcollection.rdf"), "");
                if (model.size() != 24L) {
                    this.error(string, (int)model.size());
                }
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.nextStatement();
                    stmtIterator.remove();
                }
                try {
                    model.read(System.getProperty("com.hp.hpl.jena.regression.testURL", string5));
                    ++n;
                    if (model.size() != 124L && model.size() != 125L) {
                        System.out.println("size = " + model.size());
                        this.error(string, n);
                    }
                    if (!model.contains(RDF.Property, RDF.type, RDFS.Class)) {
                        this.error(string, n);
                    }
                }
                catch (JenaException jenaException) {
                    Throwable throwable = jenaException.getCause();
                    if (throwable instanceof NoRouteToHostException || throwable instanceof UnknownHostException || throwable instanceof IOException || throwable instanceof ConnectException) {
                        logger.warn("Cannot access public internet- part of test not executed");
                        break block17;
                    }
                    throw jenaException;
                }
            }
            catch (Exception exception) {
                logger.error("test " + string + "[" + n + "]", exception);
                this.errors = true;
            }
        }
    }

    public void test19(Model model, Model model2) {
        String string = "Test19";
        int n = 0;
        try {
            try {
                n = 100;
                Resource resource = model.createResource();
                Resource resource2 = model2.createResource(new ResTestObjF());
                long l = model.size();
                long l2 = model2.size();
                resource.addProperty(RDF.value, 1L);
                ++n;
                if (model.size() != ++l) {
                    this.error(string, n);
                }
                ++n;
                if (model2.size() != l2) {
                    this.error(string, n);
                }
                Statement statement = model2.createStatement(resource, RDF.value, resource2);
                ++n;
                if (statement.getSubject().getModel() != model2) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getResource().getModel() != model2) {
                    this.error(string, n);
                }
                model.add(statement);
                ++n;
                if (model.size() != ++l) {
                    this.error(string, n);
                }
                ++n;
                if (model2.size() != l2) {
                    this.error(string, n);
                }
                StmtIterator stmtIterator = model.listStatements(new SimpleSelector(resource, RDF.value, resource2));
                ++n;
                if (!stmtIterator.hasNext()) {
                    this.error(string, n);
                }
                ++n;
                statement = stmtIterator.nextStatement();
                ++n;
                if (statement.getSubject().getModel() != model) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getResource().getModel() != model) {
                    this.error(string, n);
                }
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test20(Model model) {
        String string = "Test20";
        int n = 0;
        try {
            Statement statement = null;
            Statement statement2 = null;
            try {
                n = 100;
                ++n;
                statement = model.createStatement(model.createResource(), RDF.type, RDFS.Class);
                ++n;
                if (statement.isReified()) {
                    this.error(string, n);
                }
                ++n;
                model.add(statement);
                ++n;
                if (statement.isReified()) {
                    this.error(string, n);
                }
                ++n;
                statement2 = model.createStatement(model.createResource(), RDF.type, RDFS.Class);
                ++n;
                if (statement2.isReified()) {
                    this.error(string, n);
                }
                ++n;
                model.add(statement2);
                ++n;
                if (statement2.isReified()) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test97(Model model) {
        String string = "Test97";
        int n = 0;
        try {
            RDFNode rDFNode;
            try {
                n = 100;
                model.query(new SimpleSelector(null, null, new LiteralImpl(Node.createLiteral(null, "", false), (ModelCom)model)));
                this.error(string, n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                n = 101;
                model.query(new SimpleSelector(null, null, new LiteralImpl(Node.createLiteral(null, "en", false), (ModelCom)model)));
                this.error(string, n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            n = 102;
            StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, null, (String)null));
            while (stmtIterator.hasNext()) {
                rDFNode = stmtIterator.nextStatement().getObject();
            }
            n = 103;
            stmtIterator = model.listStatements(new SimpleSelector(null, null, (Object)null));
            while (stmtIterator.hasNext()) {
                rDFNode = stmtIterator.nextStatement().getObject();
            }
        }
        catch (Exception exception) {
            this.error(string, n, exception);
        }
    }

    public void test99(Model model) {
        String string = "Test5";
        int n = 0;
        try {
            try {
                n = 100;
                ++n;
                StmtIterator stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.nextStatement();
                    ++n;
                    stmtIterator.remove();
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (model.size() != 0L) {
                    this.error(string, 999);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void testResource(Model model, Resource resource, String string, int n, int n2) {
        try {
            Statement statement;
            boolean bl = true;
            int n4 = 1;
            int n5 = 2;
            int n6 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource2 = model.createResource();
            String string3 = "fr";
            ++n;
            if (!resource.addProperty(RDF.value, n4).hasProperty(RDF.value, n4)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, n5).hasProperty(RDF.value, n5)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, n6).hasProperty(RDF.value, n6)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, l).hasProperty(RDF.value, l)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, c).hasProperty(RDF.value, c)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, f).hasProperty(RDF.value, f)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, d).hasProperty(RDF.value, d)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, string2).hasProperty(RDF.value, string2)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, string2, string3).hasProperty(RDF.value, string2, string3)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, litTestObj).hasProperty(RDF.value, litTestObj)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, literal).hasProperty(RDF.value, literal)) {
                this.error(string, n);
            }
            ++n;
            if (!resource.addProperty(RDF.value, resource2).hasProperty(RDF.value, resource2)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)resource.getRequiredProperty(RDF.value).getSubject()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            Property property = model.createProperty("foo/", "bar");
            try {
                resource.getRequiredProperty(property);
                this.error(string, n);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            ++n;
            StmtIterator stmtIterator = resource.listProperties(RDF.value);
            int n7 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resource)) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            if (n7 != 12) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties(property);
            n7 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resource)) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            if (n7 != 0) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties();
            n7 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                if (!((Object)statement.getSubject()).equals(resource)) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            if (n7 != 12 + n2) {
                this.error(string, n);
            }
            ++n;
            resource.removeProperties();
            ++n;
            Model model2 = model.query(new SimpleSelector(resource, null, (RDFNode)null));
            if (model2.size() != 0L) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void testContainer(Model model, Container container, Container container2, String string, int n) {
        try {
            int n2;
            int n4;
            boolean bl = true;
            int n5 = 1;
            int n6 = 2;
            int n7 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            String string3 = "en";
            int n8 = 10;
            n = (n / 100 + 1) * 100;
            ++n;
            if (container.size() != 0) {
                this.error(string, n);
            }
            n = (n / 100 + 1) * 100;
            ++n;
            container.add(bl);
            ++n;
            if (!container.contains(bl)) {
                this.error(string, n);
            }
            ++n;
            container.add(n5);
            ++n;
            if (!container.contains(n5)) {
                this.error(string, n);
            }
            ++n;
            container.add(n6);
            ++n;
            if (!container.contains(n6)) {
                this.error(string, n);
            }
            ++n;
            container.add(n7);
            ++n;
            if (!container.contains(n7)) {
                this.error(string, n);
            }
            ++n;
            container.add(l);
            ++n;
            if (!container.contains(l)) {
                this.error(string, n);
            }
            ++n;
            container.add(c);
            ++n;
            if (!container.contains(c)) {
                this.error(string, n);
            }
            ++n;
            container.add(f);
            ++n;
            if (!container.contains(f)) {
                this.error(string, n);
            }
            ++n;
            container.add(d);
            ++n;
            if (!container.contains(d)) {
                this.error(string, n);
            }
            ++n;
            container.add(string2);
            ++n;
            if (!container.contains(string2)) {
                this.error(string, n);
            }
            ++n;
            if (container.contains(string2, string3)) {
                this.error(string, n);
            }
            ++n;
            container.add(string2, string3);
            ++n;
            if (!container.contains(string2, string3)) {
                this.error(string, n);
            }
            ++n;
            container.add(literal);
            ++n;
            if (!container.contains(literal)) {
                this.error(string, n);
            }
            ++n;
            container.add(resource);
            ++n;
            if (!container.contains(resource)) {
                this.error(string, n);
            }
            ++n;
            container.add(litTestObj2);
            ++n;
            if (!container.contains(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (container.size() != 13) {
                this.error(string, n);
            }
            n = (n / 100 + 1) * 100;
            for (n4 = 0; n4 < n8; ++n4) {
                container2.add(n4);
            }
            ++n;
            if (container2.size() != n8) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = container2.iterator();
            for (n4 = 0; n4 < n8; ++n4) {
                if (((Literal)nodeIterator.nextNode()).getInt() == n4) continue;
                this.error(string, 320 + n4);
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n8];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = container2.iterator();
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = container2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            for (n2 = 0; n2 < n8; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void testBag(Model model, Bag bag, Bag bag2, Bag bag3, String string, int n) {
        int n2 = 10;
        try {
            int n4;
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            for (n4 = 0; n4 < n2; ++n4) {
                bag.add(n4);
            }
            ++n;
            NodeIterator nodeIterator = bag.iterator();
            for (n4 = 0; n4 < n2; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = bag.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            for (n4 = 0; n4 < n2; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n2];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = (n / 100 + 1) * 100;
            for (n4 = 0; n4 < n2; ++n4) {
                bag2.add(n4);
            }
            ++n;
            nodeIterator = bag2.iterator();
            for (n4 = 0; n4 < n2; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            for (n4 = 0; n4 < n2; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n2];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = (n / 100 + 1) * 100;
            for (n4 = 0; n4 < n2; ++n4) {
                bag3.add(n4);
            }
            ++n;
            nodeIterator = bag3.iterator();
            for (n4 = 0; n4 < n2; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = bag3.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            for (n4 = 0; n4 < n2; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void testAlt(Model model, Alt alt, Alt alt2, Alt alt3, Alt alt4, String string, int n) {
        try {
            int n2;
            boolean bl = true;
            byte by = 1;
            short s = 2;
            int n4 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt5 = model.createAlt();
            Seq seq = model.createSeq();
            String string3 = "fr";
            int n5 = 10;
            boolean[] blArray = new boolean[n5];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = (n / 100 + 1) * 100;
            for (n2 = 0; n2 < n5; ++n2) {
                alt.add(n2);
            }
            ++n;
            NodeIterator nodeIterator = alt.iterator();
            for (n2 = 0; n2 < n5; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = alt.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            for (n2 = 0; n2 < n5; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n5];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = (n / 100 + 1) * 100;
            for (n2 = 0; n2 < n5; ++n2) {
                alt2.add(n2);
            }
            ++n;
            nodeIterator = alt2.iterator();
            for (n2 = 0; n2 < n5; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = 550;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 580;
            for (n2 = 0; n2 < n5; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n5];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = (n / 100 + 1) * 100;
            for (n2 = 0; n2 < n5; ++n2) {
                alt3.add(n2);
            }
            ++n;
            nodeIterator = alt3.iterator();
            for (n2 = 0; n2 < n5; ++n2) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n2]) {
                    nodeIterator.remove();
                }
                blArray[n2] = false;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = alt3.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            for (n2 = 0; n2 < n5; ++n2) {
                ++n;
                if (blArray[n2] == blArray2[n2]) continue;
                this.error(string, n);
            }
            n = (n / 100 + 1) * 100;
            ++n;
            if (!alt4.setDefault(literal).getDefault().equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)alt4.setDefault(literal).getDefaultLiteral()).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)alt4.setDefault(resource).getDefaultResource()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(by).getDefaultByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(s).getDefaultShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(n4).getDefaultInt() != n4) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(l).getDefaultLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(c).getDefaultChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(f).getDefaultFloat() != f) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(d).getDefaultDouble() != d) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(string2).getDefaultString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.getDefaultLanguage().equals("")) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(string2, string3).getDefaultString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.getDefaultLanguage().equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!((Object)alt4.setDefault(resource2).getDefaultResource(new ResTestObjF())).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(litTestObj2).getDefaultObject(new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(alt5).getDefaultAlt().equals(alt5)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(bag).getDefaultBag().equals(bag)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(seq).getDefaultSeq().equals(seq)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void testSeq(Model model, Seq seq, Seq seq2, Seq seq3, Seq seq4, Seq seq5, Seq seq6, Seq seq7, String string, int n) {
        try {
            int n2;
            int n4;
            int n5;
            boolean bl = true;
            byte by = 1;
            short s = 2;
            int n6 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq8 = model.createSeq();
            String string3 = "fr";
            int n7 = 10;
            for (n5 = 0; n5 < n7; ++n5) {
                seq.add(n5);
            }
            ++n;
            if (seq.size() != n7) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = seq.iterator();
            for (n5 = 0; n5 < n7; ++n5) {
                if (((Literal)nodeIterator.nextNode()).getInt() == n5) continue;
                this.error(string, 320 + n5);
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n7];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = n / 100 * 100 + 100;
            ++n;
            nodeIterator = seq.iterator();
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = n / 100 * 100 + 100;
            ++n;
            nodeIterator = seq.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = n / 100 * 100 + 100;
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n7];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = n / 100 * 100 + 100;
            for (n4 = 0; n4 < n7; ++n4) {
                seq2.add(n4);
            }
            ++n;
            nodeIterator = seq2.iterator();
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = n / 100 * 100 + 100;
            ++n;
            nodeIterator = seq2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = n / 100 * 100 + 100;
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            blArray = new boolean[n7];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = n / 100 * 100 + 100;
            for (n4 = 0; n4 < n7; ++n4) {
                seq3.add(n4);
            }
            ++n;
            nodeIterator = seq3.iterator();
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                nodeIterator.nextNode();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
            }
            ++n;
            nodeIterator.close();
            n = n / 100 * 100 + 100;
            ++n;
            nodeIterator = seq3.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.nextNode()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = n / 100 * 100 + 100;
            for (n4 = 0; n4 < n7; ++n4) {
                ++n;
                if (blArray[n4] == blArray2[n4]) continue;
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            ++n;
            seq4.add(bl);
            ++n;
            if (seq4.getBoolean(1) != bl) {
                this.error(string, n);
            }
            ++n;
            seq4.add(by);
            ++n;
            if (seq4.getByte(2) != by) {
                this.error(string, n);
            }
            ++n;
            seq4.add(s);
            ++n;
            if (seq4.getShort(3) != s) {
                this.error(string, n);
            }
            ++n;
            seq4.add(n6);
            ++n;
            if (seq4.getInt(4) != n6) {
                this.error(string, n);
            }
            ++n;
            seq4.add(l);
            ++n;
            if (seq4.getLong(5) != l) {
                this.error(string, n);
            }
            ++n;
            seq4.add(c);
            ++n;
            if (seq4.getChar(6) != c) {
                this.error(string, n);
            }
            ++n;
            seq4.add(f);
            ++n;
            if (seq4.getFloat(7) != f) {
                this.error(string, n);
            }
            ++n;
            seq4.add(d);
            ++n;
            if (seq4.getDouble(8) != d) {
                this.error(string, n);
            }
            ++n;
            seq4.add(string2);
            ++n;
            if (!seq4.getString(9).equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!seq4.getLanguage(9).equals("")) {
                this.error(string, n);
            }
            ++n;
            seq4.add(string2, string3);
            ++n;
            if (!seq4.getString(10).equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!seq4.getLanguage(10).equals(string3)) {
                this.error(string, n);
            }
            ++n;
            seq4.add(litTestObj2);
            ++n;
            if (!seq4.getObject(11, new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            seq4.add(resource);
            ++n;
            if (!((Object)seq4.getResource(12)).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            seq4.add(literal);
            ++n;
            if (!((Object)seq4.getLiteral(13)).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            seq4.add(resource2);
            ++n;
            if (!((Object)seq4.getResource(14, new ResTestObjF())).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            seq4.add(bag);
            ++n;
            if (!seq4.getBag(15).equals(bag)) {
                this.error(string, n);
            }
            ++n;
            seq4.add(alt);
            ++n;
            if (!seq4.getAlt(16).equals(alt)) {
                this.error(string, n);
            }
            ++n;
            seq4.add(seq8);
            ++n;
            if (!seq4.getSeq(17).equals(seq8)) {
                this.error(string, n);
            }
            ++n;
            try {
                seq4.getInt(18);
                this.error(string, n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            ++n;
            try {
                seq4.getInt(0);
                this.error(string, n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            n = n / 100 * 100 + 100;
            for (int i = 0; i < n7; ++i) {
                seq5.add(i);
            }
            try {
                seq5.add(0, false);
                this.error(string, ++n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            seq5.add(n7 + 1, false);
            if (seq5.size() != n7 + 1) {
                this.error(string, n);
            }
            seq5.remove(n7 + 1);
            try {
                seq5.add(n7 + 2, false);
                this.error(string, ++n);
            }
            catch (SeqIndexBoundsException seqIndexBoundsException) {
                // empty catch block
            }
            n = n / 100 * 100 + 100;
            int n8 = seq5.size();
            for (n2 = 1; n2 <= n7 - 1; ++n2) {
                ++n;
                seq5.add(n2, 1000 + n2);
                ++n;
                if (seq5.getInt(n2) != 1000 + n2) {
                    this.error(string, n);
                }
                ++n;
                if (seq5.getInt(n2 + 1) != 0) {
                    this.error(string, n);
                }
                ++n;
                if (seq5.size() != n8 + n2) {
                    this.error(string, n);
                }
                ++n;
                if (seq5.getInt(n8) == n7 - n2 - 1) continue;
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq6.add(model.createResource());
            seq6.add(1, bl);
            ++n;
            if (seq6.getBoolean(1) != bl) {
                this.error(string, n);
            }
            seq6.add(1, by);
            ++n;
            if (seq6.getByte(1) != by) {
                this.error(string, n);
            }
            seq6.add(1, s);
            ++n;
            if (seq6.getShort(1) != s) {
                this.error(string, n);
            }
            seq6.add(1, n6);
            ++n;
            if (seq6.getInt(1) != n6) {
                this.error(string, n);
            }
            seq6.add(1, l);
            ++n;
            if (seq6.getLong(1) != l) {
                this.error(string, n);
            }
            seq6.add(1, c);
            ++n;
            if (seq6.getChar(1) != c) {
                this.error(string, n);
            }
            seq6.add(1, f);
            ++n;
            if (seq6.getFloat(1) != f) {
                this.error(string, n);
            }
            seq6.add(1, d);
            ++n;
            if (seq6.getDouble(1) != d) {
                this.error(string, n);
            }
            seq6.add(1, string2);
            ++n;
            if (!seq6.getString(1).equals(string2)) {
                this.error(string, n);
            }
            seq6.add(1, string2, string3);
            ++n;
            if (!seq6.getString(1).equals(string2)) {
                this.error(string, n);
            }
            seq6.add(1, resource);
            ++n;
            if (!((Object)seq6.getResource(1)).equals(resource)) {
                this.error(string, n);
            }
            seq6.add(1, literal);
            ++n;
            if (!((Object)seq6.getLiteral(1)).equals(literal)) {
                this.error(string, n);
            }
            seq6.add(1, litTestObj2);
            ++n;
            if (!seq6.getObject(1, new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            ++n;
            if (seq6.indexOf(litTestObj2) != 1) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(literal) != 2) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(resource) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(string2, string3) != 4) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(string2) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(d) != 6) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(f) != 7) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(c) != 8) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(l) != 9) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(n6) != 10) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(s) != 11) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(by) != 12) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(bl) != 13) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(1234543L) != 0) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            for (n2 = 0; n2 < n7; ++n2) {
                seq7.add(n2);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, bl);
            ++n;
            if (seq7.getBoolean(5) != bl) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, by);
            ++n;
            if (seq7.getByte(5) != by) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, s);
            ++n;
            if (seq7.getShort(5) != s) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, n6);
            ++n;
            if (seq7.getInt(5) != n6) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, l);
            ++n;
            if (seq7.getLong(5) != l) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, c);
            ++n;
            if (seq7.getChar(5) != c) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, f);
            ++n;
            if (seq7.getFloat(5) != f) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, d);
            ++n;
            if (seq7.getDouble(5) != d) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, string2);
            ++n;
            if (!seq7.getString(5).equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!seq7.getLanguage(5).equals("")) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            seq7.set(5, string2, string3);
            ++n;
            if (!seq7.getString(5).equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!seq7.getLanguage(5).equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, literal);
            ++n;
            if (!((Object)seq7.getLiteral(5)).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, resource);
            ++n;
            if (!((Object)seq7.getResource(5)).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, litTestObj2);
            ++n;
            if (!seq7.getObject(5, new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, resource2);
            ++n;
            if (!((Object)seq7.getResource(5, new ResTestObjF())).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n7) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + string + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void error(String string, int n) {
        System.out.println("Test Failed: " + string + " " + n + " ");
        this.errors = true;
    }

    public void error(String string, int n, long l) {
        System.out.println("Test Failed: " + string + " " + n + " " + Long.toString(l));
        this.errors = true;
    }

    public void error(String string, int n, Exception exception) {
        System.out.println("Test Failed: " + string + " " + n + " " + exception.toString());
        this.errors = true;
    }

    public boolean getErrors() {
        return this.errors;
    }

    public boolean setErrors(boolean bl) {
        boolean bl2 = this.errors;
        this.errors = bl;
        return bl2;
    }

    public class ResTestObjF
    implements ResourceF {
        public Resource createResource(Resource resource) {
            return new ResourceImpl(resource, (ModelCom)resource.getModel());
        }
    }

    public class LitTestObjF
    implements ObjectF {
        public Object createObject(String string) {
            return new LitTestObj(string);
        }
    }

    public class LitTestObj {
        protected long content;

        public LitTestObj(long l) {
            this.content = l;
        }

        public LitTestObj(String string) {
            this.content = Long.parseLong(string.substring(1, string.length() - 1));
        }

        public String toString() {
            return "[" + Long.toString(this.content) + "]";
        }

        public boolean equals(Object object) {
            if (object instanceof LitTestObj) {
                return this.content == ((LitTestObj)object).content;
            }
            return false;
        }
    }
}

