/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.impl;

import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.util.XMLChar;

public class PrefixMappingImpl
implements PrefixMapping {
    protected Map prefixToURI = CollectionFactory.createHashedMap();
    protected Map URItoPrefix = CollectionFactory.createHashedMap();
    protected boolean locked;

    protected void set(String string, String string2) {
        this.prefixToURI.put(string, string2);
        this.URItoPrefix.put(string2, string);
    }

    protected String get(String string) {
        return (String)this.prefixToURI.get(string);
    }

    public PrefixMapping lock() {
        this.locked = true;
        return this;
    }

    public PrefixMapping setNsPrefix(String string, String string2) {
        this.checkUnlocked();
        this.checkLegal(string);
        if (!string.equals("")) {
            this.checkProper(string2);
        }
        this.set(string, string2);
        return this;
    }

    public PrefixMapping removeNsPrefix(String string) {
        this.checkUnlocked();
        String string2 = (String)this.prefixToURI.remove(string);
        this.regenerateReverseMapping();
        return this;
    }

    protected void regenerateReverseMapping() {
        this.URItoPrefix.clear();
        Iterator iterator = this.prefixToURI.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.URItoPrefix.put(entry.getValue(), entry.getKey());
        }
    }

    protected void checkUnlocked() {
        if (this.locked) {
            throw new PrefixMapping.JenaLockedException(this);
        }
    }

    private void checkProper(String string) {
    }

    public static boolean isNiceURI(String string) {
        if (string.equals("")) {
            return false;
        }
        char c = string.charAt(string.length() - 1);
        return Util.notNameChar(c);
    }

    public PrefixMapping setNsPrefixes(PrefixMapping prefixMapping) {
        return this.setNsPrefixes(prefixMapping.getNsPrefixMap());
    }

    public PrefixMapping withDefaultMappings(PrefixMapping prefixMapping) {
        this.checkUnlocked();
        Iterator iterator = prefixMapping.getNsPrefixMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (this.getNsPrefixURI(string) != null || this.getNsURIPrefix(string2) != null) continue;
            this.setNsPrefix(string, string2);
        }
        return this;
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.checkUnlocked();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.setNsPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private void checkLegal(String string) {
        if (string.length() > 0 && !XMLChar.isValidNCName(string)) {
            throw new PrefixMapping.IllegalPrefixException(string);
        }
    }

    public String getNsPrefixURI(String string) {
        return this.get(string);
    }

    public Map getNsPrefixMap() {
        return CollectionFactory.createHashedMap(this.prefixToURI);
    }

    public String getNsURIPrefix(String string) {
        return (String)this.URItoPrefix.get(string);
    }

    public String expandPrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = this.get(string2);
        return string3 == null ? string : string3 + string.substring(n + 1);
    }

    public String toString() {
        return "pm:" + this.prefixToURI;
    }

    public String qnameFor(String string) {
        int n = Util.splitNamespace(string);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        if (string3.equals("")) {
            return null;
        }
        String string4 = (String)this.URItoPrefix.get(string2);
        return string4 == null ? null : string4 + ":" + string3;
    }

    public String usePrefix(String string) {
        return this.shortForm(string);
    }

    public String shortForm(String string) {
        Map.Entry entry = this.findMapping(string, true);
        return entry == null ? string : entry.getKey() + ":" + string.substring(((String)entry.getValue()).length());
    }

    private Map.Entry findMapping(String string, boolean bl) {
        Iterator iterator = this.prefixToURI.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getValue();
            if (!string.startsWith(string2) || !bl && string2.length() != string.length()) continue;
            return entry;
        }
        return null;
    }
}

