/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTestPrefixMapping
extends GraphTestBase {
    static final String crispURI = "http://crisp.nosuch.net/";
    static final String ropeURI = "scheme:rope/string#";
    static final String butterURI = "ftp://ftp.nowhere.at.all/cream#";
    static final String[] badNames = new String[]{"<hello>", "foo:bar", "with a space", "-argument"};
    static final String[] dontChange = new String[]{"", "http://www.somedomain.something/whatever#", "crispy:cabbage", "cris:isOnInfiniteEarths", "rop:tangled/web", "roped:abseiling"};
    static final String[][] expansions = new String[][]{{"crisp:pathPart", "http://crisp.nosuch.net/pathPart"}, {"rope:partPath", "scheme:rope/string#partPath"}, {"crisp:path:part", "http://crisp.nosuch.net/path:part"}};

    public AbstractTestPrefixMapping(String string) {
        super(string);
    }

    protected abstract PrefixMapping getMapping();

    public void testEmptyPrefix() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("", crispURI);
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI(""));
    }

    public void testCheckNames() {
        PrefixMapping prefixMapping = this.getMapping();
        for (int i = 0; i < badNames.length; ++i) {
            String string = badNames[i];
            try {
                prefixMapping.setNsPrefix(string, crispURI);
                AbstractTestPrefixMapping.fail("'" + string + "' is an illegal prefix and should be trapped");
                continue;
            }
            catch (PrefixMapping.IllegalPrefixException illegalPrefixException) {
                AbstractTestPrefixMapping.pass();
            }
        }
    }

    public void testPrefixMappingMapping() {
        String string = "ftp://ftp.nowhere.not/";
        AbstractTestPrefixMapping.assertDiffer("crisp and toast must differ", crispURI, string);
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertEquals("crisp should be unset", null, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should be unset", null, prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should be unset", null, prefixMapping.getNsPrefixURI("butter"));
        prefixMapping.setNsPrefix("crisp", crispURI);
        AbstractTestPrefixMapping.assertEquals("crisp should be set", crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should still be unset", null, prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should still be unset", null, prefixMapping.getNsPrefixURI("butter"));
        prefixMapping.setNsPrefix("toast", string);
        AbstractTestPrefixMapping.assertEquals("crisp should be set", crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should be set", string, prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should still be unset", null, prefixMapping.getNsPrefixURI("butter"));
    }

    public void testReversePrefixMapping() {
        PrefixMapping prefixMapping = this.getMapping();
        String string = "http://jena.hpl.hp.com/A#";
        String string2 = "http://jena.hpl.hp.com/";
        String string3 = "http://jena.hpl.hp.com/Csharp/";
        String string4 = "aa";
        String string5 = "bb";
        prefixMapping.setNsPrefix(string4, string).setNsPrefix(string5, string2);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsURIPrefix(string3));
        AbstractTestPrefixMapping.assertEquals(string4, prefixMapping.getNsURIPrefix(string));
        AbstractTestPrefixMapping.assertEquals(string5, prefixMapping.getNsURIPrefix(string2));
    }

    public void testPrefixMappingMap() {
        PrefixMapping prefixMapping = this.getCrispyRope();
        Map map = prefixMapping.getNsPrefixMap();
        AbstractTestPrefixMapping.assertEquals("map should have two elements", 2, map.size());
        AbstractTestPrefixMapping.assertEquals((Object)crispURI, map.get("crisp"));
        AbstractTestPrefixMapping.assertEquals((Object)ropeURI, map.get("rope"));
    }

    public void testPrefixMappingSecret() {
        PrefixMapping prefixMapping = this.getCrispyRope();
        Map map = prefixMapping.getNsPrefixMap();
        map.put("crisp", "with/onions");
        map.put("sandwich", "with/cheese");
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(ropeURI, prefixMapping.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("sandwich"));
    }

    private PrefixMapping getCrispyRope() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("rope", ropeURI);
        return prefixMapping;
    }

    public void testExpandPrefix() {
        int n;
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("rope", ropeURI);
        for (n = 0; n < dontChange.length; ++n) {
            AbstractTestPrefixMapping.assertEquals("should be unchanged", dontChange[n], prefixMapping.expandPrefix(dontChange[n]));
        }
        for (n = 0; n < expansions.length; ++n) {
            AbstractTestPrefixMapping.assertEquals("should expand correctly", expansions[n][1], prefixMapping.expandPrefix(expansions[n][0]));
        }
    }

    public void testUseEasyPrefix() {
        AbstractTestPrefixMapping.testUseEasyPrefix("prefix mapping impl", this.getMapping());
        AbstractTestPrefixMapping.testShortForm("prefix mapping impl", this.getMapping());
    }

    public static void testUseEasyPrefix(String string, PrefixMapping prefixMapping) {
        AbstractTestPrefixMapping.testUsePrefix(string, prefixMapping);
        AbstractTestPrefixMapping.testShortForm(string, prefixMapping);
    }

    public static void testUsePrefix(String string, PrefixMapping prefixMapping) {
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(string, "", prefixMapping.usePrefix(""));
        AbstractTestPrefixMapping.assertEquals(string, ropeURI, prefixMapping.usePrefix(ropeURI));
        AbstractTestPrefixMapping.assertEquals(string, "crisp:tail", prefixMapping.usePrefix("http://crisp.nosuch.net/tail"));
        AbstractTestPrefixMapping.assertEquals(string, "butter:here:we:are", prefixMapping.usePrefix("ftp://ftp.nowhere.at.all/cream#here:we:are"));
    }

    public static void testShortForm(String string, PrefixMapping prefixMapping) {
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(string, "", prefixMapping.shortForm(""));
        AbstractTestPrefixMapping.assertEquals(string, ropeURI, prefixMapping.shortForm(ropeURI));
        AbstractTestPrefixMapping.assertEquals(string, "crisp:tail", prefixMapping.shortForm("http://crisp.nosuch.net/tail"));
        AbstractTestPrefixMapping.assertEquals(string, "butter:here:we:are", prefixMapping.shortForm("ftp://ftp.nowhere.at.all/cream#here:we:are"));
    }

    public void testEasyQName() {
        PrefixMapping prefixMapping = this.getMapping();
        String string = "http://seasonal.song/preamble/";
        prefixMapping.setNsPrefix("alpha", string);
        AbstractTestPrefixMapping.assertEquals("alpha:rowboat", prefixMapping.qnameFor(string + "rowboat"));
    }

    public void testNoQNameNoPrefix() {
        PrefixMapping prefixMapping = this.getMapping();
        String string = "http://seasonal.song/preamble/";
        prefixMapping.setNsPrefix("alpha", string);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.qnameFor("eg:rowboat"));
    }

    public void testNoQNameBadLocal() {
        PrefixMapping prefixMapping = this.getMapping();
        String string = "http://seasonal.song/preamble/";
        prefixMapping.setNsPrefix("alpha", string);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.qnameFor(string + "12345"));
    }

    public void testQnameFromEmail() {
        String string = "http://some.long.uri/for/a/namespace#";
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("x", string);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.qnameFor(string));
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.qnameFor(string + "non/fiction"));
    }

    public void testAddOtherPrefixMapping() {
        PrefixMapping prefixMapping;
        PrefixMapping prefixMapping2 = this.getMapping();
        AbstractTestPrefixMapping.assertFalse("must have two diffferent maps", prefixMapping2 == (prefixMapping = this.getMapping()));
        prefixMapping2.setNsPrefix("crisp", crispURI);
        prefixMapping2.setNsPrefix("rope", ropeURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("rope"));
        prefixMapping.setNsPrefixes(prefixMapping2);
        this.checkContainsMapping(prefixMapping);
    }

    private void checkContainsMapping(PrefixMapping prefixMapping) {
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(ropeURI, prefixMapping.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals(butterURI, prefixMapping.getNsPrefixURI("butter"));
    }

    public void testAddMap() {
        PrefixMapping prefixMapping = this.getMapping();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("crisp", crispURI);
        hashMap.put("rope", ropeURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        prefixMapping.setNsPrefixes(hashMap);
        this.checkContainsMapping(prefixMapping);
    }

    public void testAddDefaultMap() {
        PrefixMapping prefixMapping = this.getMapping();
        PrefixMappingImpl prefixMappingImpl = new PrefixMappingImpl();
        prefixMapping.setNsPrefix("a", "aPrefix:");
        prefixMapping.setNsPrefix("b", "bPrefix:");
        prefixMappingImpl.setNsPrefix("a", "pootle:");
        prefixMappingImpl.setNsPrefix("z", "bPrefix:");
        prefixMappingImpl.setNsPrefix("c", "cootle:");
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.withDefaultMappings(prefixMappingImpl));
        AbstractTestPrefixMapping.assertEquals("aPrefix:", prefixMapping.getNsPrefixURI("a"));
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("z"));
        AbstractTestPrefixMapping.assertEquals("bPrefix:", prefixMapping.getNsPrefixURI("b"));
        AbstractTestPrefixMapping.assertEquals("cootle:", prefixMapping.getNsPrefixURI("c"));
    }

    public void testSecondPrefixRetainsExistingMap() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("a", crispURI);
        prefixMapping.setNsPrefix("b", crispURI);
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("a"));
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("b"));
    }

    public void testSecondPrefixReplacesReverseMap() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("a", crispURI);
        prefixMapping.setNsPrefix("b", crispURI);
        AbstractTestPrefixMapping.assertEquals("b", prefixMapping.getNsURIPrefix(crispURI));
    }

    public void testSecondPrefixDeletedUncoversPreviousMap() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("x", crispURI);
        prefixMapping.setNsPrefix("y", crispURI);
        prefixMapping.removeNsPrefix("y");
        AbstractTestPrefixMapping.assertEquals("x", prefixMapping.getNsURIPrefix(crispURI));
    }

    public void testEmptyDoesNotWipeURI() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("frodo", ropeURI);
        prefixMapping.setNsPrefix("", ropeURI);
        AbstractTestPrefixMapping.assertEquals(ropeURI, prefixMapping.getNsPrefixURI("frodo"));
    }

    public void testSameURIKeepsDefault() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("", crispURI);
        prefixMapping.setNsPrefix("crisp", crispURI);
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI(""));
    }

    public void testReturnsSelf() {
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.setNsPrefix("crisp", crispURI));
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.setNsPrefixes(prefixMapping));
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.setNsPrefixes(new HashMap()));
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.removeNsPrefix("rhubarb"));
    }

    public void testRemovePrefix() {
        String string = "http://test.remove.prefixes/prefix#";
        String string2 = "http://other.test.remove.prefixes/prefix#";
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("hr", string);
        prefixMapping.setNsPrefix("br", string2);
        prefixMapping.removeNsPrefix("hr");
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("hr"));
        AbstractTestPrefixMapping.assertEquals(string2, prefixMapping.getNsPrefixURI("br"));
    }

    public void testAllowNastyNamespace() {
        this.getMapping().setNsPrefix("abc", "def");
    }

    public void testLock() {
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.lock());
        try {
            prefixMapping.setNsPrefix("crisp", crispURI);
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            prefixMapping.setNsPrefixes(prefixMapping);
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            prefixMapping.setNsPrefixes(new HashMap());
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            prefixMapping.removeNsPrefix("toast");
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            AbstractTestPrefixMapping.pass();
        }
    }
}

