/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.TestSuite;

public class TestPrefixMapping
extends AbstractTestPrefixMapping {
    public TestPrefixMapping(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPrefixMapping.class);
    }

    protected PrefixMapping getMapping() {
        return new PrefixMappingImpl();
    }

    public void testStandard() {
        this.testStandard(PrefixMapping.Standard);
    }

    public void testExtended() {
        this.testExtended(PrefixMapping.Extended);
    }

    public void testStandard(PrefixMapping prefixMapping) {
        TestPrefixMapping.assertEquals(RDF.getURI(), prefixMapping.getNsPrefixURI("rdf"));
        TestPrefixMapping.assertEquals(RDFS.getURI(), prefixMapping.getNsPrefixURI("rdfs"));
        TestPrefixMapping.assertEquals(DC.getURI(), prefixMapping.getNsPrefixURI("dc"));
        TestPrefixMapping.assertEquals(OWL.getURI(), prefixMapping.getNsPrefixURI("owl"));
        TestPrefixMapping.assertEquals("http://www.daml.org/2001/03/daml+oil#", prefixMapping.getNsPrefixURI("daml"));
    }

    public void testExtended(PrefixMapping prefixMapping) {
        this.testStandard(prefixMapping);
        TestPrefixMapping.assertEquals(RSS.getURI(), prefixMapping.getNsPrefixURI("rss"));
        TestPrefixMapping.assertEquals(VCARD.getURI(), prefixMapping.getNsPrefixURI("vcard"));
        TestPrefixMapping.assertEquals(JenaModelSpec.getURI(), prefixMapping.getNsPrefixURI("jms"));
    }
}

