/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestWrappedIterator
extends GraphTestBase {
    public static TestSuite suite() {
        return new TestSuite(TestWrappedIterator.class);
    }

    public TestWrappedIterator(String string) {
        super(string);
    }

    public void testWrappedIterator() {
        Iterator<String> iterator = Arrays.asList("bill", "and", "ben").iterator();
        ExtendedIterator extendedIterator = WrappedIterator.create(iterator);
        TestWrappedIterator.assertTrue("wrapper has at least one element", extendedIterator.hasNext());
        TestWrappedIterator.assertEquals("", (Object)"bill", extendedIterator.next());
        TestWrappedIterator.assertTrue("wrapper has at least two elements", extendedIterator.hasNext());
        TestWrappedIterator.assertEquals("", (Object)"and", extendedIterator.next());
        TestWrappedIterator.assertTrue("wrapper has at least three elements", extendedIterator.hasNext());
        TestWrappedIterator.assertEquals("", (Object)"ben", extendedIterator.next());
        TestWrappedIterator.assertFalse("wrapper is now empty", extendedIterator.hasNext());
    }

    public void testUnwrapExtendedIterator() {
        ExtendedIterator extendedIterator = TestWrappedIterator.graphWith("a R b").find(Triple.ANY);
        TestWrappedIterator.assertSame(extendedIterator, WrappedIterator.create(extendedIterator));
    }

    public void testWrappedNoRemove() {
        Iterator iterator = this.nodeSet("a b c").iterator();
        iterator.next();
        iterator.remove();
        WrappedIterator wrappedIterator = WrappedIterator.createNoRemove(iterator);
        wrappedIterator.next();
        try {
            wrappedIterator.remove();
            TestWrappedIterator.fail("wrapped-no-remove iterator should deny .remove()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            TestWrappedIterator.pass();
        }
    }
}

