/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheManager;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCache
extends TestCase {
    public TestCache(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("Cache");
        testSuite.addTest(new CacheTestCase("RAND"));
        return testSuite;
    }

    static class CacheTestCase
    extends TestCase {
        String cacheType;

        CacheTestCase(String string) {
            super(string);
            this.cacheType = string;
        }

        protected void runTest() {
            this.testCache();
        }

        public void testCache() {
            this.testCacheCreation(this.cacheType);
            this.testCacheSimpleReturn(this.cacheType);
            this.testFillTheCache(this.cacheType);
        }

        public void testCacheCreation(String string) {
            Cache cache = CacheManager.createCache(string, "c1", 100);
            try {
                Cache cache2 = CacheManager.createCache(string, "c2", 1);
                CacheTestCase.assertTrue("Missing error on bad cache size: " + string, false);
            }
            catch (Error error) {
                // empty catch block
            }
        }

        public void testCacheSimpleReturn(String string) {
            Integer n;
            Integer n2;
            String string2;
            String string3;
            int n4 = 100;
            Cache cache = CacheManager.createCache(string, "c1", n4);
            String string4 = string3 = (string2 = "one");
            Integer n5 = n2 = (n = new Integer(-1));
            cache.put(string2, n);
            for (int i = 0; i < n4; ++i) {
                string2 = string3;
                n = n2;
                Object object = cache.get(string2);
                CacheTestCase.assertTrue("expected a hit", object != null);
                CacheTestCase.assertEquals("should be the expected object", object, n);
                string3 = string4;
                n2 = n5;
                object = cache.get(string3);
                CacheTestCase.assertTrue("expected a hit", object != null);
                CacheTestCase.assertEquals("should be the expected object", object, n2);
                string4 = "T" + i;
                n5 = new Integer(i);
                cache.put(string4, n5);
            }
        }

        public void testFillTheCache(String string) {
            int n;
            Cache cache = CacheManager.createCache(string, "c1", 100);
            String[] stringArray = new String[100];
            String[] stringArray2 = new String[100];
            for (n = 0; n < 100; ++n) {
                stringArray[n] = "K" + n;
                stringArray2[n] = "V" + n;
                cache.put(stringArray[n], stringArray2[n]);
            }
            n = 0;
            for (int i = 0; i < 100; ++i) {
                if (cache.get(stringArray[i]) == null) continue;
                ++n;
            }
            CacheTestCase.assertTrue("too low a hit rate: " + string + " = " + n, n > 50);
            CacheTestCase.assertEquals("count puts", 100L, cache.getPuts());
            CacheTestCase.assertEquals("count gets", 100L, cache.getGets());
            CacheTestCase.assertEquals("count hits", (long)n, cache.getHits());
        }
    }
}

