/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

public class TestCollectionFactory
extends ModelTestBase {
    public TestCollectionFactory(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestCollectionFactory.class);
    }

    public void testHashMapExists() {
        Map map = CollectionFactory.createHashedMap();
        TestCollectionFactory.assertTrue(map instanceof Map);
    }

    public void testHashMapSized() {
        Map map = CollectionFactory.createHashedMap(42);
        TestCollectionFactory.assertTrue(map instanceof Map);
    }

    public void testHashMapCopy() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("here", "Bristol");
        hashMap.put("there", "Oxford");
        Map map = CollectionFactory.createHashedMap(hashMap);
        TestCollectionFactory.assertEquals(hashMap, map);
    }

    public void testHashSetExists() {
        Set set = CollectionFactory.createHashedSet();
        TestCollectionFactory.assertTrue(set instanceof Set);
    }

    public void testHashSetCopy() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("jelly");
        hashSet.add("concrete");
        Set set = CollectionFactory.createHashedSet(hashSet);
        TestCollectionFactory.assertEquals(hashSet, set);
    }
}

