/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.FileUtils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFileUtils
extends TestCase {
    public TestFileUtils(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileUtils.class);
    }

    public void testLangXML() {
        TestFileUtils.assertEquals("RDF/XML", "RDF/XML");
    }

    public void testLangXMLAbbrev() {
        TestFileUtils.assertEquals("RDF/XML-ABBREV", "RDF/XML-ABBREV");
    }

    public void testLangNTriple() {
        TestFileUtils.assertEquals("N-TRIPLE", "N-TRIPLE");
    }

    public void testLangN3() {
        TestFileUtils.assertEquals("N3", "N3");
    }

    public void testLangTurtle() {
        TestFileUtils.assertEquals("TURTLE", "TURTLE");
    }

    public void testGuessLangLowerCase() {
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("simple.n3"));
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("hello.there.n3"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("simple.ttl"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("hello.there.ttl"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("simple.nt"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("whats.up.nt"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("poggle.rdf"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("wise.owl"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("dotless"));
    }

    public void testGuessLangMixedCase() {
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("simple.N3"));
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("hello.there.N3"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("simple.TTL"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("hello.there.TTL"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("simple.NT"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("whats.up.Nt"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("poggle.rDf"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("wise.OwL"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("dotless"));
    }

    public void testGuessLangFallback() {
        TestFileUtils.assertEquals("spoo", FileUtils.guessLang("noSuffix", "spoo"));
        TestFileUtils.assertEquals("pots", FileUtils.guessLang("suffix.unknown", "pots"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("rdf.rdf", "spoo"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("rdf.owl", "spoo"));
    }

    public void testMisplacedDots() {
        TestFileUtils.assertEquals("spoo", FileUtils.guessLang("stuff.left/right", "spoo"));
        TestFileUtils.assertEquals("spoo", FileUtils.guessLang("stuff.left\\right", "spoo"));
    }

    public void testFilename1() {
        this.isFilename("foo");
    }

    public void testFilename2() {
        this.isFilename("foo/bar");
    }

    public void testFilename3() {
        this.isFilename("foo\\bar");
    }

    public void testFilename4() {
        this.isFilename("\\bar");
    }

    public void testFilename5() {
        this.isFilename("foo/bar");
    }

    public void testFilename6() {
        this.isFilename("c:foo");
    }

    public void testFilename7() {
        this.isFilename("c:\\foo");
    }

    public void testFilename8() {
        this.isFilename("c:\\foo\\bar");
    }

    public void testFilename9() {
        this.isFilename("file::foo");
    }

    public void testFilename10() {
        this.isNotFilename("http://www.hp.com/");
    }

    public void testFilename11() {
        this.isNotFilename("urn:tag:stuff");
    }

    void isFilename(String string) {
        TestFileUtils.assertTrue("Should be a file name : " + string, FileUtils.isFile(string));
    }

    void isNotFilename(String string) {
        TestFileUtils.assertFalse("Shouldn't be a  file name: " + string, FileUtils.isFile(string));
    }
}

