/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestLocationMapper
extends TestCase {
    static Log log = LogFactory.getLog(TestLocationMapper.class);
    static final String testingDir = "testing/FileManager";
    static final String filename1 = "file:test";
    static final String notFilename = "zzzz";
    static final String filename2 = "file:testing/FileManager/location-mapping-test-file";
    static final String mapping = "location-mapping-test.n3;testing/FileManager/location-mapping-test.n3";

    public TestLocationMapper(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestLocationMapper.class);
    }

    public void testLocationMapping() {
        LocationMapper locationMapper = new LocationMapper(mapping);
        String string = locationMapper.altMapping(filename1);
        TestLocationMapper.assertNotNull(string);
        TestLocationMapper.assertEquals(string, filename2);
    }

    public void testLocationMappingMiss() {
        LocationMapper locationMapper = new LocationMapper(mapping);
        String string = locationMapper.altMapping(notFilename);
        TestLocationMapper.assertNotNull(string);
        TestLocationMapper.assertEquals(string, notFilename);
    }

    public void testLocationMappingURLtoFile() {
        LocationMapper locationMapper = new LocationMapper(mapping);
        String string = locationMapper.altMapping("http://example.org/file");
        TestLocationMapper.assertNotNull(string);
        TestLocationMapper.assertEquals(string, filename2);
    }

    public void testLocationMappingFromModel() {
        String string;
        String string2;
        String string3;
        Model model = FileManager.get().loadModel("testing/FileManager/location-mapping-test.n3");
        LocationMapper locationMapper = new LocationMapper(model);
        LocationMapper locationMapper2 = new LocationMapper(mapping);
        Iterator iterator = locationMapper.listAltEntries();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            string2 = locationMapper2.getAltEntry(string3);
            string = locationMapper.getAltEntry(string3);
            TestLocationMapper.assertEquals("Different entries", string2, string);
        }
        iterator = locationMapper.listAltPrefixes();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            string2 = locationMapper2.getAltPrefix(string3);
            string = locationMapper.getAltPrefix(string3);
            TestLocationMapper.assertEquals("Different entries", string2, string);
        }
    }
}

