/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.OneToManyMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public class TestOneToManyMap
extends TestCase {
    private String s0 = "s0";
    private String s1 = "s1";
    private String s2 = "s2";
    private String s3 = "s3";
    private String s4 = "s4";

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testConstruct0() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        TestOneToManyMap.assertNotNull(oneToManyMap);
        TestOneToManyMap.assertTrue(oneToManyMap.isEmpty());
        OneToManyMap oneToManyMap2 = new OneToManyMap(oneToManyMap);
        TestOneToManyMap.assertNotNull(oneToManyMap2);
        TestOneToManyMap.assertTrue(oneToManyMap2.isEmpty());
    }

    public void testConstruct1() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(oneToManyMap.contains(this.s0, this.s1));
        OneToManyMap oneToManyMap2 = new OneToManyMap(oneToManyMap);
        TestOneToManyMap.assertTrue(oneToManyMap.contains(this.s0, this.s1));
        oneToManyMap.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue(oneToManyMap.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s1, this.s2));
    }

    public void testClear() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(oneToManyMap.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse(oneToManyMap.isEmpty());
        oneToManyMap.clear();
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s0, this.s1));
        TestOneToManyMap.assertTrue(oneToManyMap.isEmpty());
    }

    public void testContainsKey() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        TestOneToManyMap.assertFalse(oneToManyMap.containsKey(this.s0));
        TestOneToManyMap.assertFalse(oneToManyMap.containsKey(this.s1));
        oneToManyMap.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(oneToManyMap.containsKey(this.s0));
        TestOneToManyMap.assertFalse(oneToManyMap.containsKey(this.s1));
    }

    public void testContainsValue() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        TestOneToManyMap.assertFalse(oneToManyMap.containsValue(this.s0));
        TestOneToManyMap.assertFalse(oneToManyMap.containsValue(this.s1));
        TestOneToManyMap.assertFalse(oneToManyMap.containsValue(this.s2));
        oneToManyMap.put(this.s0, this.s1);
        TestOneToManyMap.assertFalse(oneToManyMap.containsValue(this.s0));
        TestOneToManyMap.assertTrue(oneToManyMap.containsValue(this.s1));
        TestOneToManyMap.assertFalse(oneToManyMap.containsValue(this.s2));
        oneToManyMap.put(this.s0, this.s2);
        TestOneToManyMap.assertFalse(oneToManyMap.containsValue(this.s0));
        TestOneToManyMap.assertTrue(oneToManyMap.containsValue(this.s1));
        TestOneToManyMap.assertTrue(oneToManyMap.containsValue(this.s2));
    }

    public void testContains() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s1, this.s2));
        oneToManyMap.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(oneToManyMap.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s1, this.s2));
        oneToManyMap.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue(oneToManyMap.contains(this.s0, this.s1));
        TestOneToManyMap.assertTrue(oneToManyMap.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(oneToManyMap.contains(this.s1, this.s2));
    }

    public void testEntrySet() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        oneToManyMap.put(this.s0, this.s2);
        oneToManyMap.put(this.s3, this.s4);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = oneToManyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry.getKey().equals(this.s0) && entry.getValue().equals(this.s1)) {
                bl = true;
                continue;
            }
            if (entry.getKey().equals(this.s0) && entry.getValue().equals(this.s2)) {
                bl2 = true;
                continue;
            }
            if (entry.getKey().equals(this.s3) && entry.getValue().equals(this.s4)) {
                bl3 = true;
                continue;
            }
            throw new IllegalArgumentException("unexpected: " + entry);
        }
        TestOneToManyMap.assertTrue(bl);
        TestOneToManyMap.assertTrue(bl2);
        TestOneToManyMap.assertTrue(bl3);
    }

    public void testEquals() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        oneToManyMap.put(this.s0, this.s2);
        oneToManyMap.put(this.s3, this.s4);
        OneToManyMap oneToManyMap2 = new OneToManyMap();
        oneToManyMap2.put(this.s3, this.s4);
        oneToManyMap2.put(this.s0, this.s1);
        oneToManyMap2.put(this.s0, this.s2);
        OneToManyMap oneToManyMap3 = new OneToManyMap();
        oneToManyMap3.put(this.s0, this.s2);
        oneToManyMap3.put(this.s3, this.s4);
        TestOneToManyMap.assertTrue(oneToManyMap.equals(oneToManyMap2));
        TestOneToManyMap.assertTrue(oneToManyMap2.equals(oneToManyMap));
        TestOneToManyMap.assertTrue(oneToManyMap.hashCode() == oneToManyMap2.hashCode());
        TestOneToManyMap.assertFalse(oneToManyMap.equals(oneToManyMap3));
        TestOneToManyMap.assertFalse(oneToManyMap3.equals(oneToManyMap));
    }

    public void testGet() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        TestOneToManyMap.assertNull(oneToManyMap.get(this.s0));
        oneToManyMap.put(this.s0, this.s1);
        TestOneToManyMap.assertEquals((Object)this.s1, oneToManyMap.get(this.s0));
        oneToManyMap.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue(oneToManyMap.get(this.s0).equals(this.s1) || oneToManyMap.get(this.s0).equals(this.s2));
    }

    public void testGetAll() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        Iterator iterator = oneToManyMap.getAll(this.s0);
        TestOneToManyMap.assertNotNull(iterator);
        TestOneToManyMap.assertFalse(iterator.hasNext());
        oneToManyMap.put(this.s0, this.s1);
        iterator = oneToManyMap.getAll(this.s0);
        TestOneToManyMap.assertNotNull(iterator);
        TestOneToManyMap.assertTrue(iterator.hasNext());
        TestOneToManyMap.assertEquals((Object)this.s1, iterator.next());
        TestOneToManyMap.assertFalse(iterator.hasNext());
        oneToManyMap.put(this.s0, this.s2);
        iterator = oneToManyMap.getAll(this.s0);
        TestOneToManyMap.assertNotNull(iterator);
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.equals(this.s1)) {
                bl = true;
                continue;
            }
            if (e.equals(this.s2)) {
                bl2 = true;
                continue;
            }
            throw new IllegalArgumentException(e.toString());
        }
        TestOneToManyMap.assertTrue(bl);
        TestOneToManyMap.assertTrue(bl2);
    }

    public void testKeySet() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        HashSet<String> hashSet = new HashSet<String>();
        TestOneToManyMap.assertEquals(hashSet, oneToManyMap.keySet());
        oneToManyMap.put(this.s0, this.s1);
        hashSet.add(this.s0);
        TestOneToManyMap.assertEquals(hashSet, oneToManyMap.keySet());
        oneToManyMap.put(this.s2, this.s1);
        hashSet.add(this.s2);
        TestOneToManyMap.assertEquals(hashSet, oneToManyMap.keySet());
    }

    public void testPutAll0() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        oneToManyMap.put(this.s0, this.s2);
        oneToManyMap.put(this.s3, this.s4);
        OneToManyMap oneToManyMap2 = new OneToManyMap();
        oneToManyMap2.put(this.s0, this.s2);
        oneToManyMap2.put(this.s3, this.s4);
        oneToManyMap2.put(this.s0, this.s1);
        OneToManyMap oneToManyMap3 = new OneToManyMap();
        oneToManyMap3.putAll((Map)oneToManyMap2);
        TestOneToManyMap.assertEquals(oneToManyMap, oneToManyMap3);
    }

    public void testPutAll1() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        oneToManyMap.put(this.s3, this.s4);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.s3, this.s4);
        hashMap.put(this.s0, this.s1);
        OneToManyMap oneToManyMap2 = new OneToManyMap();
        oneToManyMap2.putAll(hashMap);
        TestOneToManyMap.assertEquals(oneToManyMap, oneToManyMap2);
    }

    public void testRemove0() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        oneToManyMap.put(this.s3, this.s4);
        oneToManyMap.remove(this.s0);
        oneToManyMap.remove(this.s3);
        TestOneToManyMap.assertTrue(oneToManyMap.isEmpty());
    }

    public void testRemove1() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        oneToManyMap.put(this.s0, this.s1);
        oneToManyMap.put(this.s0, this.s2);
        oneToManyMap.put(this.s3, this.s4);
        oneToManyMap.remove(this.s0, this.s2);
        oneToManyMap.remove(this.s3, this.s4);
        TestOneToManyMap.assertFalse(oneToManyMap.isEmpty());
        oneToManyMap.remove(this.s0, this.s1);
        TestOneToManyMap.assertTrue(oneToManyMap.isEmpty());
    }

    public void testSize() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        TestOneToManyMap.assertEquals(0, oneToManyMap.size());
        oneToManyMap.put(this.s0, this.s1);
        TestOneToManyMap.assertEquals(1, oneToManyMap.size());
        oneToManyMap.put(this.s0, this.s2);
        TestOneToManyMap.assertEquals(2, oneToManyMap.size());
        oneToManyMap.put(this.s3, this.s4);
        TestOneToManyMap.assertEquals(3, oneToManyMap.size());
        oneToManyMap.remove(this.s0, this.s2);
        TestOneToManyMap.assertEquals(2, oneToManyMap.size());
        oneToManyMap.remove(this.s3, this.s4);
        TestOneToManyMap.assertEquals(1, oneToManyMap.size());
        oneToManyMap.remove(this.s0, this.s1);
        TestOneToManyMap.assertEquals(0, oneToManyMap.size());
    }

    public void testValues() {
        OneToManyMap oneToManyMap = new OneToManyMap();
        HashSet<String> hashSet = new HashSet<String>();
        TestOneToManyMap.assertEquals(hashSet, oneToManyMap.values());
        oneToManyMap.put(this.s0, this.s1);
        hashSet.add(this.s1);
        TestOneToManyMap.assertEquals(hashSet, oneToManyMap.values());
        oneToManyMap.put(this.s2, this.s1);
        TestOneToManyMap.assertEquals(hashSet, oneToManyMap.values());
        oneToManyMap.put(this.s2, this.s3);
        hashSet.add(this.s3);
        TestOneToManyMap.assertEquals(hashSet, oneToManyMap.values());
    }
}

