/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.util.iterator.ArrayIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.IteratorIterator;
import com.hp.hpl.jena.util.iterator.LateBindingIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.MapFilterIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.xmloutput.impl.Relation;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.XMLChar;

class Unparser {
    private static Property LI = new PropertyImpl(RDF.getURI(), "li");
    private static Property DESCRIPTION = new PropertyImpl(RDF.getURI(), "Description");
    protected static Log logger = LogFactory.getLog(Unparser.class);
    private String xmlBase;
    private static final String rdfns = RDF.type.getNameSpace();
    private static final Integer one = new Integer(1);
    private String localName;
    private Map objectTable;
    private Model model;
    private PrintWriter out;
    private Set doing = new HashSet();
    private Set doneSet = new HashSet();
    private Set haveReified = new HashSet();
    private Resource[] pleasingTypes = null;
    private Set pleasingTypeSet = new HashSet();
    private final Abbreviated prettyWriter;
    private boolean avoidExplicitReification = true;
    Map res2statement;
    Map statement2res;
    private static int RDF_HASH = RDF.getURI().length();
    private WType wdesc = new WType(){

        void wTypeStart(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.rdfEl(resource.getURI().substring(RDF_HASH)));
        }

        void wTypeEnd(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.rdfEl(resource.getURI().substring(RDF_HASH)));
        }
    };
    private WType wtype = new WType(){

        void wTypeStart(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.startElementTag(resource.getURI()));
        }

        void wTypeEnd(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.endElementTag(resource.getURI()));
        }
    };
    private Set idDone = new HashSet();
    int[] codeCoverage = new int[8];
    private int indentLevel = 0;
    private int currentColumn = 0;
    private Set infinite;
    private Set openResIterators = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Unparser(Abbreviated abbreviated, String string, Model model, PrintWriter printWriter) {
        RDFNode rDFNode;
        Object object;
        this.setLocalName(string);
        this.prettyWriter = abbreviated;
        this.out = printWriter;
        this.model = model;
        this.addTypeNameSpaces();
        this.objectTable = new HashMap();
        StmtIterator stmtIterator = model.listStatements();
        try {
            while (stmtIterator.hasNext()) {
                object = stmtIterator.nextStatement();
                rDFNode = object.getObject();
                if (!(rDFNode instanceof Resource)) continue;
                this.increaseObjectCount((Resource)rDFNode);
            }
        }
        finally {
            stmtIterator.close();
        }
        try {
            this.res2statement = new HashMap();
            this.statement2res = new HashMap();
            object = new MapFilterIterator(new MapFilter(){

                public Object accept(Object object) {
                    Resource resource = (Resource)object;
                    return resource.hasProperty(RDF.subject) && resource.hasProperty(RDF.object) && resource.hasProperty(RDF.predicate) ? resource : null;
                }
            }, this.model.listSubjectsWithProperty(RDF.type, RDF.Statement));
            while (object.hasNext()) {
                rDFNode = (Resource)object.next();
                try {
                    Statement statement = rDFNode.getRequiredProperty(RDF.subject);
                    Statement statement2 = rDFNode.getRequiredProperty(RDF.predicate);
                    Statement statement3 = rDFNode.getRequiredProperty(RDF.object);
                    RDFNode rDFNode2 = statement3.getObject();
                    Resource resource = (Resource)statement.getObject();
                    Resource resource2 = (Resource)statement2.getObject();
                    Property property = this.model.createProperty(resource2.getURI());
                    Statement statement4 = this.model.createStatement(resource, property, rDFNode2);
                    this.res2statement.put(rDFNode, statement4);
                    this.statement2res.put(statement4, rDFNode);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            stmtIterator.close();
        }
    }

    private void setLocalName(String string) {
        if (string == null || string.equals("")) {
            this.localName = "";
        } else {
            try {
                URI uRI = new URI(string);
                uRI.setFragment(null);
                this.localName = uRI.getURIString();
            }
            catch (MalformedURIException malformedURIException) {
                throw new BadURIException(string, malformedURIException);
            }
        }
    }

    void write() {
        this.prettyWriter.workOutNamespaces();
        this.wRDF();
    }

    void setTopLevelTypes(Resource[] resourceArray) {
        this.pleasingTypes = resourceArray;
        this.pleasingTypeSet = new HashSet<Resource>(Arrays.asList(resourceArray));
    }

    void setXMLBase(String string) {
        this.xmlBase = string;
    }

    private void wRDF() {
        this.tab();
        this.print("<");
        this.print(this.prettyWriter.rdfEl("RDF"));
        this.indentPlus();
        this.printNameSpaceDefn();
        if (this.xmlBase != null) {
            this.setLocalName(this.xmlBase);
            this.tab();
            this.print("xml:base=" + this.quote(this.xmlBase));
        }
        this.print(">");
        this.wObjStar();
        this.indentMinus();
        this.tab();
        this.print("</");
        this.print(this.prettyWriter.rdfEl("RDF"));
        this.print(">");
        this.tab();
    }

    private void wObjStar() {
        Iterator iterator = this.listSubjects();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            this.increaseObjectCount(resource);
            this.wObj(resource, true);
        }
        this.closeAllResIterators();
    }

    private boolean wPropertyElt(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        return this.wPropertyEltCompact(wType, property, statement, rDFNode) || this.wPropertyEltDamlCollection(wType, property, statement, rDFNode) || this.wPropertyEltLiteral(wType, property, statement, rDFNode) || this.wPropertyEltResource(wType, property, statement, rDFNode) || this.wPropertyEltDatatype(wType, property, statement, rDFNode) || this.wPropertyEltValue(wType, property, statement, rDFNode);
    }

    private boolean wPropertyEltCompact(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        if (!(rDFNode instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)rDFNode;
        if (!this.allPropsAreAttr(resource) && !this.doing.contains(resource)) {
            return false;
        }
        if (!this.hasProperties(resource) && this.isGenuineAnon(resource)) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.indentPlus();
        this.wIdRefAttrOpt(statement, resource);
        if (!this.doing.contains(resource)) {
            this.wPropAttrAll(resource);
        } else if (this.isGenuineAnon(resource)) {
            this.error("Genuine anon resource in cycle?");
        }
        this.indentMinus();
        this.print("/>");
        return true;
    }

    private boolean wPropertyEltLiteral(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        if (this.prettyWriter.sParseTypeLiteralPropertyElt) {
            return false;
        }
        if (!(rDFNode instanceof Literal) || !((Literal)rDFNode).getWellFormed()) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.wIdAttrReified(statement);
        this.maybeNewline();
        this.wParseLiteral();
        this.maybeNewline();
        this.print(">");
        this.print(((Literal)rDFNode).getLexicalForm());
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltDatatype(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        if (!(rDFNode instanceof Literal) || ((Literal)rDFNode).getDatatypeURI() == null) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.wIdAttrReified(statement);
        this.maybeNewline();
        this.wDatatype(((Literal)rDFNode).getDatatypeURI());
        this.maybeNewline();
        this.print(">");
        this.print(Util.substituteEntitiesInElementContent(((Literal)rDFNode).getLexicalForm()));
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltResource(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        if (this.prettyWriter.sParseTypeResourcePropertyElt) {
            return false;
        }
        if (rDFNode instanceof Literal) {
            return false;
        }
        Resource resource = (Resource)rDFNode;
        if (!this.isGenuineAnon(resource)) {
            return false;
        }
        if (this.getType(resource) != null) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.indentPlus();
        this.wIdAttrReified(statement);
        this.wParseResource();
        this.print(">");
        this.wPropertyEltStar(resource);
        this.indentMinus();
        this.tab();
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltValue(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        return this.wPropertyEltValueString(wType, property, statement, rDFNode) || this.wPropertyEltValueObj(wType, property, statement, rDFNode);
    }

    private boolean wPropertyEltValueString(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        if (rDFNode instanceof Literal) {
            this.done(statement);
            Literal literal = (Literal)rDFNode;
            String string = literal.getLanguage();
            this.tab();
            this.print("<");
            wType.wTypeStart(property);
            this.wIdAttrReified(statement);
            this.maybeNewline();
            if (string != null && string.length() > 0) {
                this.print(" xml:lang=" + this.q(string));
            }
            this.maybeNewline();
            this.print(">");
            this.wValueString(literal);
            this.print("</");
            wType.wTypeEnd(property);
            this.print(">");
            return true;
        }
        return false;
    }

    private void wValueString(Literal literal) {
        String string = literal.getString();
        this.print(Util.substituteEntitiesInElementContent(string));
    }

    private boolean wPropertyEltValueObj(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        if (rDFNode instanceof Resource && !this.prettyWriter.sResourcePropertyElt) {
            Resource resource = (Resource)rDFNode;
            this.done(statement);
            this.tab();
            this.print("<");
            wType.wTypeStart(property);
            this.wIdAttrReified(statement);
            this.print(">");
            this.tab();
            this.indentPlus();
            this.wObj(resource, false);
            this.indentMinus();
            this.tab();
            this.print("</");
            wType.wTypeEnd(property);
            this.print(">");
            return true;
        }
        return false;
    }

    private boolean wPropertyEltDamlCollection(WType wType, Property property, Statement statement, RDFNode rDFNode) {
        int n;
        boolean bl = true;
        Statement[][] statementArray = this.getDamlList(rDFNode);
        if (statementArray == null) {
            bl = false;
            statementArray = this.getRDFList(rDFNode);
        }
        if (statementArray == null) {
            return false;
        }
        this.done(statement);
        for (n = 0; n < statementArray.length; ++n) {
            this.done(statementArray[n][0]);
            this.done(statementArray[n][1]);
            if (!bl) continue;
            this.done(statementArray[n][2]);
        }
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.indentPlus();
        this.wIdAttrReified(statement);
        if (bl) {
            this.wParseDamlCollection();
        } else {
            this.wParseCollection();
        }
        this.print(">");
        for (n = 0; n < statementArray.length; ++n) {
            this.wObj((Resource)statementArray[n][0].getObject(), false);
        }
        this.indentMinus();
        this.tab();
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private void wPropAttrAll(Resource resource) {
        this.wPropAttrSome(resource);
        if (this.hasProperties(resource)) {
            this.error("Bad call to wPropAttrAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wPropAttrSome(Resource resource) {
        ExtendedIterator extendedIterator = this.listProperties(resource);
        try {
            HashSet hashSet = new HashSet();
            while (extendedIterator.hasNext()) {
                Statement statement = (Statement)extendedIterator.next();
                RDFNode rDFNode = statement.getObject();
                if (!this.canBeAttribute(statement, hashSet)) continue;
                this.done(statement);
                this.wPropAttr(statement.getPredicate(), statement.getObject());
            }
        }
        finally {
            extendedIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wObj(Resource resource, boolean bl) {
        try {
            this.doing.add(resource);
            Statement statement = this.getType(resource);
            if (statement != null) {
                Resource resource2 = statement.getResource();
                if (!bl && this.pleasingTypeSet.contains(resource2) && !this.isGenuineAnon(resource)) {
                    boolean bl2 = this.wTypedNodeNoProperties(resource);
                    return bl2;
                }
                boolean bl3 = this.wTypedNode(resource) || this.wDescription(resource);
                return bl3;
            }
            boolean bl4 = this.wDescription(resource);
            return bl4;
        }
        finally {
            this.doing.remove(resource);
        }
    }

    private boolean wDescription(Resource resource) {
        return this.wTypedNodeOrDescription(this.wdesc, DESCRIPTION, resource);
    }

    private boolean wTypedNode(Resource resource) {
        Statement statement = this.getType(resource);
        if (statement == null) {
            return false;
        }
        Resource resource2 = statement.getResource();
        this.done(statement);
        return this.wTypedNodeOrDescription(this.wtype, resource2, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wTypedNodeOrDescription(WType wType, Resource resource, Resource resource2) {
        Object object;
        int n;
        Vector<Object> vector = new Vector<Object>();
        ExtendedIterator extendedIterator = this.listProperties(resource2);
        try {
            n = 0;
            if (!this.prettyWriter.sListExpand) {
                while (extendedIterator.hasNext()) {
                    object = (Statement)extendedIterator.next();
                    int n2 = object.getPredicate().getOrdinal();
                    if (n2 == 0) continue;
                    if (n2 > n) {
                        vector.setSize(n2);
                        n = n2;
                    }
                    vector.set(n2 - 1, object);
                }
            }
        }
        finally {
            extendedIterator.close();
        }
        n = vector.indexOf(null);
        object = n == -1 ? vector : vector.subList(0, n);
        return this.wTypedNodeOrDescriptionCompact(wType, resource, resource2, (List)object) || this.wTypedNodeOrDescriptionLong(wType, resource, resource2, (List)object);
    }

    private boolean wTypedNodeOrDescriptionCompact(WType wType, Resource resource, Resource resource2, List list) {
        if (!list.isEmpty() || !this.allPropsAreAttr(resource2)) {
            return false;
        }
        this.tab();
        this.print("<");
        wType.wTypeStart(resource);
        this.indentPlus();
        this.wIdAboutAttrOpt(resource2);
        this.wPropAttrAll(resource2);
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeNoProperties(Resource resource) {
        if (this.isGenuineAnon(resource)) {
            return false;
        }
        Statement statement = this.getType(resource);
        if (statement == null) {
            return false;
        }
        Resource resource2 = statement.getResource();
        this.done(statement);
        this.tab();
        this.print("<");
        this.wtype.wTypeStart(resource2);
        this.indentPlus();
        this.wIdAboutAttrOpt(resource);
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeOrDescriptionLong(WType wType, Resource resource, Resource resource2, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.done((Statement)iterator.next());
        }
        this.tab();
        this.print("<");
        wType.wTypeStart(resource);
        this.indentPlus();
        this.wIdAboutAttrOpt(resource2);
        this.wPropAttrSome(resource2);
        this.print(">");
        this.wLiEltStar(list.iterator());
        this.wPropertyEltStar(resource2);
        this.indentMinus();
        this.tab();
        this.print("</");
        wType.wTypeEnd(resource);
        this.print(">");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wPropertyEltStar(Resource resource) {
        ExtendedIterator extendedIterator = this.listProperties(resource);
        try {
            while (extendedIterator.hasNext()) {
                Statement statement = (Statement)extendedIterator.next();
                this.wPropertyElt(this.wtype, statement.getPredicate(), statement, statement.getObject());
            }
        }
        finally {
            extendedIterator.close();
        }
    }

    private void wLiEltStar(Iterator iterator) {
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            this.wPropertyElt(this.wdesc, LI, statement, statement.getObject());
        }
    }

    private boolean wIdAboutAttrOpt(Resource resource) {
        return this.wIdAttrOpt(resource) || this.wNodeIDAttr(resource) || this.wAboutAttr(resource);
    }

    private boolean wIdAttrOpt(Resource resource) {
        if (this.isGenuineAnon(resource)) {
            return true;
        }
        if (this.prettyWriter.sIdAttr) {
            return false;
        }
        if (resource.isAnon()) {
            return false;
        }
        if (this.isLocalReference(resource)) {
            if (this.wantReification(resource)) {
                return false;
            }
            if (this.idDone.contains(resource)) {
                return false;
            }
            this.idDone.add(resource);
            this.print(" ");
            this.printRdfAt("ID");
            this.print("=");
            this.print(this.quote(this.getLocalName(resource)));
            return true;
        }
        return false;
    }

    private boolean wAboutAttr(Resource resource) {
        this.print(" ");
        this.printRdfAt("about");
        this.print("=");
        this.wURIreference(resource);
        return true;
    }

    private void wURIreference(String string) {
        this.print(this.quote(this.prettyWriter.relativize(string)));
    }

    private void wURIreference(Resource resource) {
        this.wURIreference(resource.getURI());
    }

    private void wIdRefAttrOpt(Statement statement, Resource resource) {
        this.wIdAttrReified(statement);
        if (!this.isGenuineAnon(resource)) {
            this.wResourceNodeIDAttr(resource);
        }
    }

    private void wIdAttrReified(Statement statement) {
        if (this.wantReification(statement)) {
            Statement[] statementArray = this.reification(statement);
            Resource resource = (Resource)this.statement2res.get(statement);
            this.idDone.add(resource);
            for (int i = 0; i < statementArray.length; ++i) {
                this.done(statementArray[i]);
            }
            this.print(" ");
            this.printRdfAt("ID");
            this.print("=");
            this.print(this.quote(this.getLocalName(resource)));
            this.haveReified.add(resource);
        }
    }

    private boolean wResourceNodeIDAttr(Resource resource) {
        return this.wNodeIDAttr(resource) || this.wResourceAttr(resource);
    }

    private boolean wNodeIDAttr(Resource resource) {
        if (!resource.isAnon()) {
            return false;
        }
        this.print(" ");
        this.printRdfAt("nodeID");
        this.print("=");
        this.print(this.q(this.prettyWriter.anonId(resource)));
        return true;
    }

    private boolean wResourceAttr(Resource resource) {
        if (resource.isAnon()) {
            return false;
        }
        this.print(" ");
        this.printRdfAt("resource");
        this.print("=");
        this.wURIreference(resource);
        return true;
    }

    private void wQNameAttr(Property property) {
        this.print(this.prettyWriter.attributeTag(property.getURI()));
    }

    private void printRdfAt(String string) {
        this.print(this.prettyWriter.rdfAt(string));
    }

    private void wPropAttr(Property property, RDFNode rDFNode) {
        this.tab();
        if (property.equals(RDF.type)) {
            this.wTypeAttr((Resource)rDFNode);
        } else {
            this.wPropAttrString(property, (Literal)rDFNode);
        }
    }

    private void wTypeAttr(Resource resource) {
        this.print(" ");
        this.printRdfAt("type");
        this.print("=");
        this.wURIreference(resource);
    }

    private void wPropAttrString(Property property, Literal literal) {
        this.print(" ");
        this.wQNameAttr(property);
        this.print("=" + this.quote(literal.getString()));
    }

    private void wParseDamlCollection() {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("daml:collection"));
    }

    private void wParseCollection() {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Collection"));
    }

    private void wParseLiteral() {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Literal"));
    }

    private void wDatatype(String string) {
        this.print(" ");
        this.printRdfAt("datatype");
        this.print("=");
        this.maybeNewline();
        this.wURIreference(string);
    }

    private void wParseResource() {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Resource"));
    }

    private void printNameSpaceDefn() {
        this.print(this.prettyWriter.xmlnsDecl());
    }

    private static String filler(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private void tab() {
        int n = this.prettyWriter.tab * this.indentLevel;
        if (n > this.prettyWriter.width) {
            n = 4 + (n - 4) % this.prettyWriter.width;
        }
        if (n == 0 && this.currentColumn == 0 || n > this.currentColumn) {
            String string = Unparser.filler(n - this.currentColumn);
            this.out.print(string);
        } else {
            this.out.println();
            this.out.print(Unparser.filler(n));
        }
        this.currentColumn = n;
    }

    private void maybeNewline() {
        if (this.currentColumn > this.prettyWriter.width) {
            this.tab();
        }
    }

    private String quote(String string) {
        return this.prettyWriter.qq(string);
    }

    private String q(String string) {
        return this.prettyWriter.q(string);
    }

    private void print(String string) {
        this.out.print(string);
        int n = string.lastIndexOf(10);
        this.currentColumn = n == -1 ? (this.currentColumn += string.length()) : string.length() - n - 1;
    }

    private void indentPlus() {
        ++this.indentLevel;
    }

    private void indentMinus() {
        --this.indentLevel;
    }

    private void error(String string) {
        BrokenException brokenException = new BrokenException("Internal error in Unparser: " + string);
        this.prettyWriter.fatalError(brokenException);
        throw brokenException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTypeNameSpaces() {
        NodeIterator nodeIterator = this.model.listObjectsOfProperty(RDF.type);
        try {
            while (nodeIterator.hasNext()) {
                RDFNode rDFNode = nodeIterator.nextNode();
                int n = this.isOKType(rDFNode);
                if (n == -1) continue;
                this.prettyWriter.addNameSpace(((Resource)rDFNode).getURI().substring(0, n));
            }
        }
        finally {
            nodeIterator.close();
        }
    }

    private String getNameSpace(Resource resource) {
        if (resource.isAnon()) {
            logger.error("Internal error - Unparser.getNameSpace; giving up");
            throw new BrokenException("Internal error: getNameSpace(bNode)");
        }
        String string = resource.getURI();
        int n = Util.splitNamespace(string);
        return string.substring(0, n);
    }

    private boolean isGenuineAnon(Resource resource) {
        if (!resource.isAnon()) {
            return false;
        }
        Integer n = (Integer)this.objectTable.get(resource);
        return n == null || !this.prettyWriter.sResourcePropertyElt && n <= 1 && !this.haveReified.contains(resource);
    }

    private boolean isLocalReference(Resource resource) {
        return !resource.isAnon() && this.getNameSpace(resource).equals(this.localName + "#") && XMLChar.isValidNCName(this.getLocalName(resource));
    }

    private String getLocalName(Resource resource) {
        if (resource.isAnon()) {
            logger.error("Internal error - giving up - Unparser.getLocalName");
            throw new BrokenException("Internal error: getLocalName(bNode)");
        }
        String string = resource.getURI();
        int n = Util.splitNamespace(string);
        return string.substring(n);
    }

    private void increaseObjectCount(Resource resource) {
        if (!resource.isAnon()) {
            return;
        }
        Integer n = (Integer)this.objectTable.get(resource);
        n = n == null ? one : new Integer(n + 1);
        this.objectTable.put(resource, n);
    }

    private boolean wantReification(Statement statement) {
        return this.wantReification(statement, (Resource)this.statement2res.get(statement));
    }

    private boolean wantReification(Resource resource) {
        return this.wantReification((Statement)this.res2statement.get(resource), resource);
    }

    private boolean wantReification(Statement statement, Resource resource) {
        if (statement == null || resource == null || resource.isAnon() || this.prettyWriter.sReification) {
            return false;
        }
        if (!this.isLocalReference(resource)) {
            return false;
        }
        Statement[] statementArray = this.reification(statement);
        for (int i = 0; i < statementArray.length; ++i) {
            if (!this.doneSet.contains(statementArray[i]) && this.model.contains(statementArray[i])) continue;
            return false;
        }
        return true;
    }

    private Statement[] reification(Statement statement) {
        Model model = statement.getModel();
        Resource resource = (Resource)this.statement2res.get(statement);
        return new Statement[]{model.createStatement(resource, RDF.type, RDF.Statement), model.createStatement(resource, RDF.subject, statement.getSubject()), model.createStatement(resource, RDF.predicate, statement.getPredicate()), model.createStatement(resource, RDF.object, statement.getObject())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProperties(Resource resource) {
        ExtendedIterator extendedIterator = this.listProperties(resource);
        if (this.avoidExplicitReification && !resource.isAnon() && this.isLocalReference(resource) && this.res2statement.containsKey(resource)) {
            extendedIterator = new MapFilterIterator(new MapFilter(){

                public Object accept(Object object) {
                    Statement statement = (Statement)object;
                    Property property = statement.getPredicate();
                    String string = property.getLocalName();
                    return !property.getNameSpace().equals(rdfns) || (!RDF.type.equals(property) || !statement.getObject().equals(RDF.Statement)) && !RDF.object.equals(property) && !RDF.predicate.equals(property) && !RDF.subject.equals(property) ? object : null;
                }
            }, extendedIterator);
        }
        try {
            boolean bl = extendedIterator.hasNext();
            return bl;
        }
        finally {
            extendedIterator.close();
        }
    }

    private ExtendedIterator listProperties(Resource resource) {
        return new MapFilterIterator(new MapFilter(){

            public Object accept(Object object) {
                return Unparser.this.doneSet.contains(object) ? null : object;
            }
        }, resource.listProperties());
    }

    private boolean canBeAttribute(Statement statement, Set set) {
        Property property = statement.getPredicate();
        if (this.prettyWriter.sPropertyAttr || set.contains(property)) {
            return false;
        }
        set.add(property);
        if (property.equals(RDF.type)) {
            RDFNode rDFNode = statement.getObject();
            return rDFNode instanceof Resource && !((Resource)rDFNode).isAnon();
        }
        if (statement.getObject() instanceof Literal) {
            Literal literal = statement.getLiteral();
            if (literal.getDatatypeURI() != null) {
                return false;
            }
            if (literal.getLanguage().equals("")) {
                if (this.prettyWriter.isDefaultNamespace(this.getNameSpace(property))) {
                    return false;
                }
                String string = literal.getString();
                if (string.length() < 40) {
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        if (cArray[i] > ' ') continue;
                        return false;
                    }
                    return !this.wantReification(statement);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allPropsAreAttr(Resource resource) {
        ExtendedIterator extendedIterator = this.listProperties(resource);
        HashSet hashSet = new HashSet();
        try {
            while (extendedIterator.hasNext()) {
                Statement statement = (Statement)extendedIterator.next();
                if (this.canBeAttribute(statement, hashSet)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            extendedIterator.close();
        }
        return true;
    }

    private void done(Statement statement) {
        this.doneSet.add(statement);
    }

    private Statement[][] getDamlList(RDFNode rDFNode) {
        return this.prettyWriter.sDamlCollection ? (Statement[][])null : this.getList(rDFNode, DAML_OIL.List, DAML_OIL.first, DAML_OIL.rest, DAML_OIL.nil);
    }

    private Statement[][] getRDFList(RDFNode rDFNode) {
        return this.prettyWriter.sParseTypeCollectionPropertyElt ? (Statement[][])null : this.getList(rDFNode, null, RDF.first, RDF.rest, RDF.nil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Statement[][] getList(RDFNode rDFNode, Resource resource, Property property, Property property2, Resource resource2) {
        Object[] objectArray;
        boolean bl = false;
        Vector<Object[]> vector = new Vector<Object[]>();
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        RDFNode rDFNode2 = rDFNode;
        while (!rDFNode2.equals(resource2)) {
            Statement[][] statementArray;
            Object object;
            Object object2;
            objectArray = new Statement[resource == null ? 2 : 3];
            if (rDFNode2 instanceof Literal) {
                object2 = null;
                return object2;
            }
            object2 = (Resource)rDFNode2;
            if (!this.isGenuineAnon((Resource)object2)) {
                object = null;
                return object;
            }
            if (hashSet.contains(rDFNode2)) {
                object = null;
                return object;
            }
            hashSet.add(rDFNode2);
            object = object2.listProperties();
            try {
                while (object.hasNext()) {
                    int n;
                    Statement statement = object.nextStatement();
                    statementArray = statement.getPredicate();
                    RDFNode rDFNode3 = statement.getObject();
                    if (this.doneSet.contains(statement)) {
                        Statement[][] statementArray2 = null;
                        return statementArray2;
                    }
                    if (!(rDFNode3 instanceof Resource)) {
                        Statement[][] statementArray3 = null;
                        return statementArray3;
                    }
                    if (statementArray.equals(RDF.type)) {
                        n = 2;
                        if (!rDFNode3.equals(resource)) {
                            Statement[][] statementArray4 = null;
                            return statementArray4;
                        }
                    } else if (statementArray.equals(property)) {
                        n = 0;
                        bl = true;
                    } else if (statementArray.equals(property2)) {
                        n = 1;
                        rDFNode2 = rDFNode3;
                    } else {
                        Statement[][] statementArray5 = null;
                        return statementArray5;
                    }
                    if (objectArray[n] != null) {
                        Statement[][] statementArray6 = null;
                        return statementArray6;
                    }
                    objectArray[n] = statement;
                }
            }
            finally {
                object.close();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                statementArray = null;
                return statementArray;
            }
            vector.add(objectArray);
        }
        if (vector.size() == 0) {
            objectArray = null;
            return objectArray;
        }
        bl = false;
        objectArray = new Statement[vector.size()][];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Statement getType(Resource resource) {
        Statement statement;
        try {
            if (resource instanceof Statement) {
                statement = ((Statement)((Object)resource)).getStatementProperty(RDF.type);
                if (statement == null || !statement.getObject().equals(RDF.Statement)) {
                    this.error("Statement type problem");
                }
            } else {
                statement = resource.getRequiredProperty(RDF.type);
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            if (resource instanceof Statement) {
                this.error("Statement type problem");
            }
            statement = null;
        }
        if (statement == null || this.isOKType(statement.getObject()) == -1) {
            return null;
        }
        return statement;
    }

    private int isOKType(RDFNode rDFNode) {
        if (!(rDFNode instanceof Resource)) {
            return -1;
        }
        if (((Resource)rDFNode).isAnon()) {
            return -1;
        }
        String string = ((Resource)rDFNode).getURI();
        int n = Util.splitNamespace(string);
        if (n == 0 || n == string.length()) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findInfiniteCycles() {
        StmtIterator stmtIterator = this.model.listStatements();
        Relation relation = new Relation();
        try {
            while (stmtIterator.hasNext()) {
                RDFNode rDFNode;
                Statement statement = stmtIterator.nextStatement();
                if (this.doneSet.contains(statement) || !((rDFNode = statement.getObject()) instanceof Resource)) continue;
                relation.set(statement.getSubject(), rDFNode);
            }
        }
        finally {
            stmtIterator.close();
        }
        relation.transitiveClosure();
        this.infinite = relation.getDiagonal();
    }

    private Iterator allInfiniteLeft() {
        return new LateBindingIterator(){

            public Iterator create() {
                return Unparser.this.infinite.iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator pleasingTypeIterator() {
        if (this.pleasingTypes == null) {
            return new NullIterator();
        }
        HashMap<Resource, Set> hashMap = new HashMap<Resource, Set>();
        Set[] setArray = new Set[this.pleasingTypes.length];
        for (int i = 0; i < this.pleasingTypes.length; ++i) {
            setArray[i] = new HashSet();
            hashMap.put(this.pleasingTypes[i], setArray[i]);
        }
        ResIterator resIterator = this.model.listSubjects();
        try {
            while (resIterator.hasNext()) {
                Integer n;
                Set set;
                Resource resource = resIterator.nextResource();
                Statement statement = this.getType(resource);
                if (statement == null || (set = (Set)hashMap.get(statement.getObject())) == null || this.isGenuineAnon(resource) && (n = (Integer)this.objectTable.get(resource)) != null && n == 1) continue;
                set.add(resource);
            }
        }
        finally {
            resIterator.close();
        }
        return new IteratorIterator(new Map1Iterator(new Map1(){

            public Object map1(Object object) {
                return ((Set)object).iterator();
            }
        }, new ArrayIterator(setArray)));
    }

    private Iterator listSubjects() {
        SingletonIterator singletonIterator = new SingletonIterator(this.model.createResource(this.localName));
        Iterator iterator = this.pleasingTypeIterator();
        NullIterator nullIterator = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.pleasingTypeSet = new HashSet();
                return false;
            }
        };
        FilterIterator filterIterator = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                return !Unparser.this.objectTable.containsKey(object) && !Unparser.this.wantReification((Resource)object);
            }
        }, this.modelListSubjects());
        NullIterator nullIterator2 = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.findInfiniteCycles();
                return false;
            }
        };
        FilterIterator filterIterator2 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Resource resource = (Resource)object;
                Unparser.this.codeCoverage[4] = Unparser.this.codeCoverage[4] + 1;
                if (resource.isAnon()) {
                    return false;
                }
                Integer n = (Integer)Unparser.this.objectTable.get(resource);
                return n != null && n > 1;
            }
        }, this.allInfiniteLeft());
        FilterIterator filterIterator3 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Unparser.this.codeCoverage[5] = Unparser.this.codeCoverage[5] + 1;
                Resource resource = (Resource)object;
                return !Unparser.this.isGenuineAnon(resource);
            }
        }, this.allInfiniteLeft());
        Iterator iterator2 = this.allInfiniteLeft();
        NullIterator nullIterator3 = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.avoidExplicitReification = false;
                return false;
            }
        };
        FilterIterator filterIterator4 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Unparser.this.codeCoverage[6] = Unparser.this.codeCoverage[6] + 1;
                return Unparser.this.res2statement.containsKey(object);
            }
        }, this.allInfiniteLeft());
        Iterator iterator3 = this.modelListSubjects();
        Iterator[] iteratorArray = new Iterator[]{singletonIterator, iterator, nullIterator, filterIterator, nullIterator2, filterIterator2, filterIterator3, iterator2, nullIterator3, filterIterator4, new NullIterator(){

            public boolean hasNext() {
                if (Unparser.this.modelListSubjects().hasNext()) {
                    Unparser.this.codeCoverage[7] = Unparser.this.codeCoverage[7] + 1;
                }
                return false;
            }
        }, iterator3};
        IteratorIterator iteratorIterator = new IteratorIterator(new ArrayIterator(iteratorArray));
        return new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                return Unparser.this.hasProperties((Resource)object);
            }
        }, iteratorIterator);
    }

    private synchronized void close(ResIterator resIterator) {
        resIterator.close();
        this.openResIterators.remove(resIterator);
    }

    private synchronized void closeAllResIterators() {
        Iterator iterator = this.openResIterators.iterator();
        while (iterator.hasNext()) {
            ((ResIterator)iterator.next()).close();
        }
        this.openResIterators = new HashSet();
    }

    private Iterator modelListSubjects() {
        ResIterator resIterator = this.model.listSubjects();
        this.openResIterators.add(resIterator);
        return resIterator;
    }

    private abstract class WType {
        private WType() {
        }

        abstract void wTypeStart(Resource var1);

        abstract void wTypeEnd(Resource var1);
    }
}

