/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.xmloutput.test.PrettyWriterTest;
import com.hp.hpl.jena.xmloutput.test.TestMacEncodings;
import com.hp.hpl.jena.xmloutput.test.testWriterAndReader;
import com.hp.hpl.jena.xmloutput.test.testWriterInterface;
import java.io.StringWriter;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPackage
extends TestCase {
    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        String[] stringArray = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE"};
        testSuite.addTest(TestMacEncodings.suite());
        testSuite.addTest(new PrettyWriterTest("testAnonDamlClass"));
        testSuite.addTest(new PrettyWriterTest("testLi"));
        testSuite.addTest(new PrettyWriterTest("test803804"));
        testSuite.addTest(new PrettyWriterTest("testRDFCollection"));
        testSuite.addTest(new PrettyWriterTest("testOWLPrefix"));
        testSuite.addTest(new testWriterInterface("testInterface", null));
        testSuite.addTest(new testWriterInterface("testNoWriter", null));
        testSuite.addTest(new testWriterInterface("testAnotherWriter", null));
        for (int i = 0; i < stringArray.length; ++i) {
            testSuite.addTest(testWriterAndReader.suite(stringArray[i]));
        }
        testSuite.addTest(new TestSuite(TestURIExceptions.class));
        return testSuite;
    }

    public static class TestURIExceptions
    extends TestCase {
        public TestURIExceptions(String string) {
            super(string);
        }

        public void testBadURIExceptionContainsBadURIInMessage() {
            String string = "http:";
            Model model = ModelFactory.createDefaultModel();
            model.add(model.createResource(string), model.createProperty("eg:B C"), model.createResource("eg:C D"));
            try {
                model.write(new StringWriter());
                TestURIExceptions.fail("should detect bad URI " + string);
            }
            catch (BadURIException badURIException) {
                TestURIExceptions.assertTrue("message must contain failing URI", badURIException.getMessage().indexOf(string) > 0);
            }
        }
    }
}

