/*
 * Decompiled with CFR 0.152.
 */
package jena;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.hp.hpl.jena.n3.N3ErrorPrinter;
import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Exception;
import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Iterator;
import jena.cmdline.ArgDecl;
import jena.cmdline.CommandLine;

public class n3 {
    static boolean firstOutput = true;
    static boolean doNodeTest = true;
    static boolean doErrorTests = false;
    static int testCount = 0;
    static boolean doRDF = false;
    static boolean printRDF = false;
    static String outputLang = "N-TRIPLE";
    static boolean printN3 = true;
    static boolean debug = false;
    static boolean verbose = false;

    public static void main(String[] stringArray) {
        String string = System.getProperty("user.dir");
        String string2 = n3.class.getName() + " [-rdf] [-base URI] [filename]";
        CommandLine commandLine = new CommandLine();
        commandLine.setUsage(string2);
        commandLine.setOutput(System.err);
        ArgDecl argDecl = new ArgDecl(false, "-v", "--verbose");
        ArgDecl argDecl2 = new ArgDecl(false, "-h", "--help");
        ArgDecl argDecl3 = new ArgDecl(false, "-rdf", "--rdf");
        ArgDecl argDecl4 = new ArgDecl(false, "--rdf-n3");
        ArgDecl argDecl5 = new ArgDecl(false, "--rdf-xml");
        ArgDecl argDecl6 = new ArgDecl(false, "--rdf-nt");
        ArgDecl argDecl7 = new ArgDecl(true, "--format", "--fmt");
        ArgDecl argDecl8 = new ArgDecl(false, "-debug");
        ArgDecl argDecl9 = new ArgDecl(true, "-base");
        ArgDecl argDecl10 = new ArgDecl(false, "-n", "--check");
        commandLine.add(argDecl);
        commandLine.add(argDecl2);
        commandLine.add(argDecl3);
        commandLine.add(argDecl4);
        commandLine.add(argDecl5);
        commandLine.add(argDecl6);
        commandLine.add(argDecl7);
        commandLine.add(argDecl8);
        commandLine.add(argDecl9);
        commandLine.add(argDecl10);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.exit(1);
        }
        verbose = commandLine.contains(argDecl);
        if (commandLine.contains(argDecl2)) {
            System.out.println(string2);
            System.out.println("Default action: parse an N3 file");
            System.out.println("    --rdf           Read into an RDF and print");
            System.out.println("    --rdf-n3        Read into an RDF and print in N3");
            System.out.println("    --rdf-xml       Read into an RDF and print in XML");
            System.out.println("    --rdf-nt        Read into an RDF and print in N-Triples");
            System.out.println("    --format FMT    Read into an RDF and print in given format");
            System.out.println("    --check | -n    Just check: no output");
            System.out.println("    --base URI      Set the base URI");
            System.exit(0);
        }
        String string3 = null;
        if (commandLine.contains(argDecl3)) {
            doRDF = true;
            printRDF = true;
            printN3 = false;
        }
        if (commandLine.contains(argDecl4)) {
            doRDF = true;
            printRDF = true;
            outputLang = "N3";
            printN3 = false;
        }
        if (commandLine.contains(argDecl5)) {
            doRDF = true;
            printRDF = true;
            outputLang = "RDF/XML-ABBREV";
            printN3 = false;
        }
        if (commandLine.contains(argDecl6)) {
            doRDF = true;
            printRDF = true;
            outputLang = "N-TRIPLE";
            printN3 = false;
        }
        if (commandLine.contains(argDecl7)) {
            doRDF = true;
            printRDF = true;
            outputLang = commandLine.getArg(argDecl7).getValue();
            printN3 = false;
        }
        if (commandLine.contains(argDecl8)) {
            debug = true;
            N3JenaWriter.DEBUG = true;
        }
        if (commandLine.contains(argDecl10)) {
            printRDF = false;
            printN3 = false;
        }
        if (commandLine.contains(argDecl)) {
            verbose = true;
            printN3 = true;
        }
        if (commandLine.contains(argDecl9)) {
            string3 = commandLine.getArg(argDecl9).getValue();
        }
        if (commandLine.items().size() == 0) {
            if (string3 == null) {
                string3 = "stdin:/";
            }
            n3.doOneFile(System.in, System.out, string3, string3);
            System.exit(0);
        }
        Iterator iterator = commandLine.items().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File not found: " + string4);
                System.exit(2);
            }
            if (string3 == null) {
                File file = new File(string4);
                string3 = "file:///" + file.getAbsolutePath();
                string3 = string3.replace('\\', '/');
            }
            n3.doOneFile(fileInputStream, System.out, string3, string4);
        }
    }

    static void doOneFile(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        BufferedReader bufferedReader = FileUtils.asBufferedUTF8(inputStream);
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8(outputStream);
        if (doRDF) {
            n3.rdfOneFile(bufferedReader, printWriter, string, string2);
        } else {
            n3.parseOneFile(bufferedReader, printWriter, string, string2);
        }
    }

    static void rdfOneFile(Reader reader, PrintWriter printWriter, String string, String string2) {
        try {
            Model model = ModelFactory.createDefaultModel();
            model.read(reader, string, "N3");
            if (printRDF) {
                if (outputLang.equals("N3")) {
                    printWriter.print("# Jena N3->RDF->" + outputLang + " : " + string2);
                    printWriter.println();
                    printWriter.println();
                }
                model.write(printWriter, outputLang, string);
                printWriter.flush();
            }
        }
        catch (JenaException jenaException) {
            Throwable throwable = jenaException.getCause();
            N3Exception n3Exception = (N3Exception)(jenaException instanceof N3Exception ? jenaException : (throwable instanceof N3Exception ? throwable : null));
            if (n3Exception != null) {
                System.err.println(n3Exception.getMessage());
            } else {
                Throwable throwable2 = throwable == null ? jenaException : throwable;
                System.err.println(throwable2.getMessage());
                throwable2.printStackTrace(System.err);
            }
            System.exit(7);
        }
    }

    private static void parseOneFile(Reader reader, PrintWriter printWriter, String string, String string2) {
        Object object;
        N3ParserEventHandler n3ParserEventHandler = null;
        n3ParserEventHandler = null;
        if (printN3 || debug) {
            object = new N3EventPrinter(printWriter);
            if (verbose) {
                ((N3EventPrinter)object).printStartFinish = true;
            }
            n3ParserEventHandler = object;
        } else {
            n3ParserEventHandler = new N3ErrorPrinter(printWriter);
        }
        try {
            object = new N3Parser(reader, n3ParserEventHandler);
            ((N3Parser)object).parse();
        }
        catch (RecognitionException recognitionException) {
            System.exit(9);
        }
        catch (TokenStreamException tokenStreamException) {
            System.exit(9);
        }
    }
}

