/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet = new byte[255];
    private static final char[] lookUpBase64Alphabet = new char[64];

    protected static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    protected static boolean isPad(char c) {
        return c == '=';
    }

    protected static boolean isData(char c) {
        return base64Alphabet[c] != -1;
    }

    protected static boolean isBase64(char c) {
        return Base64.isWhiteSpace(c) || Base64.isPad(c) || Base64.isData(c);
    }

    public static String encode(byte[] byArray) {
        byte by;
        byte by2;
        int n;
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length * 8;
        if (n2 == 0) {
            return "";
        }
        int n4 = n2 % 24;
        int n5 = n2 / 24;
        int n6 = n4 != 0 ? n5 + 1 : n5;
        int n7 = (n6 - 1) / 19 + 1;
        char[] cArray = null;
        cArray = new char[n6 * 4 + n7];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n7 - 1) {
            n = 0;
            while (n < 19) {
                by5 = byArray[n9++];
                by6 = byArray[n9++];
                by7 = byArray[n9++];
                by4 = (byte)(by6 & 0xF);
                by3 = (byte)(by5 & 3);
                by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
                by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
                byte by8 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
                cArray[n8++] = lookUpBase64Alphabet[by2];
                cArray[n8++] = lookUpBase64Alphabet[by | by3 << 4];
                cArray[n8++] = lookUpBase64Alphabet[by4 << 2 | by8];
                cArray[n8++] = lookUpBase64Alphabet[by7 & 0x3F];
                ++n10;
                ++n;
            }
            cArray[n8++] = 10;
            ++n11;
        }
        while (n10 < n5) {
            by5 = byArray[n9++];
            by6 = byArray[n9++];
            by7 = byArray[n9++];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            by = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            cArray[n8++] = lookUpBase64Alphabet[n];
            cArray[n8++] = lookUpBase64Alphabet[by2 | by3 << 4];
            cArray[n8++] = lookUpBase64Alphabet[by4 << 2 | by];
            cArray[n8++] = lookUpBase64Alphabet[by7 & 0x3F];
            ++n10;
        }
        if (n4 == 8) {
            by5 = byArray[n9];
            by3 = (byte)(by5 & 3);
            n = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            cArray[n8++] = lookUpBase64Alphabet[n];
            cArray[n8++] = lookUpBase64Alphabet[by3 << 4];
            cArray[n8++] = 61;
            cArray[n8++] = 61;
        } else if (n4 == 16) {
            by5 = byArray[n9];
            by6 = byArray[n9 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            cArray[n8++] = lookUpBase64Alphabet[n];
            cArray[n8++] = lookUpBase64Alphabet[by2 | by3 << 4];
            cArray[n8++] = lookUpBase64Alphabet[by4 << 2];
            cArray[n8++] = 61;
        }
        cArray[n8] = 10;
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = Base64.removeWhiteSpace(cArray);
        if (n % 4 != 0) {
            return null;
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byArray = new byte[n2 * 3];
        while (n4 < n2 - 1) {
            if (!(Base64.isData(c = cArray[n6++]) && Base64.isData(c2 = cArray[n6++]) && Base64.isData(c3 = cArray[n6++]) && Base64.isData(c4 = cArray[n6++]))) {
                return null;
            }
            by = base64Alphabet[c];
            by2 = base64Alphabet[c2];
            by3 = base64Alphabet[c3];
            by4 = base64Alphabet[c4];
            byArray[n5++] = (byte)(by << 2 | by2 >> 4);
            byArray[n5++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray[n5++] = (byte)(by3 << 6 | by4);
            ++n4;
        }
        if (!Base64.isData(c = cArray[n6++]) || !Base64.isData(c2 = cArray[n6++])) {
            return null;
        }
        by = base64Alphabet[c];
        by2 = base64Alphabet[c2];
        c3 = cArray[n6++];
        c4 = cArray[n6++];
        if (!Base64.isData(c3) || !Base64.isData(c4)) {
            if (Base64.isPad(c3) && Base64.isPad(c4)) {
                if ((by2 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray2 = new byte[n4 * 3 + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n4 * 3);
                byArray2[n5] = (byte)(by << 2 | by2 >> 4);
                return byArray2;
            }
            if (!Base64.isPad(c3) && Base64.isPad(c4)) {
                by3 = base64Alphabet[c3];
                if ((by3 & 3) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n4 * 3 + 2];
                System.arraycopy(byArray, 0, byArray3, 0, n4 * 3);
                byArray3[n5++] = (byte)(by << 2 | by2 >> 4);
                byArray3[n5] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
                return byArray3;
            }
            return null;
        }
        by3 = base64Alphabet[c3];
        by4 = base64Alphabet[c4];
        byArray[n5++] = (byte)(by << 2 | by2 >> 4);
        byArray[n5++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
        byArray[n5++] = (byte)(by3 << 6 | by4);
        return byArray;
    }

    protected static int removeWhiteSpace(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = cArray.length;
        int n4 = 0;
        while (n4 < n2) {
            if (!Base64.isWhiteSpace(cArray[n4])) {
                cArray[n++] = cArray[n4];
            }
            ++n4;
        }
        return n;
    }

    static {
        int n = 0;
        while (n < 255) {
            Base64.base64Alphabet[n] = -1;
            ++n;
        }
        int n2 = 90;
        while (n2 >= 65) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
            --n2;
        }
        int n4 = 122;
        while (n4 >= 97) {
            Base64.base64Alphabet[n4] = (byte)(n4 - 97 + 26);
            --n4;
        }
        int n5 = 57;
        while (n5 >= 48) {
            Base64.base64Alphabet[n5] = (byte)(n5 - 48 + 52);
            --n5;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int n6 = 0;
        while (n6 <= 25) {
            Base64.lookUpBase64Alphabet[n6] = (char)(65 + n6);
            ++n6;
        }
        int n7 = 26;
        int n8 = 0;
        while (n7 <= 51) {
            Base64.lookUpBase64Alphabet[n7] = (char)(97 + n8);
            ++n7;
            ++n8;
        }
        int n9 = 52;
        int n10 = 0;
        while (n9 <= 61) {
            Base64.lookUpBase64Alphabet[n9] = (char)(48 + n10);
            ++n9;
            ++n10;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

