/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDV
extends AbstractDateTimeDV {
    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new AbstractDateTimeDV.DateTimeData(this.parse(string), this);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "gMonth"});
        }
    }

    protected int[] parse(String string) throws SchemaDateTimeException {
        int n = string.length();
        int[] nArray = new int[8];
        int[] nArray2 = new int[2];
        nArray[0] = 2000;
        nArray[2] = 15;
        if (string.charAt(0) != '-' || string.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonth: " + string);
        }
        int n2 = 4;
        nArray[1] = this.parseInt(string, 2, n2);
        if (string.length() >= n2 + 2 && string.charAt(n2) == '-' && string.charAt(n2 + 1) == '-') {
            n2 += 2;
        }
        if (n2 < n) {
            int n4 = this.findUTCSign(string, n2, n);
            if (n4 < 0) {
                throw new SchemaDateTimeException("Error in month parsing: " + string);
            }
            this.getTimeZone(string, nArray, n4, n, nArray2);
        }
        this.validateDateTime(nArray, nArray2);
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray, nArray2);
        }
        return nArray;
    }

    protected short compareDates(int[] nArray, int[] nArray2) {
        if (nArray[7] == nArray2[7]) {
            return nArray[1] >= nArray2[1] ? (nArray[1] > nArray2[1] ? (short)1 : 0) : (short)-1;
        }
        if (nArray[7] == 90 || nArray2[7] == 90) {
            if (nArray[1] == nArray2[1]) {
                return 2;
            }
            if (nArray[1] + 1 == nArray2[1] || nArray[1] - 1 == nArray2[1]) {
                return 2;
            }
        }
        if (nArray[1] < nArray2[1]) {
            return -1;
        }
        return 1;
    }

    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append('-');
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[1], 2);
        this.append(stringBuffer, (char)nArray[7], 0);
        return stringBuffer.toString();
    }
}

