/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.io.Serializable;
import org.apache.xerces.impl.xpath.regex.Token;

final class RangeToken
extends Token
implements Serializable {
    int[] ranges;
    boolean sorted;
    boolean compacted;
    RangeToken icaseCache = null;
    int[] map = null;
    int nonMapIndex;
    private static final int MAPSIZE = 256;

    RangeToken(int n) {
        super(n);
        this.setSorted(false);
    }

    protected void addRange(int n, int n2) {
        int n4;
        int n5;
        this.icaseCache = null;
        if (n <= n2) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = n2;
            n4 = n;
        }
        int n6 = 0;
        if (this.ranges == null) {
            this.ranges = new int[2];
            this.ranges[0] = n5;
            this.ranges[1] = n4;
            this.setSorted(true);
        } else {
            n6 = this.ranges.length;
            if (this.ranges[n6 - 1] + 1 == n5) {
                this.ranges[n6 - 1] = n4;
                return;
            }
            int[] nArray = new int[n6 + 2];
            System.arraycopy(this.ranges, 0, nArray, 0, n6);
            this.ranges = nArray;
            if (this.ranges[n6 - 1] >= n5) {
                this.setSorted(false);
            }
            this.ranges[n6++] = n5;
            this.ranges[n6] = n4;
            if (!this.sorted) {
                this.sortRanges();
            }
        }
    }

    private final boolean isSorted() {
        return this.sorted;
    }

    private final void setSorted(boolean bl) {
        this.sorted = bl;
        if (!bl) {
            this.compacted = false;
        }
    }

    private final boolean isCompacted() {
        return this.compacted;
    }

    private final void setCompacted() {
        this.compacted = true;
    }

    protected void sortRanges() {
        if (this.isSorted()) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        int n = this.ranges.length - 4;
        while (n >= 0) {
            int n2 = 0;
            while (n2 <= n) {
                if (this.ranges[n2] > this.ranges[n2 + 2] || this.ranges[n2] == this.ranges[n2 + 2] && this.ranges[n2 + 1] > this.ranges[n2 + 3]) {
                    int n4 = this.ranges[n2 + 2];
                    this.ranges[n2 + 2] = this.ranges[n2];
                    this.ranges[n2] = n4;
                    n4 = this.ranges[n2 + 3];
                    this.ranges[n2 + 3] = this.ranges[n2 + 1];
                    this.ranges[n2 + 1] = n4;
                }
                n2 += 2;
            }
            n -= 2;
        }
        this.setSorted(true);
    }

    protected void compactRanges() {
        boolean bl = false;
        if (this.ranges == null || this.ranges.length <= 2) {
            return;
        }
        if (this.isCompacted()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.ranges.length) {
            if (n != n2) {
                this.ranges[n] = this.ranges[n2++];
                this.ranges[n + 1] = this.ranges[n2++];
            } else {
                n2 += 2;
            }
            int n4 = this.ranges[n + 1];
            while (n2 < this.ranges.length) {
                if (n4 + 1 < this.ranges[n2]) break;
                if (n4 + 1 == this.ranges[n2]) {
                    if (bl) {
                        System.err.println("Token#compactRanges(): Compaction: [" + this.ranges[n] + ", " + this.ranges[n + 1] + "], [" + this.ranges[n2] + ", " + this.ranges[n2 + 1] + "] -> [" + this.ranges[n] + ", " + this.ranges[n2 + 1] + "]");
                    }
                    this.ranges[n + 1] = this.ranges[n2 + 1];
                    n4 = this.ranges[n + 1];
                    n2 += 2;
                    continue;
                }
                if (n4 >= this.ranges[n2 + 1]) {
                    if (bl) {
                        System.err.println("Token#compactRanges(): Compaction: [" + this.ranges[n] + ", " + this.ranges[n + 1] + "], [" + this.ranges[n2] + ", " + this.ranges[n2 + 1] + "] -> [" + this.ranges[n] + ", " + this.ranges[n + 1] + "]");
                    }
                    n2 += 2;
                    continue;
                }
                if (n4 < this.ranges[n2 + 1]) {
                    if (bl) {
                        System.err.println("Token#compactRanges(): Compaction: [" + this.ranges[n] + ", " + this.ranges[n + 1] + "], [" + this.ranges[n2] + ", " + this.ranges[n2 + 1] + "] -> [" + this.ranges[n] + ", " + this.ranges[n2 + 1] + "]");
                    }
                    this.ranges[n + 1] = this.ranges[n2 + 1];
                    n4 = this.ranges[n + 1];
                    n2 += 2;
                    continue;
                }
                throw new RuntimeException("Token#compactRanges(): Internel Error: [" + this.ranges[n] + "," + this.ranges[n + 1] + "] [" + this.ranges[n2] + "," + this.ranges[n2 + 1] + "]");
            }
            n += 2;
        }
        if (n != this.ranges.length) {
            int[] nArray = new int[n];
            System.arraycopy(this.ranges, 0, nArray, 0, n);
            this.ranges = nArray;
        }
        this.setCompacted();
    }

    protected void mergeRanges(Token token) {
        RangeToken rangeToken = (RangeToken)token;
        this.sortRanges();
        rangeToken.sortRanges();
        if (rangeToken.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.setSorted(true);
        if (this.ranges == null) {
            this.ranges = new int[rangeToken.ranges.length];
            System.arraycopy(rangeToken.ranges, 0, this.ranges, 0, rangeToken.ranges.length);
            return;
        }
        int[] nArray = new int[this.ranges.length + rangeToken.ranges.length];
        int n = 0;
        int n2 = 0;
        int n4 = 0;
        while (n < this.ranges.length || n2 < rangeToken.ranges.length) {
            if (n >= this.ranges.length) {
                nArray[n4++] = rangeToken.ranges[n2++];
                nArray[n4++] = rangeToken.ranges[n2++];
                continue;
            }
            if (n2 >= rangeToken.ranges.length) {
                nArray[n4++] = this.ranges[n++];
                nArray[n4++] = this.ranges[n++];
                continue;
            }
            if (rangeToken.ranges[n2] < this.ranges[n] || rangeToken.ranges[n2] == this.ranges[n] && rangeToken.ranges[n2 + 1] < this.ranges[n + 1]) {
                nArray[n4++] = rangeToken.ranges[n2++];
                nArray[n4++] = rangeToken.ranges[n2++];
                continue;
            }
            nArray[n4++] = this.ranges[n++];
            nArray[n4++] = this.ranges[n++];
        }
        this.ranges = nArray;
    }

    protected void subtractRanges(Token token) {
        if (token.type == 5) {
            this.intersectRanges(token);
            return;
        }
        RangeToken rangeToken = (RangeToken)token;
        if (rangeToken.ranges == null || this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        rangeToken.sortRanges();
        rangeToken.compactRanges();
        int[] nArray = new int[this.ranges.length + rangeToken.ranges.length];
        int n = 0;
        int n2 = 0;
        int n4 = 0;
        while (n2 < this.ranges.length && n4 < rangeToken.ranges.length) {
            int n5 = this.ranges[n2];
            int n6 = this.ranges[n2 + 1];
            int n7 = rangeToken.ranges[n4];
            int n8 = rangeToken.ranges[n4 + 1];
            if (n6 < n7) {
                nArray[n++] = this.ranges[n2++];
                nArray[n++] = this.ranges[n2++];
                continue;
            }
            if (n6 >= n7 && n5 <= n8) {
                if (n7 <= n5 && n6 <= n8) {
                    n2 += 2;
                    continue;
                }
                if (n7 <= n5) {
                    this.ranges[n2] = n8 + 1;
                    n4 += 2;
                    continue;
                }
                if (n6 <= n8) {
                    nArray[n++] = n5;
                    nArray[n++] = n7 - 1;
                    n2 += 2;
                    continue;
                }
                nArray[n++] = n5;
                nArray[n++] = n7 - 1;
                this.ranges[n2] = n8 + 1;
                n4 += 2;
                continue;
            }
            if (n8 < n5) {
                n4 += 2;
                continue;
            }
            throw new RuntimeException("Token#subtractRanges(): Internal Error: [" + this.ranges[n2] + "," + this.ranges[n2 + 1] + "] - [" + rangeToken.ranges[n4] + "," + rangeToken.ranges[n4 + 1] + "]");
        }
        while (n2 < this.ranges.length) {
            nArray[n++] = this.ranges[n2++];
            nArray[n++] = this.ranges[n2++];
        }
        this.ranges = new int[n];
        System.arraycopy(nArray, 0, this.ranges, 0, n);
    }

    protected void intersectRanges(Token token) {
        RangeToken rangeToken = (RangeToken)token;
        if (rangeToken.ranges == null || this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        rangeToken.sortRanges();
        rangeToken.compactRanges();
        int[] nArray = new int[this.ranges.length + rangeToken.ranges.length];
        int n = 0;
        int n2 = 0;
        int n4 = 0;
        while (n2 < this.ranges.length && n4 < rangeToken.ranges.length) {
            int n5 = this.ranges[n2];
            int n6 = this.ranges[n2 + 1];
            int n7 = rangeToken.ranges[n4];
            int n8 = rangeToken.ranges[n4 + 1];
            if (n6 < n7) {
                n2 += 2;
                continue;
            }
            if (n6 >= n7 && n5 <= n8) {
                if (n7 <= n7 && n6 <= n8) {
                    nArray[n++] = n5;
                    nArray[n++] = n6;
                    n2 += 2;
                    continue;
                }
                if (n7 <= n5) {
                    nArray[n++] = n5;
                    nArray[n++] = n8;
                    this.ranges[n2] = n8 + 1;
                    n4 += 2;
                    continue;
                }
                if (n6 <= n8) {
                    nArray[n++] = n7;
                    nArray[n++] = n6;
                    n2 += 2;
                    continue;
                }
                nArray[n++] = n7;
                nArray[n++] = n8;
                this.ranges[n2] = n8 + 1;
                continue;
            }
            if (n8 < n5) {
                n4 += 2;
                continue;
            }
            throw new RuntimeException("Token#intersectRanges(): Internal Error: [" + this.ranges[n2] + "," + this.ranges[n2 + 1] + "] & [" + rangeToken.ranges[n4] + "," + rangeToken.ranges[n4 + 1] + "]");
        }
        while (n2 < this.ranges.length) {
            nArray[n++] = this.ranges[n2++];
            nArray[n++] = this.ranges[n2++];
        }
        this.ranges = new int[n];
        System.arraycopy(nArray, 0, this.ranges, 0, n);
    }

    static Token complementRanges(Token token) {
        int n;
        if (token.type != 4 && token.type != 5) {
            throw new IllegalArgumentException("Token#complementRanges(): must be RANGE: " + token.type);
        }
        RangeToken rangeToken = (RangeToken)token;
        rangeToken.sortRanges();
        rangeToken.compactRanges();
        int n2 = rangeToken.ranges.length + 2;
        if (rangeToken.ranges[0] == 0) {
            n2 -= 2;
        }
        if ((n = rangeToken.ranges[rangeToken.ranges.length - 1]) == 0x10FFFF) {
            n2 -= 2;
        }
        RangeToken rangeToken2 = Token.createRange();
        rangeToken2.ranges = new int[n2];
        int n4 = 0;
        if (rangeToken.ranges[0] > 0) {
            rangeToken2.ranges[n4++] = 0;
            rangeToken2.ranges[n4++] = rangeToken.ranges[0] - 1;
        }
        int n5 = 1;
        while (n5 < rangeToken.ranges.length - 2) {
            rangeToken2.ranges[n4++] = rangeToken.ranges[n5] + 1;
            rangeToken2.ranges[n4++] = rangeToken.ranges[n5 + 1] - 1;
            n5 += 2;
        }
        if (n != 0x10FFFF) {
            rangeToken2.ranges[n4++] = n + 1;
            rangeToken2.ranges[n4] = 0x10FFFF;
        }
        rangeToken2.setCompacted();
        return rangeToken2;
    }

    synchronized RangeToken getCaseInsensitiveToken() {
        int n;
        if (this.icaseCache != null) {
            return this.icaseCache;
        }
        RangeToken rangeToken = this.type == 4 ? Token.createRange() : Token.createNRange();
        int n2 = 0;
        while (n2 < this.ranges.length) {
            int n4 = this.ranges[n2];
            while (n4 <= this.ranges[n2 + 1]) {
                if (n4 > 65535) {
                    rangeToken.addRange(n4, n4);
                } else {
                    n = Character.toUpperCase((char)n4);
                    rangeToken.addRange(n, n);
                }
                ++n4;
            }
            n2 += 2;
        }
        RangeToken rangeToken2 = this.type == 4 ? Token.createRange() : Token.createNRange();
        n = 0;
        while (n < rangeToken.ranges.length) {
            int n5 = rangeToken.ranges[n];
            while (n5 <= rangeToken.ranges[n + 1]) {
                if (n5 > 65535) {
                    rangeToken2.addRange(n5, n5);
                } else {
                    char c = Character.toUpperCase((char)n5);
                    rangeToken2.addRange(c, c);
                }
                ++n5;
            }
            n += 2;
        }
        rangeToken2.mergeRanges(rangeToken);
        rangeToken2.mergeRanges(this);
        rangeToken2.compactRanges();
        this.icaseCache = rangeToken2;
        return rangeToken2;
    }

    void dumpRanges() {
        System.err.print("RANGE: ");
        if (this.ranges == null) {
            System.err.println(" NULL");
        }
        int n = 0;
        while (n < this.ranges.length) {
            System.err.print("[" + this.ranges[n] + "," + this.ranges[n + 1] + "] ");
            n += 2;
        }
        System.err.println("");
    }

    boolean match(int n) {
        boolean bl;
        if (this.map == null) {
            this.createMap();
        }
        if (this.type == 4) {
            if (n < 256) {
                return (this.map[n / 32] & 1 << (n & 0x1F)) != 0;
            }
            bl = false;
            int n2 = this.nonMapIndex;
            while (n2 < this.ranges.length) {
                if (this.ranges[n2] <= n && n <= this.ranges[n2 + 1]) {
                    return true;
                }
                n2 += 2;
            }
        } else {
            if (n < 256) {
                return (this.map[n / 32] & 1 << (n & 0x1F)) == 0;
            }
            bl = true;
            int n4 = this.nonMapIndex;
            while (n4 < this.ranges.length) {
                if (this.ranges[n4] <= n && n <= this.ranges[n4 + 1]) {
                    return false;
                }
                n4 += 2;
            }
        }
        return bl;
    }

    private void createMap() {
        int n = 8;
        this.map = new int[n];
        this.nonMapIndex = this.ranges.length;
        int n2 = 0;
        while (n2 < n) {
            this.map[n2] = 0;
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.ranges.length) {
            int n5 = this.ranges[n4];
            int n6 = this.ranges[n4 + 1];
            if (n5 < 256) {
                int n7 = n5;
                while (n7 <= n6 && n7 < 256) {
                    int n8 = n7 / 32;
                    this.map[n8] = this.map[n8] | 1 << (n7 & 0x1F);
                    ++n7;
                }
            } else {
                this.nonMapIndex = n4;
                break;
            }
            if (n6 >= 256) {
                this.nonMapIndex = n4;
                break;
            }
            n4 += 2;
        }
    }

    public String toString(int n) {
        String string;
        if (this.type == 4) {
            if (this == Token.token_dot) {
                string = ".";
            } else if (this == Token.token_0to9) {
                string = "\\d";
            } else if (this == Token.token_wordchars) {
                string = "\\w";
            } else if (this == Token.token_spaces) {
                string = "\\s";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[");
                int n2 = 0;
                while (n2 < this.ranges.length) {
                    if ((n & 0x400) != 0 && n2 > 0) {
                        stringBuffer.append(",");
                    }
                    if (this.ranges[n2] == this.ranges[n2 + 1]) {
                        stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[n2]));
                    } else {
                        stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[n2]));
                        stringBuffer.append('-');
                        stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[n2 + 1]));
                    }
                    n2 += 2;
                }
                stringBuffer.append("]");
                string = stringBuffer.toString();
            }
        } else if (this == Token.token_not_0to9) {
            string = "\\D";
        } else if (this == Token.token_not_wordchars) {
            string = "\\W";
        } else if (this == Token.token_not_spaces) {
            string = "\\S";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[^");
            int n4 = 0;
            while (n4 < this.ranges.length) {
                if ((n & 0x400) != 0 && n4 > 0) {
                    stringBuffer.append(",");
                }
                if (this.ranges[n4] == this.ranges[n4 + 1]) {
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[n4]));
                } else {
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[n4]));
                    stringBuffer.append('-');
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[n4 + 1]));
                }
                n4 += 2;
            }
            stringBuffer.append("]");
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String escapeCharInCharClass(int n) {
        String string;
        switch (n) {
            case 44: 
            case 45: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                string = "\\" + (char)n;
                break;
            }
            case 12: {
                string = "\\f";
                break;
            }
            case 10: {
                string = "\\n";
                break;
            }
            case 13: {
                string = "\\r";
                break;
            }
            case 9: {
                string = "\\t";
                break;
            }
            case 27: {
                string = "\\e";
                break;
            }
            default: {
                if (n < 32) {
                    String string2 = "0" + Integer.toHexString(n);
                    string = "\\x" + string2.substring(string2.length() - 2, string2.length());
                    break;
                }
                if (n >= 65536) {
                    String string3 = "0" + Integer.toHexString(n);
                    string = "\\v" + string3.substring(string3.length() - 6, string3.length());
                    break;
                }
                string = "" + (char)n;
            }
        }
        return string;
    }
}

