/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.util.NSItemListImpl;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSNamedMap4Types;
import org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeGroupDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSNotationDeclaration;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 16;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, false, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private XSObjectListImpl fAnnotations = null;

    public XSModelImpl(SchemaGrammar[] schemaGrammarArray) {
        int n = schemaGrammarArray.length;
        this.fNamespaces = new String[Math.max(n + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(n + 1, 5)];
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            this.fNamespaces[n2] = schemaGrammarArray[n2].getTargetNamespace();
            this.fGrammarList[n2] = schemaGrammarArray[n2];
            if (this.fNamespaces[n2] == SchemaSymbols.URI_SCHEMAFORSCHEMA) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            this.fNamespaces[n] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[n++] = SchemaGrammar.SG_SchemaNS;
        }
        int n4 = 0;
        while (n4 < n) {
            SchemaGrammar schemaGrammar = this.fGrammarList[n4];
            Vector vector = schemaGrammar.getImportedGrammars();
            int n5 = vector == null ? -1 : vector.size() - 1;
            while (n5 >= 0) {
                SchemaGrammar schemaGrammar2 = (SchemaGrammar)vector.elementAt(n5);
                int n6 = 0;
                while (n6 < n) {
                    if (schemaGrammar2 == this.fGrammarList[n6]) break;
                    ++n6;
                }
                if (n6 == n) {
                    if (n == this.fGrammarList.length) {
                        String[] stringArray = new String[n * 2];
                        System.arraycopy(this.fNamespaces, 0, stringArray, 0, n);
                        this.fNamespaces = stringArray;
                        SchemaGrammar[] schemaGrammarArray2 = new SchemaGrammar[n * 2];
                        System.arraycopy(this.fGrammarList, 0, schemaGrammarArray2, 0, n);
                        this.fGrammarList = schemaGrammarArray2;
                    }
                    this.fNamespaces[n] = schemaGrammar2.getTargetNamespace();
                    this.fGrammarList[n] = schemaGrammar2;
                    ++n;
                }
                --n5;
            }
            ++n4;
        }
        this.fGrammarMap = new SymbolHash(n * 2);
        n4 = 0;
        while (n4 < n) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[n4]), this.fGrammarList[n4]);
            ++n4;
        }
        this.fGrammarCount = n;
        this.fGlobalComponents = new XSNamedMap[17];
        this.fNSComponents = new XSNamedMap[n][17];
    }

    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    public synchronized XSNamedMap getComponents(short s) {
        if (s <= 0 || s > 16 || !GLOBAL_COMP[s]) {
            return null;
        }
        SymbolHash[] symbolHashArray = new SymbolHash[this.fGrammarCount];
        if (this.fGlobalComponents[s] == null) {
            int n = 0;
            while (n < this.fGrammarCount) {
                switch (s) {
                    case 3: 
                    case 15: 
                    case 16: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalTypeDecls;
                        break;
                    }
                    case 1: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalAttrDecls;
                        break;
                    }
                    case 2: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalElemDecls;
                        break;
                    }
                    case 5: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalAttrGrpDecls;
                        break;
                    }
                    case 6: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalGroupDecls;
                        break;
                    }
                    case 11: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalNotationDecls;
                    }
                }
                ++n;
            }
            this.fGlobalComponents[s] = s == 15 || s == 16 ? new XSNamedMap4Types(this.fNamespaces, symbolHashArray, this.fGrammarCount, s) : new XSNamedMapImpl(this.fNamespaces, symbolHashArray, this.fGrammarCount);
        }
        return this.fGlobalComponents[s];
    }

    public synchronized XSNamedMap getComponentsByNamespace(short s, String string) {
        if (s <= 0 || s > 16 || !GLOBAL_COMP[s]) {
            return null;
        }
        int n = 0;
        while (n < this.fGrammarCount) {
            if (this.fNamespaces[n] == string) break;
            ++n;
        }
        if (n == this.fGrammarCount) {
            return null;
        }
        if (this.fNSComponents[n][s] == null) {
            SymbolHash symbolHash = null;
            switch (s) {
                case 3: 
                case 15: 
                case 16: {
                    symbolHash = this.fGrammarList[n].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    symbolHash = this.fGrammarList[n].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    symbolHash = this.fGrammarList[n].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    symbolHash = this.fGrammarList[n].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[n][s] = s == 15 || s == 16 ? new XSNamedMap4Types(string, symbolHash, s) : new XSNamedMapImpl(string, symbolHash);
        }
        return this.fNSComponents[n][s];
    }

    public XSTypeDefinition getTypeDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSTypeDefinition)schemaGrammar.fGlobalTypeDecls.get(string);
    }

    public XSAttributeDeclaration getAttributeDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeDeclaration)schemaGrammar.fGlobalAttrDecls.get(string);
    }

    public XSElementDeclaration getElementDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSElementDeclaration)schemaGrammar.fGlobalElemDecls.get(string);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)schemaGrammar.fGlobalAttrGrpDecls.get(string);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSModelGroupDefinition)schemaGrammar.fGlobalGroupDecls.get(string);
    }

    public XSNotationDeclaration getNotationDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSNotationDeclaration)schemaGrammar.fGlobalNotationDecls.get(string);
    }

    public synchronized XSObjectList getAnnotations() {
        if (this.fAnnotations != null) {
            return this.fAnnotations;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.fGrammarCount) {
            n += this.fGrammarList[n2].fNumAnnotations;
            ++n2;
        }
        XSObject[] xSObjectArray = new XSAnnotationImpl[n];
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.fGrammarCount) {
            SchemaGrammar schemaGrammar = this.fGrammarList[n5];
            System.arraycopy(schemaGrammar.fAnnotations, 0, xSObjectArray, n4, schemaGrammar.fNumAnnotations);
            n4 += schemaGrammar.fNumAnnotations;
            ++n5;
        }
        this.fAnnotations = new XSObjectListImpl(xSObjectArray, xSObjectArray.length);
        return this.fAnnotations;
    }

    private static final String null2EmptyString(String string) {
        return string == null ? XMLSymbols.EMPTY_STRING : string;
    }
}

